/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ExperimentClusterViewer
extends JPanel
implements IViewer {
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_EXPERIMENT_STR = "No Experiments in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private ExperimentClusterHeader header;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int[][] clusters;
    private int[] genesOrder;
    private Dimension elementSize = new Dimension(20, 5);
    private int labelIndex = -1;
    private boolean isAntiAliasing = true;
    private boolean isDrawBorders = true;
    private boolean isDrawAnnotations = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private int firstSelectedColumn = -1;
    private int lastSelectedColumn = -1;
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.green, Color.black);
    private int annotationWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private boolean hasCentroid = false;
    private float[][] centroids;
    private int contentWidth;
    private boolean showClusters = true;
    private boolean haveColorBar = false;
    private boolean useDoubleGradient = true;

    public ExperimentClusterViewer(Experiment experiment, int[][] nArray) {
        this(experiment, nArray, true);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] nArray, boolean bl) {
        this(experiment, nArray, null, bl);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] nArray, int[] nArray2, boolean bl) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.clusters = nArray == null ? ExperimentClusterViewer.defSamplesOrder(experiment.getNumberOfSamples()) : nArray;
        this.genesOrder = nArray2 == null ? ExperimentClusterViewer.defGenesOrder(experiment.getNumberOfGenes()) : nArray2;
        this.isDrawAnnotations = bl;
        this.header = new ExperimentClusterHeader(this.experiment, this.clusters);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] nArray, int[] nArray2, boolean bl, int n) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.clusters = nArray == null ? ExperimentClusterViewer.defSamplesOrder(experiment.getNumberOfSamples()) : nArray;
        this.genesOrder = nArray2 == null ? ExperimentClusterViewer.defGenesOrder(experiment.getNumberOfGenes()) : nArray2;
        this.insets.left = n;
        this.isDrawAnnotations = bl;
        this.header = new ExperimentClusterHeader(this.experiment, this.clusters);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setLeftInset(n);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] nArray, String string, Vector vector) {
        this(experiment, nArray, string, ExperimentClusterViewer.getCentroidArray(nArray, vector));
    }

    public ExperimentClusterViewer(Experiment experiment, int[][] nArray, String string, float[][] fArray) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.clusters = nArray == null ? ExperimentClusterViewer.defSamplesOrder(experiment.getNumberOfSamples()) : nArray;
        this.genesOrder = this.genesOrder == null ? ExperimentClusterViewer.defGenesOrder(experiment.getNumberOfGenes()) : this.genesOrder;
        this.insets.left = 10;
        this.isDrawAnnotations = true;
        if (string != null) {
            this.hasCentroid = true;
            this.centroids = fArray;
        }
        this.header = new ExperimentClusterHeader(this.experiment, this.clusters, string);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    private static int[][] defSamplesOrder(int n) {
        int[][] nArray = new int[1][n];
        for (int i = 0; i < nArray[0].length; ++i) {
            nArray[0][i] = i;
        }
        return nArray;
    }

    private static int[] defGenesOrder(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static float[][] getCentroidArray(int[][] nArray, Vector vector) {
        int n = vector.size();
        float[][] fArray = new float[nArray.length][n];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = ((Float)vector.elementAt(j)).floatValue();
            }
        }
        return fArray;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    public int getCurrentNumberOfExperiments() {
        return this.getClusters()[this.clusterIndex].length;
    }

    public void selectRows(int n, int n2) {
        this.firstSelectedRow = n;
        this.lastSelectedRow = n2;
        this.repaint();
    }

    public void selectColumns(int n, int n2) {
        this.firstSelectedColumn = n;
        this.lastSelectedColumn = n2;
        this.repaint();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.useDoubleGradient = iDisplayMenu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        Integer n = (Integer)iFramework.getUserObject();
        this.setClusterIndex(n == null ? 0 : n);
        this.header.setClusterIndex(this.clusterIndex);
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.maxValue = iDisplayMenu.getMaxRatioScale();
        this.minValue = iDisplayMenu.getMinRatioScale();
        this.midValue = iDisplayMenu.getMidRatioValue();
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.updateSize();
        this.header.setData(this.data);
        this.onMenuChanged(iDisplayMenu);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.useDoubleGradient = iDisplayMenu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.maxValue = iDisplayMenu.getMaxRatioScale();
        this.minValue = iDisplayMenu.getMinRatioScale();
        this.midValue = iDisplayMenu.getMidRatioValue();
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        if (this.elementSize.equals(iDisplayMenu.getElementSize()) && this.labelIndex == iDisplayMenu.getLabelIndex() && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.updateSize();
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.header.setData(iData);
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.updateSize();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    protected boolean areProbesColored() {
        int[] nArray = this.genesOrder;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    private int getMultipleArrayDataRow(int n) {
        return this.experiment.getGeneIndexMappedToData(this.genesOrder[n]);
    }

    private int getExperimentRow(int n) {
        return this.genesOrder[n];
    }

    private int getColumn(int n) {
        return this.clusters[this.clusterIndex][n];
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    protected IData getData() {
        return this.data;
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getCluster(), this.experiment, 1);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getCluster(), this.experiment, 1);
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.onDataChanged(this.data);
    }

    public Color setHCLClusterColor(int[] nArray, Color color, boolean bl) {
        Color color2 = null;
        color2 = bl ? this.framework.storeCluster(nArray, this.experiment, 0) : this.framework.storeCluster(nArray, this.experiment, 1);
        this.selectColumns(-1, -1);
        this.selectRows(-1, -1);
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.header.repaint();
        this.repaint();
        return color2;
    }

    private int[] getIDataRowIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.getMultipleArrayDataRow(i);
        }
        return nArray2;
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getCluster(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private void setElementSize(Dimension dimension) {
        this.elementSize = new Dimension(dimension);
    }

    private void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    private void setDrawBorders(boolean bl) {
        this.isDrawBorders = bl;
    }

    public BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(NO_EXPERIMENT_STR) + 10;
            int n2 = fontMetrics.getHeight() + 30;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        int n = this.elementSize.width * this.getCluster().length + 1 + this.insets.left;
        if (this.isDrawAnnotations) {
            this.annotationWidth = this.getMaxWidth(graphics2D);
            n += 20 + this.annotationWidth;
        }
        if (this.hasCentroid) {
            n += this.elementSize.width + 5;
        }
        if (this.haveColorBar) {
            n += this.elementSize.width + 10;
        }
        int n3 = this.elementSize.height * this.genesOrder.length + 1;
        this.contentWidth = n;
        this.setSize(n, n3);
        this.setPreferredSize(new Dimension(n, n3));
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    private int getMaxWidth(Graphics2D graphics2D) {
        if (graphics2D == null || this.data == null || this.getCluster() == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (int i = 0; i < this.genesOrder.length; ++i) {
            String string = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        return n;
    }

    private Color getColor(float f) {
        int n;
        if (Float.isNaN(f)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float f2 = f < this.midValue ? this.minValue : this.maxValue;
            int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
            n2 = n2 > 255 ? 255 : n2;
            n = f < this.midValue ? this.negColorImage.getRGB(255 - n2, 0) : this.posColorImage.getRGB(n2, 0);
        } else {
            float f3 = this.maxValue - this.minValue;
            int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
            n = this.posColorImage.getRGB(n3, 0);
        }
        return new Color(n);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        if (this.data == null) {
            return;
        }
        if (this.elementSize.getHeight() < 1.0) {
            return;
        }
        int n3 = this.getCluster().length;
        if (this.clusters == null || this.getCluster().length == 0) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.setFont(ERROR_FONT);
            graphics.drawString(NO_EXPERIMENT_STR, 10, 30);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = this.getTopIndex(rectangle.y);
        int n5 = this.getBottomIndex(rectangle.y + rectangle.height, this.genesOrder.length);
        int n6 = this.getLeftIndex(rectangle.x);
        int n7 = this.getRightIndex(rectangle.x + rectangle.width, n3);
        if (this.hasCentroid) {
            for (n2 = n4; n2 < n5; ++n2) {
                this.fillCentroidRectAt(graphics, n2);
            }
        }
        for (n2 = n6; n2 < n7; ++n2) {
            for (n = n4; n < n5; ++n) {
                this.fillRectAt(graphics, n, n2);
            }
        }
        Color color = graphics.getColor();
        n = n3 * this.elementSize.width + 5;
        if (this.haveColorBar) {
            for (int i = n4; i < n5; ++i) {
                if (this.hasCentroid) {
                    this.fillClusterRectAt(graphics, i, n + this.elementSize.width + 2);
                    continue;
                }
                this.fillClusterRectAt(graphics, i, n);
            }
        }
        graphics.setColor(color);
        if (this.isDrawAnnotations) {
            if (this.isAntiAliasing) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (n7 >= n3) {
                String string = "";
                graphics.setColor(Color.black);
                int n8 = this.elementSize.width * n3 + 10;
                if (this.hasCentroid) {
                    n8 += this.elementSize.width + 5;
                }
                if (this.haveColorBar) {
                    n8 += this.elementSize.width;
                }
                for (int i = n4; i < n5; ++i) {
                    if (this.labelIndex >= 0) {
                        string = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
                    }
                    int n9 = (i + 1) * this.elementSize.height;
                    graphics.drawString(string, n8 + this.insets.left, n9);
                }
            }
        }
    }

    private void fillRectAt(Graphics graphics, int n, int n2) {
        int n3 = n2 * this.elementSize.width + this.insets.left;
        int n4 = n * this.elementSize.height;
        if (this.hasCentroid) {
            n3 += this.elementSize.width + 5;
        }
        boolean bl = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (n < this.firstSelectedRow || n > this.lastSelectedRow);
        bl = bl || this.firstSelectedColumn >= 0 && this.lastSelectedColumn >= 0 && (n2 < this.firstSelectedColumn || n2 > this.lastSelectedColumn);
        graphics.setColor(this.getColor(this.experiment.get(this.getExperimentRow(n), this.getColumn(n2))));
        graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        if (bl) {
            graphics.setColor(maskColor);
            graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(n3, n4, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void fillCentroidRectAt(Graphics graphics, int n) {
        int n2 = this.insets.left;
        int n3 = n * this.elementSize.height;
        boolean bl = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (n < this.firstSelectedRow || n > this.lastSelectedRow);
        graphics.setColor(this.getColor(this.centroids[this.clusterIndex][n]));
        graphics.fillRect(n2, n3, this.elementSize.width, this.elementSize.height);
        if (bl) {
            graphics.setColor(maskColor);
            graphics.fillRect(n2, n3, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(n2, n3, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void fillClusterRectAt(Graphics graphics, int n, int n2) {
        Color color = this.data.getProbeColor(this.getMultipleArrayDataRow(n));
        if (color == null) {
            color = Color.white;
        }
        graphics.setColor(color);
        graphics.fillRect(n2 + this.insets.left, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height);
    }

    private void drawRectAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        if (!this.hasCentroid) {
            graphics.drawRect(n2 * this.elementSize.width + this.insets.left, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
        } else {
            graphics.drawRect(n2 * this.elementSize.width + this.insets.left + this.elementSize.width + 5, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    protected boolean haveClusterColor() {
        int n = this.getCluster().length;
        for (int i = 0; i < n; ++i) {
            if (this.data.getExperimentColor(this.getColumn(i)) == null) continue;
            return true;
        }
        return false;
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < this.insets.left) {
            return 0;
        }
        if (!this.hasCentroid) {
            return (n - this.insets.left) / this.elementSize.width;
        }
        if (n < this.insets.left + this.elementSize.width + 5) {
            return 0;
        }
        return (n - this.insets.left - this.elementSize.width - 5) / this.elementSize.width;
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = 0;
        n3 = !this.hasCentroid ? n / this.elementSize.width + 1 : (n - (this.insets.left + this.elementSize.width + 5)) / this.elementSize.width + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int findColumn(int n) {
        int n2 = this.getCluster().length * this.elementSize.width;
        if (this.hasCentroid) {
            if (n >= (n2 += this.elementSize.width + 5) + this.insets.left || n < this.insets.left + this.elementSize.width + 5) {
                return -1;
            }
            return (n - this.insets.left - this.elementSize.width - 5) / this.elementSize.width;
        }
        if (n >= n2 + this.insets.left || n < this.insets.left) {
            return -1;
        }
        return (n - this.insets.left) / this.elementSize.width;
    }

    private int findRow(int n) {
        int n2 = this.genesOrder.length * this.elementSize.height;
        if (n >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.height;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.getCluster().length - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.genesOrder.length - 1;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon((String)"new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon((String)"lanuch_new_mav.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon((String)"delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.genesOrder);
        objectOutputStream.writeObject(this.elementSize);
        objectOutputStream.writeInt(this.labelIndex);
        objectOutputStream.writeBoolean(this.isDrawAnnotations);
        objectOutputStream.writeObject(this.insets);
        objectOutputStream.writeBoolean(this.hasCentroid);
        if (this.hasCentroid) {
            objectOutputStream.writeObject(this.centroids);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.header = (ExperimentClusterHeader)objectInputStream.readObject();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.genesOrder = (int[])objectInputStream.readObject();
        this.elementSize = (Dimension)objectInputStream.readObject();
        this.labelIndex = objectInputStream.readInt();
        this.isDrawAnnotations = objectInputStream.readBoolean();
        this.insets = (Insets)objectInputStream.readObject();
        this.hasCentroid = objectInputStream.readBoolean();
        if (this.hasCentroid) {
            this.centroids = (float[][])objectInputStream.readObject();
        }
        this.firstSelectedRow = -1;
        this.lastSelectedRow = -1;
        this.firstSelectedColumn = -1;
        this.lastSelectedColumn = -1;
        this.showClusters = true;
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public int getViewerType() {
        return 1;
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private String oldStatusText;
        private int oldRow = -1;
        private int oldColumn = -1;

        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            int n = ExperimentClusterViewer.this.findColumn(mouseEvent.getX());
            int n2 = ExperimentClusterViewer.this.findRow(mouseEvent.getY());
            if (!ExperimentClusterViewer.this.isLegalPosition(n2, n)) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                ExperimentClusterViewer.this.framework.displaySingleArrayViewer(ExperimentClusterViewer.this.experiment.getSampleIndex(ExperimentClusterViewer.this.getColumn(n)));
                return;
            }
            if (!mouseEvent.isShiftDown()) {
                ExperimentClusterViewer.this.framework.displaySlideElementInfo(ExperimentClusterViewer.this.experiment.getSampleIndex(ExperimentClusterViewer.this.getColumn(n)), ExperimentClusterViewer.this.getMultipleArrayDataRow(n2));
                return;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (ExperimentClusterViewer.this.experiment.getNumberOfSamples() == 0 || mouseEvent.isShiftDown()) {
                return;
            }
            int n = ExperimentClusterViewer.this.findColumn(mouseEvent.getX());
            int n2 = ExperimentClusterViewer.this.findRow(mouseEvent.getY());
            if (this.isCurrentPosition(n2, n)) {
                return;
            }
            Graphics graphics = null;
            if (ExperimentClusterViewer.this.isLegalPosition(n2, n)) {
                graphics = ExperimentClusterViewer.this.getGraphics();
                ExperimentClusterViewer.this.drawRectAt(graphics, n2, n, Color.white);
                ExperimentClusterViewer.this.framework.setStatusText("Gene: " + ExperimentClusterViewer.this.data.getUniqueId(ExperimentClusterViewer.this.getMultipleArrayDataRow(n2)) + " Sample: " + ExperimentClusterViewer.this.data.getSampleName(ExperimentClusterViewer.this.experiment.getSampleIndex(ExperimentClusterViewer.this.getColumn(n))) + " Value: " + ExperimentClusterViewer.this.experiment.get(ExperimentClusterViewer.this.getExperimentRow(n2), ExperimentClusterViewer.this.getColumn(n)));
            } else {
                ExperimentClusterViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (ExperimentClusterViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                graphics = graphics != null ? graphics : ExperimentClusterViewer.this.getGraphics();
                ExperimentClusterViewer.this.fillRectAt(graphics, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(n2, n);
            if (graphics != null) {
                graphics.dispose();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.oldStatusText = ExperimentClusterViewer.this.framework.getStatusText();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (ExperimentClusterViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics graphics = ExperimentClusterViewer.this.getGraphics();
                ExperimentClusterViewer.this.fillRectAt(graphics, this.oldRow, this.oldColumn);
                graphics.dispose();
            }
            this.setOldPosition(-1, -1);
            ExperimentClusterViewer.this.framework.setStatusText(this.oldStatusText);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        private void setOldPosition(int n, int n2) {
            this.oldColumn = n2;
            this.oldRow = n;
        }

        private boolean isCurrentPosition(int n, int n2) {
            return n == this.oldRow && n2 == this.oldColumn;
        }
    }
}

