/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ExperimentClusterCentroidViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 201070001L;
    public static final Color DEF_CLUSTER_COLOR = Color.lightGray;
    protected static final Color bColor = new Color(0, 0, 128);
    protected JMenuItem setOverallMaxMenuItem;
    protected JMenuItem setClusterMaxMenuItem;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    protected static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected Experiment experiment;
    protected IData data;
    protected IFramework framework;
    protected int clusterIndex;
    protected int[][] clusters;
    protected float maxYValue;
    protected float maxClusterValue;
    protected float maxExperimentValue;
    protected float minValue;
    protected float maxValue;
    protected float midValue = 0.0f;
    protected int yRangeOption;
    public static int USE_EXPERIMENT_MAX = 0;
    public static int USE_CLUSTER_MAX = 1;
    protected boolean drawValues = true;
    protected boolean drawVariances = true;
    protected boolean drawCodes = true;
    public static Color missingColor = new Color(128, 128, 128);
    private boolean drawMarks = false;
    protected boolean gradientColors;
    protected boolean isAntiAliasing = false;
    protected float[][] means;
    protected float[][] variances;
    protected float[][] codes;
    protected int numberOfGenes;
    public static BufferedImage posColorImage;
    public static BufferedImage negColorImage;
    protected boolean showRefLine = false;
    private boolean useDoubleGradient = true;

    public ExperimentClusterCentroidViewer(Experiment experiment, int[][] nArray) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.numberOfGenes = experiment.getNumberOfGenes();
        this.clusters = nArray;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.maxExperimentValue = experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeInt(this.yRangeOption);
        objectOutputStream.writeBoolean(this.drawValues);
        objectOutputStream.writeBoolean(this.drawVariances);
        objectOutputStream.writeBoolean(this.drawCodes);
        objectOutputStream.writeBoolean(this.drawMarks);
        objectOutputStream.writeBoolean(this.isAntiAliasing);
        objectOutputStream.writeBoolean(this.gradientColors);
        objectOutputStream.writeBoolean(this.useDoubleGradient);
        objectOutputStream.writeObject(this.means);
        objectOutputStream.writeObject(this.variances);
        if (this.codes != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.codes);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.yRangeOption = objectInputStream.readInt();
        this.drawValues = objectInputStream.readBoolean();
        this.drawVariances = objectInputStream.readBoolean();
        this.drawCodes = objectInputStream.readBoolean();
        this.drawMarks = objectInputStream.readBoolean();
        this.isAntiAliasing = objectInputStream.readBoolean();
        this.gradientColors = objectInputStream.readBoolean();
        this.useDoubleGradient = objectInputStream.readBoolean();
        this.means = (float[][])objectInputStream.readObject();
        this.variances = (float[][])objectInputStream.readObject();
        if (objectInputStream.readBoolean()) {
            this.codes = (float[][])objectInputStream.readObject();
        }
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.maxExperimentValue = this.experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
        this.numberOfGenes = this.experiment.getNumberOfGenes();
    }

    public boolean checkGradient() {
        boolean bl = true;
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].length; ++j) {
                try {
                    if (this.data.getExperimentColor(this.clusters[i][j]) == null) continue;
                    bl = false;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    private Color getColor(float f) {
        int n;
        if (Float.isNaN(f)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float f2 = f < this.midValue ? this.minValue : this.maxValue;
            int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
            n2 = n2 > 255 ? 255 : n2;
            n = f < this.midValue ? negColorImage.getRGB(255 - n2, 0) : posColorImage.getRGB(n2, 0);
        } else {
            float f3 = this.maxValue - this.minValue;
            int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
            n = posColorImage.getRGB(n3, 0);
        }
        return new Color(n);
    }

    public void setGradient(boolean bl) {
        this.gradientColors = bl;
    }

    public void setMeans(float[][] fArray) {
        this.means = fArray;
    }

    public void setVariances(float[][] fArray) {
        this.variances = fArray;
    }

    public void setCodes(float[][] fArray) {
        this.codes = fArray;
    }

    public void setDrawMarks(boolean bl) {
        this.drawMarks = bl;
    }

    public void setDrawVariances(boolean bl) {
        this.drawVariances = bl;
    }

    public void setDrawValues(boolean bl) {
        this.drawValues = bl;
    }

    public void setDrawCodes(boolean bl) {
        this.drawCodes = bl;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.setData(iFramework.getData());
        this.setAntiAliasing(iFramework.getDisplayMenu().isAntiAliasing());
        Object object = iFramework.getUserObject();
        if (object instanceof CentroidUserObject) {
            this.setClusterIndex(((CentroidUserObject)object).getClusterIndex());
            this.setMode(((CentroidUserObject)object).getMode());
        } else {
            this.setClusterIndex((Integer)object);
        }
        this.updateValues(this.getCluster());
        this.maxValue = iFramework.getDisplayMenu().getMaxRatioScale();
        this.minValue = iFramework.getDisplayMenu().getMinRatioScale();
        this.midValue = iFramework.getDisplayMenu().getMidRatioValue();
        posColorImage = iFramework.getDisplayMenu().getPositiveGradientImage();
        negColorImage = iFramework.getDisplayMenu().getNegativeGradientImage();
        this.gradientColors = iFramework.getDisplayMenu().getColorGradientState();
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
        this.updateValues(this.getCluster());
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    protected int getProbe(int n) {
        return this.experiment.getGeneIndexMappedToData(n);
    }

    public void setMode(int n) {
        switch (n) {
            case 0: {
                this.setDrawVariances(true);
                this.setDrawValues(false);
                break;
            }
            case 1: {
                this.setDrawVariances(false);
                this.setDrawValues(true);
            }
        }
    }

    private void updateValues(int[] nArray) {
        this.maxClusterValue = this.calculateMaxValue(nArray);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getCluster(), this.experiment, 1);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getCluster(), this.experiment, 1);
        this.onDataChanged(this.data);
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getCluster(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private int[] getArrayMappedToData() {
        int[] nArray = this.getCluster();
        if (nArray == null || nArray.length < 1) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    public void setYRangeOption(int n) {
        this.yRangeOption = n != USE_EXPERIMENT_MAX && n != USE_CLUSTER_MAX ? USE_EXPERIMENT_MAX : n;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        this.paint((Graphics2D)graphics, rectangle, true);
    }

    public void subPaint(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        super.paint(graphics2D);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        super.paint(graphics2D);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n4 < 5 || n5 < 5) {
            return;
        }
        int n6 = n3 + Math.round((float)n5 / 2.0f);
        int n7 = this.getCluster().length;
        if (this.yRangeOption == USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float f = (float)n5 / (2.0f * this.maxYValue);
        float f2 = (float)n4 / (float)(this.numberOfGenes - 1);
        int n8 = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            graphics2D.setColor(bColor);
            for (n = 0; n < this.numberOfGenes; ++n) {
                if (Float.isNaN(this.means[this.clusterIndex][n]) || Float.isNaN(this.variances[this.clusterIndex][n]) || this.variances[this.clusterIndex][n] < 0.0f) continue;
                graphics2D.drawLine(n2 + Math.round((float)n * f2), n6 - Math.round((this.means[this.clusterIndex][n] - this.variances[this.clusterIndex][n]) * f), n2 + Math.round((float)n * f2), n6 - Math.round((this.means[this.clusterIndex][n] + this.variances[this.clusterIndex][n]) * f));
                graphics2D.drawLine(n2 + Math.round((float)n * f2) - 3, n6 - Math.round((this.means[this.clusterIndex][n] - this.variances[this.clusterIndex][n]) * f), n2 + Math.round((float)n * f2) + 3, n6 - Math.round((this.means[this.clusterIndex][n] - this.variances[this.clusterIndex][n]) * f));
                graphics2D.drawLine(n2 + Math.round((float)n * f2) - 3, n6 - Math.round((this.means[this.clusterIndex][n] + this.variances[this.clusterIndex][n]) * f), n2 + Math.round((float)n * f2) + 3, n6 - Math.round((this.means[this.clusterIndex][n] + this.variances[this.clusterIndex][n]) * f));
            }
        }
        if (this.drawValues) {
            n = 0;
            Color color = null;
            float f3 = this.maxExperimentValue * f / 20.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < this.getCluster().length; ++i) {
                for (int j = 0; j < this.numberOfGenes - 1; ++j) {
                    float f4 = this.experiment.get(j, this.getCluster()[i]);
                    float f5 = this.experiment.get(j + 1, this.getCluster()[i]);
                    if (Float.isNaN(f4) || Float.isNaN(f5)) continue;
                    if (!this.gradientColors) {
                        color = this.data.getExperimentColor(this.getCluster()[i]);
                        color = color == null ? DEF_CLUSTER_COLOR : color;
                        graphics2D.setColor(color);
                        graphics2D.drawLine(n2 + Math.round((float)j * f2), n6 - Math.round(f4 * f), n2 + Math.round((float)(j + 1) * f2), n6 - Math.round(f5 * f));
                        continue;
                    }
                    float f6 = (f5 - f4) * f;
                    int n9 = Math.abs(f6) > f3 ? Math.abs((int)(f6 / f3)) : 1;
                    float f7 = f6 / (float)n9;
                    for (int k = 0; k < n9; ++k) {
                        graphics2D.setColor(this.getColor(f4 + (float)k * f7 / f));
                        graphics2D.drawLine(n2 + Math.round((float)j * f2 + (float)k / (float)n9 * f2), n6 - Math.round(f4 * f + (float)k * f7), n2 + Math.round((float)j * f2 + ((float)k + 1.0f) / (float)n9 * f2), n6 - Math.round(f4 * f + ((float)k + 1.0f) * f7));
                    }
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            graphics2D.setColor(Color.gray);
            for (n = 0; n < this.numberOfGenes - 1; ++n) {
                graphics2D.drawLine(n2 + Math.round((float)n * f2), n6 - Math.round(this.codes[this.clusterIndex][n] * f), n2 + Math.round((float)(n + 1) * f2), n6 - Math.round(this.codes[this.clusterIndex][n + 1] * f));
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n2, n6, n2 + n4, n6);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            graphics2D.setColor(Color.magenta);
            for (n = 0; n < this.numberOfGenes - 1; ++n) {
                if (Float.isNaN(this.means[this.clusterIndex][n]) || Float.isNaN(this.means[this.clusterIndex][n + 1])) continue;
                graphics2D.drawLine(n2 + Math.round((float)n * f2), n6 - Math.round(this.means[this.clusterIndex][n] * f), n2 + Math.round((float)(n + 1) * f2), n6 - Math.round(this.means[this.clusterIndex][n + 1] * f));
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n2, n3, n4, n5);
        for (n = 1; n < this.numberOfGenes - 1; ++n) {
            graphics2D.drawLine(n2 + Math.round((float)n * f2), n3 + n5 - 5, n2 + Math.round((float)n * f2), n3 + n5);
        }
        for (n = 1; n < n8; ++n) {
            graphics2D.drawLine(n2, n6 - Math.round((float)n * f), n2 + 5, n6 - Math.round((float)n * f));
            graphics2D.drawLine(n2, n6 + Math.round((float)n * f), n2 + 5, n6 + Math.round((float)n * f));
        }
        graphics2D.setColor(bColor);
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            graphics2D.setColor(bColor);
            for (n = 0; n < this.numberOfGenes; ++n) {
                if (Float.isNaN(this.means[this.clusterIndex][n])) continue;
                graphics2D.fillOval(n2 + Math.round((float)n * f2) - 3, n6 - Math.round(this.means[this.clusterIndex][n] * f) - 3, 6, 6);
            }
        }
        graphics2D.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            graphics2D.drawString("No Experiments In Cluster", n2 + 10, n3 + 20);
        } else if (this.getCluster().length == 1) {
            graphics2D.drawString("1 Experiment", n2 + 10, n3 + 20);
        } else {
            graphics2D.drawString(this.getCluster().length + " Experiments", n2 + 10, n3 + 20);
        }
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onDataChanged(IData iData) {
        this.setData(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.maxValue = iDisplayMenu.getMaxRatioScale();
        this.minValue = iDisplayMenu.getMinRatioScale();
        this.midValue = iDisplayMenu.getMidRatioValue();
        posColorImage = iDisplayMenu.getPositiveGradientImage();
        negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.gradientColors = iDisplayMenu.getColorGradientState();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private float calculateMaxValue(int[] nArray) {
        float f = 0.0f;
        int n = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                float f2 = this.experiment.get(i, nArray[j]);
                if (Float.isNaN(f2)) continue;
                f = Math.max(f, Math.abs(f2));
            }
        }
        return f;
    }

    protected int getNamesWidth(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 0; i < this.experiment.getNumberOfSamples(); ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.data.getSampleName(this.experiment.getSampleIndex(i))));
        }
        return n;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon((String)"new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon((String)"lanuch_new_mav.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon((String)"delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(actionListener);
        this.setOverallMaxMenuItem.setEnabled(false);
        jPopupMenu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(actionListener);
        jPopupMenu.add(this.setClusterMaxMenuItem);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int getViewerType() {
        return 1;
    }
}

