/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tigr.graph.GraphCanvas;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.util.FloatMatrix;

public class ClusterBrowser
extends JPanel {
    JTable table;
    ClusterRepository repository;
    JScrollPane pane;
    String clusterTypeStr = "Gene";
    ClusterTableModel model;
    GraphCanvas profileDisplayPanel;
    FloatMatrix matrix;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$java$lang$String;

    public ClusterBrowser(ClusterRepository clusterRepository) {
        this.repository = clusterRepository;
        if (clusterRepository == null) {
            this.add((Component)new JLabel("Empty Cluster Repository"), "Center");
            return;
        }
        if (!clusterRepository.isGeneClusterRepository()) {
            this.clusterTypeStr = "Sample";
        }
        Font font = new Font("Dialog", 1, 12);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.clusterTypeStr + " Clusters", 0, 0, font, Color.black));
        jPanel.add((Component)this.initializeTable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.table.getRowCount() > 0) {
            this.table.addRowSelectionInterval(0, 0);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Graph", 0, 0, font, Color.black));
        jPanel2.add((Component)this.initializeGraph(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.setPreferredSize(new Dimension(100, 175));
        jPanel3.setMinimumSize(new Dimension(100, 175));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Cluster getSelectedCluster() {
        int n = ((ClusterTableModel)this.table.getModel()).getClusterSerialNumber(this.table.getSelectedRow());
        return this.repository.getCluster(n);
    }

    private void setInitialColumnWidths() {
        String[] stringArray = this.model.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.setColumnWidth(stringArray[i]);
        }
    }

    private void setColumnWidth(String string) {
        int n = 10;
        if (string.equals("Serial #")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 50;
            tableColumn.setWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
        } else if (string.equals("Source")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 100;
            tableColumn.setWidth(n);
            tableColumn.setPreferredWidth(n);
        } else if (string.equals("Color")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 60;
            tableColumn.setWidth(n);
            tableColumn.setPreferredWidth(n);
        } else if (string.equals("Size")) {
            TableColumn tableColumn = this.table.getColumn(string);
            n = 50;
            tableColumn.setWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
        }
    }

    private GraphCanvas initializeGraph() {
        this.profileDisplayPanel = new GraphCanvas();
        this.profileDisplayPanel.setGraphBounds(0.0, 10.0, -3.0, 3.0);
        this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
        this.profileDisplayPanel.setXAxisValue(0.0);
        this.profileDisplayPanel.setYAxisValue(0.0);
        this.refreshGraph();
        return this.profileDisplayPanel;
    }

    private void refreshGraph() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (this.table.getRowCount() <= 0) {
            return;
        }
        int n2 = this.model.getClusterSerialNumber(n);
        Cluster cluster = this.repository.getCluster(n2);
        this.matrix = cluster.getExperiment().getMatrix();
        if (this.clusterTypeStr.equals("Sample")) {
            this.matrix = this.matrix.transpose();
        }
        int[] nArray = cluster.getExperimentIndices();
        Color color = cluster.getClusterColor();
        int n3 = this.matrix.getColumnDimension();
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        this.profileDisplayPanel.removeAllGraphElements();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            f2 = Math.max(f2, this.getMax(n4));
            f = Math.min(f, this.getMin(n4));
            float f3 = Math.max(f2, Math.abs(f));
            this.profileDisplayPanel.setGraphBounds(0.0, (double)(n3 - 1), (double)(-f3), (double)f3);
            for (int j = 0; j < n3 - 1; ++j) {
                if (Float.isNaN(this.matrix.get(n4, j)) || Float.isNaN(this.matrix.get(n4, j + 1))) continue;
                GraphLine graphLine = new GraphLine((double)j, (double)this.matrix.get(n4, j), (double)(j + 1), (double)this.matrix.get(n4, j + 1), color);
                this.profileDisplayPanel.addGraphElement((GraphElement)graphLine);
            }
        }
        this.profileDisplayPanel.repaint();
    }

    private float getMax(int n) {
        float f = Float.NEGATIVE_INFINITY;
        int n2 = this.matrix.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            float f2 = this.matrix.get(n, i);
            if (Float.isNaN(f2) || !(f < f2)) continue;
            f = f2;
        }
        return f;
    }

    private float getMin(int n) {
        float f = Float.POSITIVE_INFINITY;
        int n2 = this.matrix.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            float f2 = this.matrix.get(n, i);
            if (Float.isNaN(f2) || !(f > f2)) continue;
            f = f2;
        }
        return f;
    }

    private JScrollPane initializeTable() {
        Vector<String> vector = new Vector<String>();
        vector.add("Serial #");
        vector.add("Source");
        vector.add("Algorithm Node");
        vector.add("Cluster Node");
        vector.add("Cluster Label");
        vector.add("Remarks");
        vector.add("Size");
        vector.add("Color");
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList clusterList = this.repository.getClusterList(i);
            for (int j = 0; j < clusterList.size(); ++j) {
                Cluster cluster = clusterList.getClusterAt(j);
                vector2.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
                vector2.add(new JLabel(String.valueOf(cluster.getSource())));
                vector2.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
                vector2.add(new JLabel(String.valueOf(cluster.getClusterID())));
                vector2.add(cluster.getClusterLabel());
                vector2.add(cluster.getClusterDescription());
                vector2.add(new JLabel(String.valueOf(cluster.getSize())));
                vector2.add(cluster.getClusterColor());
                ++n;
            }
        }
        this.model = new ClusterTableModel(vector, vector2);
        this.table = new JTable(this.model);
        ClusterCellRenderer clusterCellRenderer = new ClusterCellRenderer();
        this.table.setDefaultRenderer(class$java$awt$Color == null ? (class$java$awt$Color = ClusterBrowser.class$("java.awt.Color")) : class$java$awt$Color, clusterCellRenderer);
        this.table.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = ClusterBrowser.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, clusterCellRenderer);
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 175));
        this.table.addMouseListener(new TableListener());
        this.table.setBackground(Color.white);
        this.table.setRowHeight(this.table.getRowHeight() + 10);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(0);
        this.setInitialColumnWidths();
        this.model.addTableModelListener(new TableListener());
        this.table.setRowHeight(30);
        this.pane = new JScrollPane(this.table);
        this.pane.setBackground(Color.white);
        this.validate();
        return this.pane;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TableListener
    extends MouseAdapter
    implements TableModelListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
            ClusterBrowser.this.refreshGraph();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ClusterBrowser.this.refreshGraph();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ClusterBrowser.this.refreshGraph();
        }
    }

    public class ClusterCellRenderer
    implements TableCellRenderer {
        private JPanel colorPanel = new JPanel();
        private JLabel label;
        private JTextArea textArea;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.colorPanel.setBackground((Color)object);
                return this.colorPanel;
            }
            if (object instanceof JLabel) {
                this.label = (JLabel)object;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ClusterBrowser.this.table.isRowSelected(n)) {
                    this.label.setBackground(ClusterBrowser.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (object instanceof JTextArea) {
                this.textArea = (JTextArea)object;
                if (ClusterBrowser.this.table.isRowSelected(n)) {
                    this.textArea.setBackground(ClusterBrowser.this.table.getSelectionBackground());
                }
                return this.textArea;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] rowData;
        private Row[] rows;
        private int colToSort = 0;

        public ClusterTableModel(Vector vector, Vector vector2) {
            this.initializeHeader(vector);
            this.initializeData(vector2);
            this.rows = new Row[this.rowData.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        private void initializeHeader(Vector vector) {
            this.columnNames = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.columnNames[i] = (String)vector.elementAt(i);
            }
        }

        private void initializeData(Vector vector) {
            int n = 0;
            this.rowData = new Object[vector.size() / this.columnNames.length][this.columnNames.length];
            while (n < vector.size()) {
                for (int i = 0; i < this.columnNames.length; ++i) {
                    this.rowData[n / this.columnNames.length][i] = vector.elementAt(n);
                    ++n;
                }
            }
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.rowData.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.rowData[this.rows[n].index][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 7;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.rowData[this.rows[n].index][n2] = object;
            this.fireTableChanged(new TableModelEvent(this, n, n, n2));
        }

        public Class getColumnClass(int n) {
            if (n == 7) {
                return class$java$awt$Color == null ? (class$java$awt$Color = ClusterBrowser.class$("java.awt.Color")) : class$java$awt$Color;
            }
            if (n == 4 || n == 5) {
                return class$java$lang$String == null ? (class$java$lang$String = ClusterBrowser.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = ClusterBrowser.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
        }

        public int getClusterSerialNumber(int n) {
            if (this.isLegalRow(n)) {
                return Integer.parseInt(((JLabel)this.getValueAt(n, 0)).getText());
            }
            return -1;
        }

        public boolean isLegalRow(int n) {
            return n > -1 && n < this.getRowCount();
        }

        public boolean isLegalColumn(int n) {
            return n > -1 && n < this.getColumnCount();
        }

        public void sort(int n) {
            this.colToSort = n;
            Arrays.sort(this.rows);
            ClusterBrowser.this.table.repaint();
        }

        public void sortBy(String string) {
            int n = this.getColumnIndex(string);
            if (n >= 0) {
                this.sort(n);
                this.colToSort = n;
            }
        }

        private int getColumnIndex(String string) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (this.columnNames[i] != string) continue;
                return i;
            }
            return 0;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void hide(String string) {
            ClusterBrowser.this.table.removeColumn(ClusterBrowser.this.table.getColumn(string));
        }

        public void addColumn(String string) {
            ClusterBrowser.this.table.addColumn(new TableColumn(this.getColumnIndex(string)));
            this.moveColumnFromEnd(this.getColumnIndex(string));
        }

        public void addRow(Vector vector) {
            int n;
            int n2;
            Object[][] objectArray = new Object[this.rowData.length + 1][this.rowData[0].length];
            for (n2 = 0; n2 < this.rowData.length; ++n2) {
                for (n = 0; n < this.rowData[n2].length; ++n) {
                    objectArray[n2][n] = this.rowData[n2][n];
                }
            }
            for (n2 = 0; n2 < this.columnNames.length; ++n2) {
                objectArray[objectArray.length - 1][n2] = vector.elementAt(n2);
            }
            this.rowData = objectArray;
            Row[] rowArray = new Row[this.rowData.length];
            for (n = 0; n < this.rows.length; ++n) {
                rowArray[n] = this.rows[n];
            }
            rowArray[rowArray.length - 1] = new Row();
            rowArray[rowArray.length - 1].index = rowArray.length - 1;
            this.rows = rowArray;
            this.fireTableRowsInserted(this.rows.length - 1, this.rows.length - 1);
        }

        public void removeRow(int n) {
            int n2;
            int n3 = this.rows[n].index;
            Object[][] objectArray = new Object[this.rowData.length - 1][this.rowData[0].length];
            int n4 = -1;
            for (int i = 0; i < this.rowData.length; ++i) {
                if (i == n3) continue;
                ++n4;
                for (n2 = 0; n2 < this.rowData[i].length; ++n2) {
                    objectArray[n4][n2] = this.rowData[i][n2];
                }
            }
            this.rowData = objectArray;
            Row[] rowArray = new Row[this.rowData.length];
            n4 = -1;
            for (n2 = 0; n2 < this.rows.length; ++n2) {
                if (n2 == n3) continue;
                rowArray[++n4] = this.rows[n2];
                rowArray[n4].index = n4;
            }
            this.rows = rowArray;
            this.fireTableRowsDeleted(n3, n3);
        }

        public void removeAllRows() {
            int n = this.rows.length;
            this.rowData = new Object[0][0];
            this.rows = new Row[0];
            this.fireTableRowsDeleted(0, n);
        }

        private void moveColumnFromEnd(int n) {
            for (int i = ClusterBrowser.this.table.getColumnCount() - 1; i > n; --i) {
                ClusterBrowser.this.table.moveColumn(i - 1, i);
            }
        }

        public int getSerialNumber(int n) {
            JLabel jLabel = (JLabel)this.rowData[n][0];
            return Integer.parseInt(jLabel.getText());
        }

        public void setClusterColor(int n, Color color) {
            int n2 = this.rows[n].index;
            int n3 = this.getColumnIndex("Color");
            this.setValueAt(color, n2, n3);
            this.fireTableCellUpdated(n, n3);
        }

        public void setClusterLabel(int n, String string) {
            int n2 = this.rows[n].index;
            int n3 = this.getColumnIndex("Cluster Label");
            this.setValueAt(string, n2, n3);
            this.fireTableCellUpdated(n, n3);
        }

        public void setClusterDescription(int n, String string) {
            int n2 = this.rows[n].index;
            int n3 = this.getColumnIndex("Remarks");
            this.setValueAt(string, n2, n3);
            this.fireTableCellUpdated(n, n3);
        }

        private class Row
        implements Comparable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object object) {
                Row row = (Row)object;
                Object object2 = ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort];
                Object object3 = ClusterTableModel.this.rowData[row.index][ClusterTableModel.this.colToSort];
                if (((ClusterTableModel)ClusterTableModel.this).ClusterBrowser.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Serial #") || ((ClusterTableModel)ClusterTableModel.this).ClusterBrowser.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Size")) {
                    Integer n = new Integer(((JLabel)ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort]).getText());
                    return n.compareTo(new Integer(((JLabel)object3).getText()));
                }
                if (object2 instanceof Comparable) {
                    return ((Comparable)object2).compareTo(object3);
                }
                if (object2 instanceof JLabel) {
                    this.myString = ((JLabel)object2).getText();
                    this.otherString = ((JLabel)object3).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - row.index;
            }
        }
    }
}

