/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.util.FloatMatrix;

public class CentroidExperimentHeader
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 201010001L;
    private String vectorString;
    private CentroidVectorPanel centroidVectorPanel;
    private int[][] clusters;
    protected int clusterIndex = 0;
    private int currHeight;
    private int currWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private ExperimentHeader expHeader;
    private BufferedImage posColorImage;
    private BufferedImage negColorImage;
    private boolean useDoubleGradient = true;
    private FloatMatrix mainCentroidData;

    public CentroidExperimentHeader(JComponent jComponent, FloatMatrix floatMatrix, int[][] nArray, String string) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.clusters = nArray;
        this.expHeader = (ExperimentHeader)jComponent;
        this.mainCentroidData = floatMatrix;
        this.centroidVectorPanel = new CentroidVectorPanel(floatMatrix, this.insets);
        this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centroidVectorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.vectorString = string;
        this.currHeight = 0;
        this.currWidth = 0;
    }

    public CentroidExperimentHeader() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.expHeader);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.mainCentroidData);
        objectOutputStream.writeInt(this.clusterIndex);
        objectOutputStream.writeObject(this.insets);
        objectOutputStream.writeObject(this.vectorString);
        objectOutputStream.writeInt(this.currWidth);
        objectOutputStream.writeInt(this.currHeight);
        objectOutputStream.writeObject(this.centroidVectorPanel);
        objectOutputStream.writeBoolean(this.useDoubleGradient);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.expHeader = (ExperimentHeader)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.mainCentroidData = (FloatMatrix)objectInputStream.readObject();
        this.clusterIndex = objectInputStream.readInt();
        this.insets = (Insets)objectInputStream.readObject();
        this.vectorString = (String)objectInputStream.readObject();
        this.currWidth = objectInputStream.readInt();
        this.currHeight = objectInputStream.readInt();
        this.centroidVectorPanel = (CentroidVectorPanel)objectInputStream.readObject();
        this.useDoubleGradient = objectInputStream.readBoolean();
    }

    public int getCurrWidth() {
        return this.currWidth;
    }

    public int getCurrHeight() {
        return this.currHeight + this.expHeader.getHeight();
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
        this.centroidVectorPanel.setCurrentCluster(n);
    }

    public void setUseDoubleGradient(boolean bl) {
        this.useDoubleGradient = bl;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public void updateSize(Dimension dimension) {
        this.centroidVectorPanel.updateSize(dimension);
    }

    public void setCurrentCluster(int n) {
        this.clusterIndex = n;
        this.centroidVectorPanel.setCurrentCluster(n);
    }

    public void setDrawBorders(boolean bl) {
        this.centroidVectorPanel.setDrawBorders(bl);
    }

    public void setValues(float f, float f2) {
        this.centroidVectorPanel.setValues(f, f2);
    }

    public void setValues(float f, float f2, float f3) {
        this.centroidVectorPanel.setValues(f, f2, f3);
    }

    public void setNegAndPosColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.negColorImage = bufferedImage;
        this.posColorImage = bufferedImage2;
    }

    public void setMissingColor(Color color) {
        this.centroidVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean bl) {
        this.centroidVectorPanel.setAntiAliasing(bl);
    }

    public class CentroidVectorPanel
    extends JPanel
    implements Serializable {
        private FloatMatrix codes;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private float midValue = 0.0f;
        private Dimension elementSize = new Dimension(20, 5);
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);
        private Insets insets = new Insets(0, 0, 0, 0);

        public CentroidVectorPanel(FloatMatrix floatMatrix, Insets insets) {
            this.setBackground(Color.white);
            this.codes = floatMatrix;
            this.insets = insets;
        }

        public CentroidVectorPanel() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.codes);
            objectOutputStream.writeInt(this.cluster);
            objectOutputStream.writeFloat(this.minValue);
            objectOutputStream.writeFloat(this.maxValue);
            objectOutputStream.writeObject(this.elementSize);
            objectOutputStream.writeBoolean(this.drawBorders);
            objectOutputStream.writeBoolean(this.isAntiAliasing);
            objectOutputStream.writeObject(this.insets);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.codes = (FloatMatrix)objectInputStream.readObject();
            this.cluster = objectInputStream.readInt();
            this.minValue = objectInputStream.readFloat();
            this.maxValue = objectInputStream.readFloat();
            this.elementSize = (Dimension)objectInputStream.readObject();
            this.drawBorders = objectInputStream.readBoolean();
            this.isAntiAliasing = objectInputStream.readBoolean();
            this.insets = (Insets)objectInputStream.readObject();
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int n) {
            this.cluster = n;
        }

        public void setDrawBorders(boolean bl) {
            this.drawBorders = bl;
        }

        public void setAntiAliasing(boolean bl) {
            this.isAntiAliasing = bl;
        }

        public void setValues(float f, float f2) {
            this.maxValue = f2;
            this.minValue = f;
        }

        public void setValues(float f, float f2, float f3) {
            this.maxValue = f3;
            this.minValue = f;
            this.midValue = f2;
        }

        public int getCurrWidth() {
            return CentroidExperimentHeader.this.currWidth;
        }

        public void setLeftInset(int n) {
            this.insets.left = n;
        }

        public int getCurrHeight() {
            return CentroidExperimentHeader.this.currHeight;
        }

        public void updateSize(Dimension dimension) {
            this.elementSize = new Dimension(dimension);
            this.setFont(new Font("monospaced", 0, dimension.height));
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            int n = 0;
            if (graphics2D != null) {
                if (this.isAntiAliasing) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                n = fontMetrics.stringWidth(CentroidExperimentHeader.this.vectorString) + 10;
            }
            int n2 = dimension.width * this.codes.getColumnDimension() + n + this.insets.left + 10;
            int n3 = dimension.height + 10;
            CentroidExperimentHeader.this.currWidth = n2;
            CentroidExperimentHeader.this.currHeight = n3;
            this.setMinimumSize(new Dimension(n2, n3));
            this.setPreferredSize(new Dimension(n2, n3));
            this.setSize(n2, n3);
            this.validate();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (CentroidExperimentHeader.this.getCluster().length < 1) {
                return;
            }
            if (this.isAntiAliasing) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int n = this.codes.getColumnDimension();
            for (int i = 0; i < n; ++i) {
                this.fillRectAt(graphics, i, this.getColor(this.codes.get(this.cluster, i)));
                if (!this.drawBorders) continue;
                this.drawRectAt(graphics, i, Color.black);
            }
            graphics.setColor(Color.black);
            graphics.drawString(CentroidExperimentHeader.this.vectorString, this.elementSize.width * n + 10 + this.insets.left, this.elementSize.height);
        }

        private void fillRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.fillRect(n * this.elementSize.width + this.insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.drawRect(n * this.elementSize.width + this.insets.left, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float f) {
            int n;
            if (Float.isNaN(f)) {
                return this.missingColor;
            }
            if (CentroidExperimentHeader.this.useDoubleGradient) {
                float f2 = f < this.midValue ? this.minValue : this.maxValue;
                int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
                n2 = n2 > 255 ? 255 : n2;
                n = f < this.midValue ? CentroidExperimentHeader.this.negColorImage.getRGB(255 - n2, 0) : CentroidExperimentHeader.this.posColorImage.getRGB(n2, 0);
            } else {
                float f3 = this.maxValue - this.minValue;
                int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
                n = CentroidExperimentHeader.this.posColorImage.getRGB(n3, 0);
            }
            return new Color(n);
        }
    }
}

