/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioContainerInputStream;
import com.sun.j3d.audio.AudioFormat;
import com.sun.j3d.audio.AudioMidiInputStream;
import com.sun.j3d.audio.AudioRmfInputStream;
import com.sun.j3d.audio.Format;
import com.sun.j3d.audio.HaeAudioStream;
import com.sun.j3d.audio.HaeDevice;
import com.sun.j3d.audio.HaeMixer;
import com.sun.j3d.audio.JavaSoundParams;
import java.net.URL;
import java.util.Vector;

public class J3DHaeStream {
    static HaeMixer mixer = null;
    static Vector soundSamples = new Vector();
    static Vector soundStreams = new Vector();
    static Vector soundUrls = new Vector();
    static Vector soundParams = new Vector();
    static double panLeft = 1.0;
    static double panRight = -1.0;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    public static boolean close() {
        if (mixer != null) {
            mixer.disengageAudio();
        }
        return true;
    }

    static void debugPrint(String string) {
    }

    static void debugPrintln(String string) {
    }

    public static int getDataType(int n) {
        int n2 = soundParams.size();
        if (n >= n2 || n < 0) {
            return -1;
        }
        JavaSoundParams javaSoundParams = new JavaSoundParams();
        javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        return javaSoundParams.dataType;
    }

    public static long getSampleDuration(int n) {
        HaeAudioStream haeAudioStream = null;
        if (n < 0) {
            return -1L;
        }
        if (soundSamples.size() <= n) {
            return -1L;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundStreams.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1L;
        }
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1L;
        }
        double d = audioContainerInputStream.getTotalBytes();
        if (d <= 0.0) {
            return -1L;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        int n3 = audioFormat.getSampleSize();
        int n4 = audioFormat.getChannels();
        String string = audioFormat.getEncoding();
        long l = (long)(d / (double)(n3 * n4 * n2) * 1000.0);
        return l;
    }

    public static long getStartTime(int n) {
        if (soundParams.size() <= n) {
            return 0L;
        }
        JavaSoundParams javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        return javaSoundParams.startTime;
    }

    public static int getTotalChannels() {
        if (mixer != null) {
            int n = mixer.getSoundVoiceCount();
            return n;
        }
        return 0;
    }

    public static int initAudioContainer(URL uRL, boolean bl) {
        int n;
        AudioContainerInputStream audioContainerInputStream;
        int n2 = -1;
        if (uRL == null) {
            return -1;
        }
        try {
            audioContainerInputStream = AudioContainerInputStream.getStream(uRL.openStream());
            soundStreams.addElement(audioContainerInputStream);
            n = soundStreams.indexOf(audioContainerInputStream);
        }
        catch (Exception exception) {
            return -1;
        }
        if (n < 0) {
            return -1;
        }
        n2 = audioContainerInputStream instanceof AudioMidiInputStream || audioContainerInputStream instanceof AudioRmfInputStream ? 3 : (bl ? 2 : 1);
        soundUrls.setSize(n + 1);
        soundUrls.setElementAt(uRL, n);
        JavaSoundParams javaSoundParams = new JavaSoundParams();
        javaSoundParams.dataType = n2;
        soundParams.setSize(n + 1);
        soundParams.setElementAt(javaSoundParams, n);
        return n;
    }

    public static boolean initialize() {
        try {
            mixer = HaeDevice.getSystemMixer();
            mixer.reengageAudio();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static int loadSample(URL uRL, int n) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundStreams.elementAt(n);
        try {
            HaeAudioStream haeAudioStream = new HaeAudioStream(audioContainerInputStream, uRL.toString());
            soundSamples.setSize(n + 1);
            soundSamples.setElementAt(haeAudioStream, n);
        }
        catch (Exception exception) {
            soundUrls.removeElementAt(n);
            soundParams.removeElementAt(n);
            soundStreams.removeElementAt(n);
            return -1;
        }
        return 0;
    }

    public static int pauseSample(int n) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream.pause();
        return 0;
    }

    public static int pauseSamples(int n, int n2) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        HaeAudioStream haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream == null) {
            return -1;
        }
        if (haeAudioStream2 == null) {
            return -1;
        }
        haeAudioStream.pause();
        haeAudioStream2.pause();
        return 0;
    }

    public static AudioContainerInputStream reinitAudioContainer(URL uRL, int n) {
        AudioContainerInputStream audioContainerInputStream;
        if (uRL == null) {
            return null;
        }
        try {
            audioContainerInputStream = AudioContainerInputStream.getStream(uRL.openStream());
        }
        catch (Exception exception) {
            return null;
        }
        soundStreams.setElementAt(audioContainerInputStream, n);
        return audioContainerInputStream;
    }

    static int reloadSample(int n) {
        URL uRL = (URL)soundUrls.elementAt(n);
        AudioContainerInputStream audioContainerInputStream = J3DHaeStream.reinitAudioContainer(uRL, n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        try {
            HaeAudioStream haeAudioStream = new HaeAudioStream(audioContainerInputStream, uRL.toString());
            soundSamples.setElementAt(haeAudioStream, n);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    public static void scaleSampleRate(int n, float f) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundStreams.elementAt(n);
        if (audioContainerInputStream == null) {
            return;
        }
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return;
        }
        Format[] formatArray = audioContainerInputStream.getFormat();
        AudioFormat audioFormat = (AudioFormat)formatArray[0];
        int n2 = audioFormat.getSampleRate();
        haeAudioStream.setSampleRate((float)n2 * f);
    }

    public static void setFiltering(int n, boolean bl, float f) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundStreams.elementAt(n);
        if (audioContainerInputStream == null) {
            return;
        }
        audioContainerInputStream.setFiltering(bl, f);
    }

    public static void setReverb(int n, int n2, boolean bl) {
        boolean bl2 = false;
        JavaSoundParams javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        if (javaSoundParams.getReverbType() != n2) {
            try {
                mixer.setReverbType(n2 + 1);
            }
            catch (Exception exception) {
                return;
            }
            javaSoundParams.setReverbType(n2);
            bl2 = true;
        }
        HaeAudioStream haeAudioStream = null;
        if (bl2 || javaSoundParams.getReverbFlag() != bl) {
            try {
                haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
                if (haeAudioStream == null) {
                    return;
                }
                haeAudioStream.setReverb(bl);
            }
            catch (Exception exception) {
                return;
            }
            javaSoundParams.setReverbFlag(bl);
        }
    }

    public static void setSampleDelay(int n, int n2) {
    }

    public static void setSampleGain(int n, float f) {
        if (n < 0) {
            return;
        }
        if (soundSamples.size() <= n) {
            return;
        }
        HaeAudioStream haeAudioStream = null;
        double d = f;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return;
        }
        haeAudioStream.setVolume(d);
    }

    public static int startSample(int n, int n2, float f) {
        double d = 0.0039;
        double d2 = f;
        if (n < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundStreams.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        if (soundParams.size() <= n) {
            return -1;
        }
        JavaSoundParams javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        boolean bl = javaSoundParams.getReverbFlag();
        float f2 = 0.0f;
        try {
            HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
            if (haeAudioStream == null) {
                return -1;
            }
            haeAudioStream.start(d2, f2, bl);
        }
        catch (Exception exception) {
            javaSoundParams.startTime = 0L;
            return -1;
        }
        javaSoundParams.startTime = System.currentTimeMillis();
        return 0;
    }

    public static int startSamples(int n, int n2, int n3, float f, float f2, int n4, int n5) {
        boolean bl;
        double d = 0.0039;
        double d2 = f;
        double d3 = f2;
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        if (soundSamples.size() <= n2) {
            return -1;
        }
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)soundStreams.elementAt(n);
        if (audioContainerInputStream == null) {
            return -1;
        }
        HaeAudioStream haeAudioStream = null;
        HaeAudioStream haeAudioStream2 = null;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream2 == null) {
            return -1;
        }
        if (soundParams.size() <= n) {
            return -1;
        }
        if (soundParams.size() <= n2) {
            return -1;
        }
        JavaSoundParams javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        JavaSoundParams javaSoundParams2 = (JavaSoundParams)soundParams.elementAt(n2);
        boolean bl2 = bl = false;
        try {
            if (n4 < n5) {
                haeAudioStream.start(d2, panLeft, bl);
                haeAudioStream2.start(d3, panRight, bl2);
            } else {
                haeAudioStream2.start(d3, panRight, bl2);
                haeAudioStream.start(d2, panLeft, bl);
            }
            javaSoundParams.startTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            javaSoundParams.startTime = 0L;
            return -1;
        }
        return 0;
    }

    public static int stopSample(int n) {
        if (n < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        HaeAudioStream haeAudioStream = null;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream.stop(false);
        haeAudioStream.close();
        if (J3DHaeStream.reloadSample(n) != 0) {
            return -1;
        }
        JavaSoundParams javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        javaSoundParams.startTime = 0L;
        return 0;
    }

    public static int stopSamples(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (soundSamples.size() <= n) {
            return -1;
        }
        if (soundSamples.size() <= n2) {
            return -1;
        }
        HaeAudioStream haeAudioStream = null;
        HaeAudioStream haeAudioStream2 = null;
        haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream2 == null) {
            return -1;
        }
        haeAudioStream.stop(false);
        haeAudioStream2.stop(false);
        haeAudioStream.close();
        haeAudioStream2.close();
        if (J3DHaeStream.reloadSample(n) != 0) {
            return -1;
        }
        if (J3DHaeStream.reloadSample(n2) != 0) {
            return -1;
        }
        JavaSoundParams javaSoundParams = (JavaSoundParams)soundParams.elementAt(n);
        JavaSoundParams javaSoundParams2 = (JavaSoundParams)soundParams.elementAt(n2);
        javaSoundParams.startTime = 0L;
        javaSoundParams2.startTime = 0L;
        return 0;
    }

    public static int unpauseSample(int n) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        if (haeAudioStream == null) {
            return -1;
        }
        haeAudioStream.resume();
        return 0;
    }

    public static int unpauseSamples(int n, int n2) {
        HaeAudioStream haeAudioStream = (HaeAudioStream)soundSamples.elementAt(n);
        HaeAudioStream haeAudioStream2 = (HaeAudioStream)soundSamples.elementAt(n2);
        if (haeAudioStream == null) {
            return -1;
        }
        if (haeAudioStream2 == null) {
            return -1;
        }
        haeAudioStream.resume();
        haeAudioStream2.resume();
        return 0;
    }
}

