/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioContainerInputStream;
import com.sun.j3d.audio.AudioData;
import com.sun.j3d.audio.AudioFormat;
import com.sun.j3d.audio.Format;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AudioStream
extends FilterInputStream {
    AudioContainerInputStream acis;

    public AudioStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.acis = AudioContainerInputStream.getStream(inputStream);
        this.in = this.acis;
    }

    public AudioData getData() throws IOException {
        this.acis.setData();
        if (this.acis.stream instanceof ByteArrayInputStream) {
            Format[] formatArray = this.acis.getFormat();
            byte[] byArray = this.acis.getBytes();
            if (byArray == null) {
                throw new IOException("could not create AudioData object: no data received");
            }
            return new AudioData((AudioFormat)formatArray[0], byArray);
        }
        throw new IOException("could not create AudioData object");
    }

    public int getLength() {
        return this.acis.getTotalBytes();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.acis.readFully(byArray, n, n2);
    }
}

