/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileTransferPanel
extends JPanel {
    private static final String FILE_ADD_CMD = "file-add";
    private static final String FILE_DEL_CMD = "file-del";
    private static final String FILE_ALL_ADD_CMD = "file-all-add";
    private static final String FILE_ALL_DEL_CMD = "file-all-del";
    private static final String FILE_CHOOSE = "file-choose";
    private JList availList;
    private JList choosedList;
    private DefaultListModel availModel;
    private DefaultListModel choosedModel;
    private JButton addButton;
    private JButton delButton;
    private JButton addAllButton;
    private JButton delAllButton;
    private FileFilter[] fileFilters;
    private File directory;

    public FileTransferPanel(String string, FileFilter[] fileFilterArray) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new BevelBorder(0));
        this.fileFilters = fileFilterArray;
        Listener listener = new Listener();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        JPanel jPanel = this.createDirPanel(string);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("Available:"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)new JLabel("Chosen:"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.availList = this.createList(listener);
        this.availModel = (DefaultListModel)this.availList.getModel();
        JScrollPane jScrollPane = new JScrollPane(this.availList);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.choosedList = this.createList(listener);
        this.choosedModel = (DefaultListModel)this.choosedList.getModel();
        jScrollPane = new JScrollPane(this.choosedList);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = this.createBtnsPanel(listener);
        this.add((Component)jPanel2, gridBagConstraints);
        this.updateDirectory(new File(string));
    }

    public File[] getFiles() {
        Object[] objectArray = new File[this.choosedModel.size()];
        this.choosedModel.copyInto(objectArray);
        return objectArray;
    }

    public int getFilesNumber() {
        return this.choosedModel.size();
    }

    private void updateDirectory(File file) {
        if (!file.isDirectory()) {
            return;
        }
        if (this.directory != null && this.directory.equals(file)) {
            return;
        }
        this.directory = file;
        this.availModel.clear();
        this.choosedModel.clear();
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File[] fileArray = fileSystemView.getFiles(file, true);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!this.accept(fileArray[i])) continue;
            this.availModel.addElement(fileArray[i]);
        }
        this.updateButtons();
    }

    private boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (this.fileFilters == null) {
            return true;
        }
        for (int i = 0; i < this.fileFilters.length; ++i) {
            if (!this.fileFilters[i].accept(file)) continue;
            return true;
        }
        return false;
    }

    private void addAction() {
        int n;
        int[] nArray = this.availList.getSelectedIndices();
        for (n = 0; n < nArray.length; ++n) {
            this.choosedModel.addElement(this.availModel.elementAt(nArray[n]));
        }
        for (n = 0; n < nArray.length; ++n) {
            this.availModel.remove(nArray[n] - n);
        }
    }

    private void delAction() {
        int n;
        int[] nArray = this.choosedList.getSelectedIndices();
        for (n = 0; n < nArray.length; ++n) {
            this.availModel.addElement(this.choosedModel.elementAt(nArray[n]));
        }
        for (n = 0; n < nArray.length; ++n) {
            this.choosedModel.remove(nArray[n] - n);
        }
    }

    private void addAllAction() {
        int n = this.availModel.size();
        for (int i = 0; i < n; ++i) {
            this.choosedModel.addElement(this.availModel.elementAt(i));
        }
        this.availModel.clear();
    }

    private void delAllAction() {
        int n = this.choosedModel.size();
        for (int i = 0; i < n; ++i) {
            this.availModel.addElement(this.choosedModel.elementAt(i));
        }
        this.choosedModel.clear();
    }

    private JList createList(Listener listener) {
        JList<Object> jList = new JList<Object>(new DefaultListModel());
        jList.setCellRenderer(new ListRenderer());
        jList.addListSelectionListener(listener);
        jList.addMouseListener(listener);
        return jList;
    }

    private JPanel createDirPanel(String string) {
        return new DirectoryPanel(string);
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        this.addButton = this.createButton("Add", FILE_ADD_CMD, actionListener);
        this.delButton = this.createButton("Del", FILE_DEL_CMD, actionListener);
        this.addAllButton = this.createButton("Add All", FILE_ALL_ADD_CMD, actionListener);
        this.delAllButton = this.createButton("Del All", FILE_ALL_DEL_CMD, actionListener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.delButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.addAllButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.delAllButton, gridBagConstraints);
        return jPanel;
    }

    private JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(false);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void updateButtons() {
        if (this.availModel.isEmpty()) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
        } else {
            this.addAllButton.setEnabled(true);
            if (this.availList.isSelectionEmpty()) {
                this.addButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
            }
        }
        if (this.choosedModel.isEmpty()) {
            this.delButton.setEnabled(false);
            this.delAllButton.setEnabled(false);
        } else {
            this.delAllButton.setEnabled(true);
            if (this.choosedList.isSelectionEmpty()) {
                this.delButton.setEnabled(false);
            } else {
                this.delButton.setEnabled(true);
            }
        }
    }

    private class DirectoryPanel
    extends JPanel
    implements ActionListener {
        private JTextField textField;

        public DirectoryPanel(String string) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            this.add((Component)new JLabel("Directory:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            this.textField = new JTextField(string, 30);
            this.textField.setEditable(false);
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            JButton jButton = new JButton("Choose...");
            jButton.setActionCommand(FileTransferPanel.FILE_CHOOSE);
            jButton.addActionListener(this);
            this.add((Component)jButton, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(FileTransferPanel.FILE_CHOOSE)) {
                this.chooseDirectory();
            }
        }

        private void chooseDirectory() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.textField.getText()));
            jFileChooser.setDialogTitle("Choose a directory");
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.textField.setText(file.getPath());
                FileTransferPanel.this.updateDirectory(file);
            }
        }
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            this.setText(file.getName());
            return this;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                return;
            }
            Object object = mouseEvent.getSource();
            if (object == FileTransferPanel.this.availList) {
                FileTransferPanel.this.addAction();
            } else if (object == FileTransferPanel.this.choosedList) {
                FileTransferPanel.this.delAction();
            }
            FileTransferPanel.this.updateButtons();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(FileTransferPanel.FILE_ADD_CMD)) {
                FileTransferPanel.this.addAction();
            } else if (string.equals(FileTransferPanel.FILE_DEL_CMD)) {
                FileTransferPanel.this.delAction();
            } else if (string.equals(FileTransferPanel.FILE_ALL_ADD_CMD)) {
                FileTransferPanel.this.addAllAction();
            } else if (string.equals(FileTransferPanel.FILE_ALL_DEL_CMD)) {
                FileTransferPanel.this.delAllAction();
            }
            FileTransferPanel.this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileTransferPanel.this.updateButtons();
        }
    }
}

