/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class MessageDisplay
extends ActionInfoDialog {
    static final int MESSAGE_TEXT = 0;
    static final int CLOSE_BUTTON = 1;
    private JFrame parent;
    private GBA gba;
    JLabel messageLabel;
    JButton closeButton;
    Font messageDisplayFont;

    public MessageDisplay(JFrame jFrame, String string) {
        super(jFrame, true);
        try {
            this.parent = jFrame;
            this.gba = new GBA();
            this.messageDisplayFont = new Font("serif", 0, 12);
            this.messageLabel = new JLabel(string);
            this.messageLabel.setFont(this.messageDisplayFont);
            this.messageLabel.addKeyListener(new EventListener());
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(new EventListener());
            this.contentPane.setLayout(new GridBagLayout());
            this.gba.add(this.contentPane, this.messageLabel, 0, 0, 3, 1, 1, 1, 1, 10);
            this.gba.add(this.contentPane, this.closeButton, 1, 1, 1, 1, 0, 0, 0, 10);
            this.pack();
            this.setResizable(true);
            this.setTitle("TIGR MultiExperimentViewer Message");
            this.setLocation(300, 300);
        }
        catch (Exception exception) {
            System.out.println("Exception (MessageDisplay.const()): " + exception);
        }
    }

    public MessageDisplay(JFrame jFrame, String string, String string2) {
        super(jFrame, true);
        try {
            this.parent = jFrame;
            this.gba = new GBA();
            this.messageDisplayFont = new Font("serif", 0, 12);
            if (string.startsWith("Result set is DEAD")) {
                string = "No data to retrieve for Plate Number " + string2;
            } else if (string.startsWith("Incorrect syntax near")) {
                string = string2 + " is an invalid Plate Number - Code B1";
            } else if (string.startsWith("Invalid column name")) {
                string = string2 + " is an invalid Plate Number - Code C1";
            } else if (string.startsWith("Connection failed")) {
                string = "Could not connect to database.";
            } else if (string.startsWith("Login failed")) {
                string = "Could not login to database.";
            } else if (string.startsWith("SELECT permission denied")) {
                string = "Database access error. Contact support.";
            } else if (string.startsWith("EXECUTE permission denied")) {
                string = "Database access error. Contact support.";
            } else if (string.startsWith("divide by zero")) {
                string = "Numerical Exception. Contact support.";
            } else if (string.startsWith("Null")) {
                string = "Null on Plate Number " + string2 + "?! Contact support.";
            } else if (string.startsWith("Thread write failed")) {
                string = "Error writing data to socket. Contact support.";
            } else if (string.startsWith("Server user id")) {
                string = "Invalid login for database.";
            } else if (string.startsWith("Subquery returned more than 1 value")) {
                string = "Query exception. Contact support.";
            }
            this.messageLabel = new JLabel(string);
            this.messageLabel.setFont(this.messageDisplayFont);
            this.messageLabel.addKeyListener(new EventListener());
            this.closeButton = new JButton("Close TIGR MultiViewer Message");
            this.closeButton.addActionListener(new EventListener());
            this.contentPane.setLayout(new GridBagLayout());
            this.gba.add(this.contentPane, this.messageLabel, 0, 0, 3, 1, 1, 1, 1, 10);
            this.gba.add(this.contentPane, this.closeButton, 1, 1, 1, 1, 0, 0, 0, 10);
            this.pack();
            this.setResizable(true);
            this.setTitle("TIGR MultiViewer Message");
            this.setLocation(300, 300);
            this.show();
        }
        catch (Exception exception) {
            System.out.println("Exception (MessageDisplay.const()): " + exception);
        }
    }

    public MessageDisplay(JFrame jFrame, String string, int n) {
        this(jFrame, string, "" + n);
    }

    public MessageDisplay(JFrame jFrame, Exception exception, String string) {
        this(jFrame, exception.getMessage(), string);
    }

    public MessageDisplay(JFrame jFrame, Exception exception, int n) {
        this(jFrame, exception.getMessage(), "" + n);
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MessageDisplay.this.closeButton) {
                MessageDisplay.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                MessageDisplay.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

