/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

public class IntArray {
    private int[] elementData;
    private int size;

    public IntArray(int n) {
        this.elementData = new int[n];
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.elementData, 0, nArray, 0, this.size);
        return nArray;
    }

    public int get(int n) {
        this.RangeCheck(n);
        return this.elementData[n];
    }

    public void set(int n, int n2) {
        this.RangeCheck(n);
        this.elementData[n] = n2;
    }

    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = n;
        return true;
    }

    private void RangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int[] nArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new int[n3];
            System.arraycopy(nArray, 0, this.elementData, 0, this.size);
        }
    }
}

