/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import org.tigr.graph.Drawable;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphPointGroup;
import org.tigr.graph.GraphTick;

public class GraphCanvas
extends Drawable {
    public static final int SYSTEM_QUADRANT1_ONLY = 1000;
    public static final int SYSTEM_QUADRANT12_ONLY = 1001;
    public static final int SYSTEM_ALL_QUADRANTS = 1002;
    public static final int SYSTEM_BOUNDS = 1100;
    public static final int HISTOGRAM_BAR_OUTLINE = 2000;
    public static final int HISTOGRAM_BAR_SOLID = 2001;
    public static final int GRAPH_POINTS_SEPERATE = 3000;
    public static final int GRAPH_POINTS_CONNECT = 3001;
    protected double graphStartX;
    protected double graphStopX;
    protected double graphStartY;
    protected double graphStopY;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    protected double xAxisValue;
    protected double yAxisValue;
    public boolean fixedHeight;
    public boolean fixedWidth;
    public int graphHeight;
    public int graphWidth;
    public boolean referenceLinesOn = true;
    public String title;
    public String xLabel;
    public String yLabel;
    protected Font tickFont;
    protected Font labelFont;
    protected Font titleFont;
    protected int tickFontHeight;
    protected int tickFontWidth;
    protected int labelFontHeight;
    protected int labelFontWidth;
    protected int titleFontHeight;
    protected int titleFontWidth;
    protected Vector graphElements;

    public GraphCanvas() {
        this.initialize();
    }

    public GraphCanvas(int n, int n2) {
        this.fixedHeight = true;
        this.fixedWidth = true;
        this.graphHeight = n;
        this.graphWidth = n2;
        this.initialize();
    }

    public void initialize() {
        this.graphElements = new Vector();
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.setTickFont("monospaced", 0, 10);
        this.setLabelFont("monospaced", 0, 12);
        this.setTitleFont("monospaced", 0, 16);
    }

    public void controlPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawGraph(graphics2D);
    }

    public void setTickFont(String string, int n, int n2) {
        this.tickFont = new Font(string, n, n2);
        this.tickFontWidth = (int)(0.6 * (double)n2);
        this.tickFontHeight = n2;
    }

    public void setLabelFont(String string, int n, int n2) {
        this.labelFont = new Font(string, n, n2);
        this.labelFontWidth = (int)(0.6 * (double)n2);
        this.labelFontHeight = n2;
    }

    public void setTitleFont(String string, int n, int n2) {
        this.titleFont = new Font(string, n, n2);
        this.titleFontWidth = (int)(0.6 * (double)n2);
        this.titleFontHeight = n2;
    }

    public void drawGraph(Graphics2D graphics2D) {
        this.drawSystem(graphics2D, 1100);
        for (int i = 0; i < this.graphElements.size(); ++i) {
            this.drawGraphElement(graphics2D, (GraphElement)this.graphElements.elementAt(i));
        }
        if (this.referenceLinesOn) {
            // empty if block
        }
        this.drawXLabel(graphics2D, this.xLabel, Color.black);
        this.drawYLabel(graphics2D, this.yLabel, Color.black);
        this.drawTitle(graphics2D, this.title, Color.black);
    }

    public void drawGraphElement(Graphics2D graphics2D, GraphElement graphElement) {
        if (graphElement instanceof GraphPoint) {
            this.drawPoint(graphics2D, (GraphPoint)graphElement);
        } else if (graphElement instanceof GraphBar) {
            this.drawBar(graphics2D, (GraphBar)graphElement);
        } else if (graphElement instanceof GraphTick) {
            this.drawTick(graphics2D, (GraphTick)graphElement);
        } else if (graphElement instanceof GraphLine) {
            this.drawLine(graphics2D, (GraphLine)graphElement);
        } else if (graphElement instanceof GraphPointGroup) {
            this.drawPointGroup(graphics2D, (GraphPointGroup)graphElement);
        }
    }

    public void drawReferenceLines(Graphics2D graphics2D, int n, int n2) {
        if (n <= this.convertX(this.graphStopX) && n >= this.convertX(this.graphStartX)) {
            graphics2D.setColor(Color.magenta);
            graphics2D.drawLine(n, this.convertY(this.graphStartY), n, this.convertY(this.graphStopY));
        }
        if (n2 >= this.convertY(this.graphStopY) && n2 <= this.convertY(this.graphStartY)) {
            graphics2D.setColor(Color.magenta);
            graphics2D.drawLine(this.convertX(this.graphStartX), n2, this.convertX(this.graphStopX), n2);
        }
    }

    public void addGraphElement(GraphElement graphElement) {
        this.graphElements.addElement(graphElement);
    }

    public void removeAllGraphElements() {
        this.graphElements = new Vector();
    }

    public void clearAll(Graphics2D graphics2D) {
        this.fillRect(graphics2D, 0, 0, this.getSize().width, this.getSize().height, this.getBackground());
    }

    public void setGraphStartX(double d) {
        this.graphStartX = d;
    }

    public double getGraphStartX() {
        return this.graphStartX;
    }

    public void setGraphStartY(double d) {
        this.graphStartY = d;
    }

    public double getGraphStartY() {
        return this.graphStartY;
    }

    public void setGraphStopX(double d) {
        this.graphStopX = d;
    }

    public double getGraphStopX() {
        return this.graphStopX;
    }

    public void setGraphStopY(double d) {
        this.graphStopY = d;
    }

    public double getGraphStopY() {
        return this.graphStopY;
    }

    public void setGraphBounds(double d, double d2, double d3, double d4) {
        this.graphStartX = d;
        this.graphStopX = d2;
        this.graphStartY = d3;
        this.graphStopY = d4;
    }

    public void setPreXSpacing(int n) {
        this.preXSpacing = n;
    }

    public int getPreXSpacing() {
        return this.preXSpacing;
    }

    public void setPostXSpacing(int n) {
        this.postXSpacing = n;
    }

    public int getPostXSpacing() {
        return this.postXSpacing;
    }

    public void setPreYSpacing(int n) {
        this.preYSpacing = n;
    }

    public int getPreYSpacing() {
        return this.preYSpacing;
    }

    public void setPostYSpacing(int n) {
        this.postYSpacing = n;
    }

    public int getPostYSpacing() {
        return this.postYSpacing;
    }

    public void setGraphSpacing(int n, int n2, int n3, int n4) {
        this.preXSpacing = n;
        this.postXSpacing = n2;
        this.preYSpacing = n3;
        this.postYSpacing = n4;
    }

    public void setXAxisValue(double d) {
        this.xAxisValue = d;
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setYAxisValue(double d) {
        this.yAxisValue = d;
    }

    public double getYAxisValue() {
        return this.yAxisValue;
    }

    public void drawSystem(Graphics2D graphics2D, int n) {
        switch (n) {
            case 1100: {
                this.drawLine(graphics2D, new GraphPoint(this.graphStartX, this.xAxisValue), new GraphPoint(this.graphStopX, this.xAxisValue), Color.black);
                this.drawLine(graphics2D, new GraphPoint(this.yAxisValue, this.graphStartY), new GraphPoint(this.yAxisValue, this.graphStopY), Color.black);
                break;
            }
            case 1000: {
                break;
            }
            case 1001: {
                break;
            }
        }
    }

    public int getWidth() {
        if (this.fixedWidth) {
            return this.graphWidth;
        }
        return this.getSize().width;
    }

    public int getHeight() {
        if (this.fixedHeight) {
            return this.graphHeight;
        }
        return this.getSize().height;
    }

    protected double getXScale() {
        return (double)(this.getWidth() - this.preXSpacing - this.postXSpacing) / (this.graphStopX - this.graphStartX);
    }

    protected double getYScale() {
        return (double)(this.getHeight() - this.preYSpacing - this.postYSpacing) / (this.graphStopY - this.graphStartY);
    }

    protected int convertX(double d) {
        return (int)((d - this.graphStartX) * this.getXScale() + (double)this.preXSpacing);
    }

    protected int convertY(double d) {
        return (int)((this.graphStopY - d) * this.getYScale() + (double)this.preYSpacing);
    }

    public void drawTick(Graphics2D graphics2D, GraphTick graphTick) {
        if (graphTick.getOrientation() == 0) {
            if (graphTick.getLabel() != "") {
                this.drawVerticalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor(), graphTick.getLabel(), graphTick.getLabelColor());
            } else {
                this.drawVerticalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor());
            }
        } else if (graphTick.getOrientation() == 1) {
            if (graphTick.getLabel() != "") {
                this.drawHorizontalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor(), graphTick.getLabel(), graphTick.getLabelColor());
            } else {
                this.drawHorizontalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor());
            }
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color) {
        if (d < this.graphStartX || d > this.graphStopX) {
            return;
        }
        switch (n2) {
            case 0: {
                this.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue) - n / 2, this.convertX(d), this.convertY(this.xAxisValue) + n / 2, color);
                break;
            }
            case 1: {
                this.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue), this.convertX(d), this.convertY(this.xAxisValue) - n, color);
                break;
            }
            case 5: {
                this.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue), this.convertX(d), this.convertY(this.xAxisValue) + n, color);
            }
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawVerticalTick(graphics2D, d, n, n2, color);
        graphics2D.rotate(-1.5707963267948966);
        this.drawString(graphics2D, string, -this.getHeight() + this.postYSpacing - string.length() * this.tickFontWidth - n, this.convertX(d) + this.tickFontHeight / 2, color2, this.tickFont);
        graphics2D.rotate(1.5707963267948966);
    }

    public void drawHorizontalTick(Graphics2D graphics2D, double d, int n, int n2, Color color) {
        if (d < this.graphStartY || d > this.graphStopY) {
            return;
        }
        switch (n2) {
            case 0: {
                this.drawLine(graphics2D, this.convertX(this.yAxisValue) - n / 2, this.convertY(d), this.convertX(this.yAxisValue) + n / 2, this.convertY(d), color);
                break;
            }
            case 3: {
                this.drawLine(graphics2D, this.convertX(this.yAxisValue), this.convertY(d), this.convertX(this.yAxisValue) + n, this.convertY(d), color);
                break;
            }
            case 7: {
                this.drawLine(graphics2D, this.convertX(this.yAxisValue), this.convertY(d), this.convertX(this.yAxisValue) - n, this.convertY(d), color);
            }
        }
    }

    public void drawHorizontalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawHorizontalTick(graphics2D, d, n, n2, color);
        this.drawString(graphics2D, string, this.preXSpacing - n - string.length() * this.tickFontWidth, this.convertY(d) + this.tickFontHeight / 2, color2, this.tickFont);
    }

    public void drawTitle(Graphics2D graphics2D, String string, Color color) {
        if (string == null) {
            return;
        }
        this.drawString(graphics2D, string, this.getWidth() / 2 - string.length() * this.titleFontWidth / 2, this.titleFontHeight * 2, color, this.titleFont);
    }

    public void drawXLabel(Graphics2D graphics2D, String string, Color color) {
        if (string == null) {
            return;
        }
        this.drawString(graphics2D, string, this.getWidth() / 2 - string.length() * this.labelFontWidth / 2, this.convertY(this.graphStartY) + this.postYSpacing - this.labelFontHeight, color, this.labelFont);
    }

    public void drawYLabel(Graphics2D graphics2D, String string, Color color) {
        if (string == null) {
            return;
        }
        graphics2D.rotate(-1.5707963267948966);
        this.drawString(graphics2D, string, -this.postYSpacing + this.preXSpacing - this.getHeight() / 2 - string.length() * this.labelFontWidth / 2, this.labelFontHeight, color, this.labelFont);
        graphics2D.rotate(1.5707963267948966);
    }

    public void drawPoint(Graphics2D graphics2D, GraphPoint graphPoint) {
        this.drawPointAt(graphics2D, graphPoint.getX(), graphPoint.getY(), graphPoint.getColor(), graphPoint.getPointSize());
    }

    public void drawPointAt(Graphics2D graphics2D, double d, double d2, Color color, int n) {
        if (d < this.graphStartX || d > this.graphStopX || d2 < this.graphStartY || d2 > this.graphStopY) {
            return;
        }
        this.fillRect(graphics2D, this.convertX(d) - n / 2, this.convertY(d2) - n / 2, n, n, color);
    }

    public void drawPoints(Graphics2D graphics2D, Vector vector, int n) {
        GraphPoint graphPoint = null;
        switch (n) {
            case 3000: {
                for (int i = 0; i < vector.size(); ++i) {
                    GraphPoint graphPoint2 = (GraphPoint)vector.elementAt(i);
                    this.drawPoint(graphics2D, graphPoint2);
                }
                break;
            }
            case 3001: {
                for (int i = 0; i < vector.size(); ++i) {
                    GraphPoint graphPoint3 = (GraphPoint)vector.elementAt(i);
                    if (i == 0) {
                        graphPoint = graphPoint3;
                    }
                    this.drawLine(graphics2D, graphPoint, graphPoint3, Color.black);
                    this.drawPoint(graphics2D, graphPoint);
                    this.drawPoint(graphics2D, graphPoint3);
                    graphPoint = graphPoint3;
                }
                break;
            }
        }
    }

    public void drawPointGroup(Graphics2D graphics2D, GraphPointGroup graphPointGroup) {
        double[] dArray = graphPointGroup.getX();
        double[] dArray2 = graphPointGroup.getY();
        Color color = graphPointGroup.getColor();
        int n = graphPointGroup.getPointSize();
        for (int i = 0; i < Math.min(dArray.length, dArray2.length); ++i) {
            this.drawPointAt(graphics2D, dArray[i], dArray2[i], color, n);
        }
    }

    public void drawLine(Graphics2D graphics2D, GraphLine graphLine) {
        this.drawLine(graphics2D, this.convertX(graphLine.getX1()), this.convertY(graphLine.getY1()), this.convertX(graphLine.getX2()), this.convertY(graphLine.getY2()), graphLine.getColor());
    }

    public void drawLine(Graphics2D graphics2D, GraphPoint graphPoint, GraphPoint graphPoint2, Color color) {
        this.drawLine(graphics2D, this.convertX(graphPoint.getX()), this.convertY(graphPoint.getY()), this.convertX(graphPoint2.getX()), this.convertY(graphPoint2.getY()), color);
    }

    public void drawBar(Graphics2D graphics2D, GraphBar graphBar) {
        if (graphBar.getStyle() == 0) {
            this.drawVerticalHistogramBar(graphics2D, graphBar.getLower(), graphBar.getUpper(), graphBar.getValue(), graphBar.getColor(), graphBar.getStyle());
        } else if (graphBar.getStyle() == 1) {
            // empty if block
        }
    }

    public void drawVerticalHistogramBar(Graphics2D graphics2D, double d, double d2, double d3, Color color, int n) {
        if (d < this.graphStartX || d > this.graphStopX || d2 < this.graphStartX || d2 > this.graphStopX) {
            return;
        }
        if (d3 < this.graphStartY || d3 > this.graphStopY) {
            return;
        }
        if (n == 1) {
            this.drawRect(graphics2D, this.convertX(d), this.convertY(d3), (int)((d2 - d) * this.getXScale()), (int)(d3 * this.getYScale()) - 1, color);
        } else if (n == 0) {
            this.fillRect(graphics2D, this.convertX(d), this.convertY(d3), (int)((d2 - d) * this.getXScale()) + 1, (int)(d3 * this.getYScale()) + 1, color);
        }
    }
}

