/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;

class ViewPlatformRetained
extends LeafRetained {
    int viewAttachPolicy = 0;
    private ArrayList viewList = new ArrayList();
    private View[] views;
    Locale locale = null;
    boolean viewListDirty = true;
    Transform3D vworldToVpc = null;
    Transform3D vpcToVworld = new Transform3D();
    float radius = 62.0f;
    BoundingSphere sphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), this.radius);
    BoundingSphere schedSphere = new BoundingSphere();
    Object[] targets = new Object[1];
    int vprDirtyMask = 196608;
    static final Object[] emptyObj = new Object[0];
    static final Transform3D identity = new Transform3D();

    ViewPlatformRetained() {
        this.nodeType = 16;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        this.targets[0] = this;
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        View[] viewArray = this.getViewList();
        int n = viewArray.length - 1;
        while (n >= 0) {
            viewArray[n].evaluateActive();
            --n;
        }
        setLiveState.nodeList.add(this);
        setLiveState.notifyThreads |= 3;
        this.universe.removeViewPlatform(this);
    }

    void evaluateInitViewPlatformTransform() {
        ViewPlatformRetained viewPlatformRetained = this;
        synchronized (viewPlatformRetained) {
            if (this.lastLocalToVworld[0].equals(identity)) {
                this.evaluateInitViewPlatformTransform(this, this.lastLocalToVworld[0]);
            }
        }
    }

    void evaluateInitViewPlatformTransform(NodeRetained nodeRetained, Transform3D transform3D) {
        Object object;
        if (nodeRetained instanceof TransformGroupRetained) {
            object = new Transform3D();
            TransformGroupRetained transformGroupRetained = (TransformGroupRetained)nodeRetained;
            transformGroupRetained.transform.getWithLock((Transform3D)object);
            transform3D.mul((Transform3D)object, transform3D);
        }
        if ((object = nodeRetained.getParent()) != null) {
            this.evaluateInitViewPlatformTransform((NodeRetained)object, transform3D);
        }
    }

    void evaluateViewPlatformTransform() {
        if (this.vworldToVpc != null) {
            VirtualUniverse.mc.addToTransformFreeList(this.vworldToVpc);
        }
        this.vworldToVpc = null;
    }

    float getActivationRadius() {
        return this.radius;
    }

    int getViewAttachPolicy() {
        return this.viewAttachPolicy;
    }

    View[] getViewList() {
        ArrayList arrayList = this.viewList;
        synchronized (arrayList) {
            if (this.viewListDirty) {
                this.views = this.viewList.toArray(new View[this.viewList.size()]);
                this.viewListDirty = false;
            }
            View[] viewArray = this.views;
            Object var3_3 = null;
            return viewArray;
        }
    }

    Transform3D getVpcToVworld() {
        this.vpcToVworld.set(this.getCurrentLocalToVworld(null));
        return this.vpcToVworld;
    }

    Transform3D getVworldToVpc() {
        if (this.vworldToVpc == null) {
            this.vworldToVpc = VirtualUniverse.mc.getTransform3D(this.getCurrentLocalToVworld(null));
            this.vworldToVpc.invert();
        }
        return this.vworldToVpc;
    }

    void processSwitchChanged(long[] lArray) {
        this.evalCurrentSwitchOn(lArray);
        this.reEvaluateView();
    }

    void reEvaluateView() {
        View[] viewArray = this.getViewList();
        int n = viewArray.length - 1;
        while (n >= 0) {
            viewArray[n].evaluateActive();
            --n;
        }
    }

    void removeView(View view) {
        ArrayList arrayList = this.viewList;
        synchronized (arrayList) {
            if (this.viewList.contains(view)) {
                this.viewList.remove(this.viewList.indexOf(view));
            }
            this.viewListDirty = true;
        }
    }

    void repaint() {
        View[] viewArray = this.getViewList();
        int n = viewArray.length - 1;
        while (n >= 0) {
            viewArray[n].repaint();
            --n;
        }
    }

    void setActivationRadius(float f) {
        this.radius = f;
        Object object = this.sphere;
        synchronized (object) {
            this.sphere.radius = this.radius;
        }
        if (this.source != null && this.source.isLive()) {
            this.repaint();
        }
        if (this.source.isLive()) {
            object = VirtualUniverse.mc.getMessage();
            ((J3dMessage)object).type = 3;
            ((J3dMessage)object).threads = 256;
            ((J3dMessage)object).universe = this.universe;
            ((J3dMessage)object).args[0] = this.targets;
            ((J3dMessage)object).args[1] = this;
            VirtualUniverse.mc.processMessage((J3dMessage)object);
            object = VirtualUniverse.mc.getMessage();
            ((J3dMessage)object).type = 48;
            ((J3dMessage)object).threads = 128;
            ((J3dMessage)object).universe = this.universe;
            ((J3dMessage)object).args[0] = this;
            ((J3dMessage)object).args[1] = new Float(f);
            VirtualUniverse.mc.processMessage((J3dMessage)object);
        }
    }

    void setLive(SetLiveState setLiveState) {
        ContainsNodes containsNodes;
        int n;
        View[] viewArray = this.getViewList();
        int n2 = viewArray.length - 1;
        while (n2 >= 0) {
            viewArray[n2].checkView();
            --n2;
        }
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ViewPlatformRetained1"));
        }
        this.locale = setLiveState.locale;
        if (setLiveState.transformTargets != null) {
            setLiveState.transformTargets.add(this);
            setLiveState.transformTargetThreads |= 0x383;
        }
        if (setLiveState.inSharedGroup) {
            n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.clearCompositeSwitchMask();
                    this.isNewSwitchLeaf = true;
                    containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.viewPlatformNodes.add(this);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.clearCompositeSwitchMask();
            this.isNewSwitchLeaf = true;
            containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.viewPlatformNodes.add(this);
        }
        setLiveState.nodeList.add(this);
        setLiveState.notifyThreads |= 0x100;
        super.markAsLive();
        n = viewArray.length - 1;
        while (n >= 0) {
            viewArray[n].setUniverse(setLiveState.universe);
            viewArray[n].evaluateActive();
            --n;
        }
        this.universe.addViewPlatform(this);
    }

    void setView(View view) {
        ArrayList arrayList = this.viewList;
        synchronized (arrayList) {
            if (!this.viewList.contains(view)) {
                this.viewList.add(view);
            }
            this.viewListDirty = true;
        }
    }

    void setViewAttachPolicy(int n) {
        ViewPlatformRetained viewPlatformRetained = this;
        synchronized (viewPlatformRetained) {
            this.viewAttachPolicy = n;
            this.vprDirtyMask |= 0x10000;
        }
        if (this.source != null && this.source.isLive()) {
            this.repaint();
        }
    }

    void updateTransformRegion() {
        BoundingSphere boundingSphere = this.sphere;
        synchronized (boundingSphere) {
            this.schedSphere.set(this.sphere);
        }
        this.schedSphere.transform(this.getCurrentLocalToVworld(null));
    }
}

