/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.ViewPlatformRetained;

public class ViewPlatform
extends Leaf {
    public static final int ALLOW_POLICY_READ = 12;
    public static final int ALLOW_POLICY_WRITE = 13;

    public Node cloneNode(boolean bl) {
        ViewPlatform viewPlatform = new ViewPlatform();
        viewPlatform.duplicateNode(this, bl);
        return viewPlatform;
    }

    void createRetained() {
        this.retained = new ViewPlatformRetained();
        this.retained.setSource(this);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)node.retained;
        ViewPlatformRetained viewPlatformRetained2 = (ViewPlatformRetained)this.retained;
        viewPlatformRetained2.setActivationRadius(viewPlatformRetained.getActivationRadius());
        viewPlatformRetained2.setViewAttachPolicy(viewPlatformRetained.getViewAttachPolicy());
    }

    public float getActivationRadius() {
        return ((ViewPlatformRetained)this.retained).getActivationRadius();
    }

    public int getViewAttachPolicy() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewPlatform2"));
        }
        return ((ViewPlatformRetained)this.retained).getViewAttachPolicy();
    }

    public void setActivationRadius(float f) {
        ((ViewPlatformRetained)this.retained).setActivationRadius(f);
    }

    public void setViewAttachPolicy(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewPlatform0"));
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("ViewPlatform1"));
            }
            case 0: 
            case 1: 
            case 2: 
        }
        ((ViewPlatformRetained)this.retained).setViewAttachPolicy(n);
    }
}

