/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;

class TextureAttributesRetained
extends NodeComponentRetained {
    static final int TRANSFORM_CHANGED = 1;
    static final int MODE_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int CORRECTION_CHANGED = 8;
    static final int TEXTURE_COLOR_TABLE_CHANGED = 16;
    Transform3D transform = new Transform3D();
    int textureMode = 5;
    Color4f textureBlendColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int[] textureColorTable = null;
    int numTextureColorTableComponents = 0;
    int textureColorTableSize = 0;
    boolean disableSpecular = false;
    int perspCorrectionMode = 1;

    TextureAttributesRetained() {
    }

    protected Object clone() {
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)super.clone();
        textureAttributesRetained.transform = new Transform3D(this.transform);
        textureAttributesRetained.textureBlendColor = new Color4f(this.textureBlendColor);
        if (this.textureColorTable != null) {
            textureAttributesRetained.textureColorTable = new int[this.textureColorTable.length];
            System.arraycopy(this.textureColorTable, 0, textureAttributesRetained.textureColorTable, 0, this.textureColorTable.length);
        } else {
            textureAttributesRetained.textureColorTable = null;
        }
        return textureAttributesRetained;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TextureAttributesRetained textureAttributesRetained = new TextureAttributesRetained();
                textureAttributesRetained.source = this.source;
                textureAttributesRetained.set(this);
                this.mirror = textureAttributesRetained;
            }
        } else {
            ((TextureAttributesRetained)this.mirror).set(this);
        }
    }

    boolean equivalent(TextureAttributesRetained textureAttributesRetained) {
        boolean bl;
        boolean bl2 = bl = this == textureAttributesRetained || textureAttributesRetained != null && textureAttributesRetained.transform.equals(this.transform) && textureAttributesRetained.textureBlendColor.equals((Tuple4f)this.textureBlendColor) && textureAttributesRetained.textureMode == this.textureMode && textureAttributesRetained.perspCorrectionMode == this.perspCorrectionMode;
        if (!bl) {
            return false;
        }
        if (textureAttributesRetained.textureColorTable == null) {
            return this.textureColorTable == null;
        }
        if (this.textureColorTable == null) {
            return false;
        }
        if (textureAttributesRetained.textureColorTable.length != this.textureColorTable.length) {
            return false;
        }
        int n = 0;
        while (n < this.textureColorTable.length) {
            if (this.textureColorTable[n] != textureAttributesRetained.textureColorTable[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    final int getNumTextureColorTableComponents() {
        return this.numTextureColorTableComponents;
    }

    final int getPerspectiveCorrectionMode() {
        return this.perspCorrectionMode;
    }

    final void getTextureBlendColor(Color4f color4f) {
        color4f.set((Tuple4f)this.textureBlendColor);
    }

    final void getTextureColorTable(int[][] nArray) {
        if (this.textureColorTable == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.textureColorTableSize) {
            int n3 = 0;
            while (n3 < this.numTextureColorTableComponents) {
                nArray[n3][n2] = this.textureColorTable[n++];
                ++n3;
            }
            ++n2;
        }
    }

    final int getTextureColorTableSize() {
        return this.textureColorTableSize;
    }

    final int getTextureMode() {
        return this.textureMode;
    }

    final void getTextureTransform(Transform3D transform3D) {
        transform3D.set(this.transform);
    }

    synchronized void initMirrorObject() {
        ((TextureAttributesRetained)this.mirror).set(this);
    }

    final void initPerspectiveCorrectionMode(int n) {
        this.perspCorrectionMode = n;
    }

    final void initTextureBlendColor(float f, float f2, float f3, float f4) {
        this.textureBlendColor.set(f, f2, f3, f4);
    }

    final void initTextureBlendColor(Color4f color4f) {
        this.textureBlendColor.set((Tuple4f)color4f);
    }

    final void initTextureColorTable(int[][] nArray) {
        this.numTextureColorTableComponents = 0;
        this.textureColorTableSize = 0;
        if (nArray == null) {
            this.textureColorTable = null;
            return;
        }
        if (nArray.length < 3 || nArray.length > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes13"));
        }
        if (Texture.getPowerOf2(nArray[0].length) == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes14"));
        }
        int n = 1;
        while (n < nArray.length) {
            if (nArray[n].length != nArray[0].length) {
                throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes15"));
            }
            ++n;
        }
        this.numTextureColorTableComponents = nArray.length;
        this.textureColorTableSize = nArray[0].length;
        if (this.textureColorTable == null || this.textureColorTable.length != this.numTextureColorTableComponents * this.textureColorTableSize) {
            this.textureColorTable = new int[this.numTextureColorTableComponents * this.textureColorTableSize];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.textureColorTableSize) {
            int n4 = 0;
            while (n4 < this.numTextureColorTableComponents) {
                this.textureColorTable[n2++] = nArray[n4][n3];
                ++n4;
            }
            ++n3;
        }
    }

    final void initTextureMode(int n) {
        this.textureMode = n;
    }

    final void initTextureTransform(Transform3D transform3D) {
        this.transform.set(transform3D);
    }

    native void restoreBlend1Pass(int var1);

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 11;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 11;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }

    protected void set(TextureAttributesRetained textureAttributesRetained) {
        this.transform.set(textureAttributesRetained.transform);
        this.textureBlendColor.set((Tuple4f)textureAttributesRetained.textureBlendColor);
        this.textureMode = textureAttributesRetained.textureMode;
        this.perspCorrectionMode = textureAttributesRetained.perspCorrectionMode;
        if (textureAttributesRetained.textureColorTable != null) {
            if (this.textureColorTable == null || this.textureColorTable.length != textureAttributesRetained.textureColorTable.length) {
                this.textureColorTable = new int[textureAttributesRetained.textureColorTable.length];
            }
            System.arraycopy(textureAttributesRetained.textureColorTable, 0, this.textureColorTable, 0, textureAttributesRetained.textureColorTable.length);
        } else {
            this.textureColorTable = null;
        }
        this.numTextureColorTableComponents = textureAttributesRetained.numTextureColorTableComponents;
        this.textureColorTableSize = textureAttributesRetained.textureColorTableSize;
    }

    final void setPerspectiveCorrectionMode(int n) {
        this.perspCorrectionMode = n;
        this.sendMessage(8, new Integer(n));
    }

    final void setTextureBlendColor(float f, float f2, float f3, float f4) {
        this.textureBlendColor.set(f, f2, f3, f4);
        this.sendMessage(4, new Color4f(f, f2, f3, f4));
    }

    final void setTextureBlendColor(Color4f color4f) {
        this.textureBlendColor.set((Tuple4f)color4f);
        this.sendMessage(4, new Color4f(color4f));
    }

    final void setTextureColorTable(int[][] nArray) {
        this.initTextureColorTable(nArray);
        if (nArray == null) {
            this.sendMessage(16, null);
        } else {
            int[] nArray2 = new int[this.textureColorTableSize * this.numTextureColorTableComponents];
            System.arraycopy(this.textureColorTable, 0, nArray2, 0, this.textureColorTable.length);
            Object[] objectArray = new Object[]{new Integer(this.numTextureColorTableComponents), new Integer(this.textureColorTableSize), nArray2};
            this.sendMessage(16, objectArray);
        }
    }

    final void setTextureMode(int n) {
        this.textureMode = n;
        this.sendMessage(2, new Integer(n));
    }

    final void setTextureTransform(Transform3D transform3D) {
        this.transform.set(transform3D);
        this.sendMessage(1, new Transform3D(transform3D));
    }

    native void updateBlend2Pass(int var1);

    synchronized void updateMirrorObject(int n, Object object) {
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            textureAttributesRetained.transform.set((Transform3D)object);
        } else if ((n & 2) != 0) {
            textureAttributesRetained.textureMode = (Integer)object;
        } else if ((n & 4) != 0) {
            textureAttributesRetained.textureBlendColor.set((Tuple4f)((Color4f)object));
        } else if ((n & 8) != 0) {
            textureAttributesRetained.perspCorrectionMode = (Integer)object;
        } else if ((n & 0x10) != 0) {
            if (object == null) {
                textureAttributesRetained.textureColorTable = null;
                textureAttributesRetained.numTextureColorTableComponents = 0;
                textureAttributesRetained.textureColorTableSize = 0;
            } else {
                Object[] objectArray = (Object[])object;
                textureAttributesRetained.textureColorTable = (int[])objectArray[2];
                textureAttributesRetained.numTextureColorTableComponents = (Integer)objectArray[0];
                textureAttributesRetained.textureColorTableSize = (Integer)objectArray[1];
            }
        }
    }

    native boolean updateNative(int var1, double[] var2, int var3, int var4, float var5, float var6, float var7, float var8, int var9);

    void updateNative(Canvas3D canvas3D, boolean bl, int n) {
        if (!bl) {
            this.disableSpecular = this.updateNative(canvas3D.ctx, this.transform.mat, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n);
            if (canvas3D.textureColorTableAvailable && this.textureColorTable != null) {
                this.updateTextureColorTableNative(canvas3D.ctx, this.numTextureColorTableComponents, this.textureColorTableSize, this.textureColorTable);
            }
        } else {
            this.disableSpecular = this.updateNative(canvas3D.ctx, this.transform.mat, 5, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, n);
            if (canvas3D.textureColorTableAvailable && this.textureColorTable != null) {
                this.updateTextureColorTableNative(canvas3D.ctx, this.numTextureColorTableComponents, this.textureColorTableSize, this.textureColorTable);
            }
            switch (this.textureMode) {
                case 5: {
                    canvas3D.setBlendFunc(canvas3D.ctx, 1, 0);
                    break;
                }
                case 2: {
                    canvas3D.setBlendFunc(canvas3D.ctx, 4, 0);
                    break;
                }
                case 3: {
                    if (canvas3D.texture.format == 6) {
                        canvas3D.setBlendFunc(canvas3D.ctx, 2, 3);
                        break;
                    }
                    canvas3D.setBlendFunc(canvas3D.ctx, 1, 0);
                    break;
                }
                case 4: {
                    canvas3D.setBlendFunc(canvas3D.ctx, 7, 6);
                    break;
                }
            }
        }
    }

    native void updateTextureColorTableNative(int var1, int var2, int var3, int[] var4);
}

