/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dStructure;
import javax.media.j3d.J3dThread;

class StructureUpdateThread
extends J3dThread {
    J3dStructure structure;
    private static int[] numInstances = new int[7];
    private int[] instanceNum = new int[7];

    StructureUpdateThread(ThreadGroup threadGroup, J3dStructure j3dStructure, int n) {
        super(threadGroup);
        this.structure = j3dStructure;
        this.type = n;
        this.classification = 2;
        switch (this.type) {
            case 64: {
                this.setName("J3D-GeometryStructureUpdateThread-" + this.getInstanceNum(0));
                break;
            }
            case 128: {
                this.setName("J3D-RenderStructureUpdateThread-" + this.getInstanceNum(1));
                break;
            }
            case 256: {
                this.setName("J3D-BehaviorStructureUpdateThread-" + this.getInstanceNum(2));
                break;
            }
            case 512: {
                this.setName("J3D-SoundStructureUpdateThread-" + this.getInstanceNum(3));
                break;
            }
            case 1024: {
                this.setName("J3D-RenderingAttributesStructureUpdateThread");
                break;
            }
            case 4096: {
                this.setName("J3D-RenderingEnvironmentStructureUpdateThread-" + this.getInstanceNum(4));
                break;
            }
            case 8192: {
                this.setName("J3D-TransformStructureUpdateThread-" + this.getInstanceNum(5));
                break;
            }
            case 2: {
                this.setName("J3D-SoundSchedulerUpdateThread-" + this.getInstanceNum(6));
                break;
            }
        }
    }

    void doWork(long l) {
        this.structure.processMessages(l);
    }

    int getInstanceNum(int n) {
        if (this.instanceNum[n] == 0) {
            this.instanceNum[n] = this.newInstanceNum(n);
        }
        return this.instanceNum[n];
    }

    private synchronized int newInstanceNum(int n) {
        int n2 = n;
        int n3 = numInstances[n2] + 1;
        numInstances[n2] = n3;
        return n3;
    }
}

