/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.AuralAttributes;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class SoundscapeRetained
extends LeafRetained {
    static final int ATTRIBUTES_CHANGED = 1;
    static final int BOUNDING_LEAF_CHANGED = 2;
    static final int APPLICATION_BOUNDS_CHANGED = 4;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    AuralAttributesRetained attributes = null;
    int isDirty = 65535;
    int targetThreads = 514;

    SoundscapeRetained() {
        this.nodeType = 15;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.attributes != null) {
            this.attributes.clearLive(setLiveState.refCount);
        }
        setLiveState.nodeList.add(this);
        setLiveState.notifyThreads |= 0x202;
    }

    void dispatchMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = this.targetThreads;
        j3dMessage.type = 40;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = new Integer(0);
        j3dMessage.args[3] = null;
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        if (this.boundingLeaf != null) {
            return (BoundingLeaf)this.boundingLeaf.source;
        }
        return null;
    }

    Bounds getApplicationBounds() {
        if (this.applicationRegion == null) {
            return null;
        }
        return (Bounds)this.applicationRegion.clone();
    }

    AuralAttributes getAuralAttributes() {
        if (this.attributes != null) {
            return (AuralAttributes)this.attributes.source;
        }
        return null;
    }

    void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        this.updateTransformChange();
        this.isDirty |= 2;
        this.dispatchMessage(2, boundingLeaf);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setApplicationBounds(Bounds bounds) {
        this.applicationRegion = bounds != null ? (Bounds)bounds.clone() : null;
        this.updateTransformChange();
        this.isDirty |= 4;
        this.dispatchMessage(4, bounds);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAuralAttributes(AuralAttributes auralAttributes) {
        if (this.source.isLive()) {
            if (this.attributes != null) {
                this.attributes.clearLive(this.refCount);
            }
            if (auralAttributes != null) {
                ((AuralAttributesRetained)auralAttributes.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        if (this.attributes != null) {
            this.attributes.removeUser(this);
        }
        if (auralAttributes != null) {
            this.attributes = (AuralAttributesRetained)auralAttributes.retained;
            this.attributes.addUser(this);
        } else {
            this.attributes = null;
        }
        this.isDirty |= 1;
        this.dispatchMessage(1, auralAttributes);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        if (this.attributes != null) {
            this.attributes.setLive(this.inBackgroundGroup, setLiveState.refCount);
        }
        setLiveState.nodeList.add(this);
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.clearCompositeSwitchMask();
                    this.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.envNodes.add(this);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.clearCompositeSwitchMask();
            this.isNewSwitchLeaf = true;
            ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.envNodes.add(this);
        }
        setLiveState.notifyThreads |= 0x202;
        super.markAsLive();
    }

    void update(SoundscapeRetained soundscapeRetained) {
        this.applicationRegion = (Bounds)soundscapeRetained.applicationRegion.clone();
        this.attributes = soundscapeRetained.attributes;
    }

    void updateBoundingLeaf(long l) {
        if (this.boundingLeaf != null && this.boundingLeaf.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.lastLocalToVworld[0]);
        } else {
            this.transformedRegion = null;
        }
    }

    synchronized void updateMirrorObject(Object[] objectArray) {
        Object var2_2 = null;
        int n = (Integer)objectArray[1];
        if ((n & 2) != 0) {
            if (this.boundingLeaf != null) {
                this.transformedRegion = this.boundingLeaf.transformedRegion;
            } else if (this.applicationRegion != null) {
                this.transformedRegion = (Bounds)this.applicationRegion.clone();
                this.transformedRegion.transform(this.applicationRegion, this.lastLocalToVworld[0]);
            } else {
                this.transformedRegion = null;
            }
        } else if ((n & 4) != 0) {
            if (this.boundingLeaf == null) {
                this.transformedRegion = (Bounds)this.applicationRegion.clone();
                this.transformedRegion.transform(this.applicationRegion, this.lastLocalToVworld[0]);
            } else {
                this.transformedRegion = null;
            }
        }
    }

    synchronized void updateTransformChange() {
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            if (this.lastLocalToVworld != null) {
                this.transformedRegion.transform(this.applicationRegion, this.lastLocalToVworld[0]);
            }
        } else {
            this.transformedRegion = null;
        }
    }
}

