/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BackgroundSoundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.MediaContainerRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.Sound;
import javax.media.j3d.SoundException;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundSchedulerAtom;
import javax.media.j3d.SoundscapeRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class SoundScheduler
extends J3dStructure {
    View view = null;
    boolean ready = false;
    ViewPlatformRetained viewPlatform = null;
    GraphicsContext3D graphicsCtx = null;
    AuralAttributesRetained lastAA = null;
    boolean resetAA = true;
    AudioDevice audioDevice = null;
    AudioDevice3D audioDevice3D = null;
    int totalChannels = 0;
    SoundscapeRetained[] intersectedSoundscapes = new SoundscapeRetained[32];
    Bounds[] intersectedRegions = new Bounds[32];
    Bounds region = null;
    ArrayList prioritizedSounds = new ArrayList();
    int nRetainedSounds = -1;
    int nImmedSounds = -1;
    AuralAttributesRetained aaRetained = null;
    AuralAttributesRetained aaImmed = null;
    static final int EAR_POSITIONS_CHANGED = 1;
    static final int EYE_POSITIONS_CHANGED = 2;
    static final int IMAGE_PLATE_TO_VWORLD_CHANGED = 4;
    static final int HEAD_TO_VWORLD_CHANGED = 8;
    static final int LISTENER_CHANGED = 15;
    private int listenerUpdated = 15;
    private boolean positionalSoundUpdated = false;
    private boolean auralAttribsDirty = true;
    private boolean stallThread = false;
    int lastEventReceived = 202;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundScheduler(VirtualUniverse virtualUniverse, View view) {
        super(virtualUniverse, 2);
        this.universe = virtualUniverse;
        this.view = view;
        this.reset(view);
    }

    void addPrioritizedSound(SoundRetained soundRetained) {
        SoundRetained soundRetained2 = soundRetained.sgSound;
        SoundSchedulerAtom soundSchedulerAtom = new SoundSchedulerAtom();
        soundSchedulerAtom.soundScheduler = this;
        if (soundRetained2 == null) {
            soundRetained.sgSound = soundRetained;
            soundRetained2 = soundRetained;
        }
        soundSchedulerAtom.sound = soundRetained;
        this.enableAtom(soundSchedulerAtom, soundRetained2);
        if (this.prioritizedSounds.isEmpty()) {
            this.prioritizedSounds.add(soundSchedulerAtom);
        } else {
            int n = this.prioritizedSounds.size() - 1;
            float f = soundRetained2.priority;
            int n2 = n;
            while (n2 >= 0) {
                SoundSchedulerAtom soundSchedulerAtom2 = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                SoundRetained soundRetained3 = soundSchedulerAtom2.sound;
                if (f <= soundRetained3.sgSound.priority) {
                    if (n2 == n) {
                        this.prioritizedSounds.add(soundSchedulerAtom);
                        break;
                    }
                    this.prioritizedSounds.add(n2 + 1, soundSchedulerAtom);
                    break;
                }
                --n2;
            }
            if (n2 < 0) {
                this.prioritizedSounds.add(0, soundSchedulerAtom);
            }
        }
    }

    void addSound(SoundRetained soundRetained) {
        if (soundRetained == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            this.addPrioritizedSound(soundRetained);
        }
    }

    void attachSoundData(SoundSchedulerAtom soundSchedulerAtom, MediaContainer mediaContainer) {
        long l;
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        AudioDevice3D audioDevice3D = null;
        if (this.universe != null && this.universe.currentView != null && this.universe.currentView.physicalEnvironment != null && this.universe.currentView.physicalEnvironment.audioDevice != null) {
            audioDevice3D = (AudioDevice3D)this.universe.currentView.physicalEnvironment.audioDevice;
        }
        if (audioDevice3D == null) {
            soundSchedulerAtom.loadStatus = 1;
            soundRetained.changeAtomList(soundSchedulerAtom, 1);
            return;
        }
        if (soundRetained.soundData != mediaContainer && soundRetained.soundData != null) {
            this.clearSoundData(soundSchedulerAtom);
        }
        if (mediaContainer == null) {
            soundSchedulerAtom.loadStatus = 0;
            soundRetained.changeAtomList(soundSchedulerAtom, 0);
            return;
        }
        URL uRL = ((MediaContainerRetained)soundRetained.soundData.retained).url;
        String string = ((MediaContainerRetained)soundRetained.soundData.retained).urlString;
        InputStream inputStream = ((MediaContainerRetained)soundRetained.soundData.retained).inputStream;
        if (uRL == null && string == null && inputStream == null) {
            soundSchedulerAtom.loadStatus = 0;
            soundRetained.changeAtomList(soundSchedulerAtom, 0);
            return;
        }
        if (string == null) {
            string = new String(uRL.toString());
        }
        if (uRL == null) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                soundSchedulerAtom.loadStatus = 0;
                soundRetained.changeAtomList(soundSchedulerAtom, 0);
                return;
            }
        }
        soundRetained.soundType = soundRetained instanceof ConeSoundRetained ? 3 : (soundRetained instanceof PointSoundRetained ? 2 : 1);
        MediaContainer mediaContainer2 = (MediaContainer)mediaContainer.cloneNodeComponent(true);
        mediaContainer2.setCapability(0);
        mediaContainer2.setCapability(2);
        mediaContainer2.setURLObject(null);
        mediaContainer2.setURLString(string);
        int n = audioDevice3D.prepareSound(soundRetained.soundType, mediaContainer2);
        if (n == -1) {
            soundSchedulerAtom.loadStatus = -1;
            soundRetained.changeAtomList(soundSchedulerAtom, -1);
            throw new SoundException(String.valueOf(string) + ": " + J3dI18N.getString("SoundRetained1"));
        }
        soundSchedulerAtom.sampleId = n;
        soundSchedulerAtom.loopLength = soundSchedulerAtom.sampleLength = (l = audioDevice3D.getSampleDuration(n));
        soundSchedulerAtom.loopStartOffset = 0L;
        soundSchedulerAtom.attackLength = 0L;
        soundSchedulerAtom.releaseLength = 0L;
        soundSchedulerAtom.loadStatus = 2;
        soundRetained.changeAtomList(soundSchedulerAtom, 2);
    }

    int calcSchedulingAction() {
        int n = 0;
        int n2 = 0;
        if (this.universe == null) {
            return 0;
        }
        if (this.universe.soundStructure == null) {
            return 0;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            n = this.prioritizedSounds.size();
            int n3 = 0;
            while (n3 < n) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n3);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                boolean bl = false;
                if (!soundRetained2.source.isLive() && !soundRetained2.getInImmCtx()) {
                    if (soundSchedulerAtom.playing || soundSchedulerAtom.enabled == 1) {
                        soundSchedulerAtom.setEnableState(3);
                        bl = true;
                    } else if (soundSchedulerAtom.enabled == 3) {
                        bl = true;
                    } else if (soundSchedulerAtom.enabled == 2) {
                        soundSchedulerAtom.setEnableState(0);
                    }
                } else {
                    if (soundRetained.currentSwitchOn) {
                        bl = true;
                    } else {
                        if (soundSchedulerAtom.enabled == 3) {
                            bl = true;
                        }
                        if (soundRetained2.continuous) {
                            bl = true;
                        }
                    }
                    bl = true;
                }
                if (bl) {
                    ++n2;
                    this.processSoundAtom(soundSchedulerAtom);
                } else {
                    soundSchedulerAtom.schedulingAction = 0;
                }
                ++n3;
            }
        }
        return n2;
    }

    void changeNodeAttrib(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        int n = (Integer)object2;
        if (object instanceof SoundRetained) {
            this.setAttribsDirtyFlag((SoundRetained)object, n);
            if ((n & 0x100) > 0) {
                this.shuffleSound((SoundRetained)object);
            }
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object);
            }
            if ((n & 0x20) > 0) {
                this.enableSound((SoundRetained)object);
            }
        } else if (object instanceof SoundscapeRetained) {
            this.auralAttribsDirty = true;
        } else if (object instanceof AuralAttributesRetained) {
            this.auralAttribsDirty = true;
        }
    }

    void changeNodeState(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        int n = (Integer)object2;
        if (object instanceof SoundRetained) {
            this.setStateDirtyFlag((SoundRetained)object, n);
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object);
            }
        }
    }

    boolean checkState() {
        boolean bl = false;
        if (this.stallThread) {
            bl = false;
        }
        if (this.ready) {
            bl = true;
        } else {
            this.reset(this.view);
            bl = this.ready;
        }
        return bl;
    }

    void clearDirtyFlag() {
        this.listenerUpdated = 0;
    }

    void clearSoundData(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        if (soundSchedulerAtom.sound.soundData != null) {
            if (this.universe != null && this.universe.currentView != null && this.universe.currentView.physicalEnvironment != null && this.universe.currentView.physicalEnvironment.audioDevice != null) {
                this.audioDevice3D = (AudioDevice3D)this.universe.currentView.physicalEnvironment.audioDevice;
            }
            if (this.audioDevice3D != null && soundSchedulerAtom.sampleId != -1) {
                this.audioDevice3D.clearSound(soundSchedulerAtom.sampleId);
            }
        }
        soundSchedulerAtom.sampleId = -1;
    }

    void debugPrint(String string) {
    }

    void deleteSound(SoundRetained soundRetained) {
        if (soundRetained != null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    if (soundSchedulerAtom.sound == soundRetained || soundSchedulerAtom.sound.sgSound == soundRetained) {
                        this.prioritizedSounds.remove(n2);
                    }
                    ++n2;
                }
            }
        }
    }

    void enableAtom(SoundSchedulerAtom soundSchedulerAtom, SoundRetained soundRetained) {
        if (soundRetained.enable) {
            soundSchedulerAtom.setEnableState(2);
        } else {
            soundSchedulerAtom.setEnableState(3);
        }
    }

    void enableSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        soundSchedulerAtom = this.findSoundAtom(soundRetained);
        if (soundSchedulerAtom != null) {
            this.enableAtom(soundSchedulerAtom, soundRetained);
        }
    }

    int findActiveSoundscapes() {
        int n = 0;
        int n2 = 0;
        Object var3_3 = null;
        SoundscapeRetained soundscapeRetained = null;
        boolean bl = false;
        int n3 = 0;
        UnorderList unorderList = null;
        if (this.universe == null) {
            return 0;
        }
        unorderList = this.universe.soundStructure.getSoundscapeList();
        if (unorderList == null) {
            return 0;
        }
        UnorderList unorderList2 = unorderList;
        synchronized (unorderList2) {
            n3 = unorderList.size;
            if (n3 == 0) {
                int n4 = 0;
                Object var10_10 = null;
                return n4;
            }
            if (this.intersectedRegions.length < n) {
                this.intersectedRegions = new Bounds[n + 32];
            }
            if (this.intersectedSoundscapes.length < n) {
                this.intersectedSoundscapes = new SoundscapeRetained[n + 32];
            }
            n2 = 0;
            int n5 = 0;
            while (n5 < n3) {
                soundscapeRetained = (SoundscapeRetained)unorderList.get(n5);
                if (soundscapeRetained.transformedRegion != null) {
                    if (this.region instanceof BoundingSphere && soundscapeRetained.transformedRegion instanceof BoundingSphere || this.region instanceof BoundingBox && soundscapeRetained.transformedRegion instanceof BoundingBox || this.region instanceof BoundingPolytope && soundscapeRetained.transformedRegion instanceof BoundingPolytope) {
                        soundscapeRetained.transformedRegion.getWithLock(this.region);
                    } else {
                        this.region = (Bounds)soundscapeRetained.transformedRegion.clone();
                    }
                    if (this.region != null && this.viewPlatform.schedSphere.intersect(this.region)) {
                        this.intersectedRegions[n2] = (Bounds)this.region.clone();
                        this.intersectedSoundscapes[n2] = soundscapeRetained;
                        ++n2;
                    }
                }
                ++n5;
            }
        }
        return n2;
    }

    AuralAttributesRetained findClosestAAttribs(int n) {
        AuralAttributes auralAttributes = null;
        SoundscapeRetained soundscapeRetained = null;
        boolean bl = false;
        soundscapeRetained = null;
        if (n == 1) {
            soundscapeRetained = this.intersectedSoundscapes[0];
        } else if (n > 1) {
            Bounds bounds = this.viewPlatform.schedSphere.closestIntersection(this.intersectedRegions);
            int n2 = 0;
            while (n2 < this.intersectedRegions.length) {
                if (this.intersectedRegions[n2] == bounds) {
                    soundscapeRetained = this.intersectedSoundscapes[n2];
                    break;
                }
                ++n2;
            }
        }
        if (soundscapeRetained != null) {
            auralAttributes = soundscapeRetained.getAuralAttributes();
        }
        return (AuralAttributesRetained)auralAttributes.retained;
    }

    SoundSchedulerAtom findSoundAtom(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        boolean bl = false;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    if (soundSchedulerAtom.sound == soundRetained || soundSchedulerAtom.sound.sgSound == soundRetained) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return soundSchedulerAtom;
    }

    void insertNodes(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof SoundRetained) {
                ++this.nRetainedSounds;
                this.addSound((SoundRetained)object);
            } else if (object instanceof SoundscapeRetained) {
                this.auralAttribsDirty = true;
            } else if (object instanceof AuralAttributesRetained) {
                this.auralAttribsDirty = true;
            }
            ++n;
        }
    }

    void loadSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        soundSchedulerAtom = this.findSoundAtom(soundRetained);
        if (soundSchedulerAtom != null) {
            MediaContainer mediaContainer = soundRetained.getSoundData();
            if (soundSchedulerAtom.loadStatus != 2) {
                this.attachSoundData(soundSchedulerAtom, mediaContainer);
            }
        }
    }

    void muteSilentSounds() {
        int n = 0;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n2 = this.prioritizedSounds.size();
            int n3 = 0;
            while (n3 < n2) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n3);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                int n4 = soundSchedulerAtom.sampleId;
                int n5 = soundSchedulerAtom.status;
                if (soundSchedulerAtom.status != 3 && soundSchedulerAtom.schedulingAction != 0 && n4 != -1) {
                    int n6;
                    if (soundSchedulerAtom.schedulingAction == 9 || soundSchedulerAtom.schedulingAction == 6 || soundSchedulerAtom.schedulingAction == 2 || soundSchedulerAtom.schedulingAction == 7) {
                        if (n5 != 2) {
                            this.audioDevice3D.muteSample(n4);
                        }
                        soundSchedulerAtom.numberChannels = n6 = this.audioDevice3D.getNumberOfChannelsUsed(n4);
                        n += n6;
                    } else {
                        n6 = this.audioDevice3D.getNumberOfChannelsUsed(n4, false);
                        if (n + n6 > this.totalChannels) {
                            if (soundSchedulerAtom.schedulingAction == 8 || soundSchedulerAtom.schedulingAction == 3) {
                                soundSchedulerAtom.schedulingAction = 9;
                            } else if (soundSchedulerAtom.schedulingAction == 4) {
                                soundSchedulerAtom.schedulingAction = 6;
                            } else if (soundSchedulerAtom.schedulingAction == 5) {
                                soundSchedulerAtom.schedulingAction = 7;
                            }
                            this.audioDevice3D.muteSample(n4);
                        } else if (n5 != 1) {
                            this.audioDevice3D.unmuteSample(n4);
                        }
                        soundSchedulerAtom.numberChannels = n6 = this.audioDevice3D.getNumberOfChannelsUsed(n4);
                        n += n6;
                    }
                }
                ++n3;
            }
        }
    }

    void pause(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.pauseSample(soundSchedulerAtom.sampleId);
    }

    synchronized void pauseAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        this.stallThread = true;
        if (this.prioritizedSounds != null) {
            int n = this.prioritizedSounds.size();
            int n2 = 0;
            while (n2 < n) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                switch (soundSchedulerAtom.enabled) {
                    case 1: 
                    case 3: {
                        this.pause(soundSchedulerAtom);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    int performActions() {
        int n = 0;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n2 = this.prioritizedSounds.size();
            int n3 = 0;
            while (n3 < n2) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n3);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                int n4 = soundSchedulerAtom.sampleId;
                if (n4 != -1) {
                    this.resetAA = false;
                    AuralAttributesRetained auralAttributesRetained = soundRetained2.getInImmCtx() ? (this.graphicsCtx != null && this.graphicsCtx.auralAttributes != null ? (this.aaImmed = (AuralAttributesRetained)this.graphicsCtx.auralAttributes.retained) : null) : this.aaRetained;
                    this.updateAuralAttribs(auralAttributesRetained);
                    switch (soundSchedulerAtom.schedulingAction) {
                        case 4: {
                            this.turnOff(soundSchedulerAtom);
                        }
                        case 5: {
                            soundSchedulerAtom.status = 1;
                            this.render(true, soundSchedulerAtom, auralAttributesRetained);
                            ++n;
                            break;
                        }
                        case 6: {
                            this.turnOff(soundSchedulerAtom);
                        }
                        case 7: {
                            soundSchedulerAtom.status = 2;
                            this.render(true, soundSchedulerAtom, auralAttributesRetained);
                            ++n;
                            break;
                        }
                        case 8: {
                            soundSchedulerAtom.status = 1;
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            ++n;
                            break;
                        }
                        case 9: {
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            soundSchedulerAtom.status = 2;
                            ++n;
                            break;
                        }
                        case 11: {
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            ++n;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (this.resetAA || soundSchedulerAtom.testDirtyFlags()) {
                                this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            }
                            ++n;
                            break;
                        }
                    }
                    if (soundSchedulerAtom.enabled == 2) {
                        if (n4 != -1) {
                            soundSchedulerAtom.setEnableState(1);
                        } else if (soundSchedulerAtom.enabled == 3) {
                            soundSchedulerAtom.setEnableState(0);
                        }
                    }
                    soundSchedulerAtom.clearStateDirtyFlag();
                    soundSchedulerAtom.clearAttribsDirtyFlag();
                }
                ++n3;
            }
        }
        this.resetAA = false;
        return n;
    }

    void printAtomState(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        this.debugPrint("                 this atom = " + soundSchedulerAtom + "       ");
        this.debugPrint("                 references sound = " + soundRetained + "       ");
        this.debugPrint("                 enabled " + soundSchedulerAtom.enabled);
        this.debugPrint("                 status " + soundSchedulerAtom.status);
        this.debugPrint("                 activated " + soundSchedulerAtom.activated);
        this.debugPrint("                 released " + soundRetained.release);
        this.debugPrint("                 continuous " + soundRetained.continuous);
        this.debugPrint("                 scheduling " + soundSchedulerAtom.schedulingAction);
    }

    int prioritizeSounds() {
        int n;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                this.prioritizedSounds.clear();
            }
            UnorderList unorderList = this.universe.soundStructure.getSoundList();
            this.nRetainedSounds = 0;
            this.nImmedSounds = 0;
            int n2 = 0;
            while (n2 < unorderList.size()) {
                this.addPrioritizedSound((SoundRetained)unorderList.get(n2));
                ++this.nRetainedSounds;
                ++n2;
            }
            Enumeration enumeration = this.view.getAllCanvas3Ds();
            while (enumeration.hasMoreElements()) {
                Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                GraphicsContext3D graphicsContext3D = canvas3D.getGraphicsContext3D();
                Enumeration enumeration2 = graphicsContext3D.getAllSounds();
                while (enumeration2.hasMoreElements()) {
                    Sound sound = (Sound)enumeration2.nextElement();
                    if (sound == null) continue;
                    this.addPrioritizedSound((SoundRetained)sound.retained);
                    ++this.nImmedSounds;
                }
            }
            n = this.prioritizedSounds.size();
        }
        return n;
    }

    void processImmediateNodes(Object[] objectArray, long l) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray[2];
        Sound sound = (Sound)object3;
        Sound sound2 = (Sound)object2;
        int n = (Integer)object;
        switch (n) {
            case 15: 
            case 17: {
                this.addSound((SoundRetained)sound2.retained);
                ++this.nImmedSounds;
                break;
            }
            case 16: {
                this.deleteSound((SoundRetained)sound.retained);
                --this.nImmedSounds;
                break;
            }
            case 14: {
                this.deleteSound((SoundRetained)sound.retained);
                this.addSound((SoundRetained)sound2.retained);
                break;
            }
        }
    }

    void processMessages(long l) {
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        if (j3dMessageArray != null) {
            int n = 0;
            while (n < j3dMessageArray.length) {
                switch (j3dMessageArray[n].type) {
                    case 0: {
                        this.insertNodes((Object[])j3dMessageArray[n].args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes((Object[])j3dMessageArray[n].args[0]);
                        break;
                    }
                    case 38: {
                        this.changeNodeAttrib(j3dMessageArray[n]);
                        break;
                    }
                    case 45: {
                        this.changeNodeState(j3dMessageArray[n]);
                        break;
                    }
                    case 23: {
                        this.auralAttribsDirty = true;
                        break;
                    }
                    case 39: 
                    case 40: {
                        this.changeNodeAttrib(j3dMessageArray[n]);
                        break;
                    }
                    case 3: {
                        this.updateTransformChange(j3dMessageArray[n].args, l);
                        this.auralAttribsDirty = true;
                        break;
                    }
                    case 44: {
                        this.processImmediateNodes(j3dMessageArray[n].args, l);
                        break;
                    }
                    case 4: {
                        if (this.prioritizedSounds.size() != 0) break;
                        int n2 = this.prioritizeSounds();
                        break;
                    }
                }
                j3dMessageArray[n].decRefcount();
                ++n;
            }
        }
        this.renderChanges();
        long l2 = this.shortestTimeToFinish();
        if (l2 == 0L) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 2);
        } else if (l2 > 0L) {
            VirtualUniverse.mc.sendRunMessage(l2, this.view, 2);
        }
    }

    void processSoundAtom(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundSchedulerAtom.status == 3 && soundSchedulerAtom.enabled != 2) {
            return;
        }
        if (soundSchedulerAtom.loadStatus != 2) {
            this.attachSoundData(soundSchedulerAtom, soundRetained2.soundData);
        }
        if (soundSchedulerAtom.loadStatus != 2) {
            return;
        }
        if (this.resetAA) {
            soundSchedulerAtom.setAttribsDirtyFlag(2);
        }
        boolean bl = false;
        if (soundRetained2 instanceof BackgroundSoundRetained || soundRetained2.getInImmCtx()) {
            this.region = null;
            bl = true;
        } else {
            if (soundRetained2.schedulingRegion != null && soundRetained.transformedRegion != null) {
                if (this.region instanceof BoundingSphere && soundRetained.transformedRegion instanceof BoundingSphere || this.region instanceof BoundingBox && soundRetained.transformedRegion instanceof BoundingBox || this.region instanceof BoundingPolytope && soundRetained.transformedRegion instanceof BoundingPolytope) {
                    soundRetained.transformedRegion.getWithLock(this.region);
                } else {
                    this.region = (Bounds)soundRetained.transformedRegion.clone();
                }
            } else {
                this.region = null;
            }
            bl = this.region != null ? this.viewPlatform.schedSphere.intersect(this.region) : false;
        }
        soundSchedulerAtom.schedulingAction = bl ? soundSchedulerAtom.calcActiveSchedAction() : soundSchedulerAtom.calcInactiveSchedAction();
        if (soundSchedulerAtom.schedulingAction == 3 && (soundSchedulerAtom.testDirtyFlags() || this.testDirtyFlag() && !(soundRetained2 instanceof BackgroundSoundRetained))) {
            soundSchedulerAtom.schedulingAction = 11;
        }
        switch (soundSchedulerAtom.schedulingAction) {
            case 10: {
                soundSchedulerAtom.status = 0;
                this.turnOff(soundSchedulerAtom);
                soundSchedulerAtom.schedulingAction = 1;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: {
                long l = System.currentTimeMillis();
                if (soundSchedulerAtom.endTime <= 0L || soundSchedulerAtom.endTime > l) break;
                soundSchedulerAtom.schedulingAction = 12;
                soundSchedulerAtom.status = 3;
                this.turnOff(soundSchedulerAtom);
                break;
            }
            default: {
                soundSchedulerAtom.schedulingAction = 0;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
    }

    void receiveAWTEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (this.ready && n == 203) {
            this.lastEventReceived = n;
        } else if (this.ready && this.lastEventReceived == 203 && n == 204) {
            this.lastEventReceived = n;
        }
    }

    void removeNodes(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof SoundRetained) {
                --this.nRetainedSounds;
                this.deleteSound((SoundRetained)object);
            }
            ++n;
        }
    }

    void render(boolean bl, SoundSchedulerAtom soundSchedulerAtom, AuralAttributesRetained auralAttributesRetained) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundSchedulerAtom.sampleId == -1 || soundRetained2.soundData == null) {
            return;
        }
        int n = soundSchedulerAtom.sampleId;
        if (bl) {
            if (soundRetained2 instanceof PointSoundRetained || soundRetained2 instanceof ConeSoundRetained) {
                this.updateXformedParams(true, soundSchedulerAtom);
            }
            this.updateSoundParams(true, soundSchedulerAtom, auralAttributesRetained);
            this.start(soundSchedulerAtom);
        } else if (soundSchedulerAtom.status == 1) {
            if (soundRetained2 instanceof PointSoundRetained || soundRetained2 instanceof ConeSoundRetained) {
                this.updateXformedParams(false, soundSchedulerAtom);
            }
            this.updateSoundParams(false, soundSchedulerAtom, auralAttributesRetained);
            this.update(soundSchedulerAtom);
        }
    }

    void renderChanges() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        if (!this.checkState()) {
            return;
        }
        n = this.prioritizedSounds.size();
        if (n == 0) {
            return;
        }
        if (this.auralAttribsDirty) {
            int n3 = this.findActiveSoundscapes();
            if (n3 > 0) {
                this.aaRetained = (AuralAttributesRetained)this.findClosestAAttribs(n3).clone();
            }
            this.auralAttribsDirty = false;
        }
        if (n > 0) {
            this.calcSchedulingAction();
            this.muteSilentSounds();
            this.positionalSoundUpdated = false;
            if (this.testDirtyFlag()) {
                this.audioDevice3D.setView(this.view);
            }
            n2 = this.performActions();
            if (this.positionalSoundUpdated) {
                this.clearDirtyFlag();
            }
        }
    }

    synchronized void reset(View view) {
        int n = 0;
        if (view == null) {
            this.view = null;
            this.viewPlatform = null;
            this.universe = null;
            this.ready = false;
            return;
        }
        this.view = view;
        Canvas3D canvas3D = this.view.getFirstCanvas();
        if (canvas3D != null) {
            this.graphicsCtx = canvas3D.getGraphicsContext3D();
        }
        if (view.physicalEnvironment == null) {
            this.audioDevice = null;
            ++n;
        } else if (view.physicalEnvironment.audioDevice == null) {
            if (this.audioDevice == null) {
                ++n;
            }
        } else {
            this.audioDevice = view.physicalEnvironment.audioDevice;
        }
        if (view.viewPlatform == null || view.viewPlatform.retained == null) {
            this.viewPlatform = null;
            ++n;
        } else {
            this.viewPlatform = (ViewPlatformRetained)this.view.viewPlatform.retained;
            if (this.viewPlatform.universe == null) {
                this.universe = null;
                ++n;
            } else {
                this.universe = this.viewPlatform.universe;
            }
        }
        if (n > 0) {
            this.ready = false;
        } else {
            if (this.audioDevice instanceof AudioDevice3D) {
                this.audioDevice3D = (AudioDevice3D)this.audioDevice;
                this.audioDevice3D.setView(this.view);
                this.totalChannels = this.audioDevice.getTotalChannels();
            } else {
                this.totalChannels = 0;
            }
            this.ready = true;
        }
    }

    synchronized void resumeAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        if (this.prioritizedSounds != null) {
            int n = this.prioritizedSounds.size();
            int n2 = 0;
            while (n2 < n) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                switch (soundSchedulerAtom.enabled) {
                    case 1: 
                    case 3: {
                        this.unpause(soundSchedulerAtom);
                        break;
                    }
                }
                ++n2;
            }
        }
        this.stallThread = false;
    }

    void setAttribsDirtyFlag(SoundRetained soundRetained, int n) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        soundSchedulerAtom = this.findSoundAtom(soundRetained);
        if (soundSchedulerAtom != null) {
            soundSchedulerAtom.setAttribsDirtyFlag(n);
        }
    }

    void setDirtyFlag(int n) {
        this.listenerUpdated |= n;
    }

    void setStateDirtyFlag(SoundRetained soundRetained, int n) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        soundSchedulerAtom = this.findSoundAtom(soundRetained);
        if (soundSchedulerAtom != null) {
            soundSchedulerAtom.setStateDirtyFlag(n);
        }
    }

    long shortestTimeToFinish() {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n = this.prioritizedSounds.size();
            int n2 = 0;
            while (n2 < n) {
                long l3;
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                if (soundSchedulerAtom.status != 0 && soundSchedulerAtom.status != 3 && (l3 = soundSchedulerAtom.endTime) >= 0L) {
                    long l4 = l3 - l;
                    if (l4 < 0L) {
                        l4 = 0L;
                    }
                    if (l2 < 0L) {
                        l2 = l4;
                    } else if (l4 < l2) {
                        l2 = l4;
                    }
                }
                ++n2;
            }
        }
        return l2;
    }

    void shuffleSound(SoundRetained soundRetained) {
        this.deleteSound(soundRetained);
        this.addSound(soundRetained);
    }

    void start(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        int n = soundSchedulerAtom.sampleId;
        int n2 = -1;
        if (n != -1 && (n2 = this.audioDevice3D.startSample(n)) >= 0) {
            soundSchedulerAtom.startTime = this.audioDevice3D.getStartTime(n);
            soundSchedulerAtom.calculateEndTime();
            soundSchedulerAtom.playing = true;
        } else {
            soundSchedulerAtom.startTime = 0L;
            soundSchedulerAtom.endTime = 0L;
            soundSchedulerAtom.playing = false;
        }
    }

    void startSoundScheduler() {
    }

    synchronized void stopAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        if (this.lastEventReceived == 203) {
            return;
        }
        if (this.prioritizedSounds != null) {
            int n = this.prioritizedSounds.size();
            int n2 = 0;
            while (n2 < n) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                this.stopSound(soundSchedulerAtom);
                ++n2;
            }
            this.prioritizedSounds.clear();
        }
    }

    void stopSound(SoundSchedulerAtom soundSchedulerAtom) {
        if (this.audioDevice3D == null) {
            return;
        }
        switch (soundSchedulerAtom.enabled) {
            case 1: 
            case 3: {
                soundSchedulerAtom.setEnableState(0);
                soundSchedulerAtom.status = 0;
                this.turnOff(soundSchedulerAtom);
                break;
            }
            case 2: {
                soundSchedulerAtom.setEnableState(0);
                break;
            }
        }
    }

    void stopSoundScheduler(long[] lArray, boolean bl) {
    }

    boolean testDirtyFlag() {
        return this.listenerUpdated > 0;
    }

    void turnOff(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.stopSample(soundSchedulerAtom.sampleId);
        soundSchedulerAtom.playing = false;
    }

    void unpause(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.unpauseSample(soundSchedulerAtom.sampleId);
    }

    void update(SoundSchedulerAtom soundSchedulerAtom) {
        int n = soundSchedulerAtom.sampleId;
        if (n == -1) {
            return;
        }
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        this.audioDevice3D.updateSample(n);
        soundSchedulerAtom.calculateEndTime();
        if (soundRetained instanceof PointSoundRetained || soundRetained instanceof ConeSoundRetained) {
            this.positionalSoundUpdated = true;
        }
    }

    void updateAuralAttribs(AuralAttributesRetained auralAttributesRetained) {
        if (auralAttributesRetained != null) {
            AuralAttributesRetained auralAttributesRetained2 = auralAttributesRetained;
            synchronized (auralAttributesRetained2) {
                if (auralAttributesRetained != this.lastAA || auralAttributesRetained.aaDirty) {
                    Point2f[] point2fArray;
                    this.audioDevice3D.setRolloff(auralAttributesRetained.rolloff);
                    this.audioDevice3D.setReflectionCoefficient(auralAttributesRetained.reflectionCoefficient);
                    Bounds bounds = auralAttributesRetained.reverbBounds;
                    if (bounds == null) {
                        this.audioDevice3D.setReverbDelay(auralAttributesRetained.reverbDelay);
                    } else {
                        float f;
                        if (bounds instanceof BoundingSphere) {
                            f = (float)(2.0 * ((BoundingSphere)bounds).radius / (double)0.344f);
                        } else {
                            point2fArray = new BoundingSphere(bounds);
                            f = (float)(2.0 * point2fArray.radius / (double)0.344f);
                        }
                        this.audioDevice3D.setReverbDelay(f);
                    }
                    this.audioDevice3D.setReverbOrder(auralAttributesRetained.reverbOrder);
                    int n = auralAttributesRetained.getDistanceFilterLength();
                    if (auralAttributesRetained.filterType == -1 || n == 0) {
                        this.audioDevice3D.setDistanceFilter(-1, null, null);
                    } else {
                        point2fArray = new Point2f[n];
                        int n2 = 0;
                        while (n2 < n) {
                            point2fArray[n2] = new Point2f();
                            ++n2;
                        }
                        auralAttributesRetained.getDistanceFilter(point2fArray);
                        double[] dArray = new double[n];
                        float[] fArray = new float[n];
                        int n3 = 0;
                        while (n3 < n) {
                            dArray[n3] = point2fArray[n3].x;
                            fArray[n3] = point2fArray[n3].y;
                            ++n3;
                        }
                        this.audioDevice3D.setDistanceFilter(auralAttributesRetained.filterType, dArray, fArray);
                    }
                    this.audioDevice3D.setFrequencyScaleFactor(auralAttributesRetained.frequencyScaleFactor);
                    this.audioDevice3D.setVelocityScaleFactor(auralAttributesRetained.velocityScaleFactor);
                    auralAttributesRetained.aaDirty = false;
                }
            }
            this.resetAA = true;
        } else if (this.lastAA != null) {
            this.audioDevice3D.setRolloff(1.0f);
            this.audioDevice3D.setReflectionCoefficient(0.0f);
            this.audioDevice3D.setReverbDelay(0.0f);
            this.audioDevice3D.setReverbOrder(0);
            this.audioDevice3D.setDistanceFilter(-1, null, null);
            this.audioDevice3D.setFrequencyScaleFactor(1.0f);
            this.audioDevice3D.setVelocityScaleFactor(0.0f);
            this.resetAA = true;
        }
        this.lastAA = auralAttributesRetained;
    }

    void updateSoundParams(boolean bl, SoundSchedulerAtom soundSchedulerAtom, AuralAttributesRetained auralAttributesRetained) {
        float[] fArray;
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        int n;
        PointSoundRetained pointSoundRetained;
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        int n2 = soundSchedulerAtom.sampleId;
        if (n2 == -1) {
            return;
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 2)) {
            if (auralAttributesRetained != null) {
                this.audioDevice3D.setSampleGain(n2, soundRetained2.initialGain * auralAttributesRetained.attributeGain);
            } else {
                this.audioDevice3D.setSampleGain(n2, soundRetained2.initialGain);
            }
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 4)) {
            this.audioDevice3D.setLoop(n2, soundRetained2.loopCount);
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 1024)) {
            if (soundRetained2 instanceof ConeSoundRetained) {
                pointSoundRetained = (ConeSoundRetained)soundRetained2;
                n = pointSoundRetained.getDistanceGainLength();
                if (n == 0) {
                    this.audioDevice3D.setDistanceGain(n2, null, null, null, null);
                } else {
                    objectArray3 = new Point2f[n];
                    objectArray2 = new Point2f[n];
                    int n3 = 0;
                    while (n3 < n) {
                        objectArray3[n3] = new Point2f();
                        objectArray2[n3] = new Point2f();
                        ++n3;
                    }
                    ((ConeSoundRetained)pointSoundRetained).getDistanceGain((Point2f[])objectArray3, (Point2f[])objectArray2);
                    objectArray = new double[n];
                    fArray = new float[n];
                    double[] dArray = new double[n];
                    float[] fArray2 = new float[n];
                    int n4 = 0;
                    while (n4 < n) {
                        objectArray[n4] = objectArray3[n4].x;
                        fArray[n4] = objectArray3[n4].y;
                        dArray[n4] = objectArray2[n4].x;
                        fArray2[n4] = objectArray2[n4].y;
                        ++n4;
                    }
                    this.audioDevice3D.setDistanceGain(n2, (double[])objectArray, fArray, dArray, fArray2);
                }
            } else if (soundRetained2 instanceof PointSoundRetained) {
                pointSoundRetained = (PointSoundRetained)soundRetained2;
                n = pointSoundRetained.getDistanceGainLength();
                if (n == 0) {
                    this.audioDevice3D.setDistanceGain(n2, null, null, null, null);
                } else {
                    objectArray3 = new Point2f[n];
                    int n5 = 0;
                    while (n5 < n) {
                        objectArray3[n5] = new Point2f();
                        ++n5;
                    }
                    pointSoundRetained.getDistanceGain((Point2f[])objectArray3);
                    double[] dArray = new double[n];
                    objectArray = new float[n];
                    int n6 = 0;
                    while (n6 < n) {
                        dArray[n6] = objectArray3[n6].x;
                        objectArray[n6] = objectArray3[n6].y;
                        ++n6;
                    }
                    this.audioDevice3D.setDistanceGain(n2, dArray, (float[])objectArray, null, null);
                }
            }
        }
        if (soundRetained2 instanceof ConeSoundRetained && (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 8192))) {
            pointSoundRetained = (ConeSoundRetained)soundRetained2;
            n = ((ConeSoundRetained)pointSoundRetained).getAngularAttenuationLength();
            if (n == 0) {
                objectArray3 = new double[2];
                objectArray2 = new float[2];
                objectArray3[0] = (Point2f)0.0;
                objectArray3[1] = (Point2f)1.5707963267948966;
                objectArray2[0] = (Point2f)1.0f;
                objectArray2[1] = (Point2f)0.0f;
                this.audioDevice3D.setAngularAttenuation(n2, -1, (double[])objectArray3, (float[])objectArray2, null);
            } else {
                objectArray3 = new Point3f[n];
                int n7 = 0;
                while (n7 < n) {
                    objectArray3[n7] = new Point3f();
                    ++n7;
                }
                ((ConeSoundRetained)pointSoundRetained).getAngularAttenuation((Point3f[])objectArray3);
                double[] dArray = new double[n];
                objectArray = new float[n];
                fArray = new float[n];
                int n8 = 0;
                while (n8 < n) {
                    dArray[n8] = objectArray3[n8].x;
                    objectArray[n8] = objectArray3[n8].y;
                    fArray[n8] = objectArray3[n8].z;
                    ++n8;
                }
                this.audioDevice3D.setAngularAttenuation(n2, ((ConeSoundRetained)pointSoundRetained).filterType, dArray, (float[])objectArray, fArray);
            }
        }
    }

    void updateTransformChange(Object[] objectArray, long l) {
    }

    void updateXformedParams(boolean bl, SoundSchedulerAtom soundSchedulerAtom) {
        Object object;
        Object object2;
        PointSoundRetained pointSoundRetained = (PointSoundRetained)soundSchedulerAtom.sound;
        PointSoundRetained pointSoundRetained2 = (PointSoundRetained)pointSoundRetained.sgSound;
        int n = soundSchedulerAtom.sampleId;
        if (n == -1) {
            return;
        }
        PointSoundRetained pointSoundRetained3 = pointSoundRetained;
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 512) || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.stateDirty, 32768)) {
            object2 = new Point3f();
            pointSoundRetained2.getXformPosition((Point3f)object2);
            object = new Point3d(object2);
            this.audioDevice3D.setPosition(n, (Point3d)object);
        }
        if (pointSoundRetained instanceof ConeSoundRetained) {
            object2 = (ConeSoundRetained)pointSoundRetained;
            object = (ConeSoundRetained)pointSoundRetained.sgSound;
            if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 4096) || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.stateDirty, 32768)) {
                Vector3f vector3f = new Vector3f();
                ((ConeSoundRetained)object).getXformDirection(vector3f);
                Vector3d vector3d = new Vector3d(vector3f);
                this.audioDevice3D.setDirection(n, vector3d);
            }
        }
    }
}

