/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;

class ScreenViewCache {
    Screen3D screen;
    double physicalScreenWidth;
    double physicalScreenHeight;
    int screenWidth;
    int screenHeight;
    int scrvcDirtyMask = 0;
    Transform3D trackerBaseToImagePlate = new Transform3D();
    Transform3D headTrackerToLeftImagePlate = new Transform3D();
    Transform3D headTrackerToRightImagePlate = new Transform3D();
    double metersPerPixelX;
    double metersPerPixelY;

    ScreenViewCache(Screen3D screen3D) {
        this.screen = screen3D;
    }

    synchronized void snapshot() {
        this.scrvcDirtyMask = this.screen.offScreen ? (this.scrvcDirtyMask |= this.screen.scrDirtyMask) : this.screen.scrDirtyMask;
        this.screen.scrDirtyMask = 0;
        this.physicalScreenWidth = this.screen.physicalScreenWidth;
        this.physicalScreenHeight = this.screen.physicalScreenHeight;
        this.screenWidth = this.screen.screenSize.width;
        this.screenHeight = this.screen.screenSize.height;
        this.screen.trackerBaseToImagePlate.getWithLock(this.trackerBaseToImagePlate);
        this.screen.headTrackerToLeftImagePlate.getWithLock(this.headTrackerToLeftImagePlate);
        this.screen.headTrackerToRightImagePlate.getWithLock(this.headTrackerToRightImagePlate);
        this.metersPerPixelX = this.physicalScreenWidth / (double)this.screenWidth;
        this.metersPerPixelY = this.physicalScreenHeight / (double)this.screenHeight;
    }
}

