/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

public class ScaleInterpolator
extends Interpolator {
    TransformGroup target;
    Transform3D axis = new Transform3D();
    Transform3D axisInverse = new Transform3D();
    float minimumScale;
    float maximumScale;
    Transform3D scale = new Transform3D();
    Transform3D temp = new Transform3D();

    ScaleInterpolator() {
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha);
        this.target = transformGroup;
        this.axis.setIdentity();
        this.axisInverse.setIdentity();
        this.minimumScale = 0.1f;
        this.maximumScale = 1.0f;
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f, float f2) {
        super(alpha);
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.minimumScale = f;
        this.maximumScale = f2;
    }

    public Node cloneNode(boolean bl) {
        ScaleInterpolator scaleInterpolator = new ScaleInterpolator();
        scaleInterpolator.duplicateNode(this, bl);
        return scaleInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ScaleInterpolator scaleInterpolator = (ScaleInterpolator)node;
        this.setAxisOfScale(scaleInterpolator.getAxisOfScale());
        this.setMinimumScale(scaleInterpolator.getMinimumScale());
        this.setMaximumScale(scaleInterpolator.getMaximumScale());
        this.setTarget(scaleInterpolator.getTarget());
    }

    public Transform3D getAxisOfScale() {
        return this.axis;
    }

    public float getMaximumScale() {
        return this.maximumScale;
    }

    public float getMinimumScale() {
        return this.minimumScale;
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            float f = this.alpha.value();
            double d = (1.0 - (double)f) * (double)this.minimumScale + (double)(f * this.maximumScale);
            this.scale.set(d);
            this.temp.mul(this.axis, this.scale);
            this.temp.mul(this.temp, this.axisInverse);
            this.target.setTransform(this.temp);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setAxisOfScale(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public void setMaximumScale(float f) {
        this.maximumScale = f;
    }

    public void setMinimumScale(float f) {
        this.minimumScale = f;
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

