/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.DecalGroupRetained;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightBin;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.OrderedCollection;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

class RenderBin
extends J3dStructure
implements ObjectUpdate {
    ArrayList renderAtoms = new ArrayList();
    ArrayList transList = new ArrayList();
    ArrayList transMessageList = new ArrayList();
    ArrayList lightMessageList = new ArrayList();
    J3dMessage[] m;
    int maxLights;
    LightBin opaqueBin = null;
    LightBin addOpaqueBin = null;
    LightBin transparentBin = null;
    LightBin addTransparentBin = null;
    ArrayList lightBinFreelist = new ArrayList();
    ArrayList envSetFreelist = new ArrayList();
    ArrayList attrBinFreelist = new ArrayList();
    ArrayList textureBinFreelist = new ArrayList();
    ArrayList renderMoleculeFreelist = new ArrayList();
    Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    BackgroundRetained background = new BackgroundRetained();
    Transform3D vworldToVpc = new Transform3D();
    Transform3D vpcToVworld = null;
    BoundingSphere vpSchedSphere = new BoundingSphere();
    BoundingSphere vpSchedSphereInVworld = new BoundingSphere();
    BoundingBox viewFrustumBBox = new BoundingBox();
    BoundingBox canvasFrustumBBox = new BoundingBox();
    boolean afterFirst = false;
    double backClipDistanceInVworld;
    boolean backClipActive = false;
    boolean doCompact = false;
    int frameCount = 0;
    int frameCountCutoff = 100;
    long removeCutoffTime = -1L;
    View view = null;
    ArrayList toBeAddedTextureResourceFreeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    boolean resourceToFree = false;
    ArrayList orderedBins = new ArrayList();
    ArrayList changedLts = new ArrayList();
    ArrayList changedFogs = new ArrayList();
    ArrayList changedModelClips = new ArrayList();
    static int REEVALUATE_LIGHTS = 1;
    static int REEVALUATE_FOG = 2;
    static int REEVALUATE_MCLIP = 4;
    static int REEVALUATE_ALL_ENV = REEVALUATE_LIGHTS | REEVALUATE_FOG | REEVALUATE_MCLIP;
    int envDirty = 0;
    boolean reEvaluateBg = true;
    boolean reEvaluateClip = true;
    ArrayList renderMoleculeList = new ArrayList();
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList dirtyIndexedRenderAtom = new ArrayList();
    ArrayList objUpdateList = new ArrayList();
    ArrayList removeRenderAtomInRMList = new ArrayList();
    ArrayList removeOGsList = new ArrayList();
    ArrayList addOGsList = new ArrayList();
    ArrayList orderedBinsList = new ArrayList();
    ArrayList toBeAddedBinList = new ArrayList();
    ArrayList lockGeometryList = new ArrayList();
    ArrayList dlistLockList = new ArrayList();
    BackgroundRetained geometryBackground = null;
    LightBin bgOpaqueBin = null;
    LightBin bgTransparentBin = null;
    LightBin bgAddOpaqueBin = null;
    LightBin bgAddTransparentBin = null;
    ArrayList bgOrderedBins = new ArrayList();
    Transform3D infVworldToVpc = new Transform3D();
    boolean vpcToVworldDirty = true;
    BackgroundRetained currentActiveBackground = new BackgroundRetained();
    boolean altAppearanceDirty = true;
    ArrayList nodeComponentList = new ArrayList();
    ArrayList newNodeComponentList = new ArrayList();
    ArrayList removeNodeComponentList = new ArrayList();
    ArrayList textureBinList = new ArrayList();
    ArrayList dirtyReferenceGeomList = new ArrayList();
    boolean multiScreen = false;
    ArrayList orientedRAs = new ArrayList();
    ArrayList dirtyOrientedRAs = new ArrayList();
    ArrayList offScreenMessage = new ArrayList();
    Vector3d localeTranslation = new Vector3d();
    Locale locale = null;

    RenderBin(VirtualUniverse virtualUniverse, View view) {
        super(virtualUniverse, 128);
        this.vworldToVpc.setIdentity();
        this.universe = virtualUniverse;
        this.view = view;
        this.maxLights = VirtualUniverse.mc.maxLights;
        if (this.view.viewPlatform != null) {
            this.locale = ((ViewPlatformRetained)this.view.viewPlatform.retained).locale;
        }
    }

    void addDirtyReferenceGeometry(Object object) {
        this.dirtyReferenceGeomList.add(object);
    }

    void addDirtyRenderMolecule(RenderMolecule renderMolecule) {
        if (!this.dirtyRenderMoleculeList.contains(renderMolecule)) {
            this.dirtyRenderMoleculeList.add(renderMolecule);
        }
    }

    void addDisplayListResourceFreeList(RenderMolecule renderMolecule) {
        this.displayListResourceFreeList.add(renderMolecule.displayListIdObj);
    }

    void addGeometryToLockList(Object object) {
        this.lockGeometryList.add(object);
    }

    void addNodeComponent(Object object) {
        this.newNodeComponentList.add(object);
    }

    void addTextureBin(TextureBin textureBin) {
        this.textureBinList.add(textureBin);
    }

    void addTextureResourceFreeList(TextureRetained textureRetained) {
        this.toBeAddedTextureResourceFreeList.add(textureRetained);
    }

    void checkForCompaction() {
        int n = 0;
        int n2 = 0;
        int n3 = this.renderAtoms.size();
        int n4 = 0;
        while (n4 < n3) {
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n4);
            if (renderAtom.lastVisibleTime < this.removeCutoffTime) {
                ++n;
            }
            ++n4;
        }
        n2 = n3 - n;
        if (n2 * 2 < n) {
            this.doCompact = true;
        }
    }

    void clearAllUpdateObjectState() {
        this.addOGsList.clear();
        this.removeRenderAtomInRMList.clear();
        this.addOpaqueBin = null;
        this.addTransparentBin = null;
        this.bgAddOpaqueBin = null;
        this.bgAddTransparentBin = null;
        this.orderedBinsList.clear();
        this.toBeAddedBinList.clear();
        this.objUpdateList.clear();
        this.removeOGsList.clear();
        this.displayListResourceFreeList.clear();
        this.toBeAddedTextureResourceFreeList.clear();
        this.dirtyRenderMoleculeList.clear();
        this.dirtyIndexedRenderAtom.clear();
        this.dirtyReferenceGeomList.clear();
        this.reEvaluateBg = false;
        this.textureBinList.clear();
        this.newNodeComponentList.clear();
        this.removeNodeComponentList.clear();
        this.reEvaluateClip = false;
        this.vpcToVworldDirty = false;
        this.offScreenMessage.clear();
    }

    void compact(long l) {
        if (this.doCompact) {
            int n = 0;
            while (n < this.renderAtoms.size()) {
                RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
                if (renderAtom.lastVisibleTime < this.removeCutoffTime) {
                    this.renderAtoms.remove(n);
                    if (renderAtom.isOriented) {
                        this.orientedRAs.remove(this.orientedRAs.indexOf(renderAtom));
                        if (renderAtom.inDirtyOrientedRAs) {
                            this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(renderAtom));
                        }
                    }
                    if (!renderAtom.inRenderBin) continue;
                    renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                    renderAtom.setRenderBin(false);
                    continue;
                }
                ++n;
            }
            this.doCompact = false;
        }
        ++this.frameCount;
        if (this.frameCount > this.frameCountCutoff) {
            this.removeCutoffTime = l;
            this.frameCount = 0;
        }
    }

    void computeViewFrustumBBox(BoundingBox boundingBox) {
        boundingBox.lower.x = Double.POSITIVE_INFINITY;
        boundingBox.lower.y = Double.POSITIVE_INFINITY;
        boundingBox.lower.z = Double.POSITIVE_INFINITY;
        boundingBox.upper.x = Double.NEGATIVE_INFINITY;
        boundingBox.upper.y = Double.NEGATIVE_INFINITY;
        boundingBox.upper.z = Double.NEGATIVE_INFINITY;
        Canvas3D[] canvas3DArray = this.view.getCanvases();
        int n = 0;
        while (n < canvas3DArray.length) {
            Canvas3D canvas3D = canvas3DArray[n];
            this.canvasFrustumBBox.lower.x = Double.POSITIVE_INFINITY;
            this.canvasFrustumBBox.lower.y = Double.POSITIVE_INFINITY;
            this.canvasFrustumBBox.lower.z = Double.POSITIVE_INFINITY;
            this.canvasFrustumBBox.upper.x = Double.NEGATIVE_INFINITY;
            this.canvasFrustumBBox.upper.y = Double.NEGATIVE_INFINITY;
            this.canvasFrustumBBox.upper.z = Double.NEGATIVE_INFINITY;
            canvas3D.updateViewCache(true, null, this.canvasFrustumBBox, false);
            if (boundingBox.lower.x > this.canvasFrustumBBox.lower.x) {
                boundingBox.lower.x = this.canvasFrustumBBox.lower.x;
            }
            if (boundingBox.lower.y > this.canvasFrustumBBox.lower.y) {
                boundingBox.lower.y = this.canvasFrustumBBox.lower.y;
            }
            if (boundingBox.lower.z > this.canvasFrustumBBox.lower.z) {
                boundingBox.lower.z = this.canvasFrustumBBox.lower.z;
            }
            if (boundingBox.upper.x < this.canvasFrustumBBox.upper.x) {
                boundingBox.upper.x = this.canvasFrustumBBox.upper.x;
            }
            if (boundingBox.upper.y < this.canvasFrustumBBox.upper.y) {
                boundingBox.upper.y = this.canvasFrustumBBox.upper.y;
            }
            if (boundingBox.upper.z < this.canvasFrustumBBox.upper.z) {
                boundingBox.upper.z = this.canvasFrustumBBox.upper.z;
            }
            ++n;
        }
    }

    AttributeBin findAttributeBin(EnvironmentSet environmentSet, RenderAtom renderAtom) {
        RenderingAttributesRetained renderingAttributesRetained = renderAtom.app == null ? null : renderAtom.app.renderingAttributes;
        AttributeBin attributeBin = environmentSet.attributeBinList;
        while (attributeBin != null) {
            if (attributeBin.equals(renderingAttributesRetained)) {
                return attributeBin;
            }
            attributeBin = attributeBin.next;
        }
        int n = 0;
        while (n < environmentSet.addAttributeBins.size()) {
            attributeBin = (AttributeBin)environmentSet.addAttributeBins.get(n);
            if (attributeBin.equals(renderingAttributesRetained)) {
                return attributeBin;
            }
            ++n;
        }
        attributeBin = this.getAttributeBin(renderingAttributesRetained);
        environmentSet.addAttributeBin(attributeBin, this);
        return attributeBin;
    }

    EnvironmentSet findEnvironmentSet(RenderAtom renderAtom) {
        EnvironmentSet environmentSet;
        int n;
        EnvironmentSet environmentSet2;
        LightBin lightBin;
        LightBin lightBin2 = null;
        OrderedCollection orderedCollection = null;
        if (renderAtom.geometryAtom.source.geometryBackground == null) {
            if (renderAtom.geometryAtom.source.inOrderedGroup) {
                orderedCollection = this.findOrderedCollection(renderAtom.geometryAtom, false);
                lightBin = orderedCollection.nextFrameLightBin;
                lightBin2 = orderedCollection.addLightBins;
            } else if (renderAtom.isOpaque()) {
                lightBin = this.opaqueBin;
                lightBin2 = this.addOpaqueBin;
            } else {
                lightBin = this.transparentBin;
                lightBin2 = this.addTransparentBin;
            }
        } else if (renderAtom.geometryAtom.source.inOrderedGroup) {
            orderedCollection = this.findOrderedCollection(renderAtom.geometryAtom, true);
            lightBin = orderedCollection.nextFrameLightBin;
            lightBin2 = orderedCollection.addLightBins;
        } else if (renderAtom.isOpaque()) {
            lightBin = this.bgOpaqueBin;
            lightBin2 = this.bgAddOpaqueBin;
        } else {
            lightBin = this.bgTransparentBin;
            lightBin2 = this.bgAddTransparentBin;
        }
        LightBin lightBin3 = lightBin;
        renderAtom.lights = this.universe.renderingEnvironmentStructure.getInfluencingLights(renderAtom);
        renderAtom.fog = this.universe.renderingEnvironmentStructure.getInfluencingFog(renderAtom);
        renderAtom.modelClip = this.universe.renderingEnvironmentStructure.getInfluencingModelClip(renderAtom);
        while (lightBin != null) {
            if (lightBin.geometryBackground == renderAtom.geometryAtom.source.geometryBackground) {
                environmentSet2 = lightBin.environmentSetList;
                while (environmentSet2 != null) {
                    if (environmentSet2.equals(renderAtom, renderAtom.lights, renderAtom.fog, renderAtom.modelClip)) {
                        return environmentSet2;
                    }
                    environmentSet2 = environmentSet2.next;
                }
                n = 0;
                while (n < lightBin.insertEnvSet.size()) {
                    environmentSet = (EnvironmentSet)lightBin.insertEnvSet.get(n);
                    if (environmentSet.equals(renderAtom, renderAtom.lights, renderAtom.fog, renderAtom.modelClip)) {
                        return environmentSet;
                    }
                    ++n;
                }
            }
            lightBin = lightBin.next;
        }
        lightBin = lightBin2;
        while (lightBin != null) {
            if (lightBin.geometryBackground == renderAtom.geometryAtom.source.geometryBackground) {
                n = 0;
                while (n < lightBin.insertEnvSet.size()) {
                    environmentSet = (EnvironmentSet)lightBin.insertEnvSet.get(n);
                    if (environmentSet.equals(renderAtom, renderAtom.lights, renderAtom.fog, renderAtom.modelClip)) {
                        return environmentSet;
                    }
                    ++n;
                }
            }
            lightBin = lightBin.next;
        }
        environmentSet2 = this.getEnvironmentSet(renderAtom, renderAtom.lights, renderAtom.fog, renderAtom.modelClip);
        lightBin = lightBin3;
        while (lightBin != null) {
            if (lightBin.geometryBackground == renderAtom.geometryAtom.source.geometryBackground && lightBin.willEnvironmentSetFit(environmentSet2)) break;
            lightBin = lightBin.next;
        }
        if (lightBin == null) {
            lightBin = lightBin2;
            while (lightBin != null) {
                if (lightBin.geometryBackground == renderAtom.geometryAtom.source.geometryBackground && lightBin.willEnvironmentSetFit(environmentSet2)) break;
                lightBin = lightBin.next;
            }
        }
        if (lightBin == null) {
            lightBin = this.getLightBin(this.maxLights, renderAtom.geometryAtom.source.geometryBackground);
            if (lightBin2 != null) {
                lightBin.next = lightBin2;
                lightBin2.prev = lightBin;
            }
            if (renderAtom.geometryAtom.source.inOrderedGroup) {
                if (!orderedCollection.onUpdateList) {
                    this.objUpdateList.add(orderedCollection);
                    orderedCollection.onUpdateList = true;
                }
                orderedCollection.addLightBins = lightBin;
            } else if (renderAtom.isOpaque()) {
                if (renderAtom.geometryAtom.source.geometryBackground == null) {
                    this.addOpaqueBin = lightBin;
                } else {
                    this.bgAddOpaqueBin = lightBin;
                }
            } else if (renderAtom.geometryAtom.source.geometryBackground == null) {
                this.addTransparentBin = lightBin;
            } else {
                this.bgAddTransparentBin = lightBin;
            }
        }
        lightBin.addEnvironmentSet(environmentSet2, this);
        return environmentSet2;
    }

    OrderedCollection findOrderedCollection(GeometryAtom geometryAtom, boolean bl) {
        ArrayList<OrderedBin> arrayList = null;
        OrderedCollection orderedCollection = null;
        ArrayList arrayList2 = bl ? this.bgOrderedBins : this.orderedBins;
        OrderedBin orderedBin = null;
        int n = -1;
        int n2 = 0;
        while (n2 < geometryAtom.orderedGroupsPath.size()) {
            int n3;
            int n4;
            int n5;
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)geometryAtom.orderedGroupsPath.get(n2);
            int n6 = (Integer)geometryAtom.orderedChildIdsPath.get(n2);
            if (orderedGroupRetained.orderedChildIdTable == null) {
                orderedGroupRetained.orderedChildIdTable = new int[orderedGroupRetained.getOrderedChildCount()];
                int n7 = 0;
                while (n7 < orderedGroupRetained.orderedChildIdTable.length) {
                    orderedGroupRetained.orderedChildIdTable[n7] = n7;
                    ++n7;
                }
            }
            int n8 = orderedGroupRetained.orderedChildIdTable[n6];
            if (orderedGroupRetained.orderedBin == null) {
                orderedGroupRetained.orderedBin = new OrderedBin(orderedGroupRetained.orderedChildIdTable.length, orderedGroupRetained, orderedBin, n, arrayList2);
                n5 = -1;
                n4 = 0;
                while (n4 < this.orderedBinsList.size()) {
                    if (arrayList2 == this.orderedBinsList.get(n4)) {
                        n5 = n4;
                        break;
                    }
                    ++n4;
                }
                if (n5 == -1) {
                    this.orderedBinsList.add(arrayList2);
                    arrayList = new ArrayList<OrderedBin>();
                    arrayList.add(orderedGroupRetained.orderedBin);
                    this.toBeAddedBinList.add(arrayList);
                } else {
                    arrayList = (ArrayList<OrderedBin>)this.toBeAddedBinList.get(n5);
                    arrayList.add(orderedGroupRetained.orderedBin);
                }
            } else {
                n5 = arrayList2.indexOf(orderedGroupRetained.orderedBin);
                if (n5 == -1) {
                    n4 = 0;
                    while (n4 < this.orderedBinsList.size()) {
                        if (arrayList2 == this.orderedBinsList.get(n4)) {
                            n5 = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n5 == -1) {
                        this.orderedBinsList.add(arrayList2);
                        arrayList = new ArrayList<OrderedBin>();
                        arrayList.add(orderedGroupRetained.orderedBin);
                        this.toBeAddedBinList.add(arrayList);
                    } else {
                        arrayList = (ArrayList<OrderedBin>)this.toBeAddedBinList.get(n5);
                        if (!arrayList.contains(orderedGroupRetained.orderedBin)) {
                            arrayList.add(orderedGroupRetained.orderedBin);
                        }
                    }
                }
            }
            ArrayList arrayList3 = orderedGroupRetained.orderedBin.orderedCollections;
            int n9 = 0;
            n4 = 0;
            while (n4 < orderedGroupRetained.orderedBin.addToOC.size()) {
                n3 = (Integer)orderedGroupRetained.orderedBin.addToOC.get(n4);
                if (n3 == n8) {
                    orderedCollection = (OrderedCollection)orderedGroupRetained.orderedBin.valueOfOC.get(n4);
                    if (orderedCollection != null) break;
                    orderedCollection = new OrderedCollection();
                    orderedGroupRetained.orderedBin.valueOfOC.set(n4, orderedCollection);
                    break;
                }
                if (n3 < n8) {
                    ++n9;
                }
                ++n4;
            }
            if (n4 == orderedGroupRetained.orderedBin.addToOC.size()) {
                n4 = 0;
                while (n4 < orderedGroupRetained.orderedBin.setOC.size()) {
                    n3 = (Integer)orderedGroupRetained.orderedBin.setOC.get(n4);
                    if (n3 == n8) {
                        orderedCollection = (OrderedCollection)orderedGroupRetained.orderedBin.valueOfSetOC.get(n4);
                        if (orderedCollection != null) break;
                        orderedCollection = new OrderedCollection();
                        orderedGroupRetained.orderedBin.valueOfSetOC.set(n4, orderedCollection);
                        break;
                    }
                    ++n4;
                }
                if (n4 == orderedGroupRetained.orderedBin.setOC.size() && (orderedCollection = (OrderedCollection)arrayList3.get(n8 - n9)) == null) {
                    orderedCollection = new OrderedCollection();
                    orderedGroupRetained.orderedBin.setOC.add(new Integer(n8));
                    orderedGroupRetained.orderedBin.valueOfSetOC.add(orderedCollection);
                    if (!this.addOGsList.contains(orderedGroupRetained.orderedBin)) {
                        this.addOGsList.add(orderedGroupRetained.orderedBin);
                    }
                }
            }
            if (orderedCollection.nextFrameLightBin == null) {
                orderedCollection.nextFrameLightBin = this.getLightBin(this.maxLights, geometryAtom.source.geometryBackground);
                orderedCollection.nextFrameLightBin.setOrderedInfo(orderedGroupRetained.orderedBin, n6);
                if (!orderedCollection.onUpdateList) {
                    this.objUpdateList.add(orderedCollection);
                    orderedCollection.onUpdateList = true;
                }
            }
            arrayList2 = orderedCollection.childOrderedBins;
            orderedBin = orderedGroupRetained.orderedBin;
            n = n6;
            ++n2;
        }
        return orderedCollection;
    }

    RenderMolecule findRenderMolecule(TextureBin textureBin, RenderAtom renderAtom) {
        TransparencyAttributesRetained transparencyAttributesRetained;
        ColoringAttributesRetained coloringAttributesRetained;
        MaterialRetained materialRetained;
        PointAttributesRetained pointAttributesRetained;
        LineAttributesRetained lineAttributesRetained;
        PolygonAttributesRetained polygonAttributesRetained;
        if (renderAtom.app == null) {
            polygonAttributesRetained = null;
            lineAttributesRetained = null;
            pointAttributesRetained = null;
            materialRetained = null;
            coloringAttributesRetained = null;
            transparencyAttributesRetained = null;
        } else {
            polygonAttributesRetained = renderAtom.app.polygonAttributes;
            lineAttributesRetained = renderAtom.app.lineAttributes;
            pointAttributesRetained = renderAtom.app.pointAttributes;
            materialRetained = renderAtom.app.material;
            coloringAttributesRetained = renderAtom.app.coloringAttributes;
            transparencyAttributesRetained = renderAtom.app.transparencyAttributes;
        }
        RenderMolecule renderMolecule = textureBin.renderMoleculeList;
        while (renderMolecule != null) {
            if (renderMolecule.equals(renderAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, renderAtom.geometryAtom.source.renderLocalToVworld)) {
                renderMolecule.addRenderAtom(renderAtom, this);
                renderAtom.envSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                return renderMolecule;
            }
            renderMolecule = renderMolecule.next;
        }
        int n = 0;
        while (n < textureBin.addRMs.size()) {
            renderMolecule = (RenderMolecule)textureBin.addRMs.get(n);
            if (renderMolecule.equals(renderAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, renderAtom.geometryAtom.source.renderLocalToVworld)) {
                renderMolecule.addRenderAtom(renderAtom, this);
                return renderMolecule;
            }
            ++n;
        }
        renderMolecule = this.getRenderMolecule(renderAtom.geometryAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, renderAtom.geometryAtom.source.renderLocalToVworld);
        textureBin.addRenderMolecule(renderMolecule, this);
        renderMolecule.addRenderAtom(renderAtom, this);
        return renderMolecule;
    }

    TextureBin findTextureBin(AttributeBin attributeBin, RenderAtom renderAtom) {
        TextureUnitStateRetained[] textureUnitStateRetainedArray = renderAtom.app == null ? null : renderAtom.app.texUnitState;
        TextureBin textureBin = attributeBin.textureBinList;
        while (textureBin != null) {
            if (textureBin.equals(textureUnitStateRetainedArray)) {
                return textureBin;
            }
            textureBin = textureBin.next;
        }
        int n = 0;
        while (n < attributeBin.addTBs.size()) {
            textureBin = (TextureBin)attributeBin.addTBs.get(n);
            if (textureBin.equals(textureUnitStateRetainedArray)) {
                return textureBin;
            }
            ++n;
        }
        textureBin = this.getTextureBin(textureUnitStateRetainedArray);
        attributeBin.addTextureBin(textureBin, this);
        return textureBin;
    }

    void freeResource(Canvas3D canvas3D, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        if (bl) {
            canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                int n2 = n;
                canvas3D.freeDisplayList(canvas3D.ctx, n2);
            }
            iterator = ((AbstractList)arrayList2).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                canvas3D.freeTexture(canvas3D.ctx, n);
            }
            canvas3D.makeCtxCurrent(canvas3D.ctx);
        } else {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                int n3 = n;
                canvas3D.freeDisplayList(canvas3D.ctx, n3);
            }
            iterator = ((AbstractList)arrayList2).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                canvas3D.freeTexture(canvas3D.ctx, n);
            }
        }
    }

    AttributeBin getAttributeBin(RenderingAttributesRetained renderingAttributesRetained) {
        AttributeBin attributeBin;
        if (this.attrBinFreelist.size() > 0) {
            attributeBin = (AttributeBin)this.attrBinFreelist.remove(this.attrBinFreelist.size() - 1);
            attributeBin.reset(renderingAttributesRetained);
        } else {
            attributeBin = new AttributeBin(renderingAttributesRetained);
        }
        return attributeBin;
    }

    EnvironmentSet getEnvironmentSet(RenderAtom renderAtom, LightRetained[] lightRetainedArray, FogRetained fogRetained, ModelClipRetained modelClipRetained) {
        EnvironmentSet environmentSet;
        if (this.envSetFreelist.size() > 0) {
            environmentSet = (EnvironmentSet)this.envSetFreelist.remove(this.envSetFreelist.size() - 1);
            environmentSet.reset(renderAtom, lightRetainedArray, fogRetained, modelClipRetained);
        } else {
            environmentSet = new EnvironmentSet(renderAtom, lightRetainedArray, fogRetained, modelClipRetained, this);
        }
        return environmentSet;
    }

    LightBin getLightBin(int n, BackgroundRetained backgroundRetained) {
        LightBin lightBin;
        if (this.lightBinFreelist.size() > 0) {
            lightBin = (LightBin)this.lightBinFreelist.remove(this.lightBinFreelist.size() - 1);
            lightBin.reset();
        } else {
            lightBin = new LightBin(n, this);
        }
        lightBin.geometryBackground = backgroundRetained;
        return lightBin;
    }

    void getNewEnvironment(RenderAtom renderAtom, LightRetained[] lightRetainedArray, FogRetained fogRetained, ModelClipRetained modelClipRetained, AppearanceRetained appearanceRetained) {
        EnvironmentSet environmentSet;
        int n;
        EnvironmentSet environmentSet2;
        LightBin lightBin;
        LightBin lightBin2;
        EnvironmentSet environmentSet3 = null;
        OrderedCollection orderedCollection = null;
        renderAtom.renderMolecule.removeRenderAtom(renderAtom);
        environmentSet3 = null;
        if (renderAtom.geometryAtom.source.geometryBackground == null) {
            if (renderAtom.geometryAtom.source.inOrderedGroup) {
                orderedCollection = this.findOrderedCollection(renderAtom.geometryAtom, false);
                lightBin2 = orderedCollection.nextFrameLightBin;
                lightBin = orderedCollection.addLightBins;
            } else if (renderAtom.isOpaque()) {
                lightBin = this.addOpaqueBin;
                lightBin2 = this.opaqueBin;
            } else {
                lightBin2 = this.transparentBin;
                lightBin = this.addTransparentBin;
            }
        } else if (renderAtom.geometryAtom.source.inOrderedGroup) {
            orderedCollection = this.findOrderedCollection(renderAtom.geometryAtom, true);
            lightBin2 = orderedCollection.nextFrameLightBin;
            lightBin = orderedCollection.addLightBins;
        } else if (renderAtom.isOpaque()) {
            lightBin = this.bgAddOpaqueBin;
            lightBin2 = this.bgOpaqueBin;
        } else {
            lightBin2 = this.bgTransparentBin;
            lightBin = this.bgAddTransparentBin;
        }
        LightBin lightBin3 = lightBin2;
        while (lightBin2 != null && environmentSet3 == null) {
            if (lightBin2.geometryBackground == renderAtom.geometryAtom.source.geometryBackground) {
                environmentSet2 = lightBin2.environmentSetList;
                while (environmentSet2 != null) {
                    if (environmentSet2.equals(renderAtom, lightRetainedArray, fogRetained, modelClipRetained)) {
                        environmentSet3 = environmentSet2;
                        break;
                    }
                    environmentSet2 = environmentSet2.next;
                }
                if (environmentSet3 == null) {
                    n = 0;
                    while (n < lightBin2.insertEnvSet.size()) {
                        environmentSet = (EnvironmentSet)lightBin2.insertEnvSet.get(n);
                        if (environmentSet.equals(renderAtom, lightRetainedArray, fogRetained, modelClipRetained)) {
                            environmentSet3 = environmentSet;
                            break;
                        }
                        ++n;
                    }
                }
            }
            lightBin2 = lightBin2.next;
        }
        if (environmentSet3 == null) {
            lightBin2 = lightBin;
            while (lightBin2 != null) {
                if (lightBin2.geometryBackground == renderAtom.geometryAtom.source.geometryBackground) {
                    n = 0;
                    while (n < lightBin2.insertEnvSet.size()) {
                        environmentSet = (EnvironmentSet)lightBin2.insertEnvSet.get(n);
                        if (environmentSet.equals(renderAtom, lightRetainedArray, fogRetained, modelClipRetained)) {
                            environmentSet3 = environmentSet;
                            break;
                        }
                        ++n;
                    }
                }
                lightBin2 = lightBin2.next;
            }
        }
        if (environmentSet3 == null) {
            environmentSet2 = this.getEnvironmentSet(renderAtom, lightRetainedArray, fogRetained, modelClipRetained);
            lightBin2 = lightBin3;
            while (lightBin2 != null) {
                if (lightBin2.geometryBackground == renderAtom.geometryAtom.source.geometryBackground && lightBin2.willEnvironmentSetFit(environmentSet2)) {
                    n = 0;
                    while (n < lightRetainedArray.length) {
                        if (!this.changedLts.contains(lightRetainedArray[n])) {
                            this.changedLts.add(lightRetainedArray[n]);
                        }
                        this.envDirty |= REEVALUATE_LIGHTS;
                        ++n;
                    }
                    break;
                }
                lightBin2 = lightBin2.next;
            }
            if (lightBin2 == null) {
                lightBin2 = lightBin;
                while (lightBin2 != null) {
                    if (lightBin2.geometryBackground == renderAtom.geometryAtom.source.geometryBackground && lightBin2.willEnvironmentSetFit(environmentSet2)) {
                        n = 0;
                        while (n < lightRetainedArray.length) {
                            if (!this.changedLts.contains(lightRetainedArray[n])) {
                                this.changedLts.add(lightRetainedArray[n]);
                            }
                            this.envDirty |= REEVALUATE_LIGHTS;
                            ++n;
                        }
                        break;
                    }
                    lightBin2 = lightBin2.next;
                }
            }
            if (lightBin2 == null) {
                lightBin2 = this.getLightBin(this.maxLights, renderAtom.geometryAtom.source.geometryBackground);
                if (lightBin != null) {
                    lightBin2.next = lightBin;
                    lightBin.prev = lightBin2;
                }
                if (renderAtom.geometryAtom.source.inOrderedGroup) {
                    if (!orderedCollection.onUpdateList) {
                        this.objUpdateList.add(orderedCollection);
                        orderedCollection.onUpdateList = true;
                    }
                    orderedCollection.addLightBins = lightBin2;
                } else if (renderAtom.isOpaque()) {
                    if (renderAtom.geometryAtom.source.geometryBackground == null) {
                        this.addOpaqueBin = lightBin2;
                    } else {
                        this.bgAddOpaqueBin = lightBin2;
                    }
                } else if (renderAtom.geometryAtom.source.geometryBackground == null) {
                    this.addTransparentBin = lightBin2;
                } else {
                    this.bgAddTransparentBin = lightBin2;
                }
            }
            environmentSet3 = environmentSet2;
            lightBin2.addEnvironmentSet(environmentSet3, this);
        }
        renderAtom.fog = fogRetained;
        renderAtom.lights = lightRetainedArray;
        renderAtom.modelClip = modelClipRetained;
        renderAtom.app = appearanceRetained;
        this.reInsertAttributeBin(environmentSet3, renderAtom);
    }

    RenderMolecule getRenderMolecule(GeometryAtom geometryAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, Transform3D transform3D) {
        RenderMolecule renderMolecule;
        if (this.renderMoleculeFreelist.size() > 0) {
            renderMolecule = (RenderMolecule)this.renderMoleculeFreelist.remove(this.renderMoleculeFreelist.size() - 1);
            renderMolecule.reset(geometryAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, transform3D);
        } else {
            renderMolecule = new RenderMolecule(geometryAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, transform3D, this);
        }
        if (renderMolecule.primaryMoleculeType == RenderMolecule.DLIST_MOLECULE) {
            this.renderMoleculeList.add(renderMolecule);
        }
        return renderMolecule;
    }

    TextureBin getTextureBin(TextureUnitStateRetained[] textureUnitStateRetainedArray) {
        TextureBin textureBin;
        if (this.textureBinFreelist.size() > 0) {
            textureBin = (TextureBin)this.textureBinFreelist.remove(this.textureBinFreelist.size() - 1);
            textureBin.reset(textureUnitStateRetainedArray);
        } else {
            textureBin = new TextureBin(textureUnitStateRetainedArray, this);
        }
        if (textureUnitStateRetainedArray != null) {
            int n = 0;
            while (n < textureUnitStateRetainedArray.length) {
                if (textureUnitStateRetainedArray[n] != null && textureUnitStateRetainedArray[n].texture != null) {
                    textureUnitStateRetainedArray[n].texture.incTextureBinRefCount();
                }
                ++n;
            }
        }
        return textureBin;
    }

    RenderMolecule insertRenderAtom(RenderAtom renderAtom) {
        EnvironmentSet environmentSet = this.findEnvironmentSet(renderAtom);
        if (renderAtom.geometryAtom.source.appearanceOverrideEnable) {
            Object[] objectArray = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom);
            if (objectArray[0] == Boolean.TRUE) {
                AppearanceRetained appearanceRetained = (AppearanceRetained)objectArray[1];
                if (renderAtom.geometryAtom.source.otherAppearance != appearanceRetained) {
                    if (renderAtom.geometryAtom.source.otherAppearance != null) {
                        renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                    }
                    renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                    renderAtom.app = appearanceRetained;
                    if (appearanceRetained != null) {
                        renderAtom.app.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                    }
                }
            } else {
                renderAtom.app = renderAtom.geometryAtom.source.appearance;
            }
        } else {
            renderAtom.app = renderAtom.geometryAtom.source.appearance;
        }
        AttributeBin attributeBin = this.findAttributeBin(environmentSet, renderAtom);
        TextureBin textureBin = this.findTextureBin(attributeBin, renderAtom);
        RenderMolecule renderMolecule = this.findRenderMolecule(textureBin, renderAtom);
        renderAtom.setRenderBin(true);
        this.renderAtoms.add(renderAtom);
        if (renderAtom.geometryAtom.source instanceof OrientedShape3DRetained) {
            this.orientedRAs.add(renderAtom);
            this.dirtyOrientedRAs.add(renderAtom);
            renderAtom.inDirtyOrientedRAs = true;
            renderAtom.isOriented = true;
            if (renderAtom.localToVworld == null) {
                renderAtom.localToVworld = VirtualUniverse.mc.getTransform3D(null);
            }
        }
        return renderMolecule;
    }

    void lockGeometry() {
        GeometryRetained geometryRetained;
        int n = 0;
        while (n < this.lockGeometryList.size()) {
            geometryRetained = (GeometryRetained)this.lockGeometryList.get(n);
            geometryRetained.geomLock.getLock();
            ++n;
        }
        n = 0;
        while (n < this.dlistLockList.size()) {
            geometryRetained = (GeometryRetained)this.dlistLockList.get(n);
            geometryRetained.geomLock.getLock();
            ++n;
        }
        n = 0;
        while (n < this.nodeComponentList.size()) {
            ImageComponentRetained imageComponentRetained = (ImageComponentRetained)this.nodeComponentList.get(n);
            imageComponentRetained.geomLock.getLock();
            ++n;
        }
    }

    void processAppearanceChanged(Object[] objectArray) {
        RenderAtom renderAtom;
        int n;
        ObjectUpdate objectUpdate;
        int n2;
        RenderAtom renderAtom2;
        GeometryAtom geometryAtom;
        int n3 = (Integer)objectArray[1];
        ArrayList arrayList = (ArrayList)objectArray[3];
        int n4 = 1038;
        if ((n3 & n4) != 0 && arrayList.size() > 0) {
            geometryAtom = (GeometryAtom)arrayList.get(0);
            renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
            n2 = 1;
            while (!renderAtom2.inRenderBin && n2 < arrayList.size()) {
                geometryAtom = (GeometryAtom)arrayList.get(n2);
                renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
                ++n2;
            }
            if (renderAtom2.inRenderBin) {
                objectUpdate = renderAtom2.renderMolecule.textureBin.attributeBin;
                renderAtom2.renderMolecule.removeRenderAtom(renderAtom2);
                this.reInsertTextureBin((AttributeBin)objectUpdate, renderAtom2);
                n = n2;
                while (n < arrayList.size()) {
                    geometryAtom = (GeometryAtom)arrayList.get(n);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin) {
                        renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                        this.reInsertRenderAtom(renderAtom2.renderMolecule.textureBin, renderAtom);
                    }
                    ++n;
                }
            }
        }
        if ((n3 & 0x40) != 0 && arrayList.size() > 0) {
            geometryAtom = (GeometryAtom)arrayList.get(0);
            renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
            n2 = 1;
            while (!renderAtom2.inRenderBin && n2 < arrayList.size()) {
                geometryAtom = (GeometryAtom)arrayList.get(n2);
                renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
                ++n2;
            }
            if (renderAtom2.inRenderBin) {
                objectUpdate = renderAtom2.renderMolecule.textureBin.attributeBin.environmentSet;
                renderAtom2.renderMolecule.removeRenderAtom(renderAtom2);
                this.reInsertAttributeBin((EnvironmentSet)objectUpdate, renderAtom2);
                n = n2;
                while (n < arrayList.size()) {
                    geometryAtom = (GeometryAtom)arrayList.get(n);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin) {
                        renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                        this.reInsertRenderAtom(renderAtom2.renderMolecule.textureBin, renderAtom);
                    }
                    ++n;
                }
            }
        }
        if ((n3 & 0x3B1) != 0 && arrayList.size() > 0) {
            geometryAtom = (GeometryAtom)arrayList.get(0);
            renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
            n2 = 1;
            while (!renderAtom2.inRenderBin && n2 < arrayList.size()) {
                geometryAtom = (GeometryAtom)arrayList.get(n2);
                renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
                ++n2;
            }
            if (renderAtom2.inRenderBin) {
                objectUpdate = renderAtom2.renderMolecule.textureBin;
                renderAtom2.renderMolecule.removeRenderAtom(renderAtom2);
                this.reInsertRenderAtom((TextureBin)objectUpdate, renderAtom2);
                n = n2;
                while (n < arrayList.size()) {
                    geometryAtom = (GeometryAtom)arrayList.get(n);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin) {
                        renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                        this.reInsertRenderAtom(renderAtom2.renderMolecule.textureBin, renderAtom);
                    }
                    ++n;
                }
            }
        }
    }

    void processAttributeBinNodeComponentChanged(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[3];
        int n = (Integer)objectArray[1];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            GeometryAtom geometryAtom = (GeometryAtom)arrayList.get(n2);
            RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
            if (renderAtom.inRenderBin) {
                EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                if (n != 16) {
                    this.reInsertAttributeBin(environmentSet, renderAtom);
                } else {
                    this.renderAtoms.remove(this.renderAtoms.indexOf(renderAtom));
                    renderAtom.setRenderBin(false);
                    if (renderAtom.isOriented) {
                        this.orientedRAs.remove(this.orientedRAs.indexOf(renderAtom));
                        if (renderAtom.inDirtyOrientedRAs) {
                            this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(renderAtom));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    void processBoundingLeafChanged(Object[] objectArray, long l) {
        Object[] objectArray2 = (Object[])objectArray[3];
        int n = 0;
        while (n < objectArray2.length) {
            LeafRetained leafRetained = (LeafRetained)objectArray2[n];
            switch (leafRetained.nodeType) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.envDirty |= REEVALUATE_LIGHTS;
                    break;
                }
                case 3: 
                case 4: {
                    this.envDirty |= REEVALUATE_FOG;
                    break;
                }
                case 1: {
                    this.reEvaluateBg = true;
                    break;
                }
                case 2: {
                    this.reEvaluateClip = true;
                    break;
                }
                case 26: {
                    this.envDirty |= REEVALUATE_MCLIP;
                    break;
                }
                case 27: {
                    this.altAppearanceDirty = true;
                    break;
                }
            }
            ++n;
        }
    }

    void processDataChanged(Object[] objectArray, Object[] objectArray2, long l) {
        RenderAtom renderAtom;
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < objectArray.length) {
            if (((GeometryAtom)objectArray[n]).geometry != null) {
                renderAtom = ((GeometryAtom)objectArray[n]).getRenderAtom(this.view.viewIndex);
                if (renderAtom.inRenderBin) {
                    this.renderAtoms.remove(this.renderAtoms.indexOf(renderAtom));
                    renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                    renderAtom.setRenderBin(false);
                    if (renderAtom.isOriented) {
                        this.orientedRAs.remove(this.orientedRAs.indexOf(renderAtom));
                        if (renderAtom.inDirtyOrientedRAs) {
                            this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(renderAtom));
                        }
                    }
                }
            }
            ++n;
        }
        n = 0;
        while (n < objectArray2.length) {
            if (((GeometryAtom)objectArray2[n]).geometry != null) {
                renderAtom = ((GeometryAtom)objectArray2[n]).getRenderAtom(this.view.viewIndex);
                renderAtom.lastVisibleTime = l;
                if (renderAtom.localeVwcBounds == null) {
                    if (!this.locale.hiRes.equals(renderAtom.geometryAtom.source.locale.hiRes)) {
                        renderAtom.geometryAtom.source.locale.hiRes.difference(this.locale.hiRes, this.localeTranslation);
                        renderAtom.localeVwcBounds = new BoundingBox();
                        renderAtom.localeVwcBounds.translate(renderAtom.geometryAtom.vwcBounds, this.localeTranslation);
                    } else {
                        renderAtom.localeVwcBounds = renderAtom.geometryAtom.vwcBounds;
                    }
                }
                RenderMolecule renderMolecule = this.insertRenderAtom(renderAtom);
                if (renderMolecule.primaryMoleculeType == RenderMolecule.TEXT3D_MOLECULE) {
                    if (renderAtom.localToVworld == null) {
                        renderAtom.localToVworld = VirtualUniverse.mc.getTransform3D(null);
                    }
                    if (!renderAtom.onUpdateList) {
                        renderAtom.onUpdateList = true;
                        this.objUpdateList.add(renderAtom);
                    }
                }
            }
            ++n;
        }
    }

    void processFogChanged(Object[] objectArray) {
        FogRetained fogRetained = (FogRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0xE) != 0) {
            this.envDirty |= REEVALUATE_FOG;
        } else {
            int n2 = 0;
            while (n2 < fogRetained.mirrorFog.environmentSets.size()) {
                EnvironmentSet environmentSet = (EnvironmentSet)fogRetained.mirrorFog.environmentSets.get(n2);
                environmentSet.canvasDirty |= 0x2000;
                if (!environmentSet.onUpdateList) {
                    this.objUpdateList.add(environmentSet);
                    environmentSet.onUpdateList = true;
                }
                ++n2;
            }
        }
    }

    void processGeometryAtoms(GeometryAtom[] geometryAtomArray, long l) {
        int n = 0;
        while (n < geometryAtomArray.length) {
            GeometryAtom geometryAtom = geometryAtomArray[n];
            RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
            renderAtom.lastVisibleTime = l;
            if (renderAtom.geometryAtom.geometry != null && !renderAtom.inRenderBin) {
                if (renderAtom.localeVwcBounds == null) {
                    if (!this.locale.hiRes.equals(geometryAtom.source.locale.hiRes)) {
                        geometryAtom.source.locale.hiRes.difference(this.locale.hiRes, this.localeTranslation);
                        renderAtom.localeVwcBounds = new BoundingBox();
                        renderAtom.localeVwcBounds.translate(renderAtom.geometryAtom.vwcBounds, this.localeTranslation);
                    } else {
                        renderAtom.localeVwcBounds = geometryAtom.vwcBounds;
                    }
                }
                RenderMolecule renderMolecule = this.insertRenderAtom(renderAtom);
                if (renderMolecule.primaryMoleculeType == RenderMolecule.TEXT3D_MOLECULE) {
                    if (renderAtom.localToVworld == null) {
                        renderAtom.localToVworld = VirtualUniverse.mc.getTransform3D(null);
                    }
                    if (!renderAtom.onUpdateList) {
                        renderAtom.onUpdateList = true;
                        this.objUpdateList.add(renderAtom);
                    }
                }
            }
            ++n;
        }
    }

    void processGeometryAtomsChanged(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            RenderAtom renderAtom = ((GeometryAtom)objectArray[n]).getRenderAtom(this.view.viewIndex);
            if (renderAtom.inRenderBin) {
                this.renderAtoms.remove(this.renderAtoms.indexOf(renderAtom));
                renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                renderAtom.setRenderBin(false);
                if (renderAtom.isOriented) {
                    this.orientedRAs.remove(this.orientedRAs.indexOf(renderAtom));
                    if (renderAtom.inDirtyOrientedRAs) {
                        this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(renderAtom));
                    }
                }
            }
            ++n;
        }
    }

    void processGeometryChanged(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray[0];
        ImageComponentRetained imageComponentRetained = (ImageComponentRetained)objectArray[1];
        ImageComponentRetained imageComponentRetained2 = (ImageComponentRetained)objectArray[2];
        int n = 0;
        while (n < objectArray2.length) {
            RenderAtom renderAtom = ((GeometryAtom)objectArray2[n]).getRenderAtom(this.view.viewIndex);
            if (renderAtom.inRenderBin) {
                if ((renderAtom.inPrimaryArray & RenderAtom.DLIST) != 0) {
                    this.addDirtyRenderMolecule(renderAtom.renderMolecule);
                }
                if (renderAtom.geometryAtom.geometry instanceof IndexedGeometryArrayRetained) {
                    this.dirtyIndexedRenderAtom.add(renderAtom);
                }
                if (renderAtom.geometryAtom.geometry instanceof RasterRetained) {
                    RasterRetained rasterRetained = (RasterRetained)renderAtom.geometryAtom.geometry;
                    if (imageComponentRetained != null && imageComponentRetained.isByReference()) {
                        this.removeNodeComponent(imageComponentRetained);
                    }
                    if (imageComponentRetained2 != null && imageComponentRetained2.isByReference()) {
                        this.addNodeComponent(imageComponentRetained2);
                    }
                }
            }
            ++n;
        }
    }

    void processLightChanged() {
        int n = this.lightMessageList.size();
        int n2 = 0;
        while (n2 < n) {
            J3dMessage j3dMessage = (J3dMessage)this.lightMessageList.get(n2);
            Object[] objectArray = j3dMessage.args;
            LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
            int n3 = (Integer)objectArray[1];
            LightRetained lightRetained = (LightRetained)objectArray[0];
            if ((n3 & 0x16) != 0) {
                this.envDirty |= REEVALUATE_LIGHTS;
                n3 &= 0xFFFFFFE9;
            }
            if (n3 != 0) {
                boolean bl;
                EnvironmentSet environmentSet;
                int n4;
                int n5;
                int n6;
                if (lightRetained.nodeType == 5) {
                    n6 = 0;
                    while (n6 < lightRetainedArray.length) {
                        n5 = lightRetainedArray[n6].environmentSets.size();
                        if (n5 > 0) {
                            n4 = 0;
                            while (n4 < n5) {
                                environmentSet = (EnvironmentSet)lightRetainedArray[n6].environmentSets.get(n4);
                                environmentSet.canvasDirty |= 0x100;
                                if (!environmentSet.onUpdateList) {
                                    this.objUpdateList.add(environmentSet);
                                    environmentSet.onUpdateList = true;
                                }
                                ++n4;
                            }
                        } else if ((n3 & 1) != 0 && (bl = lightRetainedArray[n6].lightOn)) {
                            if (!this.changedLts.contains(lightRetainedArray[n6])) {
                                this.changedLts.add(lightRetainedArray[n6]);
                            }
                            this.envDirty |= REEVALUATE_LIGHTS;
                        }
                        ++n6;
                    }
                } else {
                    n6 = 0;
                    while (n6 < lightRetainedArray.length) {
                        n5 = lightRetainedArray[n6].environmentSets.size();
                        if (n5 > 0) {
                            int n7;
                            if ((n3 & 1) != 0) {
                                bl = (Boolean)objectArray[4];
                                n4 = 0;
                                while (n4 < n5) {
                                    environmentSet = (EnvironmentSet)lightRetainedArray[n6].environmentSets.get(n4);
                                    n7 = 0;
                                    while (n7 < environmentSet.lights.size()) {
                                        if (environmentSet.lights.get(n7) == lightRetainedArray[n6]) {
                                            if (bl) {
                                                environmentSet.enableMaskCache |= (long)(1 << environmentSet.ltPos[n7]);
                                                break;
                                            }
                                            environmentSet.enableMaskCache &= (long)(~(1 << environmentSet.ltPos[n7]));
                                            break;
                                        }
                                        ++n7;
                                    }
                                    environmentSet.canvasDirty |= 0x80;
                                    if (!environmentSet.onUpdateList) {
                                        this.objUpdateList.add(environmentSet);
                                        environmentSet.onUpdateList = true;
                                    }
                                    ++n4;
                                }
                            } else {
                                n4 = 0;
                                while (n4 < lightRetainedArray[n6].environmentSets.size()) {
                                    environmentSet = (EnvironmentSet)lightRetainedArray[n6].environmentSets.get(n4);
                                    n7 = 0;
                                    while (n7 < environmentSet.lights.size()) {
                                        if (environmentSet.lights.get(n7) == lightRetainedArray[n6]) {
                                            environmentSet.lightBin.canvasDirty |= 0x40;
                                            environmentSet.lightBin.lightDirtyMaskCache |= 1 << environmentSet.ltPos[n7];
                                            if (environmentSet.lightBin.onUpdateList) break;
                                            environmentSet.lightBin.onUpdateList = true;
                                            this.objUpdateList.add(environmentSet.lightBin);
                                            break;
                                        }
                                        ++n7;
                                    }
                                    ++n4;
                                }
                            }
                        } else if ((n3 & 1) != 0 && (bl = ((Boolean)objectArray[4]).booleanValue())) {
                            if (!this.changedLts.contains(lightRetainedArray[n6])) {
                                this.changedLts.add(lightRetainedArray[n6]);
                            }
                            this.envDirty |= REEVALUATE_LIGHTS;
                        }
                        ++n6;
                    }
                }
            }
            j3dMessage.decRefcount();
            ++n2;
        }
    }

    void processMessages(long l) {
        GeometryAtom[] geometryAtomArray;
        int n;
        boolean bl = false;
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        if (j3dMessageArray != null) {
            n = 0;
            while (n < j3dMessageArray.length) {
                J3dMessage j3dMessage = j3dMessageArray[n];
                switch (j3dMessage.type) {
                    case 0: {
                        Object[] objectArray = (Object[])j3dMessage.args[0];
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            if (objectArray[n2] instanceof LightRetained) {
                                this.envDirty |= REEVALUATE_LIGHTS;
                                if (!this.changedLts.contains(objectArray[n2])) {
                                    this.changedLts.add(objectArray[n2]);
                                }
                            } else if (objectArray[n2] instanceof FogRetained) {
                                this.envDirty |= REEVALUATE_FOG;
                                if (!this.changedFogs.contains(objectArray[n2])) {
                                    this.changedFogs.add(objectArray[n2]);
                                }
                            } else if (objectArray[n2] instanceof BackgroundRetained) {
                                this.reEvaluateBg = true;
                            } else if (objectArray[n2] instanceof ClipRetained) {
                                this.reEvaluateClip = true;
                            } else if (objectArray[n2] instanceof ModelClipRetained) {
                                this.envDirty |= REEVALUATE_MCLIP;
                                if (!this.changedModelClips.contains(objectArray[n2])) {
                                    this.changedModelClips.add(objectArray[n2]);
                                }
                            } else if (objectArray[n2] instanceof GeometryAtom) {
                                bl = true;
                            } else if (objectArray[n2] instanceof AlternateAppearanceRetained) {
                                this.altAppearanceDirty = true;
                            }
                            ++n2;
                        }
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 1: {
                        Object[] objectArray = (Object[])j3dMessage.args[0];
                        int n3 = 0;
                        while (n3 < objectArray.length) {
                            if (objectArray[n3] instanceof GeometryAtom) {
                                geometryAtomArray = ((GeometryAtom)objectArray[n3]).getRenderAtom(this.view.viewIndex);
                                if (geometryAtomArray.inRenderBin) {
                                    this.renderAtoms.remove(this.renderAtoms.indexOf(geometryAtomArray));
                                    geometryAtomArray.renderMolecule.removeRenderAtom((RenderAtom)geometryAtomArray);
                                    geometryAtomArray.setRenderBin(false);
                                    if (geometryAtomArray.isOriented) {
                                        this.orientedRAs.remove(this.orientedRAs.indexOf(geometryAtomArray));
                                        if (geometryAtomArray.inDirtyOrientedRAs) {
                                            this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(geometryAtomArray));
                                        }
                                    }
                                }
                            } else if (objectArray[n3] instanceof AlternateAppearanceRetained) {
                                this.altAppearanceDirty = true;
                            } else if (objectArray[n3] instanceof BackgroundRetained) {
                                this.reEvaluateBg = true;
                            } else if (objectArray[n3] instanceof ClipRetained) {
                                this.reEvaluateClip = true;
                            } else {
                                this.envDirty = REEVALUATE_ALL_ENV;
                            }
                            ++n3;
                        }
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 3: {
                        int n4 = this.transList.indexOf(j3dMessage.args[1]);
                        if (n4 < 0) {
                            this.transList.add(j3dMessage.args[1]);
                            this.transMessageList.add(j3dMessage);
                            break;
                        }
                        ((J3dMessage)this.transMessageList.get(n4)).decRefcount();
                        this.transMessageList.set(n4, j3dMessage);
                        break;
                    }
                    case 19: {
                        this.lightMessageList.add(j3dMessage);
                        break;
                    }
                    case 27: {
                        bl = true;
                        this.processSwitchChanged(j3dMessage, l);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 20: {
                        this.reEvaluateBg = true;
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 21: {
                        this.reEvaluateClip = true;
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: {
                        this.processRenderMoleculeNodeComponentChanged(j3dMessage.args);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 11: 
                    case 14: 
                    case 15: 
                    case 47: {
                        this.processTextureBinNodeComponentChanged(j3dMessage.args);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 10: {
                        this.processAttributeBinNodeComponentChanged(j3dMessage.args);
                        int n5 = (Integer)j3dMessage.args[1];
                        if (n5 == 16) {
                            bl = true;
                        }
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 22: {
                        this.processFogChanged(j3dMessage.args);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 41: {
                        this.altAppearanceDirty = true;
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 18: {
                        this.processAppearanceChanged(j3dMessage.args);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 36: {
                        this.processModelClipChanged(j3dMessage.args);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged(j3dMessage.args, l);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 24: {
                        this.processShapeChanged(j3dMessage.args, l);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 46: {
                        this.processOrientedShape3DChanged((Object[])j3dMessage.args[0]);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 16: {
                        this.processMorphChanged(j3dMessage.args, l);
                        int n5 = (Integer)j3dMessage.args[1];
                        if ((n5 & 1) != 0) {
                            bl = true;
                        }
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 4: {
                        View view = (View)j3dMessage.args[0];
                        if (view.viewPlatform != null) {
                            this.updateViewPlatform((ViewPlatformRetained)view.viewPlatform.retained, ((Float)j3dMessage.args[1]).floatValue());
                            bl = true;
                            if (this.view.viewCache.visibilityPolicy != 2) {
                                int n6 = this.renderAtoms.size() - 1;
                                while (n6 >= 0) {
                                    RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n6);
                                    this.renderAtoms.remove(n6);
                                    renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                                    renderAtom.setRenderBin(false);
                                    if (renderAtom.isOriented) {
                                        this.orientedRAs.remove(this.orientedRAs.indexOf(renderAtom));
                                        if (renderAtom.inDirtyOrientedRAs) {
                                            this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(renderAtom));
                                        }
                                    }
                                    --n6;
                                }
                            }
                        }
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 48: {
                        this.updateViewPlatform((ViewPlatformRetained)j3dMessage.args[0], ((Float)j3dMessage.args[1]).floatValue());
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 26: {
                        this.processDataChanged((Object[])j3dMessage.args[0], (Object[])j3dMessage.args[1], l);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 17: {
                        this.processGeometryChanged(j3dMessage.args);
                        bl = true;
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 35: 
                    case 37: {
                        this.processGeometryAtomsChanged((Object[])j3dMessage.args[0]);
                        bl = true;
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 25: {
                        this.processText3DTransformChanged((Object[])j3dMessage.args[0], (Object[])j3dMessage.args[1], l);
                        bl = true;
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 32: {
                        this.processOrderedGroupInserted(j3dMessage);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 33: {
                        this.processOrderedGroupRemoved(j3dMessage);
                        j3dMessage.decRefcount();
                        break;
                    }
                    case 42: {
                        this.offScreenMessage.add(j3dMessage);
                        break;
                    }
                    default: {
                        j3dMessage.decRefcount();
                    }
                }
                ++n;
            }
            if (this.transMessageList.size() > 0) {
                this.processTransformChanged();
                this.transMessageList.clear();
                this.transList.clear();
                bl = true;
            }
            if (this.lightMessageList.size() > 0) {
                this.processLightChanged();
                this.lightMessageList.clear();
            }
            VirtualUniverse.mc.addMirrorObject(this);
        }
        if (this.reEvaluateBg) {
            this.currentActiveBackground = this.universe.renderingEnvironmentStructure.getApplicationBackground(this.vpSchedSphereInVworld, this.locale);
        }
        if (bl) {
            this.computeViewFrustumBBox(this.viewFrustumBBox);
            if (this.view.viewPlatform != null) {
                GeometryAtom[] geometryAtomArray2 = this.universe.geometryStructure.getVisibleGeometryAtom(this.viewFrustumBBox, this.locale, (this.view.viewCache.vcDirtyMask & 0x10000) != 0, this.view.viewCache.visibilityPolicy);
                if (geometryAtomArray2 != null) {
                    this.processGeometryAtoms(geometryAtomArray2, l);
                }
                if (this.currentActiveBackground != null && this.currentActiveBackground.geometryBranch != null && (geometryAtomArray = this.currentActiveBackground.getBackgroundGeometryAtoms()) != null) {
                    this.processGeometryAtoms(geometryAtomArray, l);
                }
            }
            bl = false;
        } else {
            n = 0;
            while (n < this.renderAtoms.size()) {
                RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
                renderAtom.lastVisibleTime = l;
                ++n;
            }
        }
        if (this.envDirty == REEVALUATE_ALL_ENV || this.envDirty == 3 || this.envDirty > 4) {
            this.reEvaluateEnv(this.changedLts, this.changedFogs, this.changedModelClips, true, this.altAppearanceDirty);
        } else if (this.envDirty == 0 && this.altAppearanceDirty) {
            this.reEvaluateAlternateAppearance();
        } else if ((this.envDirty & REEVALUATE_LIGHTS) != 0) {
            this.reEvaluateLights(this.changedLts, this.changedLts.size() > 0, this.altAppearanceDirty);
        } else if ((this.envDirty & REEVALUATE_FOG) != 0) {
            this.reEvaluateFog(this.changedFogs, this.changedFogs.size() > 0, this.altAppearanceDirty);
        } else if ((this.envDirty & REEVALUATE_MCLIP) != 0) {
            this.reEvaluateModelClip(this.changedModelClips, this.changedModelClips.size() > 0, this.altAppearanceDirty);
        }
        this.changedLts.clear();
        this.changedFogs.clear();
        this.changedModelClips.clear();
        this.envDirty = 0;
        this.altAppearanceDirty = false;
        this.view.renderBinReady = true;
        VirtualUniverse.mc.sendRunMessage(this.view, 16);
    }

    void processModelClipChanged(Object[] objectArray) {
        ModelClipRetained modelClipRetained = (ModelClipRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        ModelClipRetained[] modelClipRetainedArray = new ModelClipRetained[1];
        if ((n & 0x30) != 0) {
            modelClipRetainedArray[0] = modelClipRetained.mirrorModelClip;
            this.envDirty |= REEVALUATE_MCLIP;
        } else {
            int n2 = 0;
            while (n2 < modelClipRetained.mirrorModelClip.environmentSets.size()) {
                EnvironmentSet environmentSet = (EnvironmentSet)modelClipRetained.mirrorModelClip.environmentSets.get(n2);
                environmentSet.canvasDirty |= 0x4000;
                if (!environmentSet.onUpdateList) {
                    this.objUpdateList.add(environmentSet);
                    environmentSet.onUpdateList = true;
                }
                ++n2;
            }
        }
    }

    void processMorphChanged(Object[] objectArray, long l) {
        block22: {
            int n;
            block21: {
                RenderAtom renderAtom;
                GeometryAtom geometryAtom;
                ArrayList arrayList;
                block23: {
                    n = (Integer)objectArray[1];
                    if ((n & 2) == 0) break block21;
                    arrayList = (ArrayList)objectArray[4];
                    if (arrayList.size() <= 0) break block22;
                    geometryAtom = (GeometryAtom)arrayList.get(0);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.geometryAtom.source.appearanceOverrideEnable) break block23;
                    int n2 = 1;
                    while (!renderAtom.inRenderBin && n2 < arrayList.size()) {
                        geometryAtom = (GeometryAtom)arrayList.get(n2);
                        renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                        ++n2;
                    }
                    if (!renderAtom.inRenderBin) break block22;
                    EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                    renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                    renderAtom.app = renderAtom.geometryAtom.source.appearance;
                    this.reInsertAttributeBin(environmentSet, renderAtom);
                    int n3 = n2;
                    while (n3 < arrayList.size()) {
                        geometryAtom = (GeometryAtom)arrayList.get(n3);
                        RenderAtom renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
                        if (renderAtom2.inRenderBin) {
                            renderAtom2.renderMolecule.removeRenderAtom(renderAtom2);
                            renderAtom2.app = renderAtom2.geometryAtom.source.appearance;
                            this.reInsertRenderAtom(renderAtom.renderMolecule.textureBin, renderAtom2);
                        }
                        ++n3;
                    }
                    break block22;
                }
                TextureBin textureBin = null;
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    geometryAtom = (GeometryAtom)arrayList.get(n4);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin && renderAtom.app != renderAtom.geometryAtom.source.otherAppearance) {
                        if (textureBin == null) {
                            EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                            renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                            renderAtom.app = renderAtom.geometryAtom.source.appearance;
                            this.reInsertAttributeBin(environmentSet, renderAtom);
                            textureBin = renderAtom.renderMolecule.textureBin;
                        } else {
                            renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                            renderAtom.app = renderAtom.geometryAtom.source.appearance;
                            this.reInsertRenderAtom(textureBin, renderAtom);
                        }
                    }
                    ++n4;
                }
                break block22;
            }
            if ((n & 1) != 0) {
                Object[] objectArray2 = (Object[])objectArray[3];
                int n5 = 0;
                while (n5 < objectArray2.length) {
                    GeometryAtom geometryAtom = (GeometryAtom)objectArray2[n5];
                    RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    this.dirtyIndexedRenderAtom.add(renderAtom);
                    ++n5;
                }
            } else if ((n & 0x20) != 0) {
                AppearanceRetained appearanceRetained = null;
                Shape3DRetained shape3DRetained = null;
                ArrayList arrayList = (ArrayList)objectArray[4];
                ArrayList arrayList2 = (ArrayList)objectArray[2];
                int n6 = 0;
                while (n6 < arrayList.size()) {
                    GeometryAtom geometryAtom = (GeometryAtom)arrayList.get(n6);
                    RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin) {
                        AppearanceRetained appearanceRetained2;
                        if (shape3DRetained != renderAtom.geometryAtom.source) {
                            shape3DRetained = renderAtom.geometryAtom.source;
                            if (renderAtom.geometryAtom.source.appearanceOverrideEnable) {
                                Object[] objectArray3 = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom);
                                shape3DRetained.otherAppearance = (AppearanceRetained)objectArray3[1];
                                if (objectArray3[0] == Boolean.TRUE) {
                                    appearanceRetained2 = (AppearanceRetained)objectArray3[1];
                                    if (appearanceRetained2 != null) {
                                        appearanceRetained2.sgApp.addAMirrorUser(shape3DRetained);
                                    }
                                } else {
                                    appearanceRetained2 = renderAtom.geometryAtom.source.appearance;
                                }
                            } else {
                                if (renderAtom.app == shape3DRetained.otherAppearance && renderAtom.app != null) {
                                    renderAtom.app.sgApp.removeAMirrorUser(shape3DRetained);
                                }
                                appearanceRetained2 = renderAtom.geometryAtom.source.appearance;
                                shape3DRetained.otherAppearance = null;
                            }
                            appearanceRetained = appearanceRetained2;
                        } else {
                            appearanceRetained2 = appearanceRetained;
                        }
                        EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                        renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                        renderAtom.app = appearanceRetained2;
                        this.reInsertAttributeBin(environmentSet, renderAtom);
                    }
                    ++n6;
                }
            }
        }
    }

    void processOrderedGroupInserted(J3dMessage j3dMessage) {
        int n;
        boolean bl = false;
        OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)j3dMessage.args[0];
        int n2 = (Integer)j3dMessage.args[1];
        int n3 = (Integer)j3dMessage.args[2];
        if (orderedGroupRetained.orderedBin != null) {
            int n4;
            if (orderedGroupRetained.orderedBin.addToOC.size() > 0) {
                int n5 = orderedGroupRetained.orderedBin.addToOC.size();
                n = 0;
                while (n < orderedGroupRetained.orderedBin.addToOC.size()) {
                    n4 = (Integer)orderedGroupRetained.orderedBin.addToOC.get(n);
                    if (n4 >= n2) {
                        orderedGroupRetained.orderedBin.addToOC.add(n, new Integer(n2));
                        orderedGroupRetained.orderedBin.valueOfOC.add(n, null);
                        if (!this.addOGsList.contains(orderedGroupRetained.orderedBin)) {
                            this.addOGsList.add(orderedGroupRetained.orderedBin);
                        }
                        n5 = n + 1;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    orderedGroupRetained.orderedBin.addToOC.add(new Integer(n2));
                    orderedGroupRetained.orderedBin.valueOfOC.add(null);
                    if (!this.addOGsList.contains(orderedGroupRetained.orderedBin)) {
                        this.addOGsList.add(orderedGroupRetained.orderedBin);
                    }
                } else {
                    n = n5;
                    while (n < orderedGroupRetained.orderedBin.addToOC.size()) {
                        n4 = (Integer)orderedGroupRetained.orderedBin.addToOC.get(n);
                        orderedGroupRetained.orderedBin.addToOC.set(n, new Integer(++n4));
                        ++n;
                    }
                }
            } else {
                orderedGroupRetained.orderedBin.addToOC.add(new Integer(n2));
                orderedGroupRetained.orderedBin.valueOfOC.add(null);
                if (!this.addOGsList.contains(orderedGroupRetained.orderedBin)) {
                    this.addOGsList.add(orderedGroupRetained.orderedBin);
                }
            }
            if (orderedGroupRetained.orderedBin.setOC.size() > 0) {
                n = 0;
                while (n < orderedGroupRetained.orderedBin.setOC.size()) {
                    n4 = (Integer)orderedGroupRetained.orderedBin.setOC.get(n);
                    if (n4 >= n2) {
                        orderedGroupRetained.orderedBin.setOC.set(n, new Integer(++n4));
                    }
                    ++n;
                }
            }
            if (orderedGroupRetained.orderedBin.removeFromOC.size() > 0) {
                n = 0;
                while (n < orderedGroupRetained.orderedBin.removeFromOC.size()) {
                    n4 = (Integer)orderedGroupRetained.orderedBin.removeFromOC.get(n);
                    if (n4 >= n2) {
                        orderedGroupRetained.orderedBin.removeFromOC.set(n, new Integer(++n4));
                    }
                    ++n;
                }
            }
        }
        int n6 = 0;
        if (orderedGroupRetained.orderedChildIdTable != null) {
            n6 = orderedGroupRetained.orderedChildIdTable.length;
            n = 0;
            while (n < n6) {
                if (orderedGroupRetained.orderedChildIdTable[n] != -1 && orderedGroupRetained.orderedChildIdTable[n] >= n2) {
                    int n7 = n;
                    orderedGroupRetained.orderedChildIdTable[n7] = orderedGroupRetained.orderedChildIdTable[n7] + 1;
                }
                ++n;
            }
        }
        if (n3 >= n6) {
            int[] nArray = new int[n3 + 1];
            if (n6 > 0) {
                System.arraycopy(orderedGroupRetained.orderedChildIdTable, 0, nArray, 0, orderedGroupRetained.orderedChildIdTable.length);
            }
            orderedGroupRetained.orderedChildIdTable = nArray;
        }
        orderedGroupRetained.orderedChildIdTable[n3] = n2;
    }

    void processOrderedGroupRemoved(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        int n = 0;
        while (n < objectArray.length) {
            block12: {
                int n2;
                int n3;
                OrderedGroupRetained orderedGroupRetained;
                block10: {
                    block11: {
                        orderedGroupRetained = (OrderedGroupRetained)objectArray[n];
                        n3 = (Integer)objectArray2[n];
                        boolean bl = false;
                        if (orderedGroupRetained.orderedBin == null) break block10;
                        if (orderedGroupRetained.orderedBin.removeFromOC.size() <= 0) break block11;
                        n2 = 0;
                        while (n2 < orderedGroupRetained.orderedBin.removeFromOC.size()) {
                            int n4 = (Integer)orderedGroupRetained.orderedBin.removeFromOC.get(n2);
                            if (n4 < n3) {
                                orderedGroupRetained.orderedBin.removeFromOC.add(n2, new Integer(n3));
                                if (!this.removeOGsList.contains(orderedGroupRetained.orderedBin)) {
                                    this.removeOGsList.add(orderedGroupRetained.orderedBin);
                                }
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        if (bl) break block12;
                        orderedGroupRetained.orderedBin.removeFromOC.add(new Integer(n3));
                        if (this.removeOGsList.contains(orderedGroupRetained.orderedBin)) break block12;
                        this.removeOGsList.add(orderedGroupRetained.orderedBin);
                        break block12;
                    }
                    orderedGroupRetained.orderedBin.removeFromOC.add(new Integer(n3));
                    if (this.removeOGsList.contains(orderedGroupRetained.orderedBin)) break block12;
                    this.removeOGsList.add(orderedGroupRetained.orderedBin);
                    break block12;
                }
                if (orderedGroupRetained.orderedChildIdTable != null) {
                    n2 = 0;
                    while (n2 < orderedGroupRetained.orderedChildIdTable.length) {
                        if (orderedGroupRetained.orderedChildIdTable[n2] != -1) {
                            if (orderedGroupRetained.orderedChildIdTable[n2] > n3) {
                                int n5 = n2;
                                orderedGroupRetained.orderedChildIdTable[n5] = orderedGroupRetained.orderedChildIdTable[n5] - 1;
                            } else if (orderedGroupRetained.orderedChildIdTable[n2] == n3) {
                                orderedGroupRetained.orderedChildIdTable[n2] = -1;
                                orderedGroupRetained.freeOrderedChildId(n2);
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    void processOrientedShape3DChanged(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            RenderAtom renderAtom = ((GeometryAtom)objectArray[n]).getRenderAtom(this.view.viewIndex);
            if (renderAtom.inRenderBin && !renderAtom.inDirtyOrientedRAs) {
                this.dirtyOrientedRAs.add(renderAtom);
                renderAtom.inDirtyOrientedRAs = true;
            }
            ++n;
        }
    }

    void processRenderMoleculeNodeComponentChanged(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[3];
        int n = 0;
        while (n < arrayList.size()) {
            GeometryAtom geometryAtom = (GeometryAtom)arrayList.get(n);
            RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
            if (renderAtom.inRenderBin) {
                TextureBin textureBin = renderAtom.renderMolecule.textureBin;
                renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                this.reInsertRenderAtom(textureBin, renderAtom);
            }
            ++n;
        }
    }

    void processShapeChanged(Object[] objectArray, long l) {
        block21: {
            int n;
            block20: {
                RenderAtom renderAtom;
                GeometryAtom geometryAtom;
                ArrayList arrayList;
                block22: {
                    n = (Integer)objectArray[1];
                    if ((n & 2) == 0) break block20;
                    arrayList = (ArrayList)objectArray[4];
                    if (arrayList.size() <= 0) break block21;
                    geometryAtom = (GeometryAtom)arrayList.get(0);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.geometryAtom.source.appearanceOverrideEnable) break block22;
                    int n2 = 1;
                    while (!renderAtom.inRenderBin && n2 < arrayList.size()) {
                        geometryAtom = (GeometryAtom)arrayList.get(n2);
                        renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                        ++n2;
                    }
                    if (!renderAtom.inRenderBin) break block21;
                    EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                    renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                    renderAtom.app = renderAtom.geometryAtom.source.appearance;
                    this.reInsertAttributeBin(environmentSet, renderAtom);
                    int n3 = n2;
                    while (n3 < arrayList.size()) {
                        geometryAtom = (GeometryAtom)arrayList.get(n3);
                        RenderAtom renderAtom2 = geometryAtom.getRenderAtom(this.view.viewIndex);
                        if (renderAtom2.inRenderBin) {
                            renderAtom2.renderMolecule.removeRenderAtom(renderAtom2);
                            renderAtom2.app = renderAtom2.geometryAtom.source.appearance;
                            this.reInsertRenderAtom(renderAtom.renderMolecule.textureBin, renderAtom2);
                        }
                        ++n3;
                    }
                    break block21;
                }
                TextureBin textureBin = null;
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    geometryAtom = (GeometryAtom)arrayList.get(n4);
                    renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin && renderAtom.app != renderAtom.geometryAtom.source.otherAppearance) {
                        if (textureBin == null) {
                            EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                            renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                            renderAtom.app = renderAtom.geometryAtom.source.appearance;
                            this.reInsertAttributeBin(environmentSet, renderAtom);
                            textureBin = renderAtom.renderMolecule.textureBin;
                        } else {
                            renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                            renderAtom.app = renderAtom.geometryAtom.source.appearance;
                            this.reInsertRenderAtom(textureBin, renderAtom);
                        }
                    }
                    ++n4;
                }
                break block21;
            }
            if ((n & 1) != 0) {
                this.processDataChanged((Object[])objectArray[2], (Object[])objectArray[3], l);
            } else if ((n & 0x10) != 0) {
                AppearanceRetained appearanceRetained = null;
                Shape3DRetained shape3DRetained = null;
                ArrayList arrayList = (ArrayList)objectArray[4];
                ArrayList arrayList2 = (ArrayList)objectArray[2];
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    GeometryAtom geometryAtom = (GeometryAtom)arrayList.get(n5);
                    RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin) {
                        AppearanceRetained appearanceRetained2;
                        if (shape3DRetained != renderAtom.geometryAtom.source) {
                            shape3DRetained = renderAtom.geometryAtom.source;
                            if (renderAtom.geometryAtom.source.appearanceOverrideEnable) {
                                Object[] objectArray2 = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom);
                                shape3DRetained.otherAppearance = (AppearanceRetained)objectArray2[1];
                                if (objectArray2[0] == Boolean.TRUE) {
                                    appearanceRetained2 = (AppearanceRetained)objectArray2[1];
                                    if (appearanceRetained2 != null) {
                                        appearanceRetained2.sgApp.addAMirrorUser(shape3DRetained);
                                    }
                                } else {
                                    appearanceRetained2 = renderAtom.geometryAtom.source.appearance;
                                }
                            } else {
                                if (renderAtom.app == shape3DRetained.otherAppearance && renderAtom.app != null) {
                                    renderAtom.app.sgApp.removeAMirrorUser(shape3DRetained);
                                }
                                appearanceRetained2 = renderAtom.geometryAtom.source.appearance;
                                shape3DRetained.otherAppearance = null;
                            }
                            appearanceRetained = appearanceRetained2;
                        } else {
                            appearanceRetained2 = appearanceRetained;
                        }
                        EnvironmentSet environmentSet = renderAtom.renderMolecule.textureBin.attributeBin.environmentSet;
                        renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                        renderAtom.app = appearanceRetained2;
                        this.reInsertAttributeBin(environmentSet, renderAtom);
                    }
                    ++n5;
                }
            }
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage, long l) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof LightRetained) {
                this.envDirty |= REEVALUATE_LIGHTS;
            } else if (objectArray[n] instanceof FogRetained) {
                this.envDirty |= REEVALUATE_FOG;
            } else if (objectArray[n] instanceof ModelClipRetained) {
                this.envDirty |= REEVALUATE_MCLIP;
            } else if (objectArray[n] instanceof BackgroundRetained) {
                this.reEvaluateBg = true;
            } else if (objectArray[n] instanceof ClipRetained) {
                this.reEvaluateClip = true;
            } else if (objectArray[n] instanceof AlternateAppearanceRetained) {
                this.altAppearanceDirty = true;
            } else if (objectArray[n] instanceof BoundingLeafRetained) {
                Object[] objectArray2 = (Object[])j3dMessage.args[2];
                Object[] objectArray3 = (Object[])objectArray2[n];
                BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n];
                int n2 = 0;
                while (n2 < objectArray3.length) {
                    if (objectArray3[n2] instanceof FogRetained) {
                        this.envDirty |= REEVALUATE_FOG;
                    } else if (objectArray3[n2] instanceof LightRetained) {
                        this.envDirty |= REEVALUATE_LIGHTS;
                    } else if (objectArray3[n2] instanceof ModelClipRetained) {
                        this.envDirty |= REEVALUATE_MCLIP;
                    } else if (objectArray3[n2] instanceof AlternateAppearanceRetained) {
                        this.altAppearanceDirty = true;
                    } else if (objectArray3[n2] instanceof BackgroundRetained) {
                        this.reEvaluateBg = true;
                    } else if (objectArray3[n2] instanceof ClipRetained) {
                        this.reEvaluateClip = true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    void processText3DTransformChanged(Object[] objectArray, Object[] objectArray2, long l) {
        if (objectArray2.length != 0) {
            int n = objectArray.length / objectArray2.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < objectArray2.length) {
                    GeometryAtom geometryAtom = (GeometryAtom)objectArray[n2];
                    RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin) {
                        geometryAtom.lastLocalTransform = (Transform3D)objectArray2[n4];
                        if (renderAtom.localToVworld == null) {
                            renderAtom.localToVworld = VirtualUniverse.mc.getTransform3D(null);
                        }
                        if (renderAtom.isOriented && !renderAtom.inDirtyOrientedRAs) {
                            this.dirtyOrientedRAs.add(renderAtom);
                            renderAtom.inDirtyOrientedRAs = true;
                        } else if (!renderAtom.onUpdateList) {
                            renderAtom.onUpdateList = true;
                            this.objUpdateList.add(renderAtom);
                        }
                    }
                    ++n4;
                    ++n2;
                }
                ++n3;
            }
        }
    }

    void processTextureBinNodeComponentChanged(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[3];
        int n = 0;
        while (n < arrayList.size()) {
            GeometryAtom geometryAtom = (GeometryAtom)arrayList.get(n);
            RenderAtom renderAtom = geometryAtom.getRenderAtom(this.view.viewIndex);
            if (renderAtom.inRenderBin) {
                AttributeBin attributeBin = renderAtom.renderMolecule.textureBin.attributeBin;
                renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                this.reInsertTextureBin(attributeBin, renderAtom);
            }
            ++n;
        }
    }

    void processTransformChanged() {
        int n = this.transMessageList.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            J3dMessage j3dMessage = (J3dMessage)this.transMessageList.get(n2);
            Object[] objectArray = (Object[])j3dMessage.args[0];
            ArrayList arrayList = (ArrayList)j3dMessage.args[3];
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] instanceof GeometryAtom) {
                    RenderMolecule renderMolecule;
                    object = (GeometryAtom)objectArray[n3];
                    RenderAtom renderAtom = ((GeometryAtom)object).getRenderAtom(this.view.viewIndex);
                    if (renderAtom.inRenderBin && (renderMolecule = renderAtom.renderMolecule) != null && renderMolecule.renderBin == this) {
                        Object[] objectArray2;
                        LightRetained[] lightRetainedArray = this.universe.renderingEnvironmentStructure.getInfluencingLights(renderAtom);
                        FogRetained fogRetained = this.universe.renderingEnvironmentStructure.getInfluencingFog(renderAtom);
                        ModelClipRetained modelClipRetained = this.universe.renderingEnvironmentStructure.getInfluencingModelClip(renderAtom);
                        AppearanceRetained appearanceRetained = renderAtom.geometryAtom.source.appearanceOverrideEnable ? ((objectArray2 = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom))[0] == Boolean.TRUE ? (AppearanceRetained)objectArray2[1] : renderAtom.geometryAtom.source.appearance) : renderAtom.geometryAtom.source.appearance;
                        if (renderAtom.envSet.equals(renderAtom, lightRetainedArray, fogRetained, modelClipRetained) && appearanceRetained == renderAtom.app) {
                            if (!this.locale.hiRes.equals(((GeometryAtom)object).source.locale.hiRes)) {
                                if (renderMolecule.onUpdateList == 0) {
                                    this.objUpdateList.add(renderMolecule);
                                }
                                renderMolecule.onUpdateList |= RenderMolecule.LOCALE_TRANSLATION;
                            }
                            if ((renderMolecule.primaryMoleculeType & RenderMolecule.DLIST_MOLECULE) != 0) {
                                if (renderMolecule.onUpdateList == 0) {
                                    this.objUpdateList.add(renderMolecule);
                                }
                                renderMolecule.onUpdateList |= RenderMolecule.BOUNDS_RECOMPUTE_UPDATE;
                            } else if ((renderMolecule.primaryMoleculeType & RenderMolecule.TEXT3D_MOLECULE) != 0) {
                                if (renderAtom.localToVworld == null) {
                                    renderAtom.localToVworld = VirtualUniverse.mc.getTransform3D(null);
                                }
                                if (!renderAtom.onUpdateList) {
                                    renderAtom.onUpdateList = true;
                                    this.objUpdateList.add(renderAtom);
                                }
                            }
                            if (renderMolecule.primaryMoleculeType == RenderMolecule.ORIENTEDSHAPE3D_MOLECULE && !renderAtom.inDirtyOrientedRAs) {
                                this.dirtyOrientedRAs.add(renderAtom);
                                renderAtom.inDirtyOrientedRAs = true;
                            }
                        } else {
                            if (renderAtom.app != appearanceRetained && renderAtom.geometryAtom.source.appearanceOverrideEnable) {
                                if (renderAtom.app == renderAtom.geometryAtom.source.otherAppearance) {
                                    if (renderAtom.app != null) {
                                        renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                                        renderAtom.geometryAtom.source.otherAppearance = null;
                                    }
                                } else if (appearanceRetained != renderAtom.geometryAtom.source.appearance && appearanceRetained != null && appearanceRetained != renderAtom.geometryAtom.source.otherAppearance) {
                                    appearanceRetained.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                                    renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                                }
                            }
                            this.getNewEnvironment(renderAtom, lightRetainedArray, fogRetained, modelClipRetained, appearanceRetained);
                        }
                    }
                } else if (objectArray[n3] instanceof ViewPlatformRetained) {
                    float f;
                    Object object2 = objectArray[n3];
                    synchronized (object2) {
                        f = (float)((ViewPlatformRetained)objectArray[n3]).sphere.radius;
                    }
                    this.updateViewPlatform((ViewPlatformRetained)objectArray[n3], f);
                } else if (objectArray[n3] instanceof LightRetained) {
                    if (!this.changedLts.contains(objectArray[n3])) {
                        this.changedLts.add(objectArray[n3]);
                    }
                    this.envDirty |= REEVALUATE_LIGHTS;
                } else if (objectArray[n3] instanceof ModelClipRetained) {
                    if (!this.changedModelClips.contains(objectArray[n3])) {
                        this.changedModelClips.add(objectArray[n3]);
                    }
                    this.envDirty |= REEVALUATE_MCLIP;
                }
                ++n3;
            }
            if (arrayList != null) {
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    object = (LeafRetained)arrayList.get(n4);
                    if (object instanceof LightRetained) {
                        this.envDirty |= REEVALUATE_LIGHTS;
                    } else if (object instanceof FogRetained) {
                        this.envDirty |= REEVALUATE_FOG;
                    } else if (object instanceof ModelClipRetained) {
                        this.envDirty |= REEVALUATE_MCLIP;
                    } else if (object instanceof AlternateAppearanceRetained) {
                        this.altAppearanceDirty = true;
                    }
                    ++n4;
                }
            }
            j3dMessage.decRefcount();
            ++n2;
        }
    }

    void reEvaluateAllRenderAtoms(boolean bl) {
        int n = 0;
        while (n < this.renderAtoms.size()) {
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
            if (renderAtom.inRenderBin) {
                Object[] objectArray;
                LightRetained[] lightRetainedArray = this.universe.renderingEnvironmentStructure.getInfluencingLights(renderAtom);
                FogRetained fogRetained = this.universe.renderingEnvironmentStructure.getInfluencingFog(renderAtom);
                ModelClipRetained modelClipRetained = this.universe.renderingEnvironmentStructure.getInfluencingModelClip(renderAtom);
                AppearanceRetained appearanceRetained = bl ? (renderAtom.geometryAtom.source.appearanceOverrideEnable ? ((objectArray = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom))[0] == Boolean.TRUE ? (AppearanceRetained)objectArray[1] : renderAtom.geometryAtom.source.appearance) : renderAtom.geometryAtom.source.appearance) : renderAtom.app;
                if (!renderAtom.envSet.equals(renderAtom, lightRetainedArray, fogRetained, modelClipRetained) || appearanceRetained != renderAtom.app) {
                    if (bl && renderAtom.geometryAtom.source.appearanceOverrideEnable && appearanceRetained != renderAtom.app && renderAtom.geometryAtom.source.otherAppearance != appearanceRetained) {
                        if (renderAtom.geometryAtom.source.otherAppearance != null) {
                            renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                        }
                        if (appearanceRetained != renderAtom.geometryAtom.source.appearance) {
                            if (appearanceRetained != null) {
                                appearanceRetained.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                            }
                            renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                        } else {
                            renderAtom.geometryAtom.source.otherAppearance = null;
                        }
                    }
                    this.getNewEnvironment(renderAtom, lightRetainedArray, fogRetained, modelClipRetained, appearanceRetained);
                }
            }
            ++n;
        }
    }

    void reEvaluateAlternateAppearance() {
        int n = 0;
        while (n < this.renderAtoms.size()) {
            Object[] objectArray;
            AppearanceRetained appearanceRetained;
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
            if (renderAtom.inRenderBin && renderAtom.geometryAtom.source.appearanceOverrideEnable && (appearanceRetained = (objectArray = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom))[0] == Boolean.TRUE ? (AppearanceRetained)objectArray[1] : renderAtom.geometryAtom.source.appearance) != renderAtom.app) {
                if (renderAtom.geometryAtom.source.otherAppearance != appearanceRetained) {
                    if (renderAtom.geometryAtom.source.otherAppearance != null) {
                        renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                    }
                    if (appearanceRetained != renderAtom.geometryAtom.source.appearance) {
                        if (appearanceRetained != null) {
                            appearanceRetained.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                        }
                        renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                    } else {
                        renderAtom.geometryAtom.source.otherAppearance = null;
                    }
                }
                renderAtom.app = appearanceRetained;
                EnvironmentSet environmentSet = renderAtom.envSet;
                renderAtom.renderMolecule.removeRenderAtom(renderAtom);
                this.reInsertAttributeBin(environmentSet, renderAtom);
            }
            ++n;
        }
    }

    void reEvaluateEnv(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, boolean bl, boolean bl2) {
        this.reEvaluateAllRenderAtoms(bl2);
        if (bl) {
            if (arrayList.size() > 0) {
                this.updateCanvasForDirtyLights(arrayList);
            }
            if (arrayList2.size() > 0) {
                this.updateCanvasForDirtyFog(arrayList2);
            }
            if (arrayList3.size() > 0) {
                this.updateCanvasForDirtyModelClip(arrayList3);
            }
        }
    }

    void reEvaluateFog(ArrayList arrayList, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.renderAtoms.size()) {
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
            if (renderAtom.inRenderBin) {
                FogRetained fogRetained = this.universe.renderingEnvironmentStructure.getInfluencingFog(renderAtom);
                if (bl2 && renderAtom.geometryAtom.source.appearanceOverrideEnable) {
                    Object[] objectArray = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom);
                    AppearanceRetained appearanceRetained = objectArray[0] == Boolean.TRUE ? (AppearanceRetained)objectArray[1] : renderAtom.geometryAtom.source.appearance;
                    if (appearanceRetained == renderAtom.app) {
                        if (renderAtom.envSet.fog != fogRetained) {
                            this.getNewEnvironment(renderAtom, renderAtom.lights, fogRetained, renderAtom.modelClip, renderAtom.app);
                        }
                    } else if (renderAtom.envSet.fog == fogRetained) {
                        renderAtom.app = appearanceRetained;
                        this.reInsertAttributeBin(renderAtom.envSet, renderAtom);
                    } else {
                        if (renderAtom.geometryAtom.source.otherAppearance != appearanceRetained) {
                            if (renderAtom.geometryAtom.source.otherAppearance != null) {
                                renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                            }
                            if (appearanceRetained != renderAtom.geometryAtom.source.appearance) {
                                if (appearanceRetained != null) {
                                    appearanceRetained.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                                }
                                renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                            } else {
                                renderAtom.geometryAtom.source.otherAppearance = null;
                            }
                        }
                        this.getNewEnvironment(renderAtom, renderAtom.lights, fogRetained, renderAtom.modelClip, appearanceRetained);
                    }
                } else if (renderAtom.envSet.fog != fogRetained) {
                    this.getNewEnvironment(renderAtom, renderAtom.lights, fogRetained, renderAtom.modelClip, renderAtom.app);
                }
            }
            ++n;
        }
        if (bl) {
            this.updateCanvasForDirtyFog(arrayList);
        }
    }

    void reEvaluateLights(ArrayList arrayList, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.renderAtoms.size()) {
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
            if (renderAtom.inRenderBin) {
                LightRetained[] lightRetainedArray = this.universe.renderingEnvironmentStructure.getInfluencingLights(renderAtom);
                if (bl2 && renderAtom.geometryAtom.source.appearanceOverrideEnable) {
                    Object[] objectArray = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom);
                    AppearanceRetained appearanceRetained = objectArray[0] == Boolean.TRUE ? (AppearanceRetained)objectArray[1] : renderAtom.geometryAtom.source.appearance;
                    if (appearanceRetained == renderAtom.app) {
                        if (renderAtom.lights != lightRetainedArray && !renderAtom.envSet.equalLights(lightRetainedArray)) {
                            this.getNewEnvironment(renderAtom, lightRetainedArray, renderAtom.fog, renderAtom.modelClip, renderAtom.app);
                        }
                    } else if (renderAtom.lights == lightRetainedArray || renderAtom.envSet.equalLights(lightRetainedArray)) {
                        renderAtom.app = appearanceRetained;
                        this.reInsertAttributeBin(renderAtom.envSet, renderAtom);
                    } else {
                        if (renderAtom.geometryAtom.source.otherAppearance != appearanceRetained) {
                            if (renderAtom.geometryAtom.source.otherAppearance != null) {
                                renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                            }
                            if (appearanceRetained != renderAtom.geometryAtom.source.appearance) {
                                if (appearanceRetained != null) {
                                    appearanceRetained.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                                }
                                renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                            } else {
                                renderAtom.geometryAtom.source.otherAppearance = null;
                            }
                        }
                        this.getNewEnvironment(renderAtom, lightRetainedArray, renderAtom.fog, renderAtom.modelClip, appearanceRetained);
                    }
                } else if (renderAtom.lights != lightRetainedArray && !renderAtom.envSet.equalLights(lightRetainedArray)) {
                    this.getNewEnvironment(renderAtom, lightRetainedArray, renderAtom.fog, renderAtom.modelClip, renderAtom.app);
                }
            }
            ++n;
        }
        if (bl) {
            this.updateCanvasForDirtyLights(arrayList);
        }
    }

    void reEvaluateModelClip(ArrayList arrayList, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.renderAtoms.size()) {
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.get(n);
            if (renderAtom.inRenderBin) {
                ModelClipRetained modelClipRetained = this.universe.renderingEnvironmentStructure.getInfluencingModelClip(renderAtom);
                if (bl2 && renderAtom.geometryAtom.source.appearanceOverrideEnable) {
                    Object[] objectArray = this.universe.renderingEnvironmentStructure.getInfluencingAppearance(renderAtom);
                    AppearanceRetained appearanceRetained = objectArray[0] == Boolean.TRUE ? (AppearanceRetained)objectArray[1] : renderAtom.geometryAtom.source.appearance;
                    if (appearanceRetained == renderAtom.app) {
                        if (renderAtom.envSet.modelClip != modelClipRetained) {
                            this.getNewEnvironment(renderAtom, renderAtom.lights, renderAtom.fog, renderAtom.envSet.modelClip, renderAtom.app);
                        }
                    } else if (renderAtom.envSet.modelClip == modelClipRetained) {
                        renderAtom.app = appearanceRetained;
                        this.reInsertAttributeBin(renderAtom.envSet, renderAtom);
                    } else {
                        if (renderAtom.geometryAtom.source.otherAppearance != appearanceRetained) {
                            if (renderAtom.geometryAtom.source.otherAppearance != null) {
                                renderAtom.geometryAtom.source.otherAppearance.sgApp.removeAMirrorUser(renderAtom.geometryAtom.source);
                            }
                            if (appearanceRetained != renderAtom.geometryAtom.source.appearance) {
                                if (appearanceRetained != null) {
                                    appearanceRetained.sgApp.addAMirrorUser(renderAtom.geometryAtom.source);
                                }
                                renderAtom.geometryAtom.source.otherAppearance = appearanceRetained;
                            } else {
                                renderAtom.geometryAtom.source.otherAppearance = null;
                            }
                        }
                        this.getNewEnvironment(renderAtom, renderAtom.lights, renderAtom.fog, modelClipRetained, appearanceRetained);
                    }
                } else if (renderAtom.envSet.modelClip != modelClipRetained) {
                    this.getNewEnvironment(renderAtom, renderAtom.lights, renderAtom.fog, modelClipRetained, renderAtom.app);
                }
            }
            ++n;
        }
        if (bl) {
            this.updateCanvasForDirtyModelClip(arrayList);
        }
    }

    void reInsertAttributeBin(EnvironmentSet environmentSet, RenderAtom renderAtom) {
        AttributeBin attributeBin = this.findAttributeBin(environmentSet, renderAtom);
        this.reInsertTextureBin(attributeBin, renderAtom);
    }

    void reInsertRenderAtom(TextureBin textureBin, RenderAtom renderAtom) {
        RenderMolecule renderMolecule = this.findRenderMolecule(textureBin, renderAtom);
        renderAtom.setRenderBin(true);
    }

    void reInsertTextureBin(AttributeBin attributeBin, RenderAtom renderAtom) {
        TextureBin textureBin = this.findTextureBin(attributeBin, renderAtom);
        this.reInsertRenderAtom(textureBin, renderAtom);
    }

    void releaseGeometry() {
        GeometryRetained geometryRetained;
        int n = 0;
        while (n < this.lockGeometryList.size()) {
            geometryRetained = (GeometryRetained)this.lockGeometryList.get(n);
            geometryRetained.geomLock.unLock();
            ++n;
        }
        n = 0;
        while (n < this.dlistLockList.size()) {
            geometryRetained = (GeometryRetained)this.dlistLockList.get(n);
            geometryRetained.geomLock.unLock();
            ++n;
        }
        this.dlistLockList.clear();
        n = 0;
        while (n < this.nodeComponentList.size()) {
            ImageComponentRetained imageComponentRetained = (ImageComponentRetained)this.nodeComponentList.get(n);
            imageComponentRetained.geomLock.unLock();
            ++n;
        }
    }

    void removeAllRenderAtoms() {
        int n = 0;
        while (n < this.renderAtoms.size()) {
            RenderAtom renderAtom = (RenderAtom)this.renderAtoms.remove(0);
            RenderMolecule renderMolecule = renderAtom.renderMolecule;
            renderAtom.renderMolecule.removeRenderAtom(renderAtom);
            renderAtom.setRenderBin(false);
            if (renderAtom.isOriented) {
                this.orientedRAs.remove(this.orientedRAs.indexOf(renderAtom));
                if (renderAtom.inDirtyOrientedRAs) {
                    this.dirtyOrientedRAs.remove(this.dirtyOrientedRAs.indexOf(renderAtom));
                }
            }
            renderMolecule.updateRemoveRenderAtoms();
            ++n;
        }
        this.clearAllUpdateObjectState();
        ArrayList arrayList = this.messageList;
        synchronized (arrayList) {
            int n2 = this.messageList.size();
            n = 0;
            while (n < n2) {
                J3dMessage j3dMessage = (J3dMessage)this.messageList.remove(0);
                j3dMessage.decRefcount();
                ++n;
            }
        }
    }

    void removeDirtyReferenceGeometry(Object object) {
        ((AbstractCollection)this.dirtyReferenceGeomList).remove(object);
    }

    void removeDirtyRenderMolecule(RenderMolecule renderMolecule) {
        if (this.dirtyRenderMoleculeList.contains(renderMolecule)) {
            this.dirtyRenderMoleculeList.remove(this.dirtyRenderMoleculeList.indexOf(renderMolecule));
        }
    }

    void removeGeometryFromLockList(Object object) {
        ((AbstractCollection)this.lockGeometryList).remove(object);
    }

    void removeLightBin(LightBin lightBin) {
        if (lightBin.prev == null) {
            if (lightBin.orderedBin != null) {
                this.removeOrderedHeadLightBin(lightBin);
            }
            if (this.opaqueBin == lightBin) {
                this.opaqueBin = lightBin.next;
            }
            if (this.transparentBin == lightBin) {
                this.transparentBin = lightBin.next;
            }
            if (lightBin.next != null) {
                lightBin.next.prev = null;
            }
        } else {
            lightBin.prev.next = lightBin.next;
            if (lightBin.next != null) {
                lightBin.next.prev = lightBin.prev;
            }
        }
        Canvas3D[] canvas3DArray = this.view.getCanvases();
        int n = 0;
        while (n < canvas3DArray.length) {
            canvas3DArray[n].lightBin = null;
            ++n;
        }
        this.lightBinFreelist.add(lightBin);
        lightBin.prev = null;
        lightBin.next = null;
    }

    void removeNodeComponent(Object object) {
        this.removeNodeComponentList.add(object);
    }

    void removeOrderedHeadLightBin(LightBin lightBin) {
        int n = lightBin.orderedChildId;
        OrderedBin orderedBin = lightBin.orderedBin;
        ArrayList arrayList = orderedBin.orderedCollections;
        int n2 = orderedBin.source.orderedChildIdTable[n];
        OrderedCollection orderedCollection = (OrderedCollection)arrayList.get(n2);
        orderedCollection.lightBin = lightBin.next;
        if (orderedCollection.lightBin == null) {
            while (orderedCollection.lightBin == null && orderedCollection.childOrderedBins.isEmpty()) {
                arrayList.set(n2, null);
                orderedBin.source.orderedChildIdTable[n] = -1;
                orderedBin.source.freeOrderedChildId(n);
                int n3 = 0;
                while (n3 < orderedBin.source.orderedChildIdTable.length) {
                    if (orderedBin.source.orderedChildIdTable[n3] != -1) break;
                    ++n3;
                }
                if (n3 != orderedBin.source.orderedChildIdTable.length) break;
                ((AbstractCollection)orderedBin.parentChildOrderedBins).remove(orderedBin);
                if (orderedBin.removeFromOC.size() > 0) {
                    this.removeOGsList.remove(this.removeOGsList.indexOf(orderedBin));
                }
                orderedBin.source.orderedBin = null;
                orderedBin.source = null;
                OrderedBin orderedBin2 = orderedBin;
                n = orderedBin2.parentOrderedChildId;
                orderedBin = orderedBin2.parentOrderedBin;
                orderedBin2.parentOrderedBin = null;
                if (orderedBin == null) break;
                arrayList = orderedBin.orderedCollections;
                orderedCollection = (OrderedCollection)arrayList.get(n);
                n2 = orderedBin.source.orderedChildIdTable[n];
            }
        }
    }

    void removeRenderMolecule(RenderMolecule renderMolecule) {
        this.renderMoleculeFreelist.add(renderMolecule);
        if (renderMolecule.primaryMoleculeType == RenderMolecule.DLIST_MOLECULE) {
            ((AbstractCollection)this.renderMoleculeList).remove(renderMolecule);
        }
    }

    void removeTextureBin(TextureBin textureBin) {
        ((AbstractCollection)this.textureBinList).remove(textureBin);
    }

    void renderBackground(Canvas3D canvas3D) {
        canvas3D.setDepthBufferWriteEnable(canvas3D.ctx, false);
        canvas3D.setDepthBufferEnableOverride(true);
        LightBin lightBin = this.bgOpaqueBin;
        while (lightBin != null) {
            if (lightBin.geometryBackground == this.geometryBackground) {
                lightBin.render(canvas3D);
            }
            lightBin = lightBin.next;
        }
        if (this.bgOrderedBins.size() > 0) {
            this.renderOrderedBins(canvas3D, this.bgOrderedBins, true);
        }
        lightBin = this.bgTransparentBin;
        while (lightBin != null) {
            if (lightBin.geometryBackground == this.geometryBackground) {
                lightBin.render(canvas3D);
            }
            lightBin = lightBin.next;
        }
        canvas3D.setDepthBufferEnableOverride(false);
        canvas3D.setDepthBufferWriteEnable(canvas3D.ctx, true);
    }

    void renderOpaque(Canvas3D canvas3D) {
        LightBin lightBin = this.opaqueBin;
        while (lightBin != null) {
            lightBin.render(canvas3D);
            lightBin = lightBin.next;
        }
    }

    void renderOrdered(Canvas3D canvas3D) {
        if (this.orderedBins.size() > 0) {
            this.renderOrderedBins(canvas3D, this.orderedBins, false);
        }
    }

    void renderOrderedBin(Canvas3D canvas3D, OrderedBin orderedBin, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = orderedBin.source instanceof DecalGroupRetained;
        int n = 0;
        while (n < orderedBin.orderedCollections.size()) {
            OrderedCollection orderedCollection = (OrderedCollection)orderedBin.orderedCollections.get(n);
            if (bl3) {
                if (n == 0) {
                    canvas3D.setDepthBufferEnableOverride(true);
                    bl2 = canvas3D.decal1stChildSetup(canvas3D.ctx);
                } else if (n == 1) {
                    canvas3D.decalNthChildSetup(canvas3D.ctx);
                }
            }
            if (orderedCollection != null) {
                LightBin lightBin = orderedCollection.lightBin;
                while (lightBin != null) {
                    if (!bl || lightBin.geometryBackground == this.geometryBackground) {
                        lightBin.render(canvas3D);
                    }
                    lightBin = lightBin.next;
                }
                this.renderOrderedBins(canvas3D, orderedCollection.childOrderedBins, bl);
            }
            ++n;
        }
        if (bl3) {
            canvas3D.decalReset(canvas3D.ctx, bl2);
            canvas3D.setDepthBufferEnableOverride(false);
        }
    }

    void renderOrderedBins(Canvas3D canvas3D, ArrayList arrayList, boolean bl) {
        int n = 0;
        while (n < arrayList.size()) {
            OrderedBin orderedBin = (OrderedBin)arrayList.get(n);
            this.renderOrderedBin(canvas3D, orderedBin, bl);
            ++n;
        }
    }

    void renderTransparent(Canvas3D canvas3D) {
        LightBin lightBin = this.transparentBin;
        if (canvas3D.view.depthBufferFreezeTransparent) {
            canvas3D.setDepthBufferWriteEnableOverride(true);
        }
        while (lightBin != null) {
            lightBin.render(canvas3D);
            lightBin = lightBin.next;
        }
        canvas3D.setDepthBufferWriteEnableOverride(false);
    }

    void setBackground(BackgroundRetained backgroundRetained) {
        this.geometryBackground = null;
        if (backgroundRetained != null) {
            this.background.initColor(backgroundRetained.color);
            this.background.geometryBranch = backgroundRetained.geometryBranch;
            if (this.background.geometryBranch != null) {
                this.geometryBackground = backgroundRetained;
            }
            if (this.background.image != null && this.background.image.isByReference()) {
                this.removeNodeComponent(this.background.image);
            }
            if (backgroundRetained.image != null) {
                this.background.initImage((ImageComponent2D)backgroundRetained.image.source);
                if (backgroundRetained.image.isByReference()) {
                    this.addNodeComponent(backgroundRetained.image);
                }
            } else {
                this.background.initImage(null);
            }
        } else {
            this.background.initColor(this.black);
            this.background.geometryBranch = null;
            this.background.initImage(null);
        }
    }

    void setFrameCountCutoff(int n) {
        this.frameCountCutoff = n;
    }

    void updateAllRenderMolecule(Canvas3D canvas3D) {
        this.updateDirtyRenderMolecule(canvas3D, this.renderMoleculeList, false);
    }

    void updateCanvasForDirtyFog(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            FogRetained fogRetained = (FogRetained)arrayList.get(n);
            int n2 = 0;
            while (n2 < fogRetained.environmentSets.size()) {
                EnvironmentSet environmentSet = (EnvironmentSet)fogRetained.environmentSets.get(n2);
                environmentSet.canvasDirty |= 0x2000;
                if (!environmentSet.onUpdateList) {
                    this.objUpdateList.add(environmentSet);
                    environmentSet.onUpdateList = true;
                }
                ++n2;
            }
            ++n;
        }
    }

    void updateCanvasForDirtyLights(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            EnvironmentSet environmentSet;
            int n2;
            LightRetained lightRetained = (LightRetained)arrayList.get(n);
            if (lightRetained.nodeType == 5) {
                n2 = 0;
                while (n2 < lightRetained.environmentSets.size()) {
                    environmentSet = (EnvironmentSet)lightRetained.environmentSets.get(n2);
                    environmentSet.canvasDirty |= 0x100;
                    if (!environmentSet.onUpdateList) {
                        this.objUpdateList.add(environmentSet);
                        environmentSet.onUpdateList = true;
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < lightRetained.environmentSets.size()) {
                    environmentSet = (EnvironmentSet)lightRetained.environmentSets.get(n2);
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < environmentSet.lights.size()) {
                        LightRetained lightRetained2 = (LightRetained)environmentSet.lights.get(n4);
                        if (lightRetained == lightRetained2) {
                            n3 = 1 << environmentSet.ltPos[n4];
                            if (lightRetained2.lightOn) {
                                environmentSet.enableMaskCache |= (long)(1 << environmentSet.ltPos[n4]);
                                break;
                            }
                            environmentSet.enableMaskCache &= (long)(1 << environmentSet.ltPos[n4]);
                            break;
                        }
                        ++n4;
                    }
                    environmentSet.canvasDirty |= 0x80;
                    if (!environmentSet.onUpdateList) {
                        this.objUpdateList.add(environmentSet);
                        environmentSet.onUpdateList = true;
                    }
                    environmentSet.lightBin.canvasDirty |= 0x40;
                    environmentSet.lightBin.lightDirtyMaskCache |= n3;
                    if (!environmentSet.lightBin.onUpdateList) {
                        environmentSet.lightBin.onUpdateList = true;
                        this.objUpdateList.add(environmentSet.lightBin);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    void updateCanvasForDirtyModelClip(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            ModelClipRetained modelClipRetained = (ModelClipRetained)arrayList.get(n);
            int n2 = 0;
            while (n2 < modelClipRetained.environmentSets.size()) {
                EnvironmentSet environmentSet = (EnvironmentSet)modelClipRetained.environmentSets.get(n2);
                environmentSet.canvasDirty |= 0x4000;
                if (!environmentSet.onUpdateList) {
                    this.objUpdateList.add(environmentSet);
                    environmentSet.onUpdateList = true;
                }
                ++n2;
            }
            ++n;
        }
    }

    void updateCanvasResource(Canvas3D[] canvas3DArray) {
        int n = 0;
        while (n < canvas3DArray.length) {
            Canvas3D canvas3D = canvas3DArray[n];
            int n2 = 0;
            while (n2 < this.dirtyRenderMoleculeList.size()) {
                RenderMolecule renderMolecule = (RenderMolecule)this.dirtyRenderMoleculeList.get(n2);
                canvas3D.dirtyRenderMoleculeList.add(renderMolecule);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.toBeAddedTextureResourceFreeList.size()) {
                TextureRetained textureRetained = (TextureRetained)this.toBeAddedTextureResourceFreeList.get(n2);
                Integer n3 = new Integer(textureRetained.objectId);
                if ((textureRetained.resourceCreationMask & canvas3D.canvasBit) != 0) {
                    canvas3D.textureIdResourceFreeList.add(n3);
                    textureRetained.resourceCreationMask &= ~canvas3D.canvasBit;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.displayListResourceFreeList.size()) {
                canvas3D.displayListResourceFreeList.add(this.displayListResourceFreeList.get(n2));
                ++n2;
            }
            ++n;
        }
    }

    void updateDirtyRenderMolecule(Canvas3D canvas3D, ArrayList arrayList, boolean bl) {
        int n = 0;
        while (n < arrayList.size()) {
            RenderMolecule renderMolecule = (RenderMolecule)arrayList.get(n);
            renderMolecule.updateDisplayList(canvas3D, bl);
            ++n;
        }
    }

    void updateInfVworldToVpc() {
        this.vworldToVpc.getRotation(this.infVworldToVpc);
    }

    public void updateObject() {
        NodeComponentRetained nodeComponentRetained;
        RenderAtom renderAtom;
        Canvas3D[] canvas3DArray;
        int n;
        Canvas3D[] canvas3DArray2;
        Object object;
        RenderMolecule renderMolecule;
        OrderedBin orderedBin;
        int n2;
        if (this.addOGsList.size() > 0) {
            n2 = 0;
            while (n2 < this.addOGsList.size()) {
                orderedBin = (OrderedBin)this.addOGsList.get(n2);
                orderedBin.updateAddOrderedGroups();
                ++n2;
            }
        }
        if (this.removeRenderAtomInRMList.size() > 0) {
            n2 = 0;
            while (n2 < this.removeRenderAtomInRMList.size()) {
                renderMolecule = (RenderMolecule)this.removeRenderAtomInRMList.get(n2);
                renderMolecule.updateRemoveRenderAtoms();
                ++n2;
            }
        }
        if (this.addOpaqueBin != null) {
            if (this.opaqueBin != null) {
                this.addOpaqueBin.prev = this.opaqueBin;
                this.opaqueBin.next = this.addOpaqueBin;
            } else {
                this.opaqueBin = this.addOpaqueBin;
                this.addOpaqueBin = null;
            }
        }
        if (this.addTransparentBin != null) {
            if (this.transparentBin != null) {
                this.addTransparentBin.prev = this.transparentBin;
                this.transparentBin.next = this.addTransparentBin;
            } else {
                this.transparentBin = this.addTransparentBin;
                this.addTransparentBin = null;
            }
        }
        if (this.bgAddOpaqueBin != null) {
            if (this.bgOpaqueBin != null) {
                this.bgAddOpaqueBin.prev = this.bgOpaqueBin;
                this.bgOpaqueBin.next = this.bgAddOpaqueBin;
            } else {
                this.bgOpaqueBin = this.bgAddOpaqueBin;
                this.bgAddOpaqueBin = null;
            }
        }
        if (this.bgAddTransparentBin != null) {
            if (this.bgTransparentBin != null) {
                this.bgAddTransparentBin.prev = this.bgTransparentBin;
                this.bgTransparentBin.next = this.bgAddTransparentBin;
            } else {
                this.bgTransparentBin = this.bgAddTransparentBin;
                this.bgAddTransparentBin = null;
            }
        }
        if (this.orderedBinsList.size() > 0) {
            n2 = 0;
            while (n2 < this.orderedBinsList.size()) {
                object = (Canvas3D[][])this.orderedBinsList.get(n2);
                canvas3DArray2 = (ArrayList)this.toBeAddedBinList.get(n2);
                n = 0;
                while (n < canvas3DArray2.size()) {
                    ((ArrayList)object).add(canvas3DArray2.get(n));
                    ++n;
                }
                ++n2;
            }
        }
        if (this.objUpdateList.size() > 0) {
            n2 = 0;
            while (n2 < this.objUpdateList.size()) {
                ObjectUpdate objectUpdate = (ObjectUpdate)this.objUpdateList.get(n2);
                objectUpdate.updateObject();
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.removeOGsList.size()) {
            orderedBin = (OrderedBin)this.removeOGsList.get(n2);
            orderedBin.updateRemoveOrderedGroups();
            ++n2;
        }
        if (this.dirtyRenderMoleculeList.size() > 0 || this.displayListResourceFreeList.size() > 0 || this.toBeAddedTextureResourceFreeList.size() > 0) {
            object = this.view.getCanvasList(false);
            n2 = 0;
            while (n2 < ((Canvas3D[][])object).length) {
                canvas3DArray2 = object[n2][0];
                if (canvas3DArray2.useSharedCtx) {
                    this.updateRendererResource(canvas3DArray2.screen.renderer);
                } else {
                    this.updateCanvasResource(object[n2]);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.displayListResourceFreeList.size()) {
                canvas3DArray = (Integer)this.displayListResourceFreeList.get(n2);
                VirtualUniverse.mc.freeDisplayListId((Integer)canvas3DArray);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.toBeAddedTextureResourceFreeList.size()) {
                TextureRetained textureRetained = (TextureRetained)this.toBeAddedTextureResourceFreeList.get(n2);
                if (textureRetained.objectId != -1) {
                    VirtualUniverse.mc.freeTextureId(textureRetained.objectId);
                    textureRetained.objectId = -1;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.dirtyRenderMoleculeList.size()) {
                renderMolecule = (RenderMolecule)this.dirtyRenderMoleculeList.get(n2);
                renderAtom = renderMolecule.primaryRenderAtomList;
                while (renderAtom != null) {
                    this.dlistLockList.add(renderAtom.geometryAtom.geometry);
                    renderAtom = renderAtom.next;
                }
                ++n2;
            }
        }
        if (this.dirtyIndexedRenderAtom.size() > 0) {
            n2 = 0;
            while (n2 < this.dirtyIndexedRenderAtom.size()) {
                renderAtom = (RenderAtom)this.dirtyIndexedRenderAtom.get(n2);
                object = (GeometryArrayRetained)renderAtom.geometryAtom.geometry;
                ((GeometryRetained)object).geomLock.getLock();
                ((GeometryRetained)object).mirrorGeometry = (GeometryRetained)((IndexedGeometryArrayRetained)object).cloneNonIndexedGeometry();
                ((GeometryRetained)object).geomLock.unLock();
                ++n2;
            }
        }
        if (this.dirtyReferenceGeomList.size() > 0) {
            n2 = 0;
            while (n2 < this.dirtyReferenceGeomList.size()) {
                object = (GeometryArrayRetained)this.dirtyReferenceGeomList.get(n2);
                canvas3DArray2 = this.view.getCanvases();
                ((GeometryRetained)object).geomLock.getLock();
                n = 0;
                boolean bl = false;
                while (n < canvas3DArray2.length && !bl) {
                    if ((canvas3DArray2[n].extensionsSupported & 1) == 0) {
                        if ((((GeometryArrayRetained)object).vertexFormat & 0x100) != 0) {
                            ((GeometryArrayRetained)object).setupMirrorInterleavedColorPointer(true);
                            bl = true;
                        } else {
                            ((GeometryArrayRetained)object).setupMirrorColorPointer(((GeometryArrayRetained)object).vertexType & 0x3F0, true);
                            bl = true;
                        }
                    }
                    ++n;
                }
                ((GeometryRetained)object).geomLock.unLock();
                ++n2;
            }
        }
        if (this.reEvaluateBg) {
            this.setBackground(this.currentActiveBackground);
        }
        int n3 = 0;
        while (n3 < this.textureBinList.size()) {
            int n4 = 0;
            canvas3DArray = (TextureBin)this.textureBinList.get(n3);
            canvas3DArray.inTextureBinList = false;
            n2 = 0;
            while (n2 < canvas3DArray.texUnitState.length) {
                if (canvas3DArray.texUnitState[n2] != null && canvas3DArray.texUnitState[n2].texture != null && canvas3DArray.texUnitState[n2].texture instanceof Texture2DRetained) {
                    nodeComponentRetained = (Texture2DRetained)canvas3DArray.texUnitState[n2].texture;
                    n = 0;
                    while (n < ((TextureRetained)nodeComponentRetained).numLevels) {
                        if (canvas3DArray.images[n4] != ((TextureRetained)nodeComponentRetained).images[n]) {
                            if (canvas3DArray.images[n4] != null && canvas3DArray.images[n4].isByReference()) {
                                this.removeNodeComponent(canvas3DArray.images[n4]);
                            }
                            if (((TextureRetained)nodeComponentRetained).images[n].isByReference()) {
                                this.addNodeComponent(((TextureRetained)nodeComponentRetained).images[n]);
                            }
                            canvas3DArray.images[n4] = ((TextureRetained)nodeComponentRetained).images[n];
                        }
                        ++n;
                        ++n4;
                    }
                }
                ++n2;
            }
            ++n3;
        }
        if (this.newNodeComponentList.size() > 0) {
            n2 = 0;
            while (n2 < this.newNodeComponentList.size()) {
                Canvas3D[] canvas3DArray3 = this.view.getCanvases();
                canvas3DArray = (ImageComponentRetained)this.newNodeComponentList.get(n2);
                canvas3DArray.geomLock.getLock();
                n = 0;
                while (n < canvas3DArray3.length) {
                    if (canvas3DArray3[n].ctx != 0) {
                        canvas3DArray.evaluateExtensions(canvas3DArray3[n].extensionsSupported);
                    }
                    ++n;
                }
                canvas3DArray.geomLock.unLock();
                this.nodeComponentList.add(canvas3DArray);
                ++n2;
            }
        }
        if (this.removeNodeComponentList.size() > 0) {
            n2 = 0;
            while (n2 < this.removeNodeComponentList.size()) {
                ((AbstractCollection)this.nodeComponentList).remove(this.removeNodeComponentList.get(n2));
                ++n2;
            }
        }
        if (this.reEvaluateClip) {
            this.backClipActive = this.universe.renderingEnvironmentStructure.isBackClipActive(this.vpSchedSphereInVworld);
            if (this.backClipActive) {
                this.backClipDistanceInVworld = this.universe.renderingEnvironmentStructure.backClipDistanceInVworld();
            }
            this.view.vDirtyMask |= 0x20;
        }
        if (this.vpcToVworldDirty) {
            this.vworldToVpc.invert(this.vpcToVworld);
            Canvas3D[] canvas3DArray4 = this.view.getCanvases();
            n2 = 0;
            while (n2 < canvas3DArray4.length) {
                canvas3DArray4[n2].lightBin = null;
                ++n2;
            }
        }
        boolean bl = this.multiScreen = this.view.getScreens().length > 1;
        if (this.offScreenMessage.size() > 0) {
            canvas3DArray = this.view.getCanvases();
            n2 = this.offScreenMessage.size() - 1;
            while (n2 >= 0) {
                J3dMessage j3dMessage = (J3dMessage)this.offScreenMessage.get(n2);
                j3dMessage.threads = 16;
                ((Canvas3D)j3dMessage.args[0]).screen.renderer.rendererStructure.addMessage(j3dMessage);
                nodeComponentRetained = (ImageComponent2DRetained)((ImageComponent2D)j3dMessage.args[1]).retained;
                if (((ImageComponentRetained)nodeComponentRetained).isByReference()) {
                    ((ImageComponentRetained)nodeComponentRetained).geomLock.getLock();
                    n = 0;
                    while (n < canvas3DArray.length) {
                        ((ImageComponent2DRetained)nodeComponentRetained).evaluateExtensions(canvas3DArray[n].extensionsSupported);
                        ++n;
                    }
                    ((ImageComponentRetained)nodeComponentRetained).geomLock.unLock();
                    this.nodeComponentList.add(nodeComponentRetained);
                }
                j3dMessage.decRefcount();
                --n2;
            }
        }
        this.clearAllUpdateObjectState();
    }

    void updateOrientedRAs() {
        Canvas3D canvas3D = this.view.getCanvas3D(0);
        if (this.view.viewCache.vcDirtyMask != 0) {
            OrientedShape3DRetained orientedShape3DRetained;
            RenderAtom renderAtom;
            int n = this.orientedRAs.size();
            int n2 = 0;
            while (n2 < n) {
                renderAtom = (RenderAtom)this.orientedRAs.get(n2);
                orientedShape3DRetained = (OrientedShape3DRetained)renderAtom.geometryAtom.source;
                orientedShape3DRetained.orientedTransformDirty = true;
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                renderAtom = (RenderAtom)this.orientedRAs.get(n2);
                orientedShape3DRetained = (OrientedShape3DRetained)renderAtom.geometryAtom.source;
                if (orientedShape3DRetained.orientedTransformDirty) {
                    orientedShape3DRetained.updateOrientedTransform(canvas3D);
                    orientedShape3DRetained.orientedTransformDirty = false;
                }
                renderAtom.updateOrientedTransform();
                ++n2;
            }
        } else {
            OrientedShape3DRetained orientedShape3DRetained;
            RenderAtom renderAtom;
            int n = this.dirtyOrientedRAs.size();
            int n3 = 0;
            while (n3 < n) {
                renderAtom = (RenderAtom)this.dirtyOrientedRAs.get(n3);
                orientedShape3DRetained = (OrientedShape3DRetained)renderAtom.geometryAtom.source;
                orientedShape3DRetained.orientedTransformDirty = true;
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                renderAtom = (RenderAtom)this.dirtyOrientedRAs.get(n3);
                orientedShape3DRetained = (OrientedShape3DRetained)renderAtom.geometryAtom.source;
                if (orientedShape3DRetained.orientedTransformDirty) {
                    orientedShape3DRetained.updateOrientedTransform(canvas3D);
                    orientedShape3DRetained.orientedTransformDirty = false;
                }
                renderAtom.updateOrientedTransform();
                renderAtom.inDirtyOrientedRAs = false;
                ++n3;
            }
            this.dirtyOrientedRAs.clear();
        }
    }

    void updateRendererResource(Renderer renderer) {
        if (renderer == null) {
            return;
        }
        int n = 0;
        while (n < this.dirtyRenderMoleculeList.size()) {
            RenderMolecule renderMolecule = (RenderMolecule)this.dirtyRenderMoleculeList.get(n);
            renderer.dirtyRenderMoleculeList.add(renderMolecule);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.toBeAddedTextureResourceFreeList.size()) {
            TextureRetained textureRetained = (TextureRetained)this.toBeAddedTextureResourceFreeList.get(n2);
            Integer n3 = new Integer(textureRetained.objectId);
            if ((textureRetained.resourceCreationMask & renderer.rendererBit) != 0 && !renderer.textureIdResourceFreeList.contains(n3)) {
                renderer.textureIdResourceFreeList.add(n3);
                textureRetained.resourceCreationMask &= ~renderer.rendererBit;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.displayListResourceFreeList.size()) {
            renderer.displayListResourceFreeList.add(this.displayListResourceFreeList.get(n4));
            ++n4;
        }
    }

    void updateViewPlatform(ViewPlatformRetained viewPlatformRetained, float f) {
        Object var3_3 = null;
        if ((ViewPlatformRetained)this.view.viewPlatform.retained == viewPlatformRetained) {
            this.vpcToVworld = viewPlatformRetained.getCurrentLocalToVworld(null);
            this.vpcToVworldDirty = true;
            ViewPlatformRetained viewPlatformRetained2 = viewPlatformRetained;
            synchronized (viewPlatformRetained2) {
                viewPlatformRetained.vprDirtyMask |= 0x20000;
            }
            this.vpSchedSphere.setRadius(f);
            this.vpSchedSphereInVworld.transform(this.vpSchedSphere, this.vpcToVworld);
            this.reEvaluateBg = true;
            this.reEvaluateClip = true;
        }
    }
}

