/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.ArrayList;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

class RasterRetained
extends GeometryRetained {
    int type = 1;
    Point3f position = new Point3f();
    int xOffset = 0;
    int yOffset = 0;
    int width = 0;
    int height = 0;
    ImageComponent2DRetained image = null;
    DepthComponentRetained depthComponent = null;

    RasterRetained() {
        this.geoType = 15;
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.image != null) {
            this.image.clearLive(n);
        }
        if (this.depthComponent != null) {
            this.depthComponent.clearLive(n);
        }
    }

    void computeBoundingBox() {
        Point3d point3d = new Point3d();
        point3d.x = this.position.x;
        point3d.y = this.position.y;
        point3d.z = this.position.z;
        this.geoBounds.setUpper(point3d);
        this.geoBounds.setLower(point3d);
    }

    native void execute(int var1, GeometryRetained var2, boolean var3, float var4, int var5, int var6, int var7, int var8, int var9, float var10, float var11, float var12);

    void execute(int n, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, boolean bl4, int n2) {
        if (this.type == 2 || this.image != null && this.image.imageYdownClass == 1) {
            if (this.image.imageYdown != null) {
                this.execute(n, this, bl2, f, this.type, this.width, this.height, this.xOffset, this.yOffset, this.position.x, this.position.y, this.position.z);
            }
        } else {
            if ((this.type & 1) != 0) {
                int n3 = this.image.tilew;
                int n4 = this.image.tileh;
                int n5 = this.width;
                int n6 = this.height;
                int n7 = this.xOffset;
                int n8 = this.yOffset;
                float f2 = this.position.x;
                float f3 = this.position.y;
                int n9 = 0;
                int n10 = 0;
                while (n7 > n3) {
                    ++n9;
                    n7 -= n3;
                }
                while (n8 > n4) {
                    ++n10;
                    n8 -= n4;
                }
                int n11 = this.image.minTileY + n10;
                int n12 = this.image.minTileX + n9;
                int n13 = 0;
                int n14 = n4 - n8;
                int n15 = n11;
                while (n15 < this.image.minTileY + this.image.numYTiles) {
                    int n16 = n3 - n7;
                    int n17 = 0;
                    n5 = this.width;
                    int n18 = n12;
                    while (n18 < this.image.minTileX + this.image.numXTiles) {
                        Raster raster = this.image.bImage[0].getTile(n18, n15);
                        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                        if (n5 < n16) {
                            n16 = n5;
                        }
                        this.executeTiled(n, this, this.image.storedFormat, n16, n14, n7, n8, n17, n13, this.position.x, this.position.y, this.position.z, byArray);
                        n7 = 0;
                        if ((n5 -= n16) == 0) break;
                        n17 += n16;
                        n16 = n3;
                        ++n18;
                    }
                    n8 = 0;
                    if ((n6 -= n14) == 0) break;
                    n13 += n14;
                    n14 = n4;
                    if (n6 < n14) {
                        n14 = n6;
                    }
                    n7 = this.xOffset;
                    ++n15;
                }
            }
            if ((this.type & 2) != 0) {
                this.execute(n, this, bl2, f, 2, this.width, this.height, this.xOffset, this.yOffset, this.position.x, this.position.y, this.position.z);
            }
        }
    }

    native void executeTiled(int var1, GeometryRetained var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, float var10, float var11, float var12, byte[] var13);

    final DepthComponent getDepthComponent() {
        return this.depthComponent == null ? null : (DepthComponent)this.depthComponent.source;
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    final void getOffset(Point point) {
        point.setLocation(this.xOffset, this.yOffset);
    }

    final void getPosition(Point3f point3f) {
        point3f.x = this.position.x;
        point3f.y = this.position.y;
        point3f.z = this.position.z;
    }

    final void getSize(Dimension dimension) {
        dimension.setSize(this.width, this.height);
    }

    final int getType() {
        return this.type;
    }

    private void sendChangedMessage(int n, Object object, Object object2) {
        if (this.source.isLive()) {
            ArrayList arrayList = this.universeList;
            synchronized (arrayList) {
                int n2 = this.universeList.size();
                J3dMessage[] j3dMessageArray = new J3dMessage[n2];
                int n3 = 0;
                while (n3 < n2) {
                    j3dMessageArray[n3] = VirtualUniverse.mc.getMessage();
                    j3dMessageArray[n3].type = 17;
                    j3dMessageArray[n3].threads = n;
                    j3dMessageArray[n3].args[0] = Shape3DRetained.getGeomAtomsList((ArrayList)this.userLists.get(n3)).toArray();
                    j3dMessageArray[n3].args[1] = object;
                    j3dMessageArray[n3].args[2] = object2;
                    j3dMessageArray[n3].universe = (VirtualUniverse)this.universeList.get(n3);
                    ++n3;
                }
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
        }
    }

    final void setDepthComponent(DepthComponent depthComponent) {
        if (this.source.isLive()) {
            if (this.depthComponent != null) {
                this.depthComponent.clearLive(this.refCount);
            }
            if (depthComponent != null) {
                ((DepthComponentRetained)depthComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.geomLock.getLock();
        this.depthComponent = depthComponent == null ? null : (DepthComponentRetained)depthComponent.retained;
        this.geomLock.unLock();
    }

    final void setImage(ImageComponent2D imageComponent2D) {
        ImageComponent2DRetained imageComponent2DRetained = this.image;
        if (this.source.isLive()) {
            if (((ImageComponent2DRetained)imageComponent2D.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("RasterRetained0"));
            }
            if (this.image != null) {
                this.image.clearLive(this.refCount);
            }
            if (imageComponent2D != null) {
                ((ImageComponent2DRetained)imageComponent2D.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.geomLock.getLock();
        if (imageComponent2D != null) {
            ImageComponent2DRetained imageComponent2DRetained2 = (ImageComponent2DRetained)imageComponent2D.retained;
            imageComponent2DRetained2.setRasterRef();
            this.image = imageComponent2DRetained2;
            this.noAlpha = imageComponent2DRetained2.format == 1 || imageComponent2DRetained2.format == 5 || imageComponent2DRetained2.format == 9 || imageComponent2DRetained2.format == 3;
        } else {
            this.image = null;
        }
        this.geomLock.unLock();
        this.sendChangedMessage(128, imageComponent2DRetained, this.image);
    }

    void setLive(boolean bl, int n) {
        super.doSetLive(bl, n);
        if (this.image != null) {
            this.image.setLive(bl, n);
        }
        if (this.depthComponent != null) {
            this.depthComponent.setLive(bl, n);
        }
        this.isEditable = this.source.capabilities.get(3) || this.source.capabilities.get(1) || (this.type & 1) != 0 && this.source.capabilities.get(5) || (this.type & 2) != 0 && this.source.capabilities.get(7) || this.source.capabilities.get(9);
        super.markAsLive();
    }

    final void setOffset(int n, int n2) {
        this.geomLock.getLock();
        this.xOffset = n;
        this.yOffset = n2;
        this.geomLock.unLock();
    }

    final void setPosition(Point3f point3f) {
        this.geomLock.getLock();
        this.position.x = point3f.x;
        this.position.y = point3f.y;
        this.position.z = point3f.z;
        this.geomLock.unLock();
        this.sendChangedMessage(64, null, null);
    }

    final void setSize(int n, int n2) {
        this.geomLock.getLock();
        this.width = n;
        this.height = n2;
        this.geomLock.unLock();
    }

    final void setType(int n) {
        this.geomLock.getLock();
        this.type = n;
        this.geomLock.unLock();
    }

    void update() {
        Point3d point3d = new Point3d();
        point3d.x = this.position.x;
        point3d.y = this.position.y;
        point3d.z = this.position.z;
        this.geoBounds.setUpper(point3d);
        this.geoBounds.setLower(point3d);
    }
}

