/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.Distance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.PickCylinder;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class PickCylinderRay
extends PickCylinder {
    public PickCylinderRay() {
    }

    public PickCylinderRay(Point3d point3d, Vector3d vector3d, double d) {
        this.origin = new Point3d(point3d);
        this.direction = new Vector3d(vector3d);
        this.radius = d;
    }

    final boolean intersect(Bounds bounds, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        if (bounds instanceof BoundingSphere) {
            Point3d point3d = ((BoundingSphere)bounds).getCenter();
            double d = ((BoundingSphere)bounds).getRadius();
            double d2 = Distance.pointToRay((Point3d)point3d, (Point3d)this.origin, (Vector3d)this.direction);
            return d2 <= d * d + this.radius * this.radius;
        }
        if (bounds instanceof BoundingBox) {
            Point3d point3d = new Point3d();
            ((BoundingBox)bounds).getLower(point3d);
            Point3d point3d2 = ((BoundingBox)bounds).getCenter();
            double d = (point3d2.x - point3d.x) * (point3d2.x - point3d.x) + (point3d2.y - point3d.y) * (point3d2.y - point3d.y) + (point3d2.z - point3d.z) * (point3d2.z - point3d.z);
            double d3 = Distance.pointToRay((Point3d)point3d2, (Point3d)this.origin, (Vector3d)this.direction);
            if (d3 > d + this.radius * this.radius) {
                return false;
            }
            if (d3 < this.radius * this.radius) {
                return true;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            Point3d point3d3 = new Point3d();
            ((BoundingBox)bounds).getUpper(point3d3);
            Point3d[][] point3dArrayArray = new Point3d[][]{{point3d3, new Point3d(point3d.x, point3d3.y, point3d3.z)}, {new Point3d(point3d.x, point3d3.y, point3d3.z), new Point3d(point3d.x, point3d.y, point3d3.z)}, {new Point3d(point3d.x, point3d.y, point3d3.z), new Point3d(point3d3.x, point3d.y, point3d3.z)}, {new Point3d(point3d3.x, point3d.y, point3d3.z), point3d3}, {point3d, new Point3d(point3d.x, point3d3.y, point3d.z)}, {new Point3d(point3d.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d3.y, point3d.z)}, {new Point3d(point3d3.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d.y, point3d.z)}, {new Point3d(point3d3.x, point3d.y, point3d.z), point3d}, {point3d, new Point3d(point3d.x, point3d.y, point3d3.z)}, {new Point3d(point3d.x, point3d3.y, point3d.z), new Point3d(point3d.x, point3d3.y, point3d3.z)}, {new Point3d(point3d3.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d3.y, point3d3.z)}, {new Point3d(point3d3.x, point3d.y, point3d.z), new Point3d(point3d3.x, point3d.y, point3d3.z)}};
            int n = 0;
            while (n < point3dArrayArray.length) {
                double d4 = Distance.rayToSegment((Point3d)this.origin, (Vector3d)this.direction, (Point3d)point3dArrayArray[n][0], (Point3d)point3dArrayArray[n][1]);
                if (d4 <= this.radius * this.radius) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d point3d = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.getCenter(point3d);
            double d = boundingSphere.getRadius();
            double d5 = Distance.pointToRay((Point3d)point3d, (Point3d)this.origin, (Vector3d)this.direction);
            if (d5 > d * d + this.radius * this.radius) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            Point3d point3d4 = new Point3d();
            int n = 0;
            while (n < boundingPolytope.nVerts) {
                int n2 = n;
                while (n < boundingPolytope.nVerts) {
                    double d6;
                    point3d4.x = (boundingPolytope.verts[n].x + boundingPolytope.verts[n2].x) * 0.5;
                    point3d4.y = (boundingPolytope.verts[n].y + boundingPolytope.verts[n2].y) * 0.5;
                    point3d4.z = (boundingPolytope.verts[n].z + boundingPolytope.verts[n2].z) * 0.5;
                    if (PickCylinder.pointInPolytope(boundingPolytope, point3d4.x, point3d4.y, point3d4.z) && (d6 = Distance.rayToSegment((Point3d)this.origin, (Vector3d)this.direction, (Point3d)boundingPolytope.verts[n], (Point3d)boundingPolytope.verts[n2])) <= this.radius * this.radius) {
                        return true;
                    }
                    ++n;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public void set(Point3d point3d, Vector3d vector3d, double d) {
        this.origin.set((Tuple3d)point3d);
        this.direction.set((Tuple3d)vector3d);
        this.radius = d;
    }
}

