/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.VirtualUniverse;

class ImageComponent2DRetained
extends ImageComponentRetained {
    private int rasterRefCnt = 0;
    private int textureRefCnt = 0;
    long d3dSurface;
    long d3dTexSurface;

    ImageComponent2DRetained() {
    }

    void clearLive(int n) {
        super.clearLive();
        this.freeSurface();
    }

    final void copyImage(RenderedImage renderedImage, byte[] byArray) {
        int n = renderedImage.getNumXTiles();
        int n2 = renderedImage.getNumYTiles();
        int n3 = renderedImage.getTileWidth();
        int n4 = renderedImage.getTileHeight();
        int n5 = n3 * this.bytesPerPixelStored;
        int n6 = renderedImage.getMinTileX();
        int n7 = renderedImage.getMinTileY();
        int n8 = this.width * this.bytesPerPixelStored;
        int n9 = 0;
        int n10 = n4 * n3 * n * this.bytesPerPixelStored;
        int n11 = n7;
        while (n11 < n7 + n2) {
            int n12 = n9;
            int n13 = n6;
            while (n13 < n6 + n) {
                Raster raster = renderedImage.getTile(n13, n11);
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n14 = 0;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n4) {
                    System.arraycopy(byArray2, n14, byArray, n15, n5);
                    n14 += n5;
                    n15 += n8;
                    ++n16;
                }
                n12 += n5;
                ++n13;
            }
            n9 += n10;
            ++n11;
        }
    }

    final void evaluateExtensions(int n) {
        RenderedImage renderedImage = this.bImage[0];
        if (!this.imageYupCacheDirty && !this.imageYdownCacheDirty) {
            return;
        }
        int n2 = this.getImageType(renderedImage);
        if (this.usedByTexture || !this.usedByRaster) {
            if (!this.imageYupCacheDirty) {
                this.evaluateRaster(n2, n);
                return;
            }
            if (this.shouldImageBeCopied(n2, n, renderedImage)) {
                int n3 = this.height * this.width * this.bytesPerPixelStored;
                if (this.imageYup == null || !this.imageYupAllocated) {
                    this.imageYup = new byte[n3];
                    this.imageYupAllocated = true;
                }
                this.copyImage(renderedImage, this.imageYup, true, 0);
                this.imageYupClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                this.imageYupCacheDirty = false;
            } else {
                if (!this.imageYupCacheDirty) {
                    this.evaluateRaster(n2, n);
                    return;
                }
                this.storedFormat = this.getStoredFormat(n2, renderedImage);
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                if (!this.yUp) {
                    this.storeTextureImageWithFlip(renderedImage);
                } else {
                    byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
                    if (renderedImage instanceof BufferedImage) {
                        this.imageYup = byArray;
                        this.imageYupAllocated = false;
                        this.imageYupClass = 1;
                    } else {
                        this.numXTiles = renderedImage.getNumXTiles();
                        this.numYTiles = renderedImage.getNumYTiles();
                        this.tilew = renderedImage.getTileWidth();
                        this.tileh = renderedImage.getTileHeight();
                        this.minTileX = renderedImage.getMinTileX();
                        this.minTileY = renderedImage.getMinTileY();
                        this.imageYupAllocated = false;
                        this.imageYupClass = 2;
                        this.imageYup = null;
                    }
                }
            }
            if (!this.usedByRaster) {
                this.imageYdown = null;
                this.imageYdownAllocated = false;
            }
        }
        this.evaluateRaster(n2, n);
    }

    void evaluateRaster(int n, int n2) {
        RenderedImage renderedImage = this.bImage[0];
        if (this.usedByRaster) {
            if (!this.imageYdownCacheDirty) {
                return;
            }
            if (this.shouldImageBeCopied(n, n2, renderedImage)) {
                int n3 = this.height * this.width * this.bytesPerPixelStored;
                if (this.imageYdown == null || !this.imageYdownAllocated) {
                    this.imageYdown = new byte[n3];
                    this.imageYdownAllocated = true;
                }
                if (this.imageYup != null) {
                    this.setImageYdown(this.imageYup, this.imageYdown);
                } else {
                    this.copyImage(renderedImage, this.imageYdown, false, 0);
                }
                this.imageYdownCacheDirty = false;
                this.imageYdownClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            } else {
                if (!this.imageYdownCacheDirty) {
                    return;
                }
                this.storedFormat = this.getStoredFormat(n, renderedImage);
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                if (this.yUp) {
                    this.storeRasterImageWithFlip(renderedImage);
                } else if (renderedImage instanceof BufferedImage) {
                    byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
                    this.imageYdown = byArray;
                    this.imageYdownAllocated = false;
                    this.imageYdownClass = 1;
                } else {
                    if (this.imageYdown == null || !this.imageYdownAllocated) {
                        int n4 = this.width * this.height * this.bytesPerPixelStored;
                        this.imageYdown = new byte[n4];
                        this.imageYdownAllocated = true;
                    }
                    this.imageYdownClass = 1;
                    this.imageYdownCacheDirty = false;
                    this.copyImage(renderedImage, this.imageYdown);
                }
            }
            if (!this.usedByTexture) {
                this.imageYup = null;
                this.imageYupAllocated = false;
            }
        }
    }

    final void flipImage(RenderedImage renderedImage, byte[] byArray) {
        int n = renderedImage.getNumXTiles();
        int n2 = renderedImage.getNumYTiles();
        int n3 = renderedImage.getTileWidth();
        int n4 = renderedImage.getTileHeight();
        int n5 = n3 * this.bytesPerPixelStored;
        int n6 = renderedImage.getMinTileX();
        int n7 = renderedImage.getMinTileY();
        int n8 = this.width * this.bytesPerPixelStored;
        int n9 = (this.height - 1) * n8;
        int n10 = n4 * n3 * n * this.bytesPerPixelStored;
        int n11 = n7;
        while (n11 < n7 + n2) {
            int n12 = n9;
            int n13 = n6;
            while (n13 < n6 + n) {
                Raster raster = renderedImage.getTile(n13, n11);
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n14 = 0;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n4) {
                    System.arraycopy(byArray2, n14, byArray, n15, n5);
                    n14 += n5;
                    n15 -= n8;
                    ++n16;
                }
                n12 += n5;
                ++n13;
            }
            n9 -= n10;
            ++n11;
        }
    }

    native void freeD3DSurface();

    native void freeD3DTexSurface();

    void freeSurface() {
        if (VirtualUniverse.mc.isD3D()) {
            if (this.d3dSurface != 0L) {
                this.freeD3DSurface();
            }
            if (this.d3dTexSurface != 0L) {
                this.freeD3DTexSurface();
            }
        }
    }

    final BufferedImage getImage() {
        if (this.byReference) {
            if (this.imageDirty[0]) {
                this.imageDirty[0] = false;
                if (this.storedFormat == this.internalFormat) {
                    if (this.usedByTexture || !this.usedByRaster) {
                        this.copyBufferedImageWithFormatConversion(true, 0);
                    } else {
                        this.copyBufferedImageWithFormatConversion(false, 0);
                    }
                } else if (this.yUp) {
                    if (!this.usedByTexture || this.usedByRaster) {
                        byte[] byArray = ((DataBufferByte)((BufferedImage)this.bImage[0]).getRaster().getDataBuffer()).getData();
                        this.setImageYup(this.imageYdown, byArray);
                    }
                } else if (this.usedByTexture && !this.usedByRaster) {
                    byte[] byArray = ((DataBufferByte)((BufferedImage)this.bImage[0]).getRaster().getDataBuffer()).getData();
                    this.setImageYdown(this.imageYup, byArray);
                }
            }
        } else if (this.imageDirty[0]) {
            this.retrieveBufferedImage(0);
        }
        return (BufferedImage)this.bImage[0];
    }

    final int getImageType(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getType();
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = colorSpace.getType();
        boolean bl = colorModel.isAlphaPremultiplied();
        if (n2 != 5) {
            if (n2 == 6 && colorModel instanceof ComponentColorModel) {
                if (sampleModel.getDataType() == 0) {
                    n = 10;
                } else if (sampleModel.getDataType() == 1) {
                    n = 11;
                }
            }
        } else {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl2 = true;
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray2[n4] != 8) {
                        bl2 = false;
                        break;
                    }
                    ++n4;
                }
                if (bl2 && nArray[0] == n3 - 1 && nArray[1] == n3 - 2 && nArray[2] == n3 - 3) {
                    if (n3 == 3) {
                        n = 5;
                    } else if (nArray[3] == 0) {
                        n = bl ? 7 : 6;
                    }
                }
            }
        }
        return n;
    }

    final int getStoredFormat(int n, RenderedImage renderedImage) {
        int n2 = 0;
        switch (n) {
            case 6: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 4;
                break;
            }
            case 11: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 32;
                break;
            }
            case 0: {
                if (!this.is4ByteRGBAOr3ByteRGB(renderedImage)) break;
                SampleModel sampleModel = renderedImage.getSampleModel();
                if (sampleModel.getNumBands() == 3) {
                    n2 = 64;
                    break;
                }
                n2 = 1;
                break;
            }
        }
        return n2;
    }

    boolean is4ByteRGBAOr3ByteRGB(RenderedImage renderedImage) {
        boolean bl = false;
        int n = this.getImageType(renderedImage);
        if (n != 0) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n2 = colorSpace.getType();
        if (n2 == 5) {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl3 = true;
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray2[n4] != 8) {
                        bl3 = false;
                        break;
                    }
                    ++n4;
                }
                if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                    if (n3 == 3) {
                        bl = true;
                    } else if (nArray[3] == 3 && !bl2) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    final void set(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        if (n != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained0"));
        }
        if (n2 != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained1"));
        }
        if (!this.byReference || this.byReference && this.willBeCopied(bufferedImage)) {
            int n3 = n2 * n * this.bytesPerPixelStored;
            if (this.usedByTexture || !this.usedByRaster) {
                if (this.imageYup == null || this.imageYup.length < n3) {
                    this.imageYup = new byte[n3];
                }
                this.copyImage(bufferedImage, this.imageYup, true, 0);
                this.imageYupClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            }
            if (this.usedByRaster) {
                if (this.imageYdown == null || this.imageYdown.length < n3) {
                    this.imageYdown = new byte[n3];
                }
                if (this.imageYup != null) {
                    this.setImageYdown(this.imageYup, this.imageYdown);
                } else {
                    this.copyImage(bufferedImage, this.imageYdown, false, 0);
                }
                this.imageYdownClass = 1;
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            }
            if (this.byReference) {
                this.geomLock.getLock();
                this.bImage[0] = bufferedImage;
                this.imageYupCacheDirty = !this.usedByTexture && this.usedByRaster;
                this.imageYdownCacheDirty = !this.usedByRaster;
                this.geomLock.unLock();
            } else {
                this.imageDirty[0] = true;
            }
        } else {
            this.geomLock.getLock();
            this.imageYupCacheDirty = true;
            this.imageYdownCacheDirty = true;
            this.bImage[0] = bufferedImage;
            this.geomLock.unLock();
        }
        this.freeSurface();
    }

    final void set(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            this.set((BufferedImage)renderedImage);
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            WritableRaster writableRaster = renderedImage.copyData(null);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.set(bufferedImage);
        }
        this.freeSurface();
    }

    final void setImageYdown(byte[] byArray, byte[] byArray2) {
        int n = this.width * this.bytesPerPixelStored;
        int n2 = (this.height - 1) * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.height) {
            System.arraycopy(byArray, n2, byArray2, n3, n);
            ++n4;
            n2 -= n;
            n3 += n;
        }
    }

    final void setImageYup(byte[] byArray, byte[] byArray2) {
        int n = this.width * this.bytesPerPixelStored;
        int n2 = 0;
        int n3 = (this.height - 1) * n;
        int n4 = 0;
        while (n4 < this.height) {
            System.arraycopy(byArray, n2, byArray2, n3, n);
            ++n4;
            n2 += n;
            n3 -= n;
        }
    }

    final void setRasterRef() {
        if (this.usedByRaster) {
            return;
        }
        this.usedByRaster = true;
        if (this.format == 10) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2DRetained2"));
        }
        if (!this.byReference) {
            this.storedFormat = this.internalFormat;
            this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            if (this.imageYdown == null && this.imageYup != null) {
                this.imageYdown = new byte[this.height * this.width * this.bytesPerPixelStored];
                this.setImageYdown(this.imageYup, this.imageYdown);
                this.imageYdownClass = 1;
            }
            if (!this.usedByTexture) {
                this.imageYup = null;
                this.imageYupAllocated = false;
            }
        } else if (this.willBeCopied(this.bImage[0])) {
            this.geomLock.getLock();
            if (this.imageYdownCacheDirty) {
                if (this.imageYdown == null) {
                    this.storedFormat = this.internalFormat;
                    this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                    this.imageYdown = new byte[this.height * this.width * this.bytesPerPixelStored];
                    if (this.imageYup != null) {
                        this.setImageYdown(this.imageYup, this.imageYdown);
                    } else if (this.bImage[0] instanceof BufferedImage) {
                        this.copyImage((BufferedImage)this.bImage[0], this.imageYdown, false, 0);
                    } else {
                        this.copyImage(this.bImage[0], this.imageYdown, false, 0);
                    }
                    this.imageYdownClass = 1;
                }
                this.imageYdownCacheDirty = false;
            }
            this.geomLock.unLock();
        } else {
            this.geomLock.getLock();
            this.imageYdownCacheDirty = true;
            this.geomLock.unLock();
        }
    }

    final void setTextureRef() {
        if (this.usedByTexture) {
            return;
        }
        this.usedByTexture = true;
        if (!this.byReference) {
            this.storedFormat = this.internalFormat;
            this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
            if (this.imageYup == null && this.imageYdown != null) {
                this.imageYup = new byte[this.height * this.width * this.bytesPerPixelStored];
                this.setImageYup(this.imageYdown, this.imageYup);
                this.imageYupClass = 1;
            }
            if (!this.usedByRaster) {
                this.imageYdown = null;
                this.imageYdownAllocated = false;
            }
        } else if (this.willBeCopied(this.bImage[0])) {
            this.geomLock.getLock();
            if (this.imageYupCacheDirty) {
                this.storedFormat = this.internalFormat;
                this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
                if (this.imageYup == null) {
                    this.imageYup = new byte[this.height * this.width * this.bytesPerPixelStored];
                    if (this.imageYdown != null) {
                        this.setImageYup(this.imageYdown, this.imageYup);
                    } else if (this.bImage[0] instanceof BufferedImage) {
                        this.copyImage((BufferedImage)this.bImage[0], this.imageYup, true, 0);
                    } else {
                        this.copyImage(this.bImage[0], this.imageYup, true, 0);
                    }
                    this.imageYupClass = 1;
                }
                this.imageYupCacheDirty = false;
            }
            this.geomLock.unLock();
        } else {
            this.geomLock.getLock();
            this.imageYupCacheDirty = true;
            this.geomLock.unLock();
        }
    }

    final boolean shouldImageBeCopied(int n, int n2, RenderedImage renderedImage) {
        if (!this.byReference) {
            return true;
        }
        return !((n2 & 2) != 0 && n == 6 && this.format == 2 || (n2 & 4) != 0 && n == 5 && this.format == 2 || n == 10 && this.format == 10) && !this.is4ByteRGBAOr3ByteRGB(renderedImage);
    }

    void storeRasterImageWithFlip(RenderedImage renderedImage) {
        byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
        this.storedFormat = this.getStoredFormat(this.getImageType(renderedImage), renderedImage);
        this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
        if (renderedImage instanceof BufferedImage) {
            if (this.imageYdown == null || !this.imageYdownAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYdown = new byte[n];
                this.imageYdownAllocated = true;
            }
            this.imageYdownClass = 1;
            this.imageYdownCacheDirty = false;
            this.setImageYdown(byArray, this.imageYdown);
        } else {
            if (this.imageYdown == null || !this.imageYdownAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYdown = new byte[n];
                this.imageYdownAllocated = true;
            }
            this.imageYdownClass = 1;
            this.imageYdownCacheDirty = false;
            this.flipImage(renderedImage, this.imageYdown);
        }
    }

    void storeTextureImageWithFlip(RenderedImage renderedImage) {
        this.storedFormat = this.getStoredFormat(this.getImageType(renderedImage), renderedImage);
        this.bytesPerPixelStored = this.getBytesStored(this.storedFormat);
        if (renderedImage instanceof BufferedImage) {
            byte[] byArray = ((DataBufferByte)((BufferedImage)renderedImage).getRaster().getDataBuffer()).getData();
            if (this.imageYup == null || !this.imageYupAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYup = new byte[n];
                this.imageYupAllocated = true;
            }
            this.imageYupClass = 1;
            this.setImageYup(byArray, this.imageYup);
            this.imageYupCacheDirty = false;
        } else {
            if (this.imageYup == null || !this.imageYupAllocated) {
                int n = this.width * this.height * this.bytesPerPixelStored;
                this.imageYup = new byte[n];
                this.imageYupAllocated = true;
            }
            this.imageYupClass = 1;
            this.flipImage(renderedImage, this.imageYup);
            this.imageYupCacheDirty = false;
        }
    }

    boolean willBeCopied(RenderedImage renderedImage) {
        boolean bl = this.shouldImageBeCopied(this.getImageType(renderedImage), 6, renderedImage);
        return bl;
    }
}

