/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.Debug;
import javax.media.j3d.DepthComponentFloatRetained;
import javax.media.j3d.DepthComponentIntRetained;
import javax.media.j3d.DepthComponentNativeRetained;
import javax.media.j3d.DepthComponentRetained;
import javax.media.j3d.DirectionalLightRetained;
import javax.media.j3d.Fog;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Light;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LightSet;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.LinearFogRetained;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ModelClip;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.Raster;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Sound;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundScheduler;
import javax.media.j3d.SpotLightRetained;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class GraphicsContext3D {
    public static final int STEREO_LEFT = 0;
    public static final int STEREO_RIGHT = 1;
    public static final int STEREO_BOTH = 2;
    Canvas3D canvas3d = null;
    Background uBackground = null;
    Fog uFog = null;
    Appearance uAppearance = null;
    Vector uLights = new Vector();
    HiResCoord uHiRes = new HiResCoord();
    Transform3D uModelTransform = new Transform3D();
    Vector uSounds = new Vector();
    AuralAttributes uAuralAttributes = null;
    boolean uBufferOverride = false;
    boolean uFrontBufferRendering = false;
    int uStereoMode = 2;
    ModelClip uModelClip = null;
    Background background = null;
    BackgroundRetained black = new BackgroundRetained();
    Fog fog = null;
    ModelClip modelClip = null;
    Appearance appearance = null;
    AppearanceRetained defaultAppearanceRetained = new AppearanceRetained();
    Vector lights = new Vector();
    HiResCoord hiRes = new HiResCoord();
    Transform3D modelTransform = new Transform3D();
    Vector sounds = new Vector();
    AuralAttributes auralAttributes = null;
    LightSet ls = null;
    LightRetained[] lightlist = null;
    Color3f sceneAmbient = new Color3f(0.0f, 0.0f, 0.0f);
    int numLights = 0;
    Transform3D compTransform = new Transform3D();
    Transform3D drawTransform = new Transform3D();
    Transform3D vpcToEc;
    boolean lightsChanged = false;
    boolean soundsChanged = false;
    boolean bufferOverride = false;
    boolean frontBufferRendering = false;
    int stereoMode = 2;
    byte[] byteBuffer = new byte[1];
    float[] floatBuffer = new float[1];
    int[] intBuffer = new int[1];
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float dRed = 1.0f;
    float dGreen = 1.0f;
    float dBlue = 1.0f;
    float alpha = 0.0f;
    boolean visible = true;
    int polygonMode = 2;
    boolean lineAA = false;
    boolean pointAA = false;
    boolean enableLighting = false;
    private boolean geometryIsLocked = false;
    private boolean ignoreVertexColors = false;
    static final int CLEAR = 0;
    static final int DRAW = 1;
    static final int SWAP = 2;
    static final int READ_RASTER = 3;
    static final int SET_APPEARANCE = 4;
    static final int SET_BACKGROUND = 5;
    static final int SET_FOG = 6;
    static final int SET_LIGHT = 7;
    static final int INSERT_LIGHT = 8;
    static final int REMOVE_LIGHT = 9;
    static final int ADD_LIGHT = 10;
    static final int SET_HI_RES = 11;
    static final int SET_MODEL_TRANSFORM = 12;
    static final int MULTIPLY_MODEL_TRANSFORM = 13;
    static final int SET_SOUND = 14;
    static final int INSERT_SOUND = 15;
    static final int REMOVE_SOUND = 16;
    static final int ADD_SOUND = 17;
    static final int SET_AURAL_ATTRIBUTES = 18;
    static final int SET_BUFFER_OVERRIDE = 19;
    static final int SET_FRONT_BUFFER_RENDERING = 20;
    static final int SET_STEREO_MODE = 21;
    static final int FLUSH = 22;
    static final int FLUSH2D = 23;
    static final int SET_MODELCLIP = 24;
    static final int BUFFER_MODE = 1;
    private int dirtyMask = 0;
    int numActiveTexUnit = 0;
    int lastActiveTexUnitIndex = 0;
    boolean toSimulateMultiTex = false;
    boolean readRasterReady = false;
    boolean flushDone = false;

    GraphicsContext3D(Canvas3D canvas3D) {
        this.canvas3d = canvas3D;
    }

    public void addLight(Light light) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.addElement(light);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doAddLight(light);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 10, light, null);
        } else {
            this.sendRenderMessage(true, 10, light, null);
        }
    }

    public void addSound(Sound sound) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.addElement(sound);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doAddSound(sound);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 17, sound, null);
        } else {
            this.sendRenderMessage(true, 17, sound, null);
        }
    }

    public void clear() {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null) {
            return;
        }
        if (this.canvas3d.view.inCanvasCallback) {
            this.doClear();
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 0, null, null);
        } else {
            this.sendRenderMessage(true, 0, null, null);
        }
    }

    private void computeCompositeTransform() {
        if (this.canvas3d == null || this.canvas3d.view == null || this.canvas3d.view.viewPlatform == null || (ViewPlatformRetained)this.canvas3d.view.viewPlatform.retained == null) {
            this.compTransform.set(this.modelTransform);
            return;
        }
        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)this.canvas3d.view.viewPlatform.retained;
        if (viewPlatformRetained == null || viewPlatformRetained.locale == null) {
            this.compTransform.set(this.modelTransform);
            return;
        }
        HiResCoord hiResCoord = viewPlatformRetained.locale.hiRes;
        if (hiResCoord.equals(this.hiRes)) {
            this.compTransform.set(this.modelTransform);
        } else {
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d();
            hiResCoord.difference(this.hiRes, vector3d);
            transform3D.setTranslation(vector3d);
            this.compTransform.mul(transform3D, this.modelTransform);
        }
    }

    void doAddLight(Light light) {
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.addElement(light);
        this.lightsChanged = true;
    }

    void doAddSound(Sound sound) {
        ((SoundRetained)sound.retained).setInImmCtx(true);
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.addElement(sound);
        this.soundsChanged = true;
        this.sendSoundMessage(17, sound, null);
    }

    void doClear() {
        if (!this.canvas3d.firstPaintCalled) {
            return;
        }
        RenderBin renderBin = this.canvas3d.view.renderBin;
        BackgroundRetained backgroundRetained = null;
        backgroundRetained = this.background != null ? (BackgroundRetained)this.background.retained : this.black;
        if (!this.canvas3d.isRunning) {
            this.updateViewCache(renderBin);
        }
        try {
            this.canvas3d.drawingSurfaceObject.contextLock(true);
            if (this.canvas3d.ctx == 0) {
                Object object = VirtualUniverse.mc.contextCreationLock;
                synchronized (object) {
                    this.canvas3d.ctx = this.canvas3d.createContext(this.canvas3d.screen.display, this.canvas3d.window, this.canvas3d.vid, 0, this.canvas3d.offScreen);
                    this.canvas3d.screen.renderer.listOfCtxs.add(new Integer(this.canvas3d.ctx));
                    this.canvas3d.screen.renderer.listOfCanvases.add(this.canvas3d);
                }
                this.canvas3d.drawingSurfaceObject.contextValidated();
                VirtualUniverse.mc.currentCtx = this.canvas3d.ctx;
                this.initializeState();
                this.canvas3d.ctxChanged = true;
                this.canvas3d.canvasDirty = 65535;
                this.updateState(renderBin);
                this.canvas3d.currentLights = new LightRetained[this.canvas3d.getNumCtxLights(this.canvas3d.ctx)];
                int n = 0;
                while (n < this.canvas3d.currentLights.length) {
                    this.canvas3d.currentLights[n] = null;
                    ++n;
                }
            }
            this.canvas3d.makeCtxCurrent();
            if ((this.dirtyMask & 1) != 0) {
                if (this.bufferOverride) {
                    this.canvas3d.setRenderMode(this.canvas3d.ctx, this.stereoMode, this.canvas3d.useDoubleBuffer && !this.frontBufferRendering);
                } else {
                    this.canvas3d.setRenderMode(this.canvas3d.ctx, 2, this.canvas3d.useDoubleBuffer);
                }
                this.dirtyMask &= 0xFFFFFFFE;
            }
            if (backgroundRetained.image != null && backgroundRetained.image.isByReference()) {
                backgroundRetained.image.geomLock.getLock();
                backgroundRetained.image.evaluateExtensions(this.canvas3d.extensionsSupported);
                this.canvas3d.clear(this.canvas3d.ctx, backgroundRetained.color.x, backgroundRetained.color.y, backgroundRetained.color.z, backgroundRetained.image);
                backgroundRetained.image.geomLock.unLock();
            } else {
                this.canvas3d.clear(this.canvas3d.ctx, backgroundRetained.color.x, backgroundRetained.color.y, backgroundRetained.color.z, backgroundRetained.image);
            }
            CanvasViewCache canvasViewCache = this.canvas3d.canvasViewCache;
            this.canvas3d.setViewport(this.canvas3d.ctx, 0, 0, canvasViewCache.getCanvasWidth(), canvasViewCache.getCanvasHeight());
            this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, canvasViewCache.getLeftProjection().mat);
            this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, canvasViewCache.getLeftVpcToEc().mat, renderBin.vworldToVpc.mat);
            this.canvas3d.drawingSurfaceObject.unLock(this.canvas3d.isOffScreen() ^ true);
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock(this.canvas3d.isOffScreen() ^ true);
            throw nullPointerException;
        }
    }

    void doDraw(Geometry geometry) {
        GeometryArrayRetained geometryArrayRetained = null;
        if (geometry.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D20"));
        }
        if (!this.canvas3d.firstPaintCalled || !this.visible) {
            return;
        }
        RenderBin renderBin = this.canvas3d.view.renderBin;
        boolean bl = true;
        if (this.canvas3d.ctx == 0) {
            this.doClear();
        }
        if (Debug.ASSERT) {
            Debug.assert(this.canvas3d.ctx != 0, "canvas3d.ctx != 0");
        }
        try {
            GeometryRetained geometryRetained;
            this.canvas3d.drawingSurfaceObject.renderLock(this.canvas3d.isOffScreen() ^ true);
            this.canvas3d.makeCtxCurrent();
            if ((this.dirtyMask & 1) != 0) {
                if (this.bufferOverride) {
                    this.canvas3d.setRenderMode(this.canvas3d.ctx, this.stereoMode, this.canvas3d.useDoubleBuffer && !this.frontBufferRendering);
                } else {
                    this.canvas3d.setRenderMode(this.canvas3d.ctx, 2, this.canvas3d.useDoubleBuffer);
                }
                this.dirtyMask &= 0xFFFFFFFE;
            }
            CanvasViewCache canvasViewCache = this.canvas3d.canvasViewCache;
            this.vpcToEc = canvasViewCache.getLeftVpcToEc();
            this.drawTransform.mul(renderBin.vworldToVpc, this.compTransform);
            this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, this.drawTransform.mat);
            boolean bl2 = (this.drawTransform.getType() & 0x40) == 0;
            this.updateModelClip();
            boolean bl3 = this.updateState(renderBin);
            this.updateLightAndFog();
            if (geometry.retained instanceof GeometryArrayRetained) {
                geometryArrayRetained = (GeometryArrayRetained)geometry.retained;
                geometryArrayRetained.geomLock.getLock();
                if ((geometryArrayRetained.vertexFormat & 0x80) != 0 && geometryArrayRetained.c4fAllocated == 0 && (geometryArrayRetained.vertexFormat & 4) != 0 && bl3 && (this.canvas3d.extensionsSupported & 1) == 0) {
                    if ((geometryArrayRetained.vertexFormat & 0x100) != 0) {
                        geometryArrayRetained.setupMirrorInterleavedColorPointer(true);
                    } else {
                        geometryArrayRetained.setupMirrorColorPointer(geometryArrayRetained.vertexType & 0x3F0, true);
                    }
                }
                geometryRetained = geometry.retained instanceof IndexedGeometryArrayRetained ? (geometryArrayRetained.mirrorGeometry = (GeometryRetained)((IndexedGeometryArrayRetained)geometryArrayRetained).cloneNonIndexedGeometry()) : geometryArrayRetained;
                geometryArrayRetained.setVertexFormat(false, this.ignoreVertexColors);
            } else if (geometry.retained instanceof Text3DRetained) {
                ((Text3DRetained)geometry.retained).setModelViewMatrix(this.vpcToEc, this.drawTransform);
                geometryRetained = (GeometryRetained)geometry.retained;
            } else {
                geometryRetained = (GeometryRetained)geometry.retained;
            }
            if (!this.toSimulateMultiTex) {
                geometryRetained.execute(this.canvas3d, null, bl2, false, this.alpha, this.canvas3d.view.getScreens().length > 1, this.ignoreVertexColors, -1);
            } else {
                boolean bl4 = false;
                boolean bl5 = false;
                AppearanceRetained appearanceRetained = (AppearanceRetained)this.appearance.retained;
                if (this.numActiveTexUnit < 1) {
                    this.canvas3d.resetTexture(this.canvas3d.ctx, -1);
                    geometryRetained.execute(this.canvas3d, null, bl2, false, this.alpha, this.canvas3d.view.getScreens().length > 1, this.ignoreVertexColors, -1);
                } else if (this.numActiveTexUnit == 1) {
                    appearanceRetained.texUnitState[this.lastActiveTexUnitIndex].updateNative(-1, this.canvas3d, renderBin, true, false);
                    geometryRetained.execute(this.canvas3d, null, bl2, false, this.alpha, this.canvas3d.view.getScreens().length > 1, this.ignoreVertexColors, -1);
                    if (appearanceRetained.texUnitState[this.lastActiveTexUnitIndex].isSpecularDisabled()) {
                        this.canvas3d.setSpecular(this.canvas3d.ctx, true);
                    }
                } else {
                    if (this.fog != null) {
                        this.canvas3d.setFogEnableFlag(this.canvas3d.ctx, false);
                    }
                    int n = 0;
                    while (n < appearanceRetained.texUnitState.length) {
                        if (appearanceRetained.texUnitState[n] != null && appearanceRetained.texUnitState[n].isTextureEnabled()) {
                            if (n == this.lastActiveTexUnitIndex) {
                                this.canvas3d.setFogEnableFlag(this.canvas3d.ctx, true);
                            }
                            appearanceRetained.texUnitState[n].updateNative(-1, this.canvas3d, renderBin, false, bl5);
                            if (bl5 && !bl4) {
                                this.canvas3d.setDepthFunc(this.canvas3d.ctx, 1);
                                bl4 = true;
                            }
                            bl5 = true;
                            geometryRetained.execute(this.canvas3d, null, bl2, false, this.alpha, this.canvas3d.view.getScreens().length > 1, this.ignoreVertexColors, n);
                            if (appearanceRetained.texUnitState[n].isSpecularDisabled()) {
                                this.canvas3d.setSpecular(this.canvas3d.ctx, true);
                            }
                        }
                        ++n;
                    }
                    if (bl4) {
                        this.canvas3d.setDepthFunc(this.canvas3d.ctx, 0);
                        appearanceRetained.transparencyAttributes.updateNative(this.canvas3d.ctx, this.alpha, this.polygonMode, this.lineAA, this.pointAA);
                    }
                    if (this.fog != null) {
                        this.canvas3d.setFogEnableFlag(this.canvas3d.ctx, true);
                    }
                }
            }
            if (geometryArrayRetained != null) {
                geometryArrayRetained.geomLock.unLock();
            }
            this.canvas3d.drawingSurfaceObject.unLock(this.canvas3d.isOffScreen() ^ true);
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock(this.canvas3d.isOffScreen() ^ true);
            throw nullPointerException;
        }
        this.sendMessage();
    }

    void doFlush(boolean bl) {
        this.canvas3d.syncRender(this.canvas3d.ctx, bl);
        this.flushDone = true;
    }

    void doInsertLight(Light light, int n) {
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.insertElementAt(light, n);
        this.lightsChanged = true;
    }

    void doInsertSound(Sound sound, int n) {
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.insertElementAt(sound, n);
        this.soundsChanged = true;
        this.sendSoundMessage(15, sound, null);
    }

    void doMultiplyModelTransform(Transform3D transform3D) {
        this.modelTransform.mul(transform3D);
        this.computeCompositeTransform();
    }

    void doReadRaster(Raster raster) {
        int n;
        if (!this.canvas3d.firstPaintCalled) {
            this.readRasterReady = true;
            return;
        }
        RasterRetained rasterRetained = (RasterRetained)raster.retained;
        Dimension dimension = this.canvas3d.getSize();
        if (raster.isLive()) {
            this.readRasterReady = true;
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D21"));
        }
        if (this.canvas3d.ctx == 0) {
            this.doClear();
        }
        if (Debug.ASSERT) {
            Debug.assert(this.canvas3d.ctx != 0, "canvas3d.ctx != 0");
        }
        if ((rasterRetained.type & 1) != 0 && this.byteBuffer.length < (n = rasterRetained.image.height * rasterRetained.image.width * rasterRetained.image.bytesPerPixelStored)) {
            this.byteBuffer = new byte[n];
        }
        if ((rasterRetained.type & 2) != 0) {
            n = rasterRetained.depthComponent.height * rasterRetained.depthComponent.width;
            if (rasterRetained.depthComponent.type == 2) {
                if (this.floatBuffer.length < n) {
                    this.floatBuffer = new float[n];
                }
            } else if (this.intBuffer.length < n) {
                this.intBuffer = new int[n];
            }
        }
        try {
            this.canvas3d.drawingSurfaceObject.renderLock(this.canvas3d.isOffScreen() ^ true);
            this.canvas3d.makeCtxCurrent();
            this.canvas3d.syncRender(this.canvas3d.ctx, true);
            this.readRasterNative(this.canvas3d.ctx, rasterRetained.type, rasterRetained.xOffset, rasterRetained.yOffset, rasterRetained.width, rasterRetained.height, dimension.height, rasterRetained.image, rasterRetained.depthComponent, this);
            this.canvas3d.drawingSurfaceObject.unLock(this.canvas3d.isOffScreen() ^ true);
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock(this.canvas3d.isOffScreen() ^ true);
            throw nullPointerException;
        }
        if ((rasterRetained.type & 1) != 0) {
            rasterRetained.image.retrieveImage(this.byteBuffer, rasterRetained.width, rasterRetained.height);
        }
        if ((rasterRetained.type & 2) != 0) {
            if (rasterRetained.depthComponent.type == 2) {
                ((DepthComponentFloatRetained)rasterRetained.depthComponent).retrieveDepth(this.floatBuffer, rasterRetained.width, rasterRetained.height);
            } else if (rasterRetained.depthComponent.type == 1) {
                ((DepthComponentIntRetained)rasterRetained.depthComponent).retrieveDepth(this.intBuffer, rasterRetained.width, rasterRetained.height);
            } else if (rasterRetained.depthComponent.type == 1) {
                ((DepthComponentNativeRetained)rasterRetained.depthComponent).retrieveDepth(this.intBuffer, rasterRetained.width, rasterRetained.height);
            }
        }
        this.readRasterReady = true;
    }

    void doRemoveLight(int n) {
        Light light = (Light)this.lights.elementAt(n);
        ((LightRetained)light.retained).setInImmCtx(false);
        this.lights.removeElementAt(n);
        this.lightsChanged = true;
    }

    void doRemoveSound(int n) {
        Sound sound = (Sound)this.sounds.elementAt(n);
        SoundScheduler soundScheduler = this.getSoundScheduler();
        ((SoundRetained)sound.retained).setInImmCtx(false);
        this.sounds.removeElementAt(n);
        this.soundsChanged = true;
        this.sendSoundMessage(16, null, sound);
    }

    void doSetAppearance(Appearance appearance) {
        if (appearance != null) {
            int n;
            Object object;
            NodeComponentRetained nodeComponentRetained = ((AppearanceRetained)appearance.retained).material;
            if (nodeComponentRetained != null) {
                nodeComponentRetained.setInImmCtx(true);
                this.enableLighting = ((MaterialRetained)nodeComponentRetained).lightingEnable;
                this.dRed = ((MaterialRetained)nodeComponentRetained).diffuseColor.x;
                this.dGreen = ((MaterialRetained)nodeComponentRetained).diffuseColor.y;
                this.dBlue = ((MaterialRetained)nodeComponentRetained).diffuseColor.z;
            } else {
                this.enableLighting = false;
            }
            if (((AppearanceRetained)appearance.retained).texUnitState != null) {
                object = ((AppearanceRetained)appearance.retained).texUnitState;
                n = 0;
                while (n < ((TextureUnitStateRetained[])object).length) {
                    if (object[n] != null) {
                        if (object[n].isLive()) {
                            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D24"));
                        }
                        object[n].setInImmCtx(true);
                    }
                    ++n;
                }
            }
            if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).texCoordGeneration) != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D3"));
                }
                nodeComponentRetained.setInImmCtx(true);
            }
            if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).textureAttributes) != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D4"));
                }
                nodeComponentRetained.setInImmCtx(true);
            }
            if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).coloringAttributes) != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D5"));
                }
                nodeComponentRetained.setInImmCtx(true);
                this.red = ((ColoringAttributesRetained)nodeComponentRetained).color.x;
                this.green = ((ColoringAttributesRetained)nodeComponentRetained).color.y;
                this.blue = ((ColoringAttributesRetained)nodeComponentRetained).color.z;
            }
            if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).transparencyAttributes) != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D6"));
                }
                nodeComponentRetained.setInImmCtx(true);
                this.alpha = 1.0f - ((TransparencyAttributesRetained)nodeComponentRetained).transparency;
            } else {
                this.alpha = 1.0f;
            }
            nodeComponentRetained = ((AppearanceRetained)appearance.retained).renderingAttributes;
            if (nodeComponentRetained != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D7"));
                }
                nodeComponentRetained.setInImmCtx(true);
                this.visible = ((RenderingAttributesRetained)nodeComponentRetained).visible;
            }
            if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).polygonAttributes) != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D8"));
                }
                nodeComponentRetained.setInImmCtx(true);
                this.polygonMode = ((PolygonAttributesRetained)nodeComponentRetained).polygonMode;
            } else {
                this.polygonMode = 2;
            }
            nodeComponentRetained = ((AppearanceRetained)appearance.retained).lineAttributes;
            if (nodeComponentRetained != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D9"));
                }
                nodeComponentRetained.setInImmCtx(true);
                this.lineAA = ((LineAttributesRetained)nodeComponentRetained).lineAntialiasing;
            } else {
                this.lineAA = false;
            }
            nodeComponentRetained = ((AppearanceRetained)appearance.retained).pointAttributes;
            if (nodeComponentRetained != null) {
                if (nodeComponentRetained.source.isLive()) {
                    throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D10"));
                }
                nodeComponentRetained.setInImmCtx(true);
                this.pointAA = ((PointAttributesRetained)nodeComponentRetained).pointAntialiasing;
            } else {
                this.pointAA = false;
            }
            if (this.appearance != null) {
                object = (AppearanceRetained)this.appearance.retained;
                ((NodeComponentRetained)object).setInImmCtx(false);
                if (((AppearanceRetained)object).material != null) {
                    ((AppearanceRetained)object).material.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).texUnitState != null) {
                    n = 0;
                    while (n < ((AppearanceRetained)object).texUnitState.length) {
                        if (((AppearanceRetained)object).texUnitState[0] != null) {
                            ((AppearanceRetained)object).texUnitState[0].setInImmCtx(false);
                        }
                        ++n;
                    }
                }
                if (((AppearanceRetained)object).texture != null) {
                    ((AppearanceRetained)object).texture.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).texCoordGeneration != null) {
                    ((AppearanceRetained)object).texCoordGeneration.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).textureAttributes != null) {
                    ((AppearanceRetained)object).textureAttributes.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).coloringAttributes != null) {
                    ((AppearanceRetained)object).coloringAttributes.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).transparencyAttributes != null) {
                    ((AppearanceRetained)object).transparencyAttributes.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).renderingAttributes != null) {
                    ((AppearanceRetained)object).renderingAttributes.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).polygonAttributes != null) {
                    ((AppearanceRetained)object).polygonAttributes.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).lineAttributes != null) {
                    ((AppearanceRetained)object).lineAttributes.setInImmCtx(false);
                }
                if (((AppearanceRetained)object).pointAttributes != null) {
                    ((AppearanceRetained)object).pointAttributes.setInImmCtx(false);
                }
            }
            ((AppearanceRetained)appearance.retained).setInImmCtx(true);
        }
        this.appearance = appearance;
        this.sendMessage();
    }

    void doSetAuralAttributes(AuralAttributes auralAttributes) {
        this.auralAttributes = auralAttributes;
        this.sendMessage();
        this.sendSoundMessage(18, auralAttributes, null);
    }

    void doSetBackground(Background background) {
        if (this.background != null) {
            ((BackgroundRetained)this.background.retained).setInImmCtx(false);
        }
        ((BackgroundRetained)background.retained).setInImmCtx(true);
        this.background = background;
        this.sendMessage();
    }

    void doSetBufferOverride(boolean bl) {
        if (bl != this.bufferOverride) {
            this.bufferOverride = bl;
            this.dirtyMask |= 1;
            this.sendMessage();
        }
    }

    void doSetFog(Fog fog) {
        if (this.fog != null) {
            ((FogRetained)this.fog.retained).setInImmCtx(false);
        }
        ((FogRetained)fog.retained).setInImmCtx(true);
        this.fog = fog;
        if (fog.retained instanceof LinearFogRetained) {
            this.updateFogState((LinearFogRetained)fog.retained);
        }
        this.sendMessage();
    }

    void doSetFrontBufferRendering(boolean bl) {
        if (bl != this.frontBufferRendering) {
            this.frontBufferRendering = bl;
            this.dirtyMask |= 1;
            this.sendMessage();
        }
    }

    void doSetHiRes(HiResCoord hiResCoord) {
        this.hiRes.setHiResCoord(hiResCoord);
        this.computeCompositeTransform();
        this.sendMessage();
    }

    void doSetLight(Light light, int n) {
        Light light2 = (Light)this.lights.elementAt(n);
        if (light2 != null) {
            ((LightRetained)light2.retained).setInImmCtx(false);
        }
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.setElementAt(light, n);
        this.lightsChanged = true;
        this.sendMessage();
    }

    void doSetModelClip(ModelClip modelClip) {
        if (this.modelClip != null) {
            ((ModelClipRetained)this.modelClip.retained).setInImmCtx(false);
        }
        ((ModelClipRetained)modelClip.retained).setInImmCtx(true);
        this.modelClip = modelClip;
        this.sendMessage();
    }

    void doSetModelTransform(Transform3D transform3D) {
        this.modelTransform = transform3D;
        this.computeCompositeTransform();
        this.sendMessage();
    }

    void doSetSound(Sound sound, int n) {
        Sound sound2 = (Sound)this.sounds.elementAt(n);
        ((SoundRetained)sound.retained).setInImmCtx(true);
        if (sound2 != null) {
            ((SoundRetained)sound2.retained).setInImmCtx(false);
        }
        ((SoundRetained)sound.retained).setInImmCtx(true);
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.setElementAt(sound, n);
        this.soundsChanged = true;
        this.sendSoundMessage(14, sound, sound2);
        this.sendMessage();
    }

    void doSetStereoMode(int n) {
        if (n != this.stereoMode) {
            this.stereoMode = n;
            this.dirtyMask |= 1;
            this.sendMessage();
        }
    }

    public void draw(Geometry geometry) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null) {
            return;
        }
        if (this.canvas3d.view.inCanvasCallback) {
            this.doDraw(geometry);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 1, geometry, null);
        } else {
            this.sendRenderMessage(true, 1, geometry, null);
        }
    }

    public void draw(Shape3D shape3D) {
        ((Shape3DRetained)shape3D.retained).setInImmCtx(true);
        this.setAppearance(shape3D.getAppearance());
        this.draw(shape3D.getGeometry());
    }

    public void flush(boolean bl) {
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doFlush(bl);
        } else {
            Boolean bl2;
            if (bl) {
                bl2 = Boolean.TRUE;
                this.flushDone = false;
            } else {
                bl2 = Boolean.FALSE;
            }
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 22, bl2, null);
            } else {
                this.sendRenderMessage(true, 22, bl2, null);
            }
            if (bl) {
                while (!this.flushDone) {
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
    }

    public Enumeration getAllLights() {
        return this.uLights.elements();
    }

    public Enumeration getAllSounds() {
        return this.uSounds.elements();
    }

    public Appearance getAppearance() {
        return this.uAppearance;
    }

    public AuralAttributes getAuralAttributes() {
        return this.uAuralAttributes;
    }

    public Background getBackground() {
        return this.uBackground;
    }

    public boolean getBufferOverride() {
        return this.uBufferOverride;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas3d;
    }

    public Fog getFog() {
        return this.uFog;
    }

    public boolean getFrontBufferRendering() {
        return this.uFrontBufferRendering;
    }

    public void getHiRes(HiResCoord hiResCoord) {
        this.uHiRes.getHiResCoord(hiResCoord);
    }

    public Light getLight(int n) {
        return (Light)this.uLights.elementAt(n);
    }

    public ModelClip getModelClip() {
        return this.uModelClip;
    }

    public void getModelTransform(Transform3D transform3D) {
        transform3D.set(this.modelTransform);
    }

    public Sound getSound(int n) {
        Sound sound = (Sound)this.uSounds.elementAt(n);
        return sound;
    }

    SoundScheduler getSoundScheduler() {
        if (this.canvas3d != null && this.canvas3d.view != null) {
            return this.canvas3d.view.soundScheduler;
        }
        return null;
    }

    public int getStereoMode() {
        return this.uStereoMode;
    }

    void initializeState() {
        this.canvas3d.setSceneAmbient(this.canvas3d.ctx, 0.0f, 0.0f, 0.0f);
        this.canvas3d.disableFog(this.canvas3d.ctx);
        this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, false, false);
        this.canvas3d.resetTexture(this.canvas3d.ctx, -1);
        this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
        this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
        this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
        this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
        this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
        this.canvas3d.resetTransparency(this.canvas3d.ctx, 2, false, false);
        this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.canvas3d.updateMaterial(this.canvas3d.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void insertLight(Light light, int n) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.insertElementAt(light, n);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doInsertLight(light, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 8, light, new Integer(n));
        } else {
            this.sendRenderMessage(true, 8, light, new Integer(n));
        }
    }

    public void insertSound(Sound sound, int n) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.insertElementAt(sound, n);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doInsertSound(sound, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 15, sound, new Integer(n));
        } else {
            this.sendRenderMessage(true, 15, sound, new Integer(n));
        }
    }

    public boolean isSoundPlaying(int n) {
        Sound sound = (Sound)this.sounds.elementAt(n);
        return sound.isPlaying();
    }

    public void multiplyModelTransform(Transform3D transform3D) {
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doMultiplyModelTransform(transform3D);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            Transform3D transform3D2 = new Transform3D(transform3D);
            this.sendRenderMessage(false, 13, transform3D2, null);
        } else {
            Transform3D transform3D3 = new Transform3D(transform3D);
            this.sendRenderMessage(true, 13, transform3D3, null);
        }
    }

    public int numLights() {
        return this.uLights.size();
    }

    public int numSounds() {
        return this.uSounds.size();
    }

    public void readRaster(Raster raster) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null) {
            return;
        }
        if (this.canvas3d.view.inCanvasCallback) {
            this.doReadRaster(raster);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.readRasterReady = false;
            this.sendRenderMessage(false, 3, raster, null);
            while (!this.readRasterReady) {
                Thread.currentThread();
                Thread.yield();
            }
        } else {
            this.readRasterReady = false;
            this.sendRenderMessage(true, 3, raster, null);
            while (!this.readRasterReady) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    native void readRasterNative(int var1, int var2, int var3, int var4, int var5, int var6, int var7, ImageComponentRetained var8, DepthComponentRetained var9, GraphicsContext3D var10);

    public void removeLight(int n) {
        this.uLights.removeElementAt(n);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doRemoveLight(n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 9, new Integer(n), null);
        } else {
            this.sendRenderMessage(true, 9, new Integer(n), null);
        }
    }

    public void removeSound(int n) {
        this.uSounds.removeElementAt(n);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doRemoveSound(n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 16, new Integer(n), null);
        } else {
            this.sendRenderMessage(true, 16, new Integer(n), null);
        }
    }

    final void sendMessage() {
        if (this.canvas3d.view != null) {
            this.canvas3d.view.repaint();
        }
    }

    void sendRenderMessage(boolean bl, int n, Object object, Object object2) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 16;
        j3dMessage.type = 44;
        j3dMessage.universe = null;
        j3dMessage.view = null;
        j3dMessage.args[0] = this.canvas3d;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        while (!this.canvas3d.view.inRenderThreadData) {
            try {
                Thread.currentThread();
                Thread.sleep(0L, 10);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.canvas3d.screen.renderer.rendererStructure.addMessage(j3dMessage);
        if (bl) {
            VirtualUniverse.mc.sendRunMessage(this.canvas3d.view, 16);
        } else {
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    void sendSoundMessage(int n, Object object, Object object2) {
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            return;
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 2;
        j3dMessage.type = 44;
        j3dMessage.universe = this.canvas3d.view.universe;
        j3dMessage.view = this.canvas3d.view;
        j3dMessage.args[0] = new Integer(n);
        j3dMessage.args[1] = object;
        j3dMessage.args[2] = object2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    public void setAppearance(Appearance appearance) {
        if (appearance != null) {
            if (appearance.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D0"));
            }
            MaterialRetained materialRetained = ((AppearanceRetained)appearance.retained).material;
            if (materialRetained != null && materialRetained.source.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D1"));
            }
        }
        this.uAppearance = appearance;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetAppearance(appearance);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 4, appearance, null);
        } else {
            this.sendRenderMessage(true, 4, appearance, null);
        }
    }

    public void setAuralAttributes(AuralAttributes auralAttributes) {
        this.uAuralAttributes = auralAttributes;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetAuralAttributes(auralAttributes);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 18, auralAttributes, null);
        } else {
            this.sendRenderMessage(true, 18, auralAttributes, null);
        }
    }

    public void setBackground(Background background) {
        if (background.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D11"));
        }
        if (((BackgroundRetained)background.retained).geometryBranch != null) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D22"));
        }
        this.uBackground = background;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetBackground(background);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 5, background, null);
        } else {
            this.sendRenderMessage(true, 5, background, null);
        }
    }

    public void setBufferOverride(boolean bl) {
        this.uBufferOverride = bl;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetBufferOverride(bl);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 19, new Boolean(bl), null);
        } else {
            this.sendRenderMessage(true, 19, new Boolean(bl), null);
        }
    }

    public void setFog(Fog fog) {
        if (fog.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D12"));
        }
        this.uFog = fog;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetFog(fog);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 6, fog, null);
        } else {
            this.sendRenderMessage(true, 6, fog, null);
        }
    }

    public void setFrontBufferRendering(boolean bl) {
        this.uFrontBufferRendering = bl;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetFrontBufferRendering(bl);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 20, new Boolean(bl), null);
        } else {
            this.sendRenderMessage(true, 20, new Boolean(bl), null);
        }
    }

    public void setHiRes(HiResCoord hiResCoord) {
        this.uHiRes.setHiResCoord(hiResCoord);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetHiRes(hiResCoord);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 11, hiResCoord, null);
        } else {
            this.sendRenderMessage(true, 11, hiResCoord, null);
        }
    }

    public void setHiRes(int[] nArray, int[] nArray2, int[] nArray3) {
        HiResCoord hiResCoord = new HiResCoord(nArray, nArray2, nArray3);
        this.setHiRes(hiResCoord);
    }

    public void setLight(Light light, int n) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.setElementAt(light, n);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetLight(light, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 7, light, new Integer(n));
        } else {
            this.sendRenderMessage(true, 7, light, new Integer(n));
        }
    }

    public void setModelClip(ModelClip modelClip) {
        if (modelClip.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D25"));
        }
        this.uModelClip = modelClip;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetModelClip(modelClip);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 24, modelClip, null);
        } else {
            this.sendRenderMessage(true, 24, modelClip, null);
        }
    }

    public void setModelTransform(Transform3D transform3D) {
        this.uModelTransform = new Transform3D(transform3D);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetModelTransform(this.uModelTransform);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 12, this.uModelTransform, null);
        } else {
            this.sendRenderMessage(true, 12, this.uModelTransform, null);
        }
    }

    public void setSound(Sound sound, int n) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.setElementAt(sound, n);
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetSound(sound, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 14, sound, new Integer(n));
        } else {
            this.sendRenderMessage(true, 14, sound, new Integer(n));
        }
    }

    public void setStereoMode(int n) {
        this.uStereoMode = n;
        if (this.canvas3d.view == null || this.canvas3d.view.inCanvasCallback || this.canvas3d.view.universe == null) {
            this.doSetStereoMode(n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 21, new Integer(n), null);
        } else {
            this.sendRenderMessage(true, 21, new Integer(n), null);
        }
    }

    void updateFogState(LinearFogRetained linearFogRetained) {
        linearFogRetained.localToVworldScale = this.modelTransform.getDistanceScale();
    }

    void updateLightAndFog() {
        int n = 0;
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.lights.size()) {
            LightRetained lightRetained = (LightRetained)((Light)this.lights.get((int)n3)).retained;
            if (lightRetained instanceof AmbientLightRetained) {
                this.sceneAmbient.x += lightRetained.color.x;
                this.sceneAmbient.y += lightRetained.color.y;
                this.sceneAmbient.z += lightRetained.color.z;
            } else {
                lightRetained.update(this.canvas3d.ctx, n2, this.canvas3d.canvasViewCache.getVworldToCoexistenceScale());
                if (lightRetained.lightOn) {
                    n |= 1 << n2;
                }
                ++n2;
            }
            ++n3;
        }
        if (this.sceneAmbient.x > 1.0f) {
            this.sceneAmbient.x = 1.0f;
        }
        if (this.sceneAmbient.y > 1.0f) {
            this.sceneAmbient.y = 1.0f;
        }
        if (this.sceneAmbient.z > 1.0f) {
            this.sceneAmbient.z = 1.0f;
        }
        this.canvas3d.setSceneAmbient(this.canvas3d.ctx, this.sceneAmbient.x, this.sceneAmbient.y, this.sceneAmbient.z);
        this.canvas3d.setLightEnables(this.canvas3d.ctx, n, 32);
        this.canvas3d.lightBin = null;
        this.canvas3d.environmentSet = null;
        if (this.fog != null) {
            ((FogRetained)this.fog.retained).update(this.canvas3d.ctx, this.canvas3d.canvasViewCache.getVworldToCoexistenceScale());
        }
    }

    void updateLightState(LightRetained lightRetained) {
        if (lightRetained instanceof DirectionalLightRetained) {
            DirectionalLightRetained directionalLightRetained = (DirectionalLightRetained)lightRetained;
            this.modelTransform.transform(directionalLightRetained.direction, directionalLightRetained.xformDirection);
            directionalLightRetained.xformDirection.normalize();
        } else if (lightRetained instanceof SpotLightRetained) {
            SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetained;
            this.modelTransform.transform(spotLightRetained.direction, spotLightRetained.xformDirection);
            spotLightRetained.xformDirection.normalize();
            this.modelTransform.transform(spotLightRetained.position, spotLightRetained.xformPosition);
        } else if (lightRetained instanceof PointLightRetained) {
            PointLightRetained pointLightRetained = (PointLightRetained)lightRetained;
            this.modelTransform.transform(pointLightRetained.position, pointLightRetained.xformPosition);
            pointLightRetained.localToVworldScale = this.modelTransform.getDistanceScale();
        }
    }

    void updateModelClip() {
        if (this.modelClip != null) {
            ((ModelClipRetained)this.modelClip.retained).update(this.canvas3d.ctx, this.drawTransform);
        }
    }

    void updateSoundState(SoundRetained soundRetained) {
        Object object;
        View view = null;
        if (this.canvas3d != null) {
            view = this.canvas3d.view;
        }
        if (view != null) {
            object = this.getSoundScheduler();
        }
        if (soundRetained instanceof ConeSoundRetained) {
            object = (ConeSoundRetained)soundRetained;
            this.modelTransform.transform(((ConeSoundRetained)object).direction, ((ConeSoundRetained)object).xformDirection);
            ((ConeSoundRetained)object).xformDirection.normalize();
            this.modelTransform.transform(((PointSoundRetained)object).position, ((PointSoundRetained)object).xformPosition);
            ((PointSoundRetained)object).trans.setWithLock(this.drawTransform);
        } else if (soundRetained instanceof PointSoundRetained) {
            object = (PointSoundRetained)soundRetained;
            this.modelTransform.transform(((PointSoundRetained)object).position, ((PointSoundRetained)object).xformPosition);
            ((PointSoundRetained)object).trans.setWithLock(this.drawTransform);
        }
    }

    boolean updateState(RenderBin renderBin) {
        boolean bl = false;
        this.toSimulateMultiTex = false;
        if (this.appearance != null) {
            AppearanceRetained appearanceRetained = (AppearanceRetained)this.appearance.retained;
            if (appearanceRetained.material != null) {
                if (!appearanceRetained.material.equivalent(this.canvas3d.material)) {
                    appearanceRetained.material.updateNative(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                    this.canvas3d.material = appearanceRetained.material;
                    this.canvas3d.canvasDirty |= 8;
                }
            } else {
                this.canvas3d.updateMaterial(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha);
                this.canvas3d.material = null;
                this.canvas3d.canvasDirty |= 8;
            }
            if (appearanceRetained.texUnitState != null) {
                this.numActiveTexUnit = 0;
                this.lastActiveTexUnitIndex = 0;
                if (this.canvas3d.numTexUnitSupported >= appearanceRetained.texUnitState.length && this.canvas3d.multiTexAccelerated) {
                    int n = 0;
                    while (n < appearanceRetained.texUnitState.length) {
                        if (appearanceRetained.texUnitState[n] == null) {
                            this.canvas3d.resetTexture(this.canvas3d.ctx, n);
                        } else {
                            appearanceRetained.texUnitState[n].updateNative(n, this.canvas3d, renderBin, true, false);
                            bl = bl || appearanceRetained.texUnitState[n].texAttrs.textureMode == 4;
                        }
                        ++n;
                    }
                } else {
                    this.toSimulateMultiTex = true;
                    int n = 0;
                    while (n < appearanceRetained.texUnitState.length) {
                        if (appearanceRetained.texUnitState[n] != null) {
                            if (appearanceRetained.texUnitState[n].isTextureEnabled()) {
                                ++this.numActiveTexUnit;
                                this.lastActiveTexUnitIndex = n;
                            }
                            bl = bl || appearanceRetained.texUnitState[n].texAttrs.textureMode == 4;
                        }
                        ++n;
                    }
                }
            } else {
                if (this.canvas3d.multiTexAccelerated) {
                    int n = 0;
                    while (n < this.canvas3d.numTexUnitSupported) {
                        this.canvas3d.resetTexture(this.canvas3d.ctx, n);
                        ++n;
                    }
                }
                if (this.canvas3d.texture != appearanceRetained.texture) {
                    if (appearanceRetained.texture != null) {
                        appearanceRetained.texture.updateNative(this.canvas3d);
                        this.canvas3d.canvasDirty |= 0x400;
                    } else {
                        this.canvas3d.resetTexture(this.canvas3d.ctx, -1);
                        this.canvas3d.canvasDirty |= 0x400;
                    }
                    this.canvas3d.texture = appearanceRetained.texture;
                }
                if (appearanceRetained.texCoordGeneration != null) {
                    if (!appearanceRetained.texCoordGeneration.equivalent(this.canvas3d.texCoordGeneration)) {
                        appearanceRetained.texCoordGeneration.updateNative(this.canvas3d.ctx, this.canvas3d.vpcToEc, renderBin.vworldToVpc);
                        this.canvas3d.canvasDirty |= 0x800;
                        this.canvas3d.texCoordGeneration = appearanceRetained.texCoordGeneration;
                    }
                } else if (this.canvas3d.texCoordGeneration != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 0x800;
                    this.canvas3d.texCoordGeneration = appearanceRetained.texCoordGeneration;
                }
                if (appearanceRetained.textureAttributes != null) {
                    if (!appearanceRetained.textureAttributes.equivalent(this.canvas3d.texAttrs)) {
                        if (this.canvas3d.texture != null) {
                            appearanceRetained.textureAttributes.updateNative(this.canvas3d, false, this.canvas3d.texture.format);
                        } else {
                            appearanceRetained.textureAttributes.updateNative(this.canvas3d, false, 6);
                        }
                        this.canvas3d.canvasDirty |= 0x800;
                        this.canvas3d.texAttrs = appearanceRetained.textureAttributes;
                    }
                } else if (this.canvas3d.texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 0x800;
                    this.canvas3d.texAttrs = appearanceRetained.textureAttributes;
                }
            }
            if (appearanceRetained.coloringAttributes != null) {
                if (!appearanceRetained.coloringAttributes.equivalent(this.canvas3d.coloringAttributes)) {
                    appearanceRetained.coloringAttributes.updateNative(this.canvas3d.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
                    this.canvas3d.canvasDirty |= 0x20;
                    this.canvas3d.coloringAttributes = appearanceRetained.coloringAttributes;
                }
            } else {
                this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                this.canvas3d.canvasDirty |= 0x20;
                this.canvas3d.coloringAttributes = null;
            }
            if (appearanceRetained.transparencyAttributes != null) {
                if (!appearanceRetained.transparencyAttributes.equivalent(this.canvas3d.transparency)) {
                    appearanceRetained.transparencyAttributes.updateNative(this.canvas3d.ctx, this.alpha, this.polygonMode, this.lineAA, this.pointAA);
                    this.canvas3d.canvasDirty |= 0x10;
                    this.canvas3d.transparency = appearanceRetained.transparencyAttributes;
                }
                bl = bl || appearanceRetained.transparencyAttributes.transparencyMode != 4 && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && appearanceRetained.transparencyAttributes.transparencyMode != 3);
            } else {
                this.canvas3d.resetTransparency(this.canvas3d.ctx, this.polygonMode, this.lineAA, this.pointAA);
                this.canvas3d.canvasDirty |= 0x10;
                this.canvas3d.transparency = null;
            }
            if (appearanceRetained.renderingAttributes != null) {
                this.ignoreVertexColors = appearanceRetained.renderingAttributes.ignoreVertexColors;
                if (!appearanceRetained.renderingAttributes.equivalent(this.canvas3d.renderingAttrs)) {
                    appearanceRetained.renderingAttributes.updateNative(this.canvas3d.ctx, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
                    this.canvas3d.canvasDirty |= 0x200;
                    this.canvas3d.renderingAttrs = appearanceRetained.renderingAttributes;
                }
                bl = bl || appearanceRetained.renderingAttributes.alphaTestFunction != 0;
            } else {
                this.ignoreVertexColors = false;
                if (this.canvas3d.renderingAttrs != null) {
                    this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
                    this.canvas3d.canvasDirty |= 0x200;
                    this.canvas3d.renderingAttrs = appearanceRetained.renderingAttributes;
                }
            }
            if (appearanceRetained.polygonAttributes != null) {
                if (!appearanceRetained.polygonAttributes.equivalent(this.canvas3d.polygonAttributes)) {
                    appearanceRetained.polygonAttributes.updateNative(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 1;
                    this.canvas3d.polygonAttributes = appearanceRetained.polygonAttributes;
                }
            } else if (this.canvas3d.polygonAttributes != null) {
                this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 1;
                this.canvas3d.polygonAttributes = appearanceRetained.polygonAttributes;
            }
            if (appearanceRetained.lineAttributes != null) {
                if (!appearanceRetained.lineAttributes.equivalent(this.canvas3d.lineAttributes)) {
                    appearanceRetained.lineAttributes.updateNative(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 2;
                    this.canvas3d.lineAttributes = appearanceRetained.lineAttributes;
                }
            } else if (this.canvas3d.lineAttributes != null) {
                this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 2;
                this.canvas3d.lineAttributes = appearanceRetained.lineAttributes;
            }
            if (appearanceRetained.pointAttributes != null) {
                if (!appearanceRetained.pointAttributes.equivalent(this.canvas3d.pointAttributes)) {
                    appearanceRetained.pointAttributes.updateNative(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 4;
                    this.canvas3d.pointAttributes = appearanceRetained.pointAttributes;
                }
            } else if (this.canvas3d.pointAttributes != null) {
                this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 4;
                this.canvas3d.pointAttributes = appearanceRetained.pointAttributes;
            }
        }
        return bl;
    }

    private void updateViewCache(RenderBin renderBin) {
        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)this.canvas3d.view.viewPlatform.retained;
        if (!this.canvas3d.isRunning) {
            ((ViewPlatformRetained)this.canvas3d.view.viewPlatform.retained).evaluateInitViewPlatformTransform();
        }
        renderBin.vpcToVworld = viewPlatformRetained.getVpcToVworld();
        renderBin.vworldToVpc = viewPlatformRetained.getVworldToVpc();
        this.canvas3d.view.updateViewCache();
        this.canvas3d.updateViewCache(true, null, null, false);
    }
}

