/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FastVector;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Font3D {
    Font font;
    double tessellationTolerance;
    FontExtrusion fontExtrusion;
    int numGlyphs = 0;
    GeometryArray[] fontData;
    boolean[] fontFlags;
    FontRenderContext frc;
    Object[] gVectors;
    float[] charHeights;
    int[][] islandCounts = null;
    Point3f[][] outVerts = null;

    public Font3D(Font font, double d, FontExtrusion fontExtrusion) {
        this.font = font;
        this.tessellationTolerance = d;
        this.fontExtrusion = fontExtrusion;
        this.frc = new FontRenderContext(new AffineTransform(), true, true);
        this.numGlyphs = font.getNumGlyphs();
        this.fontData = new GeometryArray[this.numGlyphs];
        this.gVectors = new Object[this.numGlyphs];
        this.fontFlags = new boolean[this.numGlyphs];
        this.charHeights = new float[this.numGlyphs];
        int n = 0;
        while (n < this.numGlyphs) {
            this.fontData[n] = null;
            this.fontFlags[n] = false;
            this.gVectors[n] = null;
            ++n;
        }
    }

    public Font3D(Font font, FontExtrusion fontExtrusion) {
        this(font, 0.01, fontExtrusion);
    }

    int check2Contours(int n, int n2, int n3, int n4, Point3f[] point3fArray) {
        int n5 = -1;
        int n6 = n3 + n;
        n5 = this.pointInPolygon2D(point3fArray[n3].x, point3fArray[n3].y, n2, n4, point3fArray);
        int n7 = n3 + 1;
        while (n7 < n6) {
            int n8 = this.pointInPolygon2D(point3fArray[n7].x, point3fArray[n7].y, n2, n4, point3fArray);
            if (n8 != n5) {
                n5 = 2;
                break;
            }
            ++n7;
        }
        if (n5 == 0) {
            n5 = this.pointInPolygon2D(point3fArray[n4].x, point3fArray[n4].y, n, n3, point3fArray);
        }
        return n5;
    }

    public void getBoundingBox(int n, BoundingBox boundingBox) {
        int[] nArray = new int[]{n};
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, nArray);
        Rectangle2D.Float float_ = (Rectangle2D.Float)glyphVector.getGlyphMetrics(0).getBounds2D();
        Point3d point3d = new Point3d((double)float_.x, (double)float_.y, 0.0);
        Point3d point3d2 = this.fontExtrusion != null ? new Point3d((double)(float_.x + float_.width), (double)(float_.y + float_.height), (double)this.fontExtrusion.length) : new Point3d((double)(float_.x + float_.width), (double)(float_.y + float_.height), 0.0);
        boundingBox.setLower(point3d);
        boundingBox.setUpper(point3d2);
    }

    public Font getFont() {
        return this.font;
    }

    public void getFontExtrusion(FontExtrusion fontExtrusion) {
        fontExtrusion = this.fontExtrusion;
    }

    void getNormal(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        vector3f2.sub((Tuple3f)point3f2, (Tuple3f)point3f);
        vector3f3.sub((Tuple3f)point3f2, (Tuple3f)point3f3);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.negate();
        vector3f.normalize();
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }

    int pointInPolygon2D(float f, float f2, int n, int n2, Point3f[] point3fArray) {
        float f3;
        int n3 = 0;
        int n4 = n2 + n - 1;
        int n5 = n2;
        while (n5 < n4) {
            if (!(point3fArray[n5].y >= f2 && point3fArray[n5 + 1].y >= f2 || point3fArray[n5].y < f2 && point3fArray[n5 + 1].y < f2 || !(f < (f3 = point3fArray[n5].x + (point3fArray[n5].x - point3fArray[n5 + 1].x) * (f2 - point3fArray[n5].y) / (point3fArray[n5].y - point3fArray[n5 + 1].y))))) {
                ++n3;
            }
            ++n5;
        }
        if (!(point3fArray[n5].y >= f2 && point3fArray[n2].y >= f2 || point3fArray[n5].y < f2 && point3fArray[n2].y < f2 || !(f < (f3 = point3fArray[n5].x + (point3fArray[n5].x - point3fArray[n2].x) * (f2 - point3fArray[n5].y) / (point3fArray[n5].y - point3fArray[n2].y))))) {
            ++n3;
        }
        if (n3 % 2 == 0) {
            return 0;
        }
        return 1;
    }

    void processContours(int[] nArray, Point3f[] point3fArray) {
        if (nArray.length == 1) {
            this.islandCounts = new int[1][1];
            this.islandCounts[0][0] = point3fArray.length;
            this.outVerts = new Point3f[1][point3fArray.length];
            int n = 0;
            while (n < point3fArray.length) {
                this.outVerts[0][n] = point3fArray[n];
                ++n;
            }
        } else {
            int n;
            int n2;
            int n3 = -1;
            boolean[] blArray = new boolean[nArray.length];
            int n4 = 0;
            while (n4 < nArray.length) {
                blArray[n4] = false;
                ++n4;
            }
            int[][] nArray2 = new int[nArray.length][nArray.length];
            int[] nArray3 = new int[nArray.length];
            nArray3[0] = 0;
            int n5 = 0;
            n4 = 0;
            while (n4 < nArray.length - 1) {
                nArray3[n4 + 1] = n5 += nArray[n4];
                ++n4;
            }
            n4 = 0;
            while (n4 < nArray.length) {
                n5 = 0;
                while (n5 < nArray.length) {
                    nArray2[n4][n5] = -1;
                    ++n5;
                }
                ++n4;
            }
            nArray2[0][0] = 0;
            blArray[0] = true;
            n4 = 1;
            while (n4 < nArray.length) {
                n5 = 0;
                while (n5 < nArray.length && nArray2[n5][0] != -1) {
                    n2 = 0;
                    while (n2 < nArray.length && nArray2[n5][n2] != -1) {
                        n3 = this.check2Contours(nArray[n4], nArray[nArray2[n5][n2]], nArray3[n4], nArray3[nArray2[n5][n2]], point3fArray);
                        if (n3 == 2) {
                            n = n5 + 1;
                            while (nArray2[n][0] != -1) {
                                ++n;
                            }
                            nArray2[n][0] = n4;
                            break;
                        }
                        if (n3 == 1) {
                            n = n2 + 1;
                            while (nArray2[n5][n] != -1) {
                                ++n;
                            }
                            nArray2[n5][n] = n4;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 != 0) {
                        blArray[n4] = true;
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
            n4 = 1;
            while (n4 < nArray.length) {
                if (!blArray[n4]) {
                    n5 = 0;
                    while (n5 < nArray.length && nArray2[n5][0] != -1) {
                        n2 = 0;
                        while (n2 < nArray.length && nArray2[n5][n2] != -1) {
                            n3 = this.check2Contours(nArray[n4], nArray[nArray2[n5][n2]], nArray3[n4], nArray3[nArray2[n5][n2]], point3fArray);
                            if (n3 == 2) {
                                n = n5 + 1;
                                while (nArray2[n][0] != -1) {
                                    ++n;
                                }
                                nArray2[n][0] = n4;
                                break;
                            }
                            if (n3 == 1) {
                                n = n2 + 1;
                                while (nArray2[n5][n] != -1) {
                                    ++n;
                                }
                                nArray2[n5][n] = n4;
                                break;
                            }
                            ++n2;
                        }
                        if (n3 != 0) {
                            blArray[n4] = true;
                            break;
                        }
                        ++n5;
                    }
                    if (n3 == 0) {
                        nArray2[n5][0] = n4;
                    }
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < nArray.length && nArray2[n4][0] != -1) {
                ++n4;
            }
            this.outVerts = new Point3f[n4][];
            this.islandCounts = new int[n4][];
            int n6 = 0;
            int n7 = 0;
            n4 = 0;
            while (n4 < nArray.length && nArray2[n4][0] != -1) {
                int n8 = 0;
                n5 = 0;
                while (n5 < nArray.length && nArray2[n4][n5] != -1) {
                    n8 += nArray[nArray2[n4][n5]];
                    ++n5;
                }
                this.outVerts[n4] = new Point3f[n8];
                this.islandCounts[n4] = new int[n5];
                n = 0;
                n5 = 0;
                while (n5 < nArray.length && nArray2[n4][n5] != -1) {
                    this.islandCounts[n4][n5] = nArray[nArray2[n4][n5]];
                    n6 = nArray3[nArray2[n4][n5]];
                    n7 = n6 + this.islandCounts[n4][n5];
                    n2 = n6;
                    while (n2 < n7) {
                        this.outVerts[n4][n] = point3fArray[n2];
                        ++n2;
                        ++n;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
    }

    void triangulateGlyphs(int n, char c) {
        if (!this.fontFlags[n]) {
            Object object;
            char[] cArray = new char[]{c};
            this.charHeights[n] = this.font.getLineMetrics(cArray, 0, 1, this.frc).getHeight();
            this.gVectors[n] = this.font.createGlyphVector(this.frc, cArray);
            GlyphVector glyphVector = (GlyphVector)this.gVectors[n];
            Rectangle2D.Float float_ = (Rectangle2D.Float)glyphVector.getGlyphMetrics(0).getBounds2D();
            AffineTransform affineTransform = new AffineTransform();
            double d = (double)float_.x + 0.5 * (double)float_.width;
            double d2 = (double)float_.y + 0.5 * (double)float_.height;
            affineTransform.setToTranslation(-d, -d2);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(d, -d2);
            Shape shape = glyphVector.getOutline();
            PathIterator pathIterator = shape.getPathIterator(affineTransform, this.tessellationTolerance);
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
            float[] fArray = new float[6];
            float f = 0.0f;
            float f2 = 0.0f;
            GeometryInfo geometryInfo = null;
            NormalGenerator normalGenerator = new NormalGenerator();
            FastVector fastVector = new FastVector(1, 1);
            this.fontFlags[n] = true;
            while (!pathIterator.isDone()) {
                float f3 = 0.0f;
                float f4 = 0.0f;
                object = new Point3f();
                n2 = pathIterator.currentSegment(fArray);
                if (n2 == 4) {
                    fastVector.addElement(n5);
                    n5 = 0;
                    ++n3;
                } else if (n2 == 0) {
                    object.x = fArray[0];
                    object.y = fArray[1];
                    f = object.x;
                    f2 = object.y;
                    arrayList.add((Point3f)object);
                    if (n5 > 0) {
                        fastVector.addElement(n5);
                        n5 = 0;
                        ++n3;
                    }
                    ++n5;
                    ++n4;
                } else if (n2 == 1) {
                    object.x = fArray[0];
                    object.y = fArray[1];
                    if (object.x == f && object.y == f2) {
                        pathIterator.next();
                        continue;
                    }
                    arrayList.add((Point3f)object);
                    ++n5;
                    ++n4;
                }
                pathIterator.next();
            }
            if (n4 == 0) {
                return;
            }
            n5 = arrayList.size();
            Point3f[] point3fArray = new Point3f[n5];
            int n6 = 0;
            while (n6 < n5) {
                point3fArray[n6] = (Point3f)arrayList.get(n6);
                ++n6;
            }
            int[] nArray = fastVector.getData();
            this.processContours(nArray, point3fArray);
            object = new int[1];
            object[0] = (Point3f)n3;
            int n7 = 0;
            int n8 = 0;
            ArrayList<GeometryArray> arrayList2 = new ArrayList<GeometryArray>();
            Point3f point3f = new Point3f();
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            Point3f point3f4 = new Point3f();
            Point3f point3f5 = new Point3f();
            Point3f point3f6 = new Point3f();
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            TriangleArray triangleArray = null;
            n4 = 0;
            n6 = 0;
            while (n6 < this.islandCounts.length) {
                object[0] = (Point3f)this.islandCounts[n6].length;
                n4 += this.outVerts[n6].length;
                geometryInfo = new GeometryInfo(5);
                geometryInfo.setCoordinates(this.outVerts[n6]);
                geometryInfo.setStripCounts(this.islandCounts[n6]);
                geometryInfo.setContourCounts((int[])object);
                normalGenerator.generateNormals(geometryInfo);
                GeometryArray geometryArray = geometryInfo.getGeometryArray();
                n8 += geometryArray.getVertexCount();
                arrayList2.add(geometryArray);
                ++n6;
            }
            int n9 = this.fontExtrusion == null ? n8 : (this.fontExtrusion.shape == null ? n8 * 2 + n4 * 6 : n8 * 2 + n4 * 6 * (this.fontExtrusion.pnts.length - 1));
            triangleArray = new TriangleArray(n9, 3);
            boolean bl = false;
            int n10 = 0;
            while (n10 < this.islandCounts.length) {
                GeometryArray geometryArray = (GeometryArray)arrayList2.get(n10);
                n8 = geometryArray.getVertexCount();
                geometryArray.getCoordinate(0, point3f);
                geometryArray.getCoordinate(1, point3f2);
                geometryArray.getCoordinate(2, point3f3);
                this.getNormal(point3f, point3f2, point3f3, vector3f2);
                bl = !(vector3f2.z > 0.0f);
                if (this.fontExtrusion != null) {
                    n6 = 0;
                    while (n6 < n8) {
                        geometryArray.getCoordinate(n6, point3f);
                        geometryArray.getNormal(n6, vector3f);
                        geometryArray.getCoordinate(n6 + 1, point3f2);
                        geometryArray.getCoordinate(n6 + 2, point3f3);
                        if (bl) {
                            point3f4.x = point3f2.x;
                            point3f4.y = point3f2.y;
                            point3f4.z = point3f2.z;
                            point3f2.x = point3f3.x;
                            point3f2.y = point3f3.y;
                            point3f2.z = point3f3.z;
                            point3f3.x = point3f4.x;
                            point3f3.y = point3f4.y;
                            point3f3.z = point3f4.z;
                            vector3f.x = -vector3f.x;
                            vector3f.y = -vector3f.y;
                            vector3f.z = -vector3f.z;
                        }
                        vector3f2.x = -vector3f.x;
                        vector3f2.y = -vector3f.y;
                        vector3f2.z = -vector3f.z;
                        triangleArray.setCoordinate(n7, point3f);
                        triangleArray.setNormal(n7, vector3f2);
                        triangleArray.setCoordinate(n7 + 1, point3f3);
                        triangleArray.setNormal(n7 + 1, vector3f2);
                        triangleArray.setCoordinate(n7 + 2, point3f2);
                        triangleArray.setNormal(n7 + 2, vector3f2);
                        point3f4.x = point3f.x;
                        point3f4.y = point3f.y;
                        point3f4.z = point3f.z + this.fontExtrusion.length;
                        point3f5.x = point3f2.x;
                        point3f5.y = point3f2.y;
                        point3f5.z = point3f2.z + this.fontExtrusion.length;
                        point3f6.x = point3f3.x;
                        point3f6.y = point3f3.y;
                        point3f6.z = point3f3.z + this.fontExtrusion.length;
                        triangleArray.setCoordinate(n7 + n8, point3f4);
                        triangleArray.setNormal(n7 + n8, vector3f);
                        triangleArray.setCoordinate(n7 + 1 + n8, point3f5);
                        triangleArray.setNormal(n7 + 1 + n8, vector3f);
                        triangleArray.setCoordinate(n7 + 2 + n8, point3f6);
                        triangleArray.setNormal(n7 + 2 + n8, vector3f);
                        n6 += 3;
                        n7 += 3;
                    }
                    n7 += n8;
                } else {
                    n6 = 0;
                    while (n6 < n8) {
                        geometryArray.getCoordinate(n6, point3f);
                        geometryArray.getNormal(n6, vector3f);
                        geometryArray.getCoordinate(n6 + 1, point3f2);
                        geometryArray.getCoordinate(n6 + 2, point3f3);
                        if (bl) {
                            point3f4.x = point3f2.x;
                            point3f4.y = point3f2.y;
                            point3f4.z = point3f2.z;
                            point3f2.x = point3f3.x;
                            point3f2.y = point3f3.y;
                            point3f2.z = point3f3.z;
                            point3f3.x = point3f4.x;
                            point3f3.y = point3f4.y;
                            point3f3.z = point3f4.z;
                            vector3f.x = -vector3f.x;
                            vector3f.y = -vector3f.y;
                            vector3f.z = -vector3f.z;
                        }
                        triangleArray.setCoordinate(n7, point3f);
                        triangleArray.setNormal(n7, vector3f);
                        triangleArray.setCoordinate(n7 + 1, point3f2);
                        triangleArray.setNormal(n7 + 1, vector3f);
                        triangleArray.setCoordinate(n7 + 2, point3f3);
                        triangleArray.setNormal(n7 + 2, vector3f);
                        n6 += 3;
                        n7 += 3;
                    }
                }
                ++n10;
            }
            if (this.fontExtrusion != null) {
                if (this.fontExtrusion.shape == null) {
                    float f5 = (float)Math.cos(0.767944870877505);
                    Vector3f vector3f3 = null;
                    Vector3f vector3f4 = null;
                    Vector3f vector3f5 = new Vector3f();
                    Vector3f vector3f6 = new Vector3f();
                    Vector3f vector3f7 = new Vector3f();
                    Vector3f vector3f8 = new Vector3f();
                    Vector3f vector3f9 = new Vector3f();
                    Vector3f vector3f10 = new Vector3f();
                    Vector3f vector3f11 = new Vector3f();
                    Vector3f vector3f12 = new Vector3f();
                    n6 = 0;
                    while (n6 < this.islandCounts.length) {
                        n10 = 0;
                        int n11 = 0;
                        n5 = 0;
                        while (n10 < this.islandCounts[n6].length) {
                            point3f.x = this.outVerts[n6][(n5 += this.islandCounts[n6][n10]) - 1].x;
                            point3f.y = this.outVerts[n6][n5 - 1].y;
                            point3f.z = 0.0f;
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            while (n11 < n5) {
                                boolean bl2;
                                float f6;
                                point3f2.x = this.outVerts[n6][n11].x;
                                point3f2.y = this.outVerts[n6][n11].y;
                                point3f2.z = 0.0f;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                point3f5.z = point3f2.z + this.fontExtrusion.length;
                                this.getNormal(point3f, point3f4, point3f2, vector3f);
                                this.getNormal(point3f2, point3f4, point3f5, vector3f2);
                                if (vector3f3 != null) {
                                    f6 = vector3f.dot(vector3f4);
                                    boolean bl3 = bl2 = f6 > f5;
                                    if (bl2) {
                                        vector3f7.x = vector3f3.x + vector3f4.x + vector3f.x;
                                        vector3f7.y = vector3f3.y + vector3f4.y + vector3f.y;
                                        vector3f7.z = vector3f3.z + vector3f4.z + vector3f.z;
                                        vector3f7.normalize();
                                        vector3f10.x = vector3f4.x + vector3f.x + vector3f2.x;
                                        vector3f10.y = vector3f4.y + vector3f.y + vector3f2.y;
                                        vector3f10.z = vector3f4.z + vector3f.z + vector3f2.z;
                                        vector3f10.normalize();
                                    } else {
                                        vector3f7.x = vector3f.x;
                                        vector3f7.y = vector3f.y;
                                        vector3f7.z = vector3f.z;
                                        vector3f10.x = vector3f.x + vector3f2.x;
                                        vector3f10.y = vector3f.y + vector3f2.y;
                                        vector3f10.z = vector3f.z + vector3f2.z;
                                        vector3f10.normalize();
                                    }
                                } else {
                                    vector3f3 = new Vector3f();
                                    vector3f4 = new Vector3f();
                                    vector3f7.x = vector3f.x;
                                    vector3f7.y = vector3f.y;
                                    vector3f7.z = vector3f.z;
                                    vector3f10.x = vector3f.x + vector3f2.x;
                                    vector3f10.y = vector3f.y + vector3f2.y;
                                    vector3f10.z = vector3f.z + vector3f2.z;
                                    vector3f10.normalize();
                                }
                                if (n11 + 1 < n5) {
                                    point3f3.x = this.outVerts[n6][n11 + 1].x;
                                    point3f3.y = this.outVerts[n6][n11 + 1].y;
                                    point3f3.z = 0.0f;
                                    point3f6.x = point3f3.x;
                                    point3f6.y = point3f3.y;
                                    point3f6.z = point3f3.z + this.fontExtrusion.length;
                                    this.getNormal(point3f2, point3f5, point3f3, vector3f5);
                                    this.getNormal(point3f3, point3f5, point3f6, vector3f6);
                                    f6 = vector3f2.dot(vector3f5);
                                    boolean bl4 = bl2 = f6 > f5;
                                    if (bl2) {
                                        vector3f8.x = vector3f.x + vector3f2.x + vector3f5.x;
                                        vector3f8.y = vector3f.y + vector3f2.y + vector3f5.y;
                                        vector3f8.z = vector3f.z + vector3f2.z + vector3f5.z;
                                        vector3f8.normalize();
                                        vector3f11.x = vector3f2.x + vector3f5.x + vector3f6.x;
                                        vector3f11.y = vector3f2.y + vector3f5.y + vector3f6.y;
                                        vector3f11.z = vector3f2.z + vector3f5.z + vector3f6.z;
                                        vector3f11.normalize();
                                    } else {
                                        vector3f8.x = vector3f.x + vector3f2.x;
                                        vector3f8.y = vector3f.y + vector3f2.y;
                                        vector3f8.z = vector3f.z + vector3f2.z;
                                        vector3f8.normalize();
                                        vector3f11.x = vector3f2.x;
                                        vector3f11.y = vector3f2.y;
                                        vector3f11.z = vector3f2.z;
                                    }
                                } else {
                                    vector3f8.x = vector3f.x + vector3f2.x;
                                    vector3f8.y = vector3f.y + vector3f2.y;
                                    vector3f8.z = vector3f.z + vector3f2.z;
                                    vector3f8.normalize();
                                    vector3f11.x = vector3f2.x;
                                    vector3f11.y = vector3f2.y;
                                    vector3f11.z = vector3f2.z;
                                }
                                triangleArray.setCoordinate(n7, point3f);
                                triangleArray.setNormal(n7, vector3f7);
                                triangleArray.setCoordinate(++n7, point3f4);
                                triangleArray.setNormal(n7, vector3f10);
                                triangleArray.setCoordinate(++n7, point3f2);
                                triangleArray.setNormal(n7, vector3f8);
                                triangleArray.setCoordinate(++n7, point3f2);
                                triangleArray.setNormal(n7, vector3f8);
                                triangleArray.setCoordinate(++n7, point3f4);
                                triangleArray.setNormal(n7, vector3f10);
                                triangleArray.setCoordinate(++n7, point3f5);
                                triangleArray.setNormal(n7, vector3f11);
                                ++n7;
                                vector3f3.x = vector3f.x;
                                vector3f3.y = vector3f.y;
                                vector3f3.z = vector3f.z;
                                vector3f4.x = vector3f2.x;
                                vector3f4.y = vector3f2.y;
                                vector3f4.z = vector3f2.z;
                                point3f.x = point3f2.x;
                                point3f.y = point3f2.y;
                                point3f.z = point3f2.z;
                                point3f4.x = point3f5.x;
                                point3f4.y = point3f5.y;
                                point3f4.z = point3f5.z;
                                ++n11;
                            }
                            vector3f3 = null;
                            vector3f4 = null;
                            ++n10;
                        }
                        ++n6;
                    }
                } else {
                    int n12 = 0;
                    Point3f point3f7 = new Point3f();
                    Point3f point3f8 = new Point3f();
                    Point3f point3f9 = new Point3f();
                    Vector3f vector3f13 = new Vector3f();
                    Vector3f vector3f14 = new Vector3f();
                    Vector3f vector3f15 = new Vector3f();
                    Vector3f vector3f16 = new Vector3f();
                    Vector3f vector3f17 = new Vector3f();
                    Vector3f vector3f18 = new Vector3f();
                    n6 = 0;
                    while (n6 < this.islandCounts.length) {
                        n10 = 0;
                        int n13 = 0;
                        n5 = 0;
                        n12 = 0;
                        while (n10 < this.islandCounts[n6].length) {
                            point3f.x = this.outVerts[n6][(n5 += this.islandCounts[n6][n10]) - 1].x;
                            point3f.y = this.outVerts[n6][n5 - 1].y;
                            point3f.z = 0.0f;
                            point3f4.x = point3f.x;
                            point3f4.y = point3f.y;
                            point3f4.z = point3f.z + this.fontExtrusion.length;
                            point3f3.x = this.outVerts[n6][n5 - 2].x;
                            point3f3.y = this.outVerts[n6][n5 - 2].y;
                            point3f3.z = 0.0f;
                            this.getNormal(point3f3, point3f4, point3f, vector3f14);
                            while (n13 < n5) {
                                point3f2.x = this.outVerts[n6][n13].x;
                                point3f2.y = this.outVerts[n6][n13].y;
                                point3f2.z = 0.0f;
                                point3f5.x = point3f2.x;
                                point3f5.y = point3f2.y;
                                point3f5.z = point3f2.z + this.fontExtrusion.length;
                                this.getNormal(point3f, point3f4, point3f2, vector3f15);
                                point3f3.x = this.outVerts[n6][n13 + 1 == n5 ? n12 : n13 + 1].x;
                                point3f3.y = this.outVerts[n6][n13 + 1 == n5 ? n12 : n13 + 1].y;
                                point3f3.z = 0.0f;
                                this.getNormal(point3f3, point3f2, point3f5, vector3f16);
                                vector3f17.x = vector3f14.x + vector3f15.x;
                                vector3f17.y = vector3f14.y + vector3f15.y;
                                vector3f17.z = vector3f14.z + vector3f15.z;
                                vector3f17.normalize();
                                vector3f18.x = vector3f16.x + vector3f15.x;
                                vector3f18.y = vector3f16.y + vector3f15.y;
                                vector3f18.z = vector3f16.z + vector3f15.z;
                                vector3f18.normalize();
                                point3f9.x = point3f.x;
                                point3f9.y = point3f.y;
                                point3f9.z = point3f.z;
                                point3f7.x = point3f2.x;
                                point3f7.y = point3f2.y;
                                point3f7.z = point3f2.z;
                                point3f8.x = point3f5.x;
                                point3f8.y = point3f5.y;
                                point3f8.z = point3f5.z;
                                int n14 = 1;
                                while (n14 < this.fontExtrusion.pnts.length) {
                                    point3f4.z = point3f5.z = this.fontExtrusion.pnts[n14].x;
                                    point3f4.x = point3f9.x + vector3f17.x * this.fontExtrusion.pnts[n14].y;
                                    point3f4.y = point3f9.y + vector3f17.y * this.fontExtrusion.pnts[n14].y;
                                    point3f5.x = point3f7.x + vector3f18.x * this.fontExtrusion.pnts[n14].y;
                                    point3f5.y = point3f7.y + vector3f18.y * this.fontExtrusion.pnts[n14].y;
                                    this.getNormal(point3f, point3f4, point3f2, vector3f);
                                    triangleArray.setCoordinate(n7, point3f);
                                    triangleArray.setNormal(n7, vector3f);
                                    triangleArray.setCoordinate(++n7, point3f4);
                                    triangleArray.setNormal(n7, vector3f);
                                    triangleArray.setCoordinate(++n7, point3f2);
                                    triangleArray.setNormal(n7, vector3f);
                                    this.getNormal(point3f2, point3f4, point3f5, vector3f);
                                    triangleArray.setCoordinate(++n7, point3f2);
                                    triangleArray.setNormal(n7, vector3f);
                                    triangleArray.setCoordinate(++n7, point3f4);
                                    triangleArray.setNormal(n7, vector3f);
                                    triangleArray.setCoordinate(++n7, point3f5);
                                    triangleArray.setNormal(n7, vector3f);
                                    ++n7;
                                    point3f.x = point3f4.x;
                                    point3f.y = point3f4.y;
                                    point3f.z = point3f4.z;
                                    point3f2.x = point3f5.x;
                                    point3f2.y = point3f5.y;
                                    point3f2.z = point3f5.z;
                                    ++n14;
                                }
                                point3f.x = point3f7.x;
                                point3f.y = point3f7.y;
                                point3f.z = point3f7.z;
                                point3f4.x = point3f8.x;
                                point3f4.y = point3f8.y;
                                point3f4.z = point3f8.z;
                                vector3f14.x = vector3f15.x;
                                vector3f14.y = vector3f15.y;
                                vector3f14.z = vector3f15.z;
                                ++n13;
                            }
                            n12 = n5;
                            ++n10;
                        }
                        ++n6;
                    }
                }
            }
            this.islandCounts = null;
            this.outVerts = null;
            this.fontData[n] = triangleArray;
        }
    }
}

