/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.FogRetained;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;

class BoundingLeafRetained
extends LeafRetained {
    static final int REGION_CHANGED = 1;
    static final Integer REGION_CHANGED_MESSAGE = new Integer(1);
    Bounds region = null;
    Bounds transformedRegion = null;
    BoundingLeafRetained mirrorBoundingLeaf;
    ArrayList users = new ArrayList();
    int targetThreads = 4224;
    int transformTargetThreads = 4160;

    BoundingLeafRetained() {
        this.nodeType = 25;
    }

    synchronized void addUser(LeafRetained leafRetained) {
        this.users.add(leafRetained);
        if (leafRetained.nodeType == 1 || leafRetained.nodeType == 2 || leafRetained.nodeType == 27 || leafRetained instanceof FogRetained || leafRetained instanceof LightRetained) {
            this.transformTargetThreads |= 0x80;
        } else if (leafRetained instanceof BehaviorRetained) {
            this.transformTargetThreads |= 0x100;
            this.targetThreads |= 0x100;
        } else if (leafRetained instanceof SoundRetained || leafRetained.nodeType == 15) {
            this.transformTargetThreads |= 0x200;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive();
        setLiveState.transformBLTargets.add(this);
    }

    void createBoundingLeaf() {
        this.nodeType = 25;
        this.mirrorBoundingLeaf = new BoundingLeafRetained();
    }

    Bounds getRegion() {
        return this.region != null ? (Bounds)this.region.clone() : null;
    }

    void initRegion(Bounds bounds) {
        this.region = bounds != null ? (Bounds)bounds.clone() : null;
    }

    synchronized void removeUser(LeafRetained leafRetained) {
        this.users.remove(this.users.indexOf(leafRetained));
        this.transformTargetThreads = 4096;
        this.targetThreads = 4224;
        int n = 0;
        while (n < this.users.size()) {
            LeafRetained leafRetained2 = (LeafRetained)this.users.get(n);
            if (leafRetained2.nodeType == 1 || leafRetained2.nodeType == 2 || leafRetained2.nodeType == 27 || leafRetained2 instanceof FogRetained || leafRetained2 instanceof LightRetained) {
                this.transformTargetThreads |= 0x80;
            } else if (leafRetained2.nodeType == 17) {
                this.transformTargetThreads |= 0x100;
                this.targetThreads |= 0x100;
            } else if (leafRetained2 instanceof SoundRetained || leafRetained2.nodeType == 15) {
                this.transformTargetThreads |= 0x200;
            }
            ++n;
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BoundingLeafRetained0"));
        }
        setLiveState.transformBLTargets.add(this.mirrorBoundingLeaf);
        this.mirrorBoundingLeaf.currentLocalToVworld = new Transform3D[1];
        this.mirrorBoundingLeaf.lastLocalToVworld = new Transform3D[1];
        this.mirrorBoundingLeaf.currentLocalToVworld[0] = this.currentLocalToVworld[0];
        this.mirrorBoundingLeaf.lastLocalToVworld[0] = this.lastLocalToVworld[0];
        this.mirrorBoundingLeaf.parent = this.parent;
        if (this.region != null) {
            this.mirrorBoundingLeaf.region = (Bounds)this.region.clone();
            this.mirrorBoundingLeaf.transformedRegion = (Bounds)this.region.clone();
            this.mirrorBoundingLeaf.transformedRegion.transform(this.mirrorBoundingLeaf.currentLocalToVworld[0]);
        } else {
            this.mirrorBoundingLeaf.region = null;
            this.mirrorBoundingLeaf.transformedRegion = null;
        }
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.mirrorBoundingLeaf.clearCompositeSwitchMask();
                    this.mirrorBoundingLeaf.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.boundingLeafNodes.add(this.mirrorBoundingLeaf);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.mirrorBoundingLeaf.clearCompositeSwitchMask();
            this.mirrorBoundingLeaf.isNewSwitchLeaf = true;
            ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.boundingLeafNodes.add(this.mirrorBoundingLeaf);
        }
        super.markAsLive();
    }

    synchronized void setRegion(Bounds bounds) {
        this.initRegion(bounds);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = this.mirrorBoundingLeaf.targetThreads;
        j3dMessage.type = 23;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = REGION_CHANGED_MESSAGE;
        j3dMessage.args[2] = bounds != null ? (Bounds)bounds.clone() : null;
        j3dMessage.args[3] = this.mirrorBoundingLeaf.users.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    synchronized void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        Bounds bounds = (Bounds)objectArray[2];
        if ((n & 1) != 0) {
            this.mirrorBoundingLeaf.region = bounds;
            if (bounds != null) {
                this.mirrorBoundingLeaf.transformedRegion = (Bounds)bounds.clone();
                Transform3D transform3D = this.mirrorBoundingLeaf.currentLocalToVworld[0];
                this.mirrorBoundingLeaf.transformedRegion.transform(bounds, transform3D);
            } else {
                this.mirrorBoundingLeaf.transformedRegion = null;
            }
        }
    }

    void updateImmediateTransformChange() {
        Transform3D transform3D = this.currentLocalToVworld[0];
        if (this.region != null) {
            this.transformedRegion.transform(this.region, transform3D);
        }
    }
}

