/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.VirtualUniverse;

class TextureBin
implements ObjectUpdate {
    TextureUnitStateRetained[] texUnitState = null;
    int lastActiveTexUnitIndex;
    int numActiveTexUnit;
    int numImages;
    ImageComponentRetained[] images = null;
    RenderBin renderBin = null;
    AttributeBin attributeBin = null;
    TextureBin next = null;
    TextureBin prev = null;
    int equivalent = 0;
    RenderMolecule renderMoleculeList = null;
    ArrayList addRMs = new ArrayList();
    boolean onUpdateList = false;
    boolean inTextureBinList = false;

    TextureBin(TextureUnitStateRetained[] textureUnitStateRetainedArray, RenderBin renderBin) {
        this.renderBin = renderBin;
        this.reset(textureUnitStateRetainedArray);
    }

    void addRenderMolecule(RenderMolecule renderMolecule, RenderBin renderBin) {
        renderMolecule.textureBin = this;
        this.addRMs.add(renderMolecule);
        if (!this.onUpdateList) {
            this.onUpdateList = true;
            renderBin.objUpdateList.add(this);
        }
    }

    boolean equals(TextureUnitStateRetained[] textureUnitStateRetainedArray) {
        boolean bl = false;
        if (this.texUnitState == textureUnitStateRetainedArray) {
            return true;
        }
        if (this.texUnitState == null || textureUnitStateRetainedArray == null) {
            return false;
        }
        if (textureUnitStateRetainedArray.length != this.texUnitState.length) {
            return false;
        }
        int n = 0;
        while (n < this.texUnitState.length) {
            if (this.texUnitState[n] == null ? textureUnitStateRetainedArray[n] != null : !this.texUnitState[n].equivalent(textureUnitStateRetainedArray[n])) {
                return false;
            }
            ++n;
        }
        if (!this.inTextureBinList) {
            this.renderBin.addTextureBin(this);
            this.inTextureBinList = true;
        }
        return true;
    }

    void insertRenderMolecule(RenderMolecule renderMolecule) {
        RenderMolecule renderMolecule2 = this.renderMoleculeList;
        while (renderMolecule2 != null) {
            if (renderMolecule2.definingMaterial == renderMolecule.definingMaterial || renderMolecule2.definingMaterial != null && renderMolecule2.definingMaterial.equivalent(renderMolecule.definingMaterial)) {
                renderMolecule.next = renderMolecule2;
                renderMolecule.prev = renderMolecule2.prev;
                if (renderMolecule2.prev == null) {
                    this.renderMoleculeList = renderMolecule;
                } else {
                    renderMolecule2.prev.next = renderMolecule;
                }
                renderMolecule2.prev = renderMolecule;
                renderMolecule.checkEquivalenceWithBothNeighbors();
                return;
            }
            renderMolecule2 = renderMolecule2.next;
        }
        renderMolecule.next = this.renderMoleculeList;
        this.renderMoleculeList.prev = renderMolecule;
        this.renderMoleculeList = renderMolecule;
        renderMolecule.checkEquivalenceWithBothNeighbors();
    }

    void removeRenderMolecule(RenderMolecule renderMolecule) {
        renderMolecule.textureBin = null;
        if (renderMolecule.prev == null) {
            this.renderMoleculeList = renderMolecule.next;
            if (renderMolecule.next != null) {
                renderMolecule.next.prev = null;
                renderMolecule.next.dirtyAttrsAcrossRms = 63;
            }
        } else {
            renderMolecule.prev.next = renderMolecule.next;
            if (renderMolecule.next != null) {
                renderMolecule.next.prev = renderMolecule.prev;
                renderMolecule.next.checkEquivalenceWithLeftNeighbor();
            }
        }
        renderMolecule.prev = null;
        renderMolecule.next = null;
        this.renderBin.removeRenderMolecule(renderMolecule);
        if (this.renderMoleculeList == null && this.addRMs.size() == 0) {
            if (this.inTextureBinList) {
                this.inTextureBinList = false;
                this.renderBin.removeTextureBin(this);
            }
            this.attributeBin.removeTextureBin(this);
            this.texUnitState = null;
            int n = 0;
            while (n < this.numImages) {
                this.images[n] = null;
                ++n;
            }
        }
    }

    void render(Canvas3D canvas3D) {
        boolean bl = false;
        boolean bl2 = false;
        canvas3D.textureBin = this;
        if (this.texUnitState == null) {
            if (canvas3D.multiTexAccelerated) {
                int n = 0;
                while (n < canvas3D.numTexUnitSupported) {
                    canvas3D.resetTexture(canvas3D.ctx, n);
                    ++n;
                }
            } else {
                canvas3D.resetTexture(canvas3D.ctx, -1);
            }
            this.render(canvas3D, 0);
        } else {
            int n;
            bl = this.numActiveTexUnit != 1 || this.lastActiveTexUnitIndex != 0;
            boolean bl3 = false;
            if (VirtualUniverse.mc.isD3D()) {
                n = 0;
                while (n < this.texUnitState.length) {
                    if (this.texUnitState[n] != null && this.texUnitState[n].isTextureEnabled() && this.texUnitState[n].needBlend2Pass()) {
                        bl3 = true;
                        break;
                    }
                    ++n;
                }
            }
            if (canvas3D.numTexUnitSupported >= this.texUnitState.length && canvas3D.multiTexAccelerated && !bl3) {
                if (VirtualUniverse.mc.isD3D()) {
                    n = 0;
                    int n2 = 0;
                    while (n2 < this.texUnitState.length) {
                        if (this.texUnitState[n2] != null && this.texUnitState[n2].isTextureEnabled()) {
                            this.setTexUnitStateMap(canvas3D.ctx, n2, n);
                            this.texUnitState[n2].updateNative(n++, canvas3D, this.renderBin, bl, false);
                            if (!bl2) {
                                bl2 = this.texUnitState[n2].isSpecularDisabled();
                            }
                        }
                        ++n2;
                    }
                    int n3 = n;
                    while (n3 < this.texUnitState.length) {
                        canvas3D.resetTexture(canvas3D.ctx, n3);
                        this.setTexUnitStateMap(canvas3D.ctx, n3, -1);
                        ++n3;
                    }
                } else {
                    n = 0;
                    while (n < this.texUnitState.length) {
                        if (this.texUnitState[n] != null && this.texUnitState[n].isTextureEnabled()) {
                            this.texUnitState[n].updateNative(n, canvas3D, this.renderBin, bl, false);
                        } else {
                            canvas3D.resetTexture(canvas3D.ctx, n);
                        }
                        ++n;
                    }
                }
                if (bl2) {
                    canvas3D.setSpecular(canvas3D.ctx, false);
                    this.render(canvas3D, -1);
                    canvas3D.setSpecular(canvas3D.ctx, true);
                } else {
                    this.render(canvas3D, -1);
                }
            } else {
                n = 0;
                boolean bl4 = false;
                boolean bl5 = false;
                RenderMolecule renderMolecule = this.renderMoleculeList;
                if (this.numActiveTexUnit < 1) {
                    canvas3D.resetTexture(canvas3D.ctx, -1);
                    this.render(canvas3D, 0);
                } else if (this.numActiveTexUnit == 1) {
                    this.texUnitState[this.lastActiveTexUnitIndex].updateNative(-1, canvas3D, this.renderBin, bl, false);
                    if (!this.texUnitState[this.lastActiveTexUnitIndex].needBlend2Pass()) {
                        if (this.texUnitState[this.lastActiveTexUnitIndex].isSpecularDisabled()) {
                            canvas3D.setSpecular(canvas3D.ctx, false);
                            this.render(canvas3D, this.lastActiveTexUnitIndex);
                            canvas3D.setSpecular(canvas3D.ctx, true);
                        } else {
                            this.render(canvas3D, this.lastActiveTexUnitIndex);
                        }
                    } else {
                        boolean bl6 = bl5 = this.attributeBin.environmentSet.fog != null;
                        if (bl5) {
                            canvas3D.setFogEnableFlag(canvas3D.ctx, false);
                        }
                        this.render(canvas3D, this.lastActiveTexUnitIndex);
                        this.texUnitState[this.lastActiveTexUnitIndex].texAttrs.updateBlend2Pass(canvas3D.ctx);
                        canvas3D.setSpecular(canvas3D.ctx, false);
                        if (bl5) {
                            canvas3D.setFogEnableFlag(canvas3D.ctx, true);
                        }
                        canvas3D.setDepthFunc(canvas3D.ctx, 1);
                        this.render(canvas3D, this.lastActiveTexUnitIndex);
                        canvas3D.setSpecular(canvas3D.ctx, true);
                        this.texUnitState[this.lastActiveTexUnitIndex].texAttrs.restoreBlend1Pass(canvas3D.ctx);
                        canvas3D.setDepthFunc(canvas3D.ctx, 0);
                    }
                } else {
                    bl5 = this.attributeBin.environmentSet.fog != null;
                    while (renderMolecule != null) {
                        bl4 = false;
                        n = 0;
                        if (bl5) {
                            canvas3D.setFogEnableFlag(canvas3D.ctx, false);
                        }
                        int n4 = 0;
                        while (n4 < this.texUnitState.length) {
                            if (this.texUnitState[n4] != null && this.texUnitState[n4].isTextureEnabled()) {
                                this.texUnitState[n4].updateNative(-1, canvas3D, this.renderBin, bl, bl4);
                                if (bl4 && n == 0) {
                                    canvas3D.setDepthFunc(canvas3D.ctx, 1);
                                    n = 1;
                                }
                                bl4 = true;
                                if (!this.texUnitState[n4].needBlend2Pass()) {
                                    if (n4 == this.lastActiveTexUnitIndex && bl5) {
                                        canvas3D.setFogEnableFlag(canvas3D.ctx, true);
                                    }
                                    if (this.texUnitState[n4].isSpecularDisabled()) {
                                        canvas3D.setSpecular(canvas3D.ctx, false);
                                        renderMolecule.render(canvas3D, n4);
                                        canvas3D.setSpecular(canvas3D.ctx, true);
                                    } else {
                                        renderMolecule.render(canvas3D, n4);
                                    }
                                } else {
                                    this.render(canvas3D, n4);
                                    this.texUnitState[n4].texAttrs.updateBlend2Pass(canvas3D.ctx);
                                    canvas3D.setSpecular(canvas3D.ctx, false);
                                    if (n == 0) {
                                        canvas3D.setDepthFunc(canvas3D.ctx, 1);
                                        n = 1;
                                    }
                                    if (n4 == this.lastActiveTexUnitIndex && bl5) {
                                        canvas3D.setFogEnableFlag(canvas3D.ctx, true);
                                    }
                                    this.render(canvas3D, n4);
                                    canvas3D.setSpecular(canvas3D.ctx, true);
                                    this.texUnitState[n4].texAttrs.restoreBlend1Pass(canvas3D.ctx);
                                }
                            }
                            ++n4;
                        }
                        if (n != 0) {
                            canvas3D.setDepthFunc(canvas3D.ctx, 0);
                            renderMolecule.renderTransparencyAttributes(canvas3D);
                        }
                        renderMolecule = renderMolecule.next;
                    }
                }
            }
        }
        canvas3D.canvasDirty &= 0xFFFFFBFF;
    }

    void render(Canvas3D canvas3D, int n) {
        RenderMolecule renderMolecule = this.renderMoleculeList;
        while (renderMolecule != null) {
            renderMolecule.render(canvas3D, n);
            renderMolecule = renderMolecule.next;
        }
    }

    void reset(TextureUnitStateRetained[] textureUnitStateRetainedArray) {
        int n = 0;
        this.prev = null;
        this.next = null;
        this.onUpdateList = false;
        this.inTextureBinList = false;
        this.renderMoleculeList = null;
        this.numActiveTexUnit = 0;
        this.lastActiveTexUnitIndex = 0;
        if (textureUnitStateRetainedArray != null) {
            if (this.texUnitState == null || this.texUnitState.length != textureUnitStateRetainedArray.length) {
                this.texUnitState = new TextureUnitStateRetained[textureUnitStateRetainedArray.length];
            }
            int n2 = 0;
            while (n2 < textureUnitStateRetainedArray.length) {
                if (textureUnitStateRetainedArray[n2] == null) {
                    this.texUnitState[n2] = null;
                } else {
                    if (this.texUnitState[n2] == null) {
                        this.texUnitState[n2] = new TextureUnitStateRetained();
                    }
                    this.texUnitState[n2].set(textureUnitStateRetainedArray[n2]);
                    if (this.texUnitState[n2].isTextureEnabled()) {
                        ++this.numActiveTexUnit;
                        this.lastActiveTexUnitIndex = n2;
                    }
                    if (this.texUnitState[n2].texture != null && this.texUnitState[n2].texture instanceof Texture2DRetained) {
                        n += this.texUnitState[n2].texture.numLevels;
                    }
                }
                ++n2;
            }
            if (n > this.numImages) {
                this.images = new ImageComponentRetained[n];
            }
            this.numImages = n;
            n = 0;
            if (!this.inTextureBinList) {
                this.renderBin.addTextureBin(this);
                this.inTextureBinList = true;
            }
        } else {
            this.numImages = 0;
            this.texUnitState = null;
        }
    }

    native void setTexUnitStateMap(int var1, int var2, int var3);

    public void updateObject() {
        if (this.addRMs.size() > 0) {
            RenderMolecule renderMolecule = (RenderMolecule)this.addRMs.get(0);
            if (this.renderMoleculeList == null) {
                this.renderMoleculeList = renderMolecule;
            } else {
                this.insertRenderMolecule(renderMolecule);
            }
            renderMolecule.evalAlphaUsage();
            int n = 1;
            while (n < this.addRMs.size()) {
                renderMolecule = (RenderMolecule)this.addRMs.get(n);
                this.insertRenderMolecule(renderMolecule);
                renderMolecule.evalAlphaUsage();
                ++n;
            }
        }
        this.addRMs.clear();
        this.onUpdateList = false;
    }
}

