/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Font3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.TriangleArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class Text3DRetained
extends GeometryRetained {
    Font3D font3D = null;
    String string = null;
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    int alignment = 1;
    int path = 1;
    float charSpacing = 0.0f;
    int numChars = 0;
    static final int targetThreads = 8384;
    int[] charIndex;
    Transform3D[] charTransforms = new Transform3D[0];
    GeometryRetained[] geometryList = new GeometryRetained[0];
    Point3d lower = new Point3d();
    Point3d upper = new Point3d();
    ArrayList newGeometryAtomList = new ArrayList();
    ArrayList oldGeometryAtomList = new ArrayList();
    Transform3D vpcToEc;
    Transform3D drawTransform;
    static char[] unicodeBlocks;

    static {
        char[] cArray = new char[138];
        cArray[1] = 127;
        cArray[2] = 128;
        cArray[3] = 255;
        cArray[4] = 256;
        cArray[5] = 383;
        cArray[6] = 384;
        cArray[7] = 591;
        cArray[8] = 592;
        cArray[9] = 687;
        cArray[10] = 688;
        cArray[11] = 767;
        cArray[12] = 768;
        cArray[13] = 879;
        cArray[14] = 880;
        cArray[15] = 1023;
        cArray[16] = 1024;
        cArray[17] = 1279;
        cArray[18] = 1328;
        cArray[19] = 1423;
        cArray[20] = 1424;
        cArray[21] = 1535;
        cArray[22] = 1536;
        cArray[23] = 1791;
        cArray[24] = 2304;
        cArray[25] = 2431;
        cArray[26] = 2432;
        cArray[27] = 2559;
        cArray[28] = 2560;
        cArray[29] = 2687;
        cArray[30] = 2688;
        cArray[31] = 2815;
        cArray[32] = 2816;
        cArray[33] = 2943;
        cArray[34] = 2944;
        cArray[35] = 3071;
        cArray[36] = 3072;
        cArray[37] = 3199;
        cArray[38] = 3200;
        cArray[39] = 3327;
        cArray[40] = 3328;
        cArray[41] = 3455;
        cArray[42] = 3584;
        cArray[43] = 3711;
        cArray[44] = 3712;
        cArray[45] = 3839;
        cArray[46] = 3840;
        cArray[47] = 4031;
        cArray[48] = 4256;
        cArray[49] = 4351;
        cArray[50] = 4352;
        cArray[51] = 4607;
        cArray[52] = 7680;
        cArray[53] = 7935;
        cArray[54] = 7936;
        cArray[55] = 8191;
        cArray[56] = 8192;
        cArray[57] = 8303;
        cArray[58] = 8304;
        cArray[59] = 8351;
        cArray[60] = 8352;
        cArray[61] = 8399;
        cArray[62] = 8400;
        cArray[63] = 8447;
        cArray[64] = 8448;
        cArray[65] = 8527;
        cArray[66] = 8528;
        cArray[67] = 8591;
        cArray[68] = 8592;
        cArray[69] = 8703;
        cArray[70] = 8704;
        cArray[71] = 8959;
        cArray[72] = 8960;
        cArray[73] = 9215;
        cArray[74] = 9216;
        cArray[75] = 9279;
        cArray[76] = 9280;
        cArray[77] = 9311;
        cArray[78] = 9312;
        cArray[79] = 9471;
        cArray[80] = 9472;
        cArray[81] = 9599;
        cArray[82] = 9600;
        cArray[83] = 9631;
        cArray[84] = 9632;
        cArray[85] = 9727;
        cArray[86] = 9728;
        cArray[87] = 9983;
        cArray[88] = 9984;
        cArray[89] = 10175;
        cArray[90] = 12288;
        cArray[91] = 12351;
        cArray[92] = 12352;
        cArray[93] = 12447;
        cArray[94] = 12448;
        cArray[95] = 12543;
        cArray[96] = 12544;
        cArray[97] = 12591;
        cArray[98] = 12592;
        cArray[99] = 12687;
        cArray[100] = 12688;
        cArray[101] = 12703;
        cArray[102] = 12800;
        cArray[103] = 13055;
        cArray[104] = 13056;
        cArray[105] = 13311;
        cArray[106] = 19968;
        cArray[107] = 40959;
        cArray[108] = 44032;
        cArray[109] = 55203;
        cArray[110] = 55296;
        cArray[111] = 56191;
        cArray[112] = 56192;
        cArray[113] = 56319;
        cArray[114] = 56320;
        cArray[115] = 57343;
        cArray[116] = 57344;
        cArray[117] = 63743;
        cArray[118] = 63744;
        cArray[119] = 64255;
        cArray[120] = 64256;
        cArray[121] = 64335;
        cArray[122] = 64336;
        cArray[123] = 65023;
        cArray[124] = 65056;
        cArray[125] = 65071;
        cArray[126] = 65072;
        cArray[127] = 65103;
        cArray[128] = 65104;
        cArray[129] = 65135;
        cArray[130] = 65136;
        cArray[131] = 65279;
        cArray[132] = 65280;
        cArray[133] = 65519;
        cArray[134] = 65279;
        cArray[135] = 65279;
        cArray[136] = 65520;
        cArray[137] = 65535;
        unicodeBlocks = cArray;
    }

    Text3DRetained() {
        this.geoType = 16;
    }

    synchronized void computeBoundingBox() {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3f vector3f = new Vector3f((Tuple3f)this.position);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        point3d.set((Tuple3f)vector3f);
        point3d2.set((Tuple3f)vector3f);
        if (this.numChars != 0) {
            Rectangle2D.Float float_;
            GlyphMetrics glyphMetrics;
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[0]]).getGlyphMetrics(0);
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                point3d2.x += (double)float_.width;
                point3d2.y += (double)float_.height;
            }
            int n3 = 1;
            while (n3 < n2) {
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[n]]).getGlyphMetrics(0);
                f = glyphMetrics.getAdvance();
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                f += this.charSpacing;
                f2 = this.font3D.charHeights[this.charIndex[n]];
                switch (this.path) {
                    case 1: {
                        point3d2.x += (double)f;
                        if (!(point3d2.y < (double)(f2 + vector3f.y))) break;
                        point3d2.y = vector3f.y + f2;
                        break;
                    }
                    case 0: {
                        point3d.x -= (double)f;
                        if (!(point3d2.y < (double)(f2 + vector3f.y))) break;
                        point3d2.y = vector3f.y + f2;
                        break;
                    }
                    case 2: {
                        point3d2.y += (double)f2;
                        if (!(point3d2.x < (double)(float_.width + vector3f.x))) break;
                        point3d2.x = vector3f.x + float_.width;
                        break;
                    }
                    case 3: {
                        point3d.y -= (double)f2;
                        if (!(point3d2.x < (double)(float_.width + vector3f.x))) break;
                        point3d2.x = vector3f.x + float_.width;
                        break;
                    }
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d = point3d2.x - point3d.x;
                double d2 = point3d2.y - point3d.y;
                if (this.alignment == 0) {
                    d *= 0.5;
                    d2 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        point3d.x -= d;
                        point3d2.x -= d;
                        break;
                    }
                    case 0: {
                        point3d.x += d;
                        point3d2.x += d;
                        break;
                    }
                    case 2: {
                        point3d.y -= d2;
                        point3d2.y -= d2;
                        break;
                    }
                    case 3: {
                        point3d.y += d2;
                        point3d2.y += d2;
                        break;
                    }
                }
            }
        }
        point3d.z = 0.0;
        point3d2.z = this.font3D == null || this.font3D.fontExtrusion == null ? point3d.z : point3d.z + (double)this.font3D.fontExtrusion.length;
    }

    void execute(int n, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, boolean bl4, int n2) {
    }

    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, boolean bl4, int n) {
        Transform3D transform3D = new Transform3D();
        int n2 = 0;
        while (n2 < this.geometryList.length) {
            transform3D.set(this.drawTransform);
            transform3D.mul(this.charTransforms[n2]);
            canvas3D.setModelViewMatrix(canvas3D.ctx, this.vpcToEc.mat, transform3D.mat);
            this.geometryList[n2].execute(canvas3D.ctx, renderAtom, bl, bl2, f, bl3, bl4, n);
            ++n2;
        }
    }

    final int getAlignment() {
        return this.alignment;
    }

    final void getBoundingBox(BoundingBox boundingBox) {
        Text3DRetained text3DRetained = this;
        synchronized (text3DRetained) {
            boundingBox.setLower(this.lower);
            boundingBox.setUpper(this.upper);
        }
    }

    final float getCharacterSpacing() {
        return this.charSpacing;
    }

    final Font3D getFont3D() {
        return this.font3D;
    }

    final int getPath() {
        return this.path;
    }

    final void getPosition(Point3f point3f) {
        point3f.set((Tuple3f)this.position);
    }

    final String getString() {
        return this.string;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        Transform3D transform3D2 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D2.set(transform3D);
                transform3D2.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D2, bounds)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D2, bounds)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D2, bounds)) {
                        return true;
                    }
                } else {
                    System.out.println("Text3D - collision intersect : Geometry type not supported.");
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, PickRay pickRay, double[] dArray) {
        Transform3D transform3D2 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D2.set(transform3D);
                transform3D2.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D2, pickRay, dArray)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D2, pickRay, dArray)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D2, pickRay, dArray)) {
                        return true;
                    }
                } else {
                    throw new RuntimeException(J3dI18N.getString("Text3DRetained1"));
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, PickShape pickShape) {
        Transform3D transform3D2 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D2.set(transform3D);
                transform3D2.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D2, pickShape)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D2, pickShape)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D2, pickShape)) {
                        return true;
                    }
                } else {
                    throw new RuntimeException(J3dI18N.getString("Text3DRetained1"));
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Transform3D transform3D3 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D3.set(transform3D);
                transform3D3.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D3, transform3D2, geometryRetained)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D3, transform3D2, geometryRetained)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D3, transform3D2, geometryRetained)) {
                        return true;
                    }
                } else {
                    System.out.println("Text3D - collision intersect : Geometry type not supported.");
                }
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Transform3D transform3D2 = new Transform3D();
        GeometryArrayRetained geometryArrayRetained = null;
        int n = 0;
        while (n < this.numChars) {
            if (this.font3D.fontData[this.charIndex[n]] != null) {
                geometryArrayRetained = (GeometryArrayRetained)this.font3D.fontData[this.charIndex[n]].retained;
                transform3D2.set(transform3D);
                transform3D2.mul(this.charTransforms[n]);
                if (geometryArrayRetained instanceof TriangleArrayRetained) {
                    if (((TriangleArrayRetained)geometryArrayRetained).intersect(transform3D2, point3dArray)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleStripArrayRetained) {
                    if (((TriangleStripArrayRetained)geometryArrayRetained).intersect(transform3D2, point3dArray)) {
                        return true;
                    }
                } else if (geometryArrayRetained instanceof TriangleFanArrayRetained) {
                    if (((TriangleFanArrayRetained)geometryArrayRetained).intersect(transform3D2, point3dArray)) {
                        return true;
                    }
                } else {
                    System.out.println("Text3D - collision intersect : Geometry type not supported.");
                }
            }
            ++n;
        }
        return false;
    }

    final void sendDataChangedMessage() {
        ArrayList arrayList = new ArrayList();
        ArrayList<GeometryAtom> arrayList2 = new ArrayList<GeometryAtom>();
        if (this.source.isLive()) {
            ArrayList arrayList3 = this.universeList;
            synchronized (arrayList3) {
                int n = this.universeList.size();
                J3dMessage[] j3dMessageArray = new J3dMessage[n];
                int n2 = 0;
                while (n2 < n) {
                    j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                    j3dMessageArray[n2].type = 26;
                    j3dMessageArray[n2].threads = 8384;
                    ArrayList arrayList4 = (ArrayList)this.userLists.get(n2);
                    this.newGeometryAtomList.clear();
                    this.oldGeometryAtomList.clear();
                    int n3 = 0;
                    while (n3 < arrayList4.size()) {
                        arrayList.clear();
                        arrayList2.clear();
                        Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList4.get(n3);
                        int n4 = 0;
                        while (n4 < shape3DRetained.geometryList.size()) {
                            GeometryRetained geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n4);
                            if (geometryRetained == this) break;
                            ++n4;
                        }
                        if (n4 < shape3DRetained.geometryList.size()) {
                            ArrayList arrayList5 = Shape3DRetained.getGeomAtomsList(shape3DRetained, n4);
                            this.oldGeometryAtomList.addAll(arrayList5);
                            arrayList.addAll(arrayList5);
                            GeometryAtom[] geometryAtomArray = new GeometryAtom[this.geometryList.length];
                            int n5 = 0;
                            while (n5 < geometryAtomArray.length) {
                                geometryAtomArray[n5] = new GeometryAtom();
                                if (this.geometryList[n5] != null) {
                                    geometryAtomArray[n5].geometry = this.geometryList[n5];
                                    if (shape3DRetained.boundsAutoCompute) {
                                        geometryAtomArray[n5].bounds = (Bounds)geometryAtomArray[n5].geometry.geoBounds.clone();
                                        geometryAtomArray[n5].bounds.transform(geometryAtomArray[n5].bounds, this.charTransforms[n5]);
                                    } else {
                                        geometryAtomArray[n5].bounds = shape3DRetained.localBounds;
                                    }
                                }
                                geometryAtomArray[n5].locale = shape3DRetained.locale;
                                geometryAtomArray[n5].geoType = this.geoType;
                                geometryAtomArray[n5].currentLocalTransform = this.charTransforms[n5];
                                geometryAtomArray[n5].lastLocalTransform = this.charTransforms[n5];
                                geometryAtomArray[n5].vwcBounds = new BoundingBox();
                                geometryAtomArray[n5].source = shape3DRetained;
                                geometryAtomArray[n5].evalAlphaEditable();
                                if (shape3DRetained.inOrderedGroup) {
                                    geometryAtomArray[n5].orderedGroupsPath = shape3DRetained.orderedGroupsPath;
                                    geometryAtomArray[n5].orderedChildIdsPath = shape3DRetained.orderedChildIdsPath;
                                }
                                this.newGeometryAtomList.add(geometryAtomArray[n5]);
                                arrayList2.add(geometryAtomArray[n5]);
                                ++n5;
                            }
                            if (shape3DRetained.parentList != null) {
                                n5 = 0;
                                while (n5 < shape3DRetained.parentList.size()) {
                                    TransformGroupRetained transformGroupRetained = (TransformGroupRetained)shape3DRetained.parentList.get(n5);
                                    transformGroupRetained.updateTargets(arrayList, arrayList2);
                                    ++n5;
                                }
                            }
                            Shape3DRetained.setGeomAtomsList(shape3DRetained, n4, geometryAtomArray);
                        }
                        ++n3;
                    }
                    j3dMessageArray[n2].args[0] = this.oldGeometryAtomList.toArray();
                    j3dMessageArray[n2].args[1] = this.newGeometryAtomList.toArray();
                    j3dMessageArray[n2].universe = (VirtualUniverse)this.universeList.get(n2);
                    ++n2;
                }
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
        }
    }

    final void sendTransformChangedMessage() {
        ArrayList arrayList = new ArrayList();
        if (this.source.isLive()) {
            ArrayList arrayList2 = this.universeList;
            synchronized (arrayList2) {
                int n = this.universeList.size();
                J3dMessage[] j3dMessageArray = new J3dMessage[n];
                int n2 = 0;
                while (n2 < n) {
                    j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                    j3dMessageArray[n2].type = 25;
                    j3dMessageArray[n2].threads = 8384;
                    ArrayList arrayList3 = (ArrayList)this.userLists.get(n2);
                    int n3 = 0;
                    while (n3 < arrayList3.size()) {
                        Shape3DRetained shape3DRetained = (Shape3DRetained)arrayList3.get(n3);
                        int n4 = 0;
                        while (n4 < shape3DRetained.geometryList.size()) {
                            GeometryRetained geometryRetained = (GeometryRetained)shape3DRetained.geometryList.get(n4);
                            if (geometryRetained == this) break;
                            ++n4;
                        }
                        if (n4 < shape3DRetained.geometryList.size()) {
                            arrayList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained, n4));
                        }
                        ++n3;
                    }
                    j3dMessageArray[n2].args[0] = arrayList.toArray();
                    j3dMessageArray[n2].args[1] = this.charTransforms;
                    j3dMessageArray[n2].universe = (VirtualUniverse)this.universeList.get(n2);
                    ++n2;
                }
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
        }
    }

    final void setAlignment(int n) {
        this.alignment = n;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final void setCharacterSpacing(float f) {
        this.charSpacing = f;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final void setFont3D(Font3D font3D) {
        this.font3D = font3D;
        this.updateCharacterData();
        this.sendDataChangedMessage();
    }

    void setLive(boolean bl, int n) {
        this.updateCharacterData();
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    void setModelViewMatrix(Transform3D transform3D, Transform3D transform3D2) {
        this.vpcToEc = transform3D;
        this.drawTransform = transform3D2;
    }

    final void setPath(int n) {
        this.path = n;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final void setPosition(Point3f point3f) {
        this.position.set((Tuple3f)point3f);
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    final void setString(String string) {
        this.string = string;
        this.numChars = string == null ? 0 : string.length();
        this.updateCharacterData();
        this.sendDataChangedMessage();
    }

    void update() {
    }

    final synchronized void updateCharacterData() {
        int n = unicodeBlocks.length - 2;
        char c = '\u0000';
        this.charIndex = new int[this.numChars];
        this.geometryList = new GeometryArrayRetained[this.numChars];
        if (this.numChars != 0 && this.font3D != null) {
            char[] cArray = new char[this.numChars];
            this.string.getChars(0, this.numChars, cArray, 0);
            int n2 = 0;
            while (n2 < n) {
                if (cArray[0] >= unicodeBlocks[n2] && cArray[0] < unicodeBlocks[n2 + 1]) {
                    c = unicodeBlocks[n2];
                    break;
                }
                n2 += 2;
            }
            n2 = 0;
            while (n2 < this.numChars) {
                cArray[n2] = (char)(cArray[n2] - c);
                this.charIndex[n2] = cArray[n2] >= this.font3D.numGlyphs || cArray[n2] < '\u0000' ? this.font3D.numGlyphs - 1 : cArray[n2];
                this.font3D.triangulateGlyphs(this.charIndex[n2], this.string.charAt(n2));
                this.geometryList[n2] = this.font3D.fontData[this.charIndex[n2]] != null ? (GeometryRetained)this.font3D.fontData[this.charIndex[n2]].retained : null;
                ++n2;
            }
        }
        this.updateTransformData();
    }

    final synchronized void updateTransformData() {
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector3f vector3f = new Vector3f((Tuple3f)this.position);
        this.lower.set((Tuple3f)vector3f);
        this.upper.set((Tuple3f)vector3f);
        this.charTransforms = new Transform3D[this.numChars];
        int n3 = 0;
        while (n3 < this.numChars) {
            this.charTransforms[n3] = VirtualUniverse.mc.getTransform3D(null);
            ++n3;
        }
        if (this.numChars != 0) {
            Rectangle2D.Float float_;
            GlyphMetrics glyphMetrics;
            this.charTransforms[0].set(vector3f);
            if (this.path == 1 || this.path == 2) {
                n = 0;
                n2 = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                n = 1;
                n2 = this.numChars;
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[0]]).getGlyphMetrics(0);
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                this.upper.x += (double)float_.width;
                this.upper.y += (double)float_.height;
            }
            n3 = 1;
            while (n3 < n2) {
                glyphMetrics = ((GlyphVector)this.font3D.gVectors[this.charIndex[n]]).getGlyphMetrics(0);
                f = glyphMetrics.getAdvance();
                float_ = (Rectangle2D.Float)glyphMetrics.getBounds2D();
                f += this.charSpacing;
                f2 = this.font3D.charHeights[this.charIndex[n]];
                switch (this.path) {
                    case 1: {
                        vector3f.x += f;
                        this.upper.x += (double)f;
                        if (!(this.upper.y < (double)(f2 + vector3f.y))) break;
                        this.upper.y = vector3f.y + f2;
                        break;
                    }
                    case 0: {
                        vector3f.x -= f;
                        this.lower.x -= (double)f;
                        if (!(this.upper.y < (double)(f2 + vector3f.y))) break;
                        this.upper.y = vector3f.y + f2;
                        break;
                    }
                    case 2: {
                        vector3f.y += f2;
                        this.upper.y += (double)f2;
                        if (!(this.upper.x < (double)(float_.width + vector3f.x))) break;
                        this.upper.x = vector3f.x + float_.width;
                        break;
                    }
                    case 3: {
                        vector3f.y -= f2;
                        this.lower.y -= (double)f2;
                        if (!(this.upper.x < (double)(float_.width + vector3f.x))) break;
                        this.upper.x = vector3f.x + float_.width;
                        break;
                    }
                }
                if (n3 < this.numChars) {
                    this.charTransforms[n3].set(vector3f);
                }
                ++n3;
                ++n;
            }
            if (this.alignment != 1) {
                double d = this.upper.x - this.lower.x;
                double d2 = this.upper.y - this.lower.y;
                if (this.alignment == 0) {
                    d *= 0.5;
                    d2 *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[3] = this.charTransforms[n3].mat[3] - d;
                            ++n3;
                        }
                        this.lower.x -= d;
                        this.upper.x -= d;
                        break;
                    }
                    case 0: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[3] = this.charTransforms[n3].mat[3] + d;
                            ++n3;
                        }
                        this.lower.x += d;
                        this.upper.x += d;
                        break;
                    }
                    case 2: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[7] = this.charTransforms[n3].mat[7] - d2;
                            ++n3;
                        }
                        this.lower.y -= d2;
                        this.upper.y -= d2;
                        break;
                    }
                    case 3: {
                        n3 = 0;
                        while (n3 < this.numChars) {
                            this.charTransforms[n3].mat[7] = this.charTransforms[n3].mat[7] + d2;
                            ++n3;
                        }
                        this.lower.y += d2;
                        this.upper.y += d2;
                        break;
                    }
                }
            }
        }
        this.lower.z = 0.0;
        this.upper.z = this.font3D == null || this.font3D.fontExtrusion == null ? this.lower.z : this.lower.z + (double)this.font3D.fontExtrusion.length;
    }
}

