/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.Switch;

public class SwitchValueInterpolator
extends Interpolator {
    Switch target;
    int firstSwitchIndex;
    int lastSwitchIndex;
    int childCount;

    SwitchValueInterpolator() {
    }

    public SwitchValueInterpolator(Alpha alpha, Switch switch_) {
        super(alpha);
        this.target = switch_;
        this.firstSwitchIndex = 0;
        this.childCount = switch_.numChildren();
        this.lastSwitchIndex = this.childCount - 1;
    }

    public SwitchValueInterpolator(Alpha alpha, Switch switch_, int n, int n2) {
        super(alpha);
        this.target = switch_;
        this.firstSwitchIndex = n;
        this.lastSwitchIndex = n2;
        this.computeChildCount();
    }

    public Node cloneNode(boolean bl) {
        SwitchValueInterpolator switchValueInterpolator = new SwitchValueInterpolator();
        switchValueInterpolator.duplicateNode(this, bl);
        return switchValueInterpolator;
    }

    private final void computeChildCount() {
        this.childCount = this.lastSwitchIndex >= this.firstSwitchIndex ? this.lastSwitchIndex - this.firstSwitchIndex + 1 : this.firstSwitchIndex - this.lastSwitchIndex + 1;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        SwitchValueInterpolator switchValueInterpolator = (SwitchValueInterpolator)node;
        this.setFirstChildIndex(switchValueInterpolator.getFirstChildIndex());
        this.setLastChildIndex(switchValueInterpolator.getLastChildIndex());
        this.setTarget(switchValueInterpolator.getTarget());
    }

    public int getFirstChildIndex() {
        return this.firstSwitchIndex;
    }

    public int getLastChildIndex() {
        return this.lastSwitchIndex;
    }

    public Switch getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            float f = this.alpha.value();
            int n = this.lastSwitchIndex > this.firstSwitchIndex ? this.firstSwitchIndex + (int)(f * (float)(this.childCount - 1) + 0.5f) : this.firstSwitchIndex - (int)(f * (float)(this.childCount - 1) + 0.5f);
            this.target.setWhichChild(n);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setFirstChildIndex(int n) {
        this.firstSwitchIndex = n;
        this.computeChildCount();
    }

    public void setLastChildIndex(int n) {
        this.lastSwitchIndex = n;
        this.computeChildCount();
    }

    public void setTarget(Switch switch_) {
        this.target = switch_;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        Switch switch_ = this.getTarget();
        if (switch_ != null) {
            this.setTarget((Switch)nodeReferenceTable.getNewObjectReference(switch_));
        }
    }
}

