/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.Renderer;
import javax.media.j3d.ScreenViewCache;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

public class Screen3D {
    private static final double METERS_PER_PIXEL = 2.8222222222222223E-4;
    GraphicsDevice graphicsDevice;
    boolean offScreen;
    int display;
    int screen;
    double physicalScreenWidth;
    double physicalScreenHeight;
    Dimension screenSize = new Dimension(0, 0);
    Transform3D trackerBaseToImagePlate = new Transform3D();
    Transform3D headTrackerToLeftImagePlate = new Transform3D();
    Transform3D headTrackerToRightImagePlate = new Transform3D();
    static final int PHYSICAL_SCREEN_SIZE_DIRTY = 1;
    static final int SCREEN_SIZE_DIRTY_DIRTY = 2;
    static final int TRACKER_BASE_TO_IMAGE_PLATE_DIRTY = 4;
    static final int HEAD_TRACKER_TO_IMAGE_PLATE_DIRTY = 8;
    int scrDirtyMask = 15;
    ScreenViewCache screenViewCache = null;
    Renderer renderer = null;
    static Hashtable deviceRendererMap = new Hashtable();
    int canvasCount = 0;
    UnorderList activeViews = new UnorderList(1, class$javax$media$j3d$View != null ? class$javax$media$j3d$View : (class$javax$media$j3d$View = Screen3D.class$("javax.media.j3d.View")));
    ArrayList users = new ArrayList();
    static /* synthetic */ Class class$javax$media$j3d$View;

    static {
        VirtualUniverse.loadLibraries();
    }

    Screen3D(GraphicsDevice graphicsDevice, boolean bl) {
        this.graphicsDevice = graphicsDevice;
        this.offScreen = bl;
        this.screenViewCache = new ScreenViewCache(this);
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo(graphicsDevice);
        this.display = nativeScreenInfo.getDisplay();
        this.screen = nativeScreenInfo.getScreen();
        if (!bl) {
            Dimension dimension = new Dimension();
            Dimension dimension2 = new Dimension();
            this.getDisplayParameters(this.display, this.screen, dimension, dimension2);
            this.screenSize.width = dimension.width;
            this.screenSize.height = dimension.height;
        }
        this.physicalScreenWidth = (double)this.screenSize.width * 2.8222222222222223E-4;
        this.physicalScreenHeight = (double)this.screenSize.height * 2.8222222222222223E-4;
    }

    boolean activeViewEmpty() {
        return this.activeViews.isEmpty();
    }

    void addActiveView(View view) {
        this.activeViews.addUnique(view);
    }

    synchronized void addUser(Canvas3D canvas3D) {
        this.users.add(canvas3D);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    synchronized void decCanvasCount() {
        --this.canvasCount;
    }

    native void getDisplayParameters(int var1, int var2, Dimension var3, Dimension var4);

    public void getHeadTrackerToLeftImagePlate(Transform3D transform3D) {
        transform3D.set(this.headTrackerToLeftImagePlate);
    }

    public void getHeadTrackerToRightImagePlate(Transform3D transform3D) {
        transform3D.set(this.headTrackerToRightImagePlate);
    }

    public double getPhysicalScreenHeight() {
        return this.physicalScreenHeight;
    }

    public double getPhysicalScreenWidth() {
        return this.physicalScreenWidth;
    }

    public Dimension getSize() {
        return new Dimension(this.screenSize);
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.screenSize);
        }
        dimension.setSize(this.screenSize);
        return dimension;
    }

    public void getTrackerBaseToImagePlate(Transform3D transform3D) {
        transform3D.set(this.trackerBaseToImagePlate);
    }

    synchronized void incCanvasCount() {
        ++this.canvasCount;
    }

    synchronized void notifyUsers() {
        int n = 0;
        while (n < this.users.size()) {
            Canvas3D canvas3D = (Canvas3D)this.users.get(n);
            canvas3D.redraw();
            ++n;
        }
    }

    void removeActiveView(View view) {
        this.activeViews.remove(view);
    }

    synchronized void removeUser(Canvas3D canvas3D) {
        this.users.remove(this.users.indexOf(canvas3D));
    }

    public void setHeadTrackerToLeftImagePlate(Transform3D transform3D) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if ((transform3D.getType() & 0x20) == 0) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.headTrackerToLeftImagePlate.setWithLock(transform3D);
            this.scrDirtyMask |= 8;
        }
        this.notifyUsers();
    }

    public void setHeadTrackerToRightImagePlate(Transform3D transform3D) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if ((transform3D.getType() & 0x20) == 0) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.headTrackerToRightImagePlate.setWithLock(transform3D);
            this.scrDirtyMask |= 8;
        }
        this.notifyUsers();
    }

    public void setPhysicalScreenHeight(double d) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.physicalScreenHeight = d;
            this.scrDirtyMask |= 1;
        }
        this.notifyUsers();
    }

    public void setPhysicalScreenWidth(double d) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.physicalScreenWidth = d;
            this.scrDirtyMask |= 1;
        }
        this.notifyUsers();
    }

    public void setSize(int n, int n2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Screen3D1"));
        }
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenSize.width = n;
            this.screenSize.height = n2;
            this.scrDirtyMask |= 2;
        }
    }

    public void setSize(Dimension dimension) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Screen3D1"));
        }
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenSize.width = dimension.width;
            this.screenSize.height = dimension.height;
            this.scrDirtyMask |= 2;
        }
    }

    public void setTrackerBaseToImagePlate(Transform3D transform3D) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if ((transform3D.getType() & 0x20) == 0) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.trackerBaseToImagePlate.setWithLock(transform3D);
            this.scrDirtyMask |= 4;
        }
        this.notifyUsers();
    }

    public String toString() {
        return "Screen3D: size = (" + this.getSize().width + " x " + this.getSize().height + ")" + ", physical size = " + "(" + this.getPhysicalScreenWidth() + "m x " + this.getPhysicalScreenHeight() + "m)";
    }

    void updateViewCache() {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenViewCache.snapshot();
        }
    }
}

