/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.BitSet;
import java.util.Hashtable;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphObjectRetained;

public abstract class SceneGraphObject {
    BitSet capabilities = new BitSet();
    SceneGraphObjectRetained retained;
    private boolean compiled = false;
    private boolean live = false;
    private boolean liveOrCompiled = false;
    private Object userData = null;
    Hashtable nodeHashtable = null;

    public SceneGraphObject() {
        this.createRetained();
    }

    final void checkForLiveOrCompiled() {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject2"));
        }
    }

    public final void clearCapability(int n) {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject0"));
        }
        this.capabilities.clear(n);
    }

    final void clearLive() {
        this.live = false;
        this.liveOrCompiled = this.live || this.compiled;
    }

    void createRetained() {
        this.retained = null;
    }

    protected void duplicateSceneGraphObject(SceneGraphObject sceneGraphObject) {
        this.capabilities = (BitSet)sceneGraphObject.capabilities.clone();
        this.userData = sceneGraphObject.userData;
    }

    public final boolean getCapability(int n) {
        return this.capabilities.get(n);
    }

    NodeComponent getNodeComponent(NodeComponent nodeComponent, boolean bl, Hashtable hashtable) {
        if (nodeComponent != null && (bl || nodeComponent.duplicateChild())) {
            NodeComponent nodeComponent2 = (NodeComponent)hashtable.get(nodeComponent);
            if (nodeComponent2 == null) {
                nodeComponent.nodeHashtable = hashtable;
                try {
                    nodeComponent2 = nodeComponent.cloneNodeComponent(bl);
                }
                catch (RuntimeException runtimeException) {
                    nodeComponent.nodeHashtable = null;
                    throw runtimeException;
                }
                nodeComponent.nodeHashtable = null;
                hashtable.put(nodeComponent, nodeComponent2);
            }
            return nodeComponent2;
        }
        return nodeComponent;
    }

    public Object getUserData() {
        return this.userData;
    }

    public final boolean isCompiled() {
        return this.compiled;
    }

    public final boolean isLive() {
        return this.live;
    }

    final boolean isLiveOrCompiled() {
        return this.liveOrCompiled;
    }

    public final void setCapability(int n) {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject0"));
        }
        this.capabilities.set(n);
    }

    final void setCompiled() {
        this.compiled = true;
        this.liveOrCompiled = this.live || this.compiled;
    }

    final void setLive() {
        this.live = true;
        this.liveOrCompiled = this.live || this.compiled;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
    }
}

