/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PositionPathInterpolator
extends PathInterpolator {
    private TransformGroup target;
    private Transform3D axis = new Transform3D();
    private Transform3D axisInverse = new Transform3D();
    private Transform3D position = new Transform3D();
    private Transform3D temp = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Point3f[] positions;

    PositionPathInterpolator() {
    }

    public PositionPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Point3f[] point3fArray) {
        super(alpha, fArray);
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.setPathArrays(point3fArray);
    }

    public Node cloneNode(boolean bl) {
        PositionPathInterpolator positionPathInterpolator = new PositionPathInterpolator();
        positionPathInterpolator.duplicateNode(this, bl);
        return positionPathInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PositionPathInterpolator positionPathInterpolator = (PositionPathInterpolator)node;
        this.setAxisOfTranslation(positionPathInterpolator.getAxisOfTranslation());
        int n = positionPathInterpolator.getArrayLengths();
        this.positions = new Point3f[n];
        Point3f point3f = new Point3f();
        int n2 = 0;
        while (n2 < n) {
            this.positions[n2] = new Point3f();
            positionPathInterpolator.getPosition(n2, point3f);
            this.setPosition(n2, point3f);
            ++n2;
        }
        this.setTarget(positionPathInterpolator.getTarget());
    }

    public Transform3D getAxisOfTranslation() {
        return new Transform3D(this.axis);
    }

    public void getPosition(int n, Point3f point3f) {
        point3f.set((Tuple3f)this.positions[n]);
    }

    public void getPositions(Point3f[] point3fArray) {
        int n = 0;
        while (n < this.positions.length) {
            point3fArray[n].set((Tuple3f)this.positions[n]);
            ++n;
        }
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            this.computePathInterpolation();
            if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
                this.pos.x = this.positions[0].x;
                this.pos.y = this.positions[0].y;
                this.pos.z = this.positions[0].z;
            } else {
                this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
            }
            this.position.setIdentity();
            this.position.setTranslation(this.pos);
            this.temp.mul(this.axis, this.position);
            this.temp.mul(this.temp, this.axisInverse);
            this.target.setTransform(this.temp);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setAxisOfTranslation(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public void setPathArrays(float[] fArray, Point3f[] point3fArray) {
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(point3fArray);
    }

    private void setPathArrays(Point3f[] point3fArray) {
        this.positions = new Point3f[point3fArray.length];
        int n = 0;
        while (n < point3fArray.length) {
            this.positions[n] = new Point3f();
            this.positions[n].set((Tuple3f)point3fArray[n]);
            ++n;
        }
    }

    public void setPosition(int n, Point3f point3f) {
        this.positions[n].set((Tuple3f)point3f);
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

