/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.VirtualUniverse;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;

class NativeConfigTemplate3D {
    static final int RED_SIZE = 0;
    static final int GREEN_SIZE = 1;
    static final int BLUE_SIZE = 2;
    static final int ALPHA_SIZE = 3;
    static final int DEPTH_SIZE = 4;
    static final int DOUBLEBUFFER = 5;
    static final int STEREO = 6;
    static final int NUM_ITEMS = 7;

    NativeConfigTemplate3D() {
    }

    native int choosePixelFormat(int var1, int[] var2);

    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfigurationArray[0]).getDevice();
        int[] nArray = new int[7];
        VirtualUniverse.loadLibraries();
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[4] = graphicsConfigTemplate3D.getDepthSize();
        nArray[5] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[6] = graphicsConfigTemplate3D.getStereo();
        if (VirtualUniverse.mc.getRenderingAPI() != 2) {
            int n = this.choosePixelFormat(0, nArray);
            VirtualUniverse.mc.setPixelFormat(n);
            return new Win32GraphicsConfig((GraphicsDevice)win32GraphicsDevice, n);
        }
        return new Win32GraphicsConfig((GraphicsDevice)win32GraphicsDevice, 1);
    }

    boolean hasDoubleBuffer(GraphicsConfiguration graphicsConfiguration) {
        if (VirtualUniverse.mc.getRenderingAPI() == 2) {
            return true;
        }
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = VirtualUniverse.mc.getPixelFormat();
        return this.isDoubleBufferAvailable(0, n, n2, n3);
    }

    boolean hasSceneAntialiasing(GraphicsConfiguration graphicsConfiguration) {
        if (VirtualUniverse.mc.getRenderingAPI() == 2) {
            return false;
        }
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = VirtualUniverse.mc.getPixelFormat();
        return this.isSceneAntialiasingAvailable(0, n, n2, n3);
    }

    boolean hasStereo(GraphicsConfiguration graphicsConfiguration) {
        if (VirtualUniverse.mc.getRenderingAPI() == 2) {
            return false;
        }
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = VirtualUniverse.mc.getPixelFormat();
        return this.isStereoAvailable(0, n, n2, n3);
    }

    native boolean isDoubleBufferAvailable(int var1, int var2, int var3, int var4);

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        return false;
    }

    native boolean isSceneAntialiasingAvailable(int var1, int var2, int var3, int var4);

    native boolean isStereoAvailable(int var1, int var2, int var3, int var4);
}

