/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTError;
import java.awt.Toolkit;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompressedGeometryRenderMethod;
import javax.media.j3d.DefaultRenderMethod;
import javax.media.j3d.DisplayListRenderMethod;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceBlockingThread;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dProperties;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.MasterControlThread;
import javax.media.j3d.NativeAPIInfo;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRenderMethod;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.StructureUpdateThread;
import javax.media.j3d.Text3DRenderMethod;
import javax.media.j3d.TimerThread;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VertexArrayRenderMethod;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class MasterControl {
    static final int CHECK_FOR_WORK = 0;
    static final int SET_WORK = 1;
    static final int RUN_THREADS = 2;
    static final int THREAD_DONE = 3;
    static final int WAIT_FOR_ALL = 4;
    static final int SET_WORK_FOR_REQUEST_RENDERER = 5;
    static final int SLEEPING = 0;
    static final int RUNNING = 1;
    static final int WAITING_FOR_THREAD = 2;
    static final int WAITING_FOR_THREADS = 3;
    static final int WAITING_FOR_CPU = 4;
    static final int RENDER_OPENGL_SOLARIS = 0;
    static final int RENDER_OPENGL_WIN32 = 1;
    static final int RENDER_DIRECT3D = 2;
    static final Integer REQUESTRENDER = new Integer(3);
    static final Integer RENDER = new Integer(0);
    static final Integer SWAP = new Integer(1);
    static final Integer ACTIVATE_VIEW = new Integer(1);
    static final Integer DEACTIVATE_VIEW = new Integer(2);
    static final Integer START_VIEW = new Integer(3);
    static final Integer STOP_VIEW = new Integer(4);
    static final Integer REEVALUATE_CANVAS = new Integer(5);
    static final Integer UNREGISTER_VIEW = new Integer(6);
    static final Integer PHYSICAL_ENV_CHANGE = new Integer(7);
    static final Integer INPUTDEVICE_CHANGE = new Integer(8);
    static final Integer EMPTY_UNIVERSE = new Integer(9);
    static final Integer START_RENDERER = new Integer(10);
    static final Integer STOP_RENDERER = new Integer(11);
    static final Integer RENDER_ONCE = new Integer(12);
    static final Integer FREE_CONTEXT = new Integer(13);
    private MasterControlThread mcThread = null;
    private UnorderList views = new UnorderList(1, class$javax$media$j3d$View != null ? class$javax$media$j3d$View : (class$javax$media$j3d$View = MasterControl.class$("javax.media.j3d.View")));
    private int numActiveViews = 0;
    private Transform3D[] transformFreeList = new Transform3D[2];
    private int numFreeTransforms = 0;
    private UnorderList activeUniverseList = new UnorderList(class$javax$media$j3d$VirtualUniverse != null ? class$javax$media$j3d$VirtualUniverse : (class$javax$media$j3d$VirtualUniverse = MasterControl.class$("javax.media.j3d.VirtualUniverse")));
    private UnorderList regUniverseList = new UnorderList(class$javax$media$j3d$VirtualUniverse != null ? class$javax$media$j3d$VirtualUniverse : (class$javax$media$j3d$VirtualUniverse = MasterControl.class$("javax.media.j3d.VirtualUniverse")));
    private Object timeLock = new Object();
    private long time = 0L;
    private long waitTimestamp = 0L;
    private UnorderList stateWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData != null ? class$javax$media$j3d$J3dThreadData : (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")));
    private UnorderList renderWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData != null ? class$javax$media$j3d$J3dThreadData : (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")));
    private UnorderList requestRenderWorkThreads = new UnorderList(class$javax$media$j3d$J3dThreadData != null ? class$javax$media$j3d$J3dThreadData : (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")));
    private UnorderList renderThreadData = new UnorderList(class$javax$media$j3d$J3dThreadData != null ? class$javax$media$j3d$J3dThreadData : (class$javax$media$j3d$J3dThreadData = MasterControl.class$("javax.media.j3d.J3dThreadData")));
    private UnorderList inputDeviceThreads = new UnorderList(1, class$javax$media$j3d$InputDeviceScheduler != null ? class$javax$media$j3d$InputDeviceScheduler : (class$javax$media$j3d$InputDeviceScheduler = MasterControl.class$("javax.media.j3d.InputDeviceScheduler")));
    private boolean threadListsChanged;
    private int lastTransformStructureThread = 0;
    private int lastStructureUpdateThread = 0;
    private long currentTime;
    TimerThread timerThread;
    boolean running = true;
    private boolean workToDo = false;
    private boolean requestRenderWorkToDo = false;
    private int threadPending = 0;
    private int renderPending = 0;
    private int statePending = 0;
    private boolean renderWaiting = false;
    private boolean stateWaiting = false;
    private int state = 0;
    private int cpuLimit;
    private UnorderList messageFreeList = new UnorderList(class$javax$media$j3d$J3dMessage != null ? class$javax$media$j3d$J3dMessage : (class$javax$media$j3d$J3dMessage = MasterControl.class$("javax.media.j3d.J3dMessage")));
    private UnorderList bhLeafFreeList = new UnorderList(class$javax$media$j3d$BHNode != null ? class$javax$media$j3d$BHNode : (class$javax$media$j3d$BHNode = MasterControl.class$("javax.media.j3d.BHNode")));
    private UnorderList bhInternalFreeList = new UnorderList(class$javax$media$j3d$BHNode != null ? class$javax$media$j3d$BHNode : (class$javax$media$j3d$BHNode = MasterControl.class$("javax.media.j3d.BHNode")));
    private UnorderList mirrorObjects = new UnorderList(class$javax$media$j3d$ObjectUpdate != null ? class$javax$media$j3d$ObjectUpdate : (class$javax$media$j3d$ObjectUpdate = MasterControl.class$("javax.media.j3d.ObjectUpdate")));
    private RenderingAttributesStructure renderingAttributesStructure = new RenderingAttributesStructure();
    private DefaultRenderMethod defaultRenderMethod = null;
    private Text3DRenderMethod text3DRenderMethod = null;
    private VertexArrayRenderMethod vertexArrayRenderMethod = null;
    private DisplayListRenderMethod displayListRenderMethod = null;
    private CompressedGeometryRenderMethod compressedGeometryRenderMethod = null;
    private OrientedShape3DRenderMethod orientedShape3DRenderMethod = null;
    int currentCtx = 0;
    static long systemStartTime = System.currentTimeMillis();
    private int renderingAPI = 0;
    private boolean isD3DAPI = false;
    private NativeAPIInfo nativeAPIInfo = null;
    private J3dProperties j3dProperties = null;
    private int displayListIdCount = 1;
    UnorderList displayListIdFreeList = new UnorderList(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")));
    private int textureIdCount = 1;
    private UnorderList textureIdFreeList = new UnorderList(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")));
    private int canvasBitCount = 0;
    private UnorderList canvasBitFreeList = new UnorderList(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")));
    private int rendererCount = 0;
    boolean jvm13 = false;
    boolean isSharedCtx = false;
    boolean sharedCtxOverride = false;
    Object contextCreationLock = new Object();
    boolean doDsiRenderLock = true;
    boolean isJ3dG2dDrawPixel = true;
    int pixelFormat = -1;
    private UnorderList requestObjList = new UnorderList();
    private UnorderList requestTypeList = new UnorderList(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = MasterControl.class$("java.lang.Integer")));
    private UnorderList tempViewList = new UnorderList();
    private UnorderList renderOnceList = new UnorderList();
    private boolean pendingRequest = false;
    private static ThreadGroup rootThreadGroup;
    private static int threadPriority;
    private long sleepTime;
    private Object mcThreadLock = new Object();
    private ArrayList timestampUpdateList = new ArrayList(3);
    int awt;
    int maxLights;
    String[] mtype = new String[]{"-INSERT_NODES                   ", "-REMOVE_NODES                   ", "-RUN                            ", "-TRANSFORM_CHANGED              ", "-UPDATE_VIEW                    ", "-STOP_THREAD                    ", "-COLORINGATTRIBUTES_CHANGED     ", "-LINEATTRIBUTES_CHANGED         ", "-POINTATTRIBUTES_CHANGED        ", "-POLYGONATTRIBUTES_CHANGED      ", "-RENDERINGATTRIBUTES_CHANGED    ", "-TEXTUREATTRIBUTES_CHANGED      ", "-TRANSPARENCYATTRIBUTES_CHANGED ", "-MATERIAL_CHANGED               ", "-TEXCOORDGENERATION_CHANGED     ", "-TEXTURE_CHANGED                ", "-MORPH_CHANGED                  ", "-GEOMETRY_CHANGED               ", "-APPEARANCE_CHANGED             ", "-LIGHT_CHANGED                  ", "-BACKGROUND_CHANGED             ", "-CLIP_CHANGED                   ", "-FOG_CHANGED                    ", "-BOUNDINGLEAF_CHANGED           ", "-SHAPE3D_CHANGED                ", "-TEXT3D_TRANSFORM_CHANGED       ", "-TEXT3D_DATA_CHANGED            ", "-SWITCH_CHANGED                 ", "-COND_MET                       ", "-BEHAVIOR_ENABLE                ", "-BEHAVIOR_DISABLE               ", "-INSERT_RENDERATOMS             ", "-ORDERED_GROUP_INSERTED         ", "-ORDERED_GROUP_REMOVED          ", "-COLLISION_BOUND_CHANGED        ", "-REGION_BOUND_CHANGED           ", "-MODELCLIP_CHANGED              ", "-BOUNDS_AUTO_COMPUTE_CHANGED    ", "-SOUND_ATTRIB_CHANGED           ", "-AURALATTRIBUTES_CHANGED        ", "-SOUNDSCAPE_CHANGED             ", "-ALTERNATEAPPEARANCE_CHANGED    ", "-RENDER_OFFSCREEN               ", "-RENDER_RETAINED                ", "-RENDER_IMMEDIATE               ", "-SOUND_STATE_CHANGED            ", "-ORIENTEDSHAPE3D_CHANGED        ", "-TEXTURE_UNIT_STATE_CHANGED     ", "-UPDATE_VIEWPLATFORM            ", " BEHAVIOR_ACTIVATE              "};
    static /* synthetic */ Class class$javax$media$j3d$View;
    static /* synthetic */ Class class$javax$media$j3d$VirtualUniverse;
    static /* synthetic */ Class class$javax$media$j3d$J3dThreadData;
    static /* synthetic */ Class class$javax$media$j3d$InputDeviceScheduler;
    static /* synthetic */ Class class$javax$media$j3d$J3dMessage;
    static /* synthetic */ Class class$javax$media$j3d$BHNode;
    static /* synthetic */ Class class$javax$media$j3d$ObjectUpdate;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$media$j3d$PhysicalEnvironment;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                Thread thread = Thread.currentThread();
                threadPriority = thread.getPriority();
                rootThreadGroup = thread.getThreadGroup();
                while ((threadGroup = rootThreadGroup.getParent()) != null) {
                    rootThreadGroup = threadGroup;
                }
                rootThreadGroup = new ThreadGroup(rootThreadGroup, "Java3D");
                return null;
            }
        });
    }

    MasterControl() {
        Integer n;
        Boolean bl;
        Object object;
        try {
            object = Toolkit.getDefaultToolkit();
            object = null;
        }
        catch (AWTError aWTError) {}
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("J3D");
                return null;
            }
        });
        object = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        });
        this.jvm13 = ((String)object).startsWith("1.2") ^ true;
        this.nativeAPIInfo = new NativeAPIInfo();
        this.renderingAPI = this.nativeAPIInfo.getRenderingAPI();
        this.isD3DAPI = this.renderingAPI == 2;
        this.j3dProperties = new J3dProperties();
        if (this.getRenderingAPI() != 2) {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("j3d.sharedctx");
                    if (string == null) {
                        return Boolean.FALSE;
                    }
                    MasterControl.this.sharedCtxOverride = true;
                    return new Boolean(string);
                }
            });
            this.isSharedCtx = bl;
            if (this.sharedCtxOverride) {
                if (this.isSharedCtx) {
                    System.err.println("Java 3D: shared contexts enabled");
                } else {
                    System.err.println("Java 3D: shared contexts disabled");
                }
            }
        }
        bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("j3d.renderLock", "true");
                return new Boolean(string);
            }
        });
        this.doDsiRenderLock = bl;
        if (!this.doDsiRenderLock) {
            System.err.println("Java 3D: render lock disabled");
        }
        if (!this.isD3D()) {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("j3d.g2ddrawpixel", "true");
                    return new Boolean(string);
                }
            });
            this.isJ3dG2dDrawPixel = bl2;
        } else {
            this.isJ3dG2dDrawPixel = true;
        }
        final int n2 = this.getNumberOfProcessor() + 1;
        Integer n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.threadLimit", n2);
            }
        });
        this.cpuLimit = n3;
        if (this.cpuLimit < 1) {
            this.cpuLimit = 1;
        }
        if (J3dDebug.debug || this.cpuLimit != n2) {
            System.err.println("Java 3D: concurrent threadLimit = " + this.cpuLimit);
        }
        int n4 = this.getThreadConcurrency();
        if (J3dDebug.debug) {
            System.err.println("System threadConcurrency = " + n4);
        }
        if (n4 != -1 && n4 < this.cpuLimit + 1) {
            n4 = this.cpuLimit + 1;
            if (J3dDebug.debug) {
                System.err.println("Setting system threadConcurrency to " + n4);
            }
            this.setThreadConcurrency(n4);
        }
        if ((n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.deviceSampleTime", 0);
            }
        })) > 0) {
            InputDeviceScheduler.samplingTime = n;
            System.err.println("Java 3D: Input device sampling time = " + n + " ms");
        }
        this.initializeJ3D();
        this.maxLights = this.getMaximumLights();
    }

    void addBHNodeToFreelists(BHNode bHNode) {
        bHNode.parent = null;
        bHNode.mark = false;
        if (bHNode.nodeType == 1) {
            ((BHInternalNode)bHNode).lChild = null;
            ((BHInternalNode)bHNode).rChild = null;
            UnorderList unorderList = this.bhInternalFreeList;
            synchronized (unorderList) {
                this.bhInternalFreeList.add(bHNode);
            }
        }
        if (bHNode.nodeType == 2) {
            UnorderList unorderList = this.bhLeafFreeList;
            synchronized (unorderList) {
                ((BHLeafNode)bHNode).leafIF = null;
                this.bhLeafFreeList.add(bHNode);
            }
        }
    }

    void addInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        UnorderList unorderList = this.inputDeviceThreads;
        synchronized (unorderList) {
            this.inputDeviceThreads.add(inputDeviceScheduler);
            if (this.inputDeviceThreads.size() == 1) {
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    final void addMessageToFreelists(J3dMessage j3dMessage) {
        this.messageFreeList.add(j3dMessage);
    }

    void addMirrorObject(ObjectUpdate objectUpdate) {
        this.mirrorObjects.add(objectUpdate);
    }

    private final void addToStateThreads(J3dThreadData j3dThreadData) {
        if (j3dThreadData.thread.active) {
            this.stateWorkThreads.add(j3dThreadData);
        }
    }

    void addToTransformFreeList(Transform3D transform3D) {
        Transform3D[] transform3DArray = this.transformFreeList;
        synchronized (transform3DArray) {
            if (this.transformFreeList.length == this.numFreeTransforms) {
                Transform3D[] transform3DArray2 = new Transform3D[this.numFreeTransforms * 2];
                System.arraycopy(this.transformFreeList, 0, transform3DArray2, 0, this.numFreeTransforms);
                transform3DArray2[this.numFreeTransforms++] = transform3D;
                this.transformFreeList = transform3DArray2;
            } else {
                this.transformFreeList[this.numFreeTransforms++] = transform3D;
            }
        }
    }

    private void assignNewPrimaryView(VirtualUniverse virtualUniverse) {
        View view = virtualUniverse.getCurrentView();
        if (view != null) {
            view.primaryView = false;
        }
        View[] viewArray = (View[])this.views.toArray(false);
        int n = this.views.size();
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            if (view2.active && view2.isRunning && virtualUniverse == view2.universe) {
                view2.primaryView = true;
                virtualUniverse.setCurrentView(view2);
                return;
            }
            ++n2;
        }
        virtualUniverse.setCurrentView(null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void clearRenderOnceList() {
        int n = this.renderOnceList.size() - 1;
        while (n >= 0) {
            View view = (View)this.renderOnceList.get(n);
            view.isRunning = false;
            view.renderOnceFinish = true;
            --n;
        }
        this.renderOnceList.clear();
        this.threadListsChanged = true;
    }

    void createMCThreads() {
        this.createUpdateThread(this.renderingAttributesStructure);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.timerThread = new TimerThread(rootThreadGroup);
                    MasterControl.this.timerThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.timerThread.start();
    }

    void createMasterControlThread() {
        this.running = true;
        this.workToDo = false;
        this.state = 1;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.mcThread = new MasterControlThread(rootThreadGroup);
                    MasterControl.this.mcThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        while (this.state != 0) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void createUpdateThread(J3dStructure j3dStructure) {
        final J3dStructure j3dStructure2 = j3dStructure;
        if (j3dStructure2.updateThread == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        j3dStructure2.updateThread = new StructureUpdateThread(rootThreadGroup, j3dStructure2, j3dStructure2.threadType);
                        j3dStructure2.updateThread.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            j3dStructure2.updateThread.initialize();
            j3dStructure2.threadData.thread = j3dStructure2.updateThread;
            j3dStructure2.threadData.lastUpdateTime = Math.max(this.currentTime, j3dStructure2.threadData.lastUpdateTime);
        }
    }

    private void destroyUniverseThreads(VirtualUniverse virtualUniverse) {
        if (this.regUniverseList.contains(virtualUniverse)) {
            this.destroyUpdateThread(virtualUniverse.behaviorStructure);
            this.destroyUpdateThread(virtualUniverse.geometryStructure);
            this.destroyUpdateThread(virtualUniverse.soundStructure);
            this.destroyUpdateThread(virtualUniverse.renderingEnvironmentStructure);
            this.destroyUpdateThread(virtualUniverse.transformStructure);
            virtualUniverse.behaviorScheduler.finish();
            virtualUniverse.behaviorScheduler.getThreadData(null, null).thread = null;
            virtualUniverse.behaviorScheduler = null;
            this.activeUniverseList.remove(virtualUniverse);
            this.regUniverseList.remove(virtualUniverse);
        }
        if (this.regUniverseList.isEmpty() && this.views.isEmpty()) {
            if (this.timerThread != null) {
                this.renderingAttributesStructure.updateThread.finish();
                this.renderingAttributesStructure.updateThread = null;
                this.timerThread.finish();
                this.timerThread = null;
            }
            this.running = false;
        }
    }

    private void destroyUpdateThread(J3dStructure j3dStructure) {
        j3dStructure.updateThread.finish();
        j3dStructure.threadData.thread = null;
        j3dStructure.updateThread = null;
    }

    void doWork() {
        this.runMonitor(0, null, null, null, null);
        if (this.pendingRequest) {
            this.handlePendingRequest();
        }
        if (!this.running) {
            return;
        }
        if (this.threadListsChanged) {
            this.updateWorkThreads();
        }
        this.updateTimeValues();
        View[] viewArray = (View[])this.views.toArray(false);
        int n = this.views.size() - 1;
        while (n >= 0) {
            if (viewArray[n].active) {
                viewArray[n].updateViewCache();
            }
            --n;
        }
        this.runMonitor(2, this.stateWorkThreads, this.renderWorkThreads, this.requestRenderWorkThreads, null);
        if (this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
    }

    void dumpWorkThreads() {
        System.err.println("-----------------------------");
        System.err.println("MasterControl/dumpWorkThreads");
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            J3dThreadData[] j3dThreadDataArray;
            switch (n2) {
                case 0: {
                    j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
                    n = this.stateWorkThreads.arraySize();
                    break;
                }
                case 1: {
                    j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
                    n = this.renderWorkThreads.arraySize();
                    break;
                }
                default: {
                    j3dThreadDataArray = (J3dThreadData[])this.requestRenderWorkThreads.toArray(false);
                    n = this.requestRenderWorkThreads.arraySize();
                }
            }
            int n3 = 0;
            while (n3 < n) {
                J3dThreadData j3dThreadData = j3dThreadDataArray[n3];
                System.err.println("Thread " + n3 + ": " + j3dThreadData.thread);
                System.err.println("\tOps: " + j3dThreadData.threadOpts);
                if (j3dThreadData.threadArgs != null) {
                    Object[] objectArray = (Object[])j3dThreadData.threadArgs;
                    System.err.print("\tArgs: ");
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        System.err.print(String.valueOf(String.valueOf(objectArray[n4])) + " ");
                        ++n4;
                    }
                }
                System.err.println("");
                ++n3;
            }
            ++n2;
        }
        System.err.println("-----------------------------");
    }

    void dumpmsg(J3dMessage j3dMessage) {
        System.out.println(this.mtype[j3dMessage.type]);
        if ((j3dMessage.threads & 1) != 0) {
            System.out.println("  BEHAVIOR_SCHEDULER");
        }
        if ((j3dMessage.threads & 2) != 0) {
            System.out.println("  SOUND_SCHEDULER");
        }
        if ((j3dMessage.threads & 4) != 0) {
            System.out.println("  INPUT_DEVICE_SCHEDULER");
        }
        if ((j3dMessage.threads & 0x10) != 0) {
            System.out.println("  RENDER_THREAD");
        }
        if ((j3dMessage.threads & 0x40) != 0) {
            System.out.println("  UPDATE_GEOMETRY");
        }
        if ((j3dMessage.threads & 0x80) != 0) {
            System.out.println("  UPDATE_RENDER");
        }
        if ((j3dMessage.threads & 0x100) != 0) {
            System.out.println("  UPDATE_BEHAVIOR");
        }
        if ((j3dMessage.threads & 0x200) != 0) {
            System.out.println("  UPDATE_SOUND");
        }
        if ((j3dMessage.threads & 0x400) != 0) {
            System.out.println("  UPDATE_RENDERING_ATTRIBUTES");
        }
        if ((j3dMessage.threads & 0x1000) != 0) {
            System.out.println("  UPDATE_RENDERING_ENVIRONMENT");
        }
        if ((j3dMessage.threads & 0x2000) != 0) {
            System.out.println("  UPDATE_TRANSFORM");
        }
    }

    private void evaluateAllCanvases() {
        UnorderList unorderList = this.renderThreadData;
        synchronized (unorderList) {
            this.renderThreadData.clear();
            View[] viewArray = (View[])this.views.toArray(false);
            int n = this.views.size() - 1;
            while (n >= 0) {
                viewArray[n].getCanvasList(true);
                Screen3D[] screen3DArray = viewArray[n].getScreens();
                int n2 = screen3DArray.length - 1;
                while (n2 >= 0) {
                    screen3DArray[n2].canvasCount = 0;
                    --n2;
                }
                --n;
            }
            int n3 = this.views.size() - 1;
            while (n3 >= 0) {
                View view = viewArray[n3];
                Canvas3D[][] canvas3DArray = view.getCanvasList(false);
                if (view.active) {
                    int n4 = canvas3DArray.length - 1;
                    while (n4 >= 0) {
                        boolean bl = false;
                        int n5 = canvas3DArray[n4].length - 1;
                        while (n5 >= 0) {
                            Canvas3D canvas3D = canvas3DArray[n4][n5];
                            final Screen3D screen3D = canvas3D.screen;
                            if (canvas3D.active) {
                                Object object;
                                if (screen3D.canvasCount++ == 0 && screen3D.renderer == null) {
                                    object = (Renderer)Screen3D.deviceRendererMap.get(canvas3D.screen.graphicsDevice);
                                    if (object == null) {
                                        AccessController.doPrivileged(new PrivilegedAction(){

                                            public Object run() {
                                                ThreadGroup threadGroup = rootThreadGroup;
                                                synchronized (threadGroup) {
                                                    screen3D.renderer = new Renderer(rootThreadGroup);
                                                    screen3D.renderer.setPriority(threadPriority);
                                                }
                                                return null;
                                            }
                                        });
                                        screen3D.renderer.initialize();
                                        Screen3D.deviceRendererMap.put(screen3D.graphicsDevice, screen3D.renderer);
                                    } else {
                                        screen3D.renderer = object;
                                    }
                                }
                                if (canvas3D.offScreen) {
                                    screen3D.renderer.offScreen = screen3D;
                                } else {
                                    screen3D.renderer.onScreen = screen3D;
                                    if (!bl) {
                                        object = screen3D.renderer.getThreadData(view, null);
                                        this.renderThreadData.add(object);
                                        if (view.renderBinReady) {
                                            ((J3dThreadData)object).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object).lastUpdateTime);
                                        }
                                        bl = true;
                                    }
                                    object = screen3D.renderer.getThreadData(view, canvas3D);
                                    this.renderThreadData.add(object);
                                    if (view.renderBinReady) {
                                        ((J3dThreadData)object).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object).lastUpdateTime);
                                    }
                                }
                            }
                            --n5;
                        }
                        --n4;
                    }
                }
                --n3;
            }
        }
        this.threadListsChanged = true;
    }

    private void evaluatePhysicalEnv(View view) {
        final PhysicalEnvironment physicalEnvironment = view.physicalEnvironment;
        if (physicalEnvironment.inputsched == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        physicalEnvironment.inputsched = new InputDeviceScheduler(rootThreadGroup, physicalEnvironment);
                        physicalEnvironment.inputsched.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            physicalEnvironment.inputsched.start();
            PhysicalEnvironment.physicalEnvMap.put(physicalEnvironment, physicalEnvironment.inputsched);
        }
        this.threadListsChanged = true;
    }

    void freeCanvasBit(int n) {
        UnorderList unorderList = this.canvasBitFreeList;
        synchronized (unorderList) {
            this.canvasBitFreeList.add(new Integer(n));
        }
    }

    void freeDisplayListId(Integer n) {
        UnorderList unorderList = this.displayListIdFreeList;
        synchronized (unorderList) {
            this.displayListIdFreeList.add(n);
        }
    }

    void freeTextureId(int n) {
        UnorderList unorderList = this.textureIdFreeList;
        synchronized (unorderList) {
            this.textureIdFreeList.add(new Integer(n));
        }
    }

    native int getAWT();

    BHNode getBHNode(int n) {
        if (n == 2) {
            UnorderList unorderList = this.bhLeafFreeList;
            synchronized (unorderList) {
                if (this.bhLeafFreeList.size() > 0) {
                    BHNode bHNode = (BHNode)this.bhLeafFreeList.removeLastElement();
                    Object var4_8 = null;
                    return bHNode;
                }
                BHLeafNode bHLeafNode = new BHLeafNode();
                Object var4_9 = null;
                return bHLeafNode;
            }
        }
        if (n == 1) {
            UnorderList unorderList = this.bhInternalFreeList;
            synchronized (unorderList) {
                if (this.bhInternalFreeList.size() > 0) {
                    BHNode bHNode = (BHNode)this.bhInternalFreeList.removeLastElement();
                    Object var4_10 = null;
                    return bHNode;
                }
                BHInternalNode bHInternalNode = new BHInternalNode();
                Object var4_11 = null;
                return bHInternalNode;
            }
        }
        return null;
    }

    int getCanvasBit() {
        UnorderList unorderList = this.canvasBitFreeList;
        synchronized (unorderList) {
            if (this.canvasBitFreeList.size() == 0) {
                if (this.canvasBitCount > 31) {
                    throw new InternalError();
                }
                int n = 1 << this.canvasBitCount++;
                Object var3_4 = null;
                return n;
            }
            int n = (Integer)this.canvasBitFreeList.removeLastElement();
            Object var3_5 = null;
            return n;
        }
    }

    RenderMethod getCompressedGeometryRenderMethod() {
        if (this.compressedGeometryRenderMethod == null) {
            this.compressedGeometryRenderMethod = new CompressedGeometryRenderMethod();
        }
        return this.compressedGeometryRenderMethod;
    }

    RenderMethod getDefaultRenderMethod() {
        if (this.defaultRenderMethod == null) {
            this.defaultRenderMethod = new DefaultRenderMethod();
        }
        return this.defaultRenderMethod;
    }

    Integer getDisplayListId() {
        UnorderList unorderList = this.displayListIdFreeList;
        synchronized (unorderList) {
            if (this.displayListIdFreeList.size() == 0) {
                Integer n = new Integer(++this.displayListIdCount);
                Object var3_4 = null;
                return n;
            }
            Integer n = (Integer)this.displayListIdFreeList.removeLastElement();
            Object var3_5 = null;
            return n;
        }
    }

    RenderMethod getDisplayListRenderMethod() {
        if (this.displayListRenderMethod == null) {
            this.displayListRenderMethod = new DisplayListRenderMethod();
        }
        return this.displayListRenderMethod;
    }

    InputDeviceBlockingThread getInputDeviceBlockingThread(final InputDevice inputDevice) {
        return (InputDeviceBlockingThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    InputDeviceBlockingThread inputDeviceBlockingThread = new InputDeviceBlockingThread(rootThreadGroup, inputDevice);
                    inputDeviceBlockingThread.setPriority(threadPriority);
                    InputDeviceBlockingThread inputDeviceBlockingThread2 = inputDeviceBlockingThread;
                    Object var3_4 = null;
                    return inputDeviceBlockingThread2;
                }
            }
        });
    }

    private native int getMaximumLights();

    final J3dMessage getMessage() {
        UnorderList unorderList = this.messageFreeList;
        synchronized (unorderList) {
            J3dMessage j3dMessage = this.messageFreeList.size() > 0 ? (J3dMessage)this.messageFreeList.removeLastElement() : new J3dMessage();
            Object var3_3 = null;
            return j3dMessage;
        }
    }

    private native int getNumberOfProcessor();

    RenderMethod getOrientedShape3DRenderMethod() {
        if (this.orientedShape3DRenderMethod == null) {
            this.orientedShape3DRenderMethod = new OrientedShape3DRenderMethod();
        }
        return this.orientedShape3DRenderMethod;
    }

    int getPixelFormat() {
        return this.pixelFormat;
    }

    int getRendererBit() {
        return 1 << this.rendererCount++;
    }

    final int getRenderingAPI() {
        return this.renderingAPI;
    }

    RenderMethod getText3DRenderMethod() {
        if (this.text3DRenderMethod == null) {
            this.text3DRenderMethod = new Text3DRenderMethod();
        }
        return this.text3DRenderMethod;
    }

    int getTextureId() {
        UnorderList unorderList = this.textureIdFreeList;
        synchronized (unorderList) {
            if (this.textureIdFreeList.size() == 0) {
                int n = ++this.textureIdCount;
                Object var3_4 = null;
                return n;
            }
            int n = (Integer)this.textureIdFreeList.removeLastElement();
            Object var3_5 = null;
            return n;
        }
    }

    private native int getThreadConcurrency();

    int getThreadPriority() {
        return threadPriority;
    }

    long getTime() {
        Object object = this.timeLock;
        synchronized (object) {
            long l = this.time++;
            Object var4_3 = null;
            return l;
        }
    }

    Transform3D getTransform3D(Transform3D transform3D) {
        Transform3D transform3D2;
        Transform3D[] transform3DArray = this.transformFreeList;
        synchronized (transform3DArray) {
            if (this.numFreeTransforms > 0) {
                --this.numFreeTransforms;
                transform3D2 = this.transformFreeList[this.numFreeTransforms];
                if (transform3D != null) {
                    transform3D2.set(transform3D);
                }
            } else {
                transform3D2 = transform3D != null ? new Transform3D(transform3D) : new Transform3D();
            }
        }
        return transform3D2;
    }

    RenderMethod getVertexArrayRenderMethod() {
        if (this.vertexArrayRenderMethod == null) {
            this.vertexArrayRenderMethod = new VertexArrayRenderMethod();
        }
        return this.vertexArrayRenderMethod;
    }

    private void handlePendingRequest() {
        Object object;
        Serializable serializable;
        int n;
        Integer[] integerArray;
        Object[] objectArray;
        UnorderList unorderList = this.requestObjList;
        synchronized (unorderList) {
            objectArray = this.requestObjList.toArray();
            integerArray = (Integer[])this.requestTypeList.toArray();
            n = this.requestObjList.size();
            this.requestObjList.clear();
            this.requestTypeList.clear();
        }
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            serializable = integerArray[n2];
            object = objectArray[n2];
            if (serializable == ACTIVATE_VIEW) {
                this.viewActivate((View)object);
            } else if (serializable == DEACTIVATE_VIEW) {
                this.viewDeactivate((View)object);
            } else if (serializable == REEVALUATE_CANVAS) {
                this.evaluateAllCanvases();
            } else if (serializable == INPUTDEVICE_CHANGE) {
                this.inputDeviceThreads.clearMirror();
                this.threadListsChanged = true;
            } else if (serializable == START_VIEW) {
                this.startView((View)object);
            } else if (serializable == STOP_VIEW) {
                object2 = (View)object;
                if (++((View)object2).stopViewCount > 4) {
                    ((View)object2).stopViewCount = -1;
                    this.stopView((View)object2);
                } else {
                    this.tempViewList.add(object2);
                }
            } else if (serializable == UNREGISTER_VIEW) {
                this.unregisterView((View)object);
            } else if (serializable == PHYSICAL_ENV_CHANGE) {
                this.evaluatePhysicalEnv((View)object);
            } else if (serializable == EMPTY_UNIVERSE) {
                this.destroyUniverseThreads((VirtualUniverse)object);
                this.threadListsChanged = true;
            } else if (serializable == START_RENDERER) {
                ((Canvas3D)object).isRunningStatus = true;
                this.threadListsChanged = true;
            } else if (serializable == STOP_RENDERER) {
                ((Canvas3D)object).isRunningStatus = false;
                this.threadListsChanged = true;
            } else if (serializable == RENDER_ONCE) {
                object2 = (View)object;
                ((View)object2).isRunning = true;
                this.renderOnceList.add(object2);
                this.sendRunMessage((View)object2, 128);
                this.threadListsChanged = true;
            } else if (serializable == FREE_CONTEXT) {
                object2 = (Canvas3D)object;
                if (((Canvas3D)object2).screen != null && ((Canvas3D)object2).screen.renderer != null) {
                    ((Canvas3D)object2).screen.renderer.removeCtx((Canvas3D)object2);
                }
            }
            ++n2;
        }
        n = this.tempViewList.size();
        if (n > 0) {
            if (this.running) {
                serializable = this.requestObjList;
                synchronized (serializable) {
                    int n3 = 0;
                    while (n3 < n) {
                        this.requestTypeList.add(STOP_VIEW);
                        this.requestObjList.add(this.tempViewList.get(n3));
                        ++n3;
                    }
                    this.setWork();
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    object = (View)this.tempViewList.get(n4);
                    ((View)object).stopViewCount = -1;
                    ((View)object).isRunning = false;
                    ++n4;
                }
            }
            this.tempViewList.clear();
            this.pendingRequest = true;
        } else {
            serializable = this.requestObjList;
            synchronized (serializable) {
                this.pendingRequest = this.requestObjList.size() > 0;
            }
        }
        if (!this.running && this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        this.requestObjList.clearMirror();
        this.requestTypeList.clearMirror();
    }

    private native void initializeJ3D();

    final boolean isD3D() {
        return this.isD3DAPI;
    }

    boolean isRegistered(View view) {
        return this.views.contains(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean mcThreadDone() {
        Object object = this.mcThreadLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (!this.pendingRequest) {
                    this.mcThread = null;
                    return true;
                }
                this.running = true;
                this.createMCThreads();
                return false;
            }
        }
    }

    void postRequest(Integer n, Object object) {
        Object object2 = this.mcThreadLock;
        synchronized (object2) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.mcThread == null) {
                    this.createMasterControlThread();
                }
                this.requestObjList.add(object);
                this.requestTypeList.add(n);
                this.pendingRequest = true;
            }
        }
        this.setWork();
    }

    void processMessage(J3dMessage j3dMessage) {
        j3dMessage.time = this.getTime();
        this.sendMessage(j3dMessage);
    }

    void processMessage(J3dMessage[] j3dMessageArray) {
        long l = this.getTime();
        int n = 0;
        while (n < j3dMessageArray.length) {
            j3dMessageArray[n].time = l;
            this.sendMessage(j3dMessageArray[n]);
            ++n;
        }
    }

    private void registerView(View view) {
        final VirtualUniverse virtualUniverse = view.universe;
        if (this.views.contains(view) && this.regUniverseList.contains(virtualUniverse)) {
            return;
        }
        if (!this.running) {
            this.running = true;
            this.createMCThreads();
        }
        view.assignViewId();
        this.createUpdateThread(virtualUniverse.behaviorStructure);
        this.createUpdateThread(virtualUniverse.geometryStructure);
        this.createUpdateThread(virtualUniverse.soundStructure);
        this.createUpdateThread(virtualUniverse.renderingEnvironmentStructure);
        this.createUpdateThread(virtualUniverse.transformStructure);
        J3dThreadData j3dThreadData = null;
        if (virtualUniverse.behaviorScheduler == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        virtualUniverse.behaviorScheduler = new BehaviorScheduler(rootThreadGroup, virtualUniverse);
                        virtualUniverse.behaviorScheduler.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            virtualUniverse.behaviorScheduler.initialize();
            j3dThreadData = virtualUniverse.behaviorScheduler.getThreadData(null, null);
            j3dThreadData.thread = virtualUniverse.behaviorScheduler;
            j3dThreadData.threadType = 1;
            j3dThreadData.lastUpdateTime = Math.max(this.currentTime, j3dThreadData.lastUpdateTime);
        }
        this.createUpdateThread(view.renderBin);
        this.createUpdateThread(view.soundScheduler);
        this.views.addUnique(view);
        this.regUniverseList.addUnique(virtualUniverse);
        this.evaluatePhysicalEnv(view);
    }

    void removeInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        this.inputDeviceThreads.remove(inputDeviceScheduler);
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void runMonitor(int var1_1, UnorderList var2_2, UnorderList var3_3, UnorderList var4_4, J3dThread var5_5) {
        block56: {
            cfr_temp_0 = -2147483648;
lbl2:
            // 2 sources

            block20: while (true) {
                switch (cfr_temp_0 == -2147483648 ? var1_1 : cfr_temp_0) {
                    case 2: {
                        var6_6 = 0;
                        var7_7 = 0;
                        var8_8 = 0;
                        var12_9 = (J3dThreadData[])var3_3.toArray(false);
                        var13_10 = (J3dThreadData[])var2_2.toArray(false);
                        var14_11 = (J3dThreadData[])var4_4.toArray(false);
                        var15_12 = var3_3.arraySize();
                        var16_13 = var2_2.arraySize();
                        var17_14 = var4_4.arraySize();
                        this.sleepTime = -1L;
                        var10_15 = false;
                        while (true) {
                            if (var10_15) {
                                return;
                            }
                            while (!this.renderWaiting && var7_7 != var15_12) {
                                var11_17 = var12_9[var7_7++];
                                if (!var11_17.needsRun) continue;
                                if ((var11_17.threadOpts & 8) != 0) {
                                    var9_16 = (View)((Object[])var11_17.threadArgs)[2];
                                    var9_16.computeCycleTime();
                                    if (!var9_16.isMinCycleTimeAchieve) {
                                        if (this.sleepTime < 0L) {
                                            this.sleepTime = var9_16.sleepTime;
                                        } else if (this.sleepTime > var9_16.sleepTime) {
                                            this.sleepTime = var9_16.sleepTime;
                                        }
                                        this.sendRunMessage(var9_16, 16);
                                        continue;
                                    }
                                    this.sleepTime = 0L;
                                    ++var9_16.frameNumber;
                                    var9_16.startTime = System.currentTimeMillis();
                                    if (var9_16.viewCache.vcDirtyMask != 0 && !var9_16.renderBin.orientedRAs.isEmpty() || !var9_16.renderBin.dirtyOrientedRAs.isEmpty()) {
                                        var9_16.renderBin.updateOrientedRAs();
                                        var9_16.viewCache.vcDirtyMask = 0;
                                    }
                                }
                                if (!var11_17.view.isMinCycleTimeAchieve) continue;
                                if ((var11_17.threadOpts & 32) != 0) {
                                    var9_16 = (View)((Object[])var11_17.threadArgs)[2];
                                    var9_16.renderBin.lockGeometry();
                                }
                                ++this.renderPending;
                                if (this.cpuLimit == 1) {
                                    var11_17.thread.args = (Object[])var11_17.threadArgs;
                                    var11_17.thread.doWork(this.currentTime);
                                } else {
                                    ++this.threadPending;
                                    var11_17.thread.runMonitor(2, this.currentTime, (Object[])var11_17.threadArgs);
                                }
                                if ((var11_17.threadOpts & 64) != 0) {
                                    var9_16 = (View)((Object[])var11_17.threadArgs)[2];
                                    var9_16.renderBin.releaseGeometry();
                                }
                                if ((var11_17.threadOpts & 16) != 0) {
                                    var9_16 = (View)((Object[])var11_17.threadArgs)[3];
                                    var9_16.stopTime = System.currentTimeMillis();
                                    this.timestampUpdateList.add(var9_16);
                                    var9_16.renderBin.compact(this.currentTime);
                                }
                                if (this.cpuLimit != 1 && (var11_17.threadOpts & 1) != 0) {
                                    this.renderWaiting = true;
                                }
                                if (this.cpuLimit == 1 || this.cpuLimit != this.threadPending) continue;
                                this.state = 4;
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var18_18) {
                                    System.err.println(var18_18);
                                }
                                this.state = 1;
                            }
                            if (true) ** GOTO lbl128
                            break;
                        }
                    }
                    case 3: {
                        --this.threadPending;
                        if (var5_5.type == 16) {
                            if (--this.renderPending == 0) {
                                this.renderWaiting = false;
                            }
                        } else if (--this.statePending == 0) {
                            this.stateWaiting = false;
                        }
                        if (this.state != 4) {
                            if (this.state != 3) return;
                        }
                        this.notify();
                        return;
                    }
                    case 0: {
                        if (!this.workToDo) {
                            this.state = 0;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var18_25) {
                                System.err.println(var18_25);
                            }
                            this.state = 1;
                        }
                        this.workToDo = false;
                        return;
                    }
                    case 1: {
                        this.workToDo = true;
                        if (this.state != 0) return;
                        this.notify();
                        return;
                    }
                    case 5: {
                        this.requestRenderWorkToDo = true;
                        if (this.state != 4 && this.state != 3) {
                            if (this.state != 0) return;
                        }
                        this.workToDo = true;
                        this.notify();
                        return;
                    }
                    default: {
                        return;
                    }
                    do {
                        var11_17 = var13_10[var6_6++];
                        if (!var11_17.needsRun) continue;
                        ++this.statePending;
                        if (this.cpuLimit == 1) {
                            var11_17.thread.args = (Object[])var11_17.threadArgs;
                            var11_17.thread.doWork(this.currentTime);
                        } else {
                            ++this.threadPending;
                            var11_17.thread.runMonitor(2, this.currentTime, (Object[])var11_17.threadArgs);
                        }
                        if (this.cpuLimit != 1 && (var11_17.threadOpts & 1) != 0) {
                            this.stateWaiting = true;
                        }
                        if (this.cpuLimit == 1 || this.cpuLimit != this.threadPending) continue;
                        this.state = 4;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var18_20) {
                            System.err.println(var18_20);
                        }
                        this.state = 1;
lbl128:
                        // 4 sources

                    } while (!this.stateWaiting && var6_6 != var16_13);
                    if (!this.renderWaiting && var7_7 == var15_12) {
                        var8_8 = 0;
                        while (!this.renderWaiting && var8_8 != var17_14) {
                            var11_17 = var14_11[var8_8++];
                            ++this.renderPending;
                            if (this.cpuLimit == 1) {
                                var11_17.thread.args = (Object[])var11_17.threadArgs;
                                var11_17.thread.doWork(this.currentTime);
                            } else {
                                ++this.threadPending;
                                var11_17.thread.runMonitor(2, this.currentTime, (Object[])var11_17.threadArgs);
                            }
                            if (this.cpuLimit != 1 && (var11_17.threadOpts & 1) != 0) {
                                this.renderWaiting = true;
                            }
                            if (this.cpuLimit == 1 || this.cpuLimit != this.threadPending) continue;
                            this.state = 4;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var18_21) {
                                System.err.println(var18_21);
                            }
                            this.state = 1;
                        }
                    }
                    if (this.cpuLimit != 1 && (this.renderWaiting != false && var6_6 == var16_13 || this.stateWaiting != false && var7_7 == var15_12 || this.renderWaiting && this.stateWaiting)) {
                        if (!this.requestRenderWorkToDo) {
                            this.state = 3;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var18_22) {
                                System.err.println(var18_22);
                            }
                            this.state = 1;
                        }
                        this.requestRenderWorkToDo = false;
                    }
                    if (var6_6 != var16_13 || var7_7 != var15_12 || var8_8 != var17_14 || this.threadPending != 0) ** continue;
                    var18_23 = this.timestampUpdateList.size() - 1;
                    while (var18_23 >= 0) {
                        var19_26 = (View)this.timestampUpdateList.get(var18_23);
                        var19_26.setFrameTimingValues();
                        var19_26.universe.behaviorStructure.incElapsedFrames();
                        --var18_23;
                    }
                    this.timestampUpdateList.clear();
                    this.updateMirrorObjects();
                    return;
lbl172:
                    // 1 sources

                    while (true) {
                        this.state = 3;
                        try {
                            this.wait();
                            cfr_temp_0 = 4;
                            continue block20;
                        }
                        catch (InterruptedException var18_24) {
                            cfr_temp_0 = 4;
                            System.err.println(var18_24);
                        }
                        break;
                    }
                    case 4: 
                }
                break;
            }
            break block56;
            ** while (true)
        }
        ** while (this.threadPending != 0)
lbl186:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    void sendMessage(J3dMessage var1_1) {
        block23: {
            var2_2 = var1_1;
            synchronized (var2_2) {
                block24: {
                    var4_3 = var1_1.universe;
                    var5_4 = var1_1.threads;
                    if ((var5_4 & 1024) != 0) {
                        this.renderingAttributesStructure.addMessage(var1_1);
                    }
                    if (var4_3 != null) {
                        if ((var5_4 & 64) != 0) {
                            var4_3.geometryStructure.addMessage(var1_1);
                        }
                        if ((var5_4 & 8192) != 0) {
                            var4_3.transformStructure.addMessage(var1_1);
                        }
                        if ((var5_4 & 256) != 0) {
                            var4_3.behaviorStructure.addMessage(var1_1);
                        }
                        if ((var5_4 & 512) != 0) {
                            var4_3.soundStructure.addMessage(var1_1);
                        }
                        if ((var5_4 & 4096) != 0) {
                            var4_3.renderingEnvironmentStructure.addMessage(var1_1);
                        }
                    }
                    if ((var5_4 & 2) != 0) {
                        if (var1_1.view != null && var1_1.view.soundScheduler != null) {
                            var1_1.view.soundScheduler.addMessage(var1_1);
                        } else {
                            var6_5 = this.views;
                            synchronized (var6_5) {
                                var8_6 = (View[])this.views.toArray(false);
                                var9_7 = this.views.arraySize() - 1;
                                while (var9_7 >= 0) {
                                    var8_6[var9_7--].soundScheduler.addMessage(var1_1);
                                }
                            }
                        }
                    }
                    if ((var5_4 & 128) == 0) break block23;
                    if (var1_1.view == null || var1_1.view.renderBin == null) break block24;
                    var1_1.view.renderBin.addMessage(var1_1);
                    break block23;
                }
                var6_5 = this.views;
                synchronized (var6_5) {
                    var8_6 = (View[])this.views.toArray(false);
                    var9_7 = this.views.arraySize() - 1;
                    if (var4_3 != null) ** GOTO lbl52
                    while (var9_7 >= 0) {
                        var8_6[var9_7--].renderBin.addMessage(var1_1);
                    }
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        if (var8_6[var9_7].universe == var4_3) {
                            var8_6[var9_7].renderBin.addMessage(var1_1);
                        }
                        --var9_7;
lbl52:
                        // 2 sources

                        ** while (var9_7 >= 0)
                    }
lbl53:
                    // 1 sources

                }
            }
        }
        this.setWork();
    }

    void sendRunMessage(int n) {
        long l = this.getTime();
        if ((n & 4) != 0) {
            UnorderList unorderList = this.inputDeviceThreads;
            synchronized (unorderList) {
                InputDeviceScheduler[] inputDeviceSchedulerArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(false);
                int n2 = this.inputDeviceThreads.size() - 1;
                while (n2 >= 0) {
                    if (inputDeviceSchedulerArray[n2].physicalEnv.activeViewRef > 0) {
                        inputDeviceSchedulerArray[n2].getThreadData().lastUpdateTime = l;
                    }
                    --n2;
                }
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        this.setWork();
    }

    void sendRunMessage(long l, View view, int n) {
        long l2 = this.getTime();
        if ((n & 2) != 0) {
            if (view.soundScheduler != null) {
                view.soundScheduler.threadData.lastUpdateTime = l2;
            }
            this.timerThread.addSoundSchedCond(l2 + l);
        }
        this.setWork();
    }

    void sendRunMessage(View view, int n) {
        long l = this.getTime();
        if ((n & 0x10) != 0) {
            UnorderList unorderList = this.renderThreadData;
            synchronized (unorderList) {
                J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                int n2 = this.renderThreadData.arraySize() - 1;
                while (n2 >= 0) {
                    J3dThreadData j3dThreadData = j3dThreadDataArray[n2--];
                    if (j3dThreadData.view != view || !view.renderBinReady) continue;
                    j3dThreadData.lastUpdateTime = l;
                }
            }
        }
        this.setWork();
    }

    void sendRunMessage(VirtualUniverse virtualUniverse, int n) {
        int n2;
        Object[] objectArray;
        UnorderList unorderList;
        long l = this.getTime();
        if ((n & 1) != 0 && virtualUniverse.behaviorScheduler != null) {
            virtualUniverse.behaviorScheduler.getThreadData(null, null).lastUpdateTime = l;
        }
        if ((n & 0x100) != 0) {
            virtualUniverse.behaviorStructure.threadData.lastUpdateTime = l;
        }
        if ((n & 0x200) != 0) {
            virtualUniverse.soundStructure.threadData.lastUpdateTime = l;
        }
        if ((n & 2) != 0) {
            unorderList = this.views;
            synchronized (unorderList) {
                objectArray = (View[])this.views.toArray(false);
                n2 = this.views.arraySize() - 1;
                while (n2 >= 0) {
                    if (((View)objectArray[n2]).soundScheduler != null && ((View)objectArray[n2]).universe == virtualUniverse) {
                        ((View)objectArray[n2]).soundScheduler.threadData.lastUpdateTime = l;
                    }
                    --n2;
                }
            }
        }
        if ((n & 0x10) != 0) {
            unorderList = this.renderThreadData;
            synchronized (unorderList) {
                objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                n2 = this.renderThreadData.arraySize() - 1;
                while (n2 >= 0) {
                    Object object = objectArray[n2--];
                    if (((J3dThreadData)object).view.universe != virtualUniverse || !((J3dThreadData)object).view.renderBinReady) continue;
                    ((J3dThreadData)object).lastUpdateTime = l;
                }
            }
        }
        this.setWork();
    }

    void setPixelFormat(int n) {
        this.pixelFormat = n;
    }

    private native void setThreadConcurrency(int var1);

    void setThreadPriority(final int n) {
        ThreadGroup threadGroup = rootThreadGroup;
        synchronized (threadGroup) {
            threadPriority = n;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread[] threadArray = new Thread[rootThreadGroup.activeCount()];
                    int n3 = rootThreadGroup.enumerate(threadArray);
                    int n2 = n3 - 1;
                    while (n2 >= 0) {
                        threadArray[n2].setPriority(n);
                        --n2;
                    }
                    return null;
                }
            });
        }
    }

    final void setWork() {
        this.runMonitor(1, null, null, null, null);
    }

    final void setWorkForRequestRenderer() {
        this.runMonitor(5, null, null, null, null);
    }

    private void startView(View view) {
        if (!this.views.contains(view) || view.isRunning || !view.active) {
            view.isRunning = true;
            return;
        }
        if (this.numActiveViews++ == 0) {
            this.renderingAttributesStructure.updateThread.active = true;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (virtualUniverse.activeViewCount++ == 0) {
            virtualUniverse.transformStructure.updateThread.active = true;
            virtualUniverse.geometryStructure.updateThread.active = true;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        }
        view.renderBin.updateThread.active = true;
        view.soundScheduler.updateThread.active = true;
        view.isRunning = true;
        this.threadListsChanged = true;
    }

    private void stopView(View view) {
        if (!(this.views.contains(view) && view.isRunning && view.active)) {
            view.isRunning = false;
            return;
        }
        if (--this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (--virtualUniverse.activeViewCount == 0) {
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
        }
        view.renderBin.updateThread.active = false;
        view.soundScheduler.updateThread.active = false;
        view.isRunning = false;
        this.assignNewPrimaryView(virtualUniverse);
        this.threadListsChanged = true;
    }

    private void unregisterView(View view) {
        int n;
        J3dThread j3dThread;
        Object object;
        if (!this.views.remove(view)) {
            view.active = false;
            return;
        }
        if (view.active) {
            this.viewDeactivate(view);
        }
        view.soundScheduler.updateThread.finish();
        view.soundScheduler.updateThread = null;
        view.renderBin.updateThread.finish();
        view.renderBin.removeAllRenderAtoms();
        view.cleanupViewId();
        view.renderBin.updateThread = null;
        VirtualUniverse virtualUniverse = view.universe;
        if (virtualUniverse.isEmpty()) {
            this.destroyUniverseThreads(virtualUniverse);
        }
        UnorderList unorderList = new UnorderList(1, class$javax$media$j3d$PhysicalEnvironment != null ? class$javax$media$j3d$PhysicalEnvironment : (class$javax$media$j3d$PhysicalEnvironment = MasterControl.class$("javax.media.j3d.PhysicalEnvironment")));
        Enumeration enumeration = PhysicalEnvironment.physicalEnvMap.keys();
        while (enumeration.hasMoreElements()) {
            object = (PhysicalEnvironment)enumeration.nextElement();
            j3dThread = (InputDeviceScheduler)PhysicalEnvironment.physicalEnvMap.get(object);
            n = ((PhysicalEnvironment)object).users.size() - 1;
            while (n >= 0) {
                if (this.views.contains((View)((PhysicalEnvironment)object).users.get(n))) break;
                --n;
            }
            if (n >= 0) continue;
            j3dThread.finish();
            ((PhysicalEnvironment)object).inputsched = null;
            unorderList.add(object);
        }
        n = unorderList.size() - 1;
        while (n >= 0) {
            PhysicalEnvironment.physicalEnvMap.remove(unorderList.get(n));
            --n;
        }
        if (this.views.isEmpty()) {
            object = Screen3D.deviceRendererMap.elements();
            while (object.hasMoreElements()) {
                j3dThread = (Renderer)object.nextElement();
                j3dThread.finish();
                if (((Renderer)j3dThread).onScreen != null && ((Renderer)j3dThread).onScreen.renderer != null) {
                    ((Renderer)j3dThread).onScreen.renderer.removeAllCtxs();
                    ((Renderer)j3dThread).onScreen.renderer = null;
                }
                if (((Renderer)j3dThread).offScreen != null && ((Renderer)j3dThread).offScreen.renderer != null) {
                    ((Renderer)j3dThread).offScreen.renderer.removeAllCtxs();
                    ((Renderer)j3dThread).offScreen.renderer = null;
                }
                ((Renderer)j3dThread).onScreen = null;
                ((Renderer)j3dThread).offScreen = null;
            }
            Screen3D.deviceRendererMap.clear();
        }
        this.evaluateAllCanvases();
        this.threadListsChanged = true;
    }

    void updateMirrorObjects() {
        ObjectUpdate[] objectUpdateArray = (ObjectUpdate[])this.mirrorObjects.toArray(false);
        int n = 0;
        while (n < this.mirrorObjects.arraySize()) {
            objectUpdateArray[n].updateObject();
            ++n;
        }
        this.mirrorObjects.clear();
    }

    private void updateTimeValues() {
        block25: {
            int n = 0;
            J3dThreadData j3dThreadData = null;
            J3dThreadData j3dThreadData2 = null;
            long l = this.currentTime;
            this.currentTime = this.getTime();
            J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
            int n2 = this.stateWorkThreads.arraySize();
            while (n < this.lastTransformStructureThread) {
                j3dThreadData2 = j3dThreadDataArray[n++];
                if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                    j3dThreadData = j3dThreadData2;
                    j3dThreadData2.needsRun = true;
                    j3dThreadData2.threadOpts = 2;
                    j3dThreadData2.lastRunTime = this.currentTime;
                    continue;
                }
                j3dThreadData2.needsRun = false;
            }
            if (j3dThreadData != null) {
                j3dThreadData.threadOpts = 1;
                j3dThreadData = null;
            }
            while (n < this.lastStructureUpdateThread) {
                j3dThreadData2 = j3dThreadDataArray[n++];
                if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                    j3dThreadData = j3dThreadData2;
                    j3dThreadData2.needsRun = true;
                    j3dThreadData2.threadOpts = 2;
                    j3dThreadData2.lastRunTime = this.currentTime;
                    continue;
                }
                j3dThreadData2.needsRun = false;
            }
            if (j3dThreadData != null) {
                j3dThreadData.threadOpts = 1;
                j3dThreadData = null;
            }
            while (n < n2) {
                j3dThreadData2 = j3dThreadDataArray[n++];
                if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                    j3dThreadData = j3dThreadData2;
                    j3dThreadData2.needsRun = true;
                    j3dThreadData2.threadOpts = 2;
                    j3dThreadData2.lastRunTime = this.currentTime;
                    continue;
                }
                j3dThreadData2.needsRun = false;
            }
            if (j3dThreadData != null) {
                j3dThreadData.threadOpts = 1;
                j3dThreadData = null;
            }
            j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
            n2 = this.renderWorkThreads.arraySize();
            View view = null;
            J3dThreadData j3dThreadData3 = null;
            ++this.waitTimestamp;
            n = 0;
            while (n < n2) {
                j3dThreadData2 = j3dThreadDataArray[n];
                if (j3dThreadData2.canvas == null) {
                    ((Object[])j3dThreadData2.threadArgs)[3] = null;
                }
                if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                    if (j3dThreadData2.thread.lastWaitTimestamp == this.waitTimestamp) {
                        ++this.waitTimestamp;
                        if (j3dThreadData2.view != view) {
                            view = j3dThreadData2.view;
                            j3dThreadData3.threadOpts = 17;
                            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                            j3dThreadData2.threadOpts = 42;
                        } else {
                            j3dThreadData3.threadOpts = (j3dThreadData3.threadOpts & 8) != 0 ? 41 : 1;
                            j3dThreadData2.threadOpts = 2;
                            if (j3dThreadData2.canvas == null) {
                                j3dThreadData3.threadOpts |= 0x40;
                            }
                        }
                    } else if (j3dThreadData2.view != view) {
                        view = j3dThreadData2.view;
                        if (j3dThreadData3 != null) {
                            j3dThreadData3.threadOpts = 17;
                            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                        }
                        j3dThreadData2.threadOpts = 42;
                    } else {
                        j3dThreadData2.threadOpts = 2;
                    }
                    j3dThreadData2.thread.lastWaitTimestamp = this.waitTimestamp;
                    j3dThreadData2.needsRun = true;
                    j3dThreadData2.lastRunTime = this.currentTime;
                    j3dThreadData3 = j3dThreadData2;
                } else {
                    j3dThreadData2.needsRun = false;
                }
                ++n;
            }
            if (j3dThreadData3 != null) {
                j3dThreadData3.threadOpts = 17;
                ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
            }
            if (this.sleepTime <= 0L) break block25;
            this.sleepTime -= this.currentTime - l;
            if (this.sleepTime > 0L) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void updateWorkThreads() {
        J3dThreadData j3dThreadData;
        Canvas3D[][] canvas3DArray;
        Object object;
        View[] viewArray;
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        if (this.numActiveViews > 0) {
            this.addToStateThreads(this.renderingAttributesStructure.getUpdateThreadData());
        }
        VirtualUniverse[] virtualUniverseArray = (VirtualUniverse[])this.activeUniverseList.toArray(false);
        int n = this.activeUniverseList.arraySize();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.addToStateThreads(virtualUniverseArray[n2].transformStructure.getUpdateThreadData());
            --n2;
        }
        this.lastTransformStructureThread = this.stateWorkThreads.size();
        n2 = n - 1;
        while (n2 >= 0) {
            VirtualUniverse virtualUniverse = virtualUniverseArray[n2];
            this.addToStateThreads(virtualUniverse.geometryStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.behaviorStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.renderingEnvironmentStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.soundStructure.getUpdateThreadData());
            --n2;
        }
        this.lastStructureUpdateThread = this.stateWorkThreads.size();
        n2 = n - 1;
        while (n2 >= 0) {
            this.addToStateThreads(virtualUniverseArray[n2].behaviorScheduler.getThreadData(null, null));
            --n2;
        }
        InputDeviceScheduler[] inputDeviceSchedulerArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(true);
        n2 = this.inputDeviceThreads.size() - 1;
        while (n2 >= 0) {
            viewArray = inputDeviceSchedulerArray[n2].getThreadData();
            viewArray.thread.active = true;
            this.addToStateThreads((J3dThreadData)viewArray);
            --n2;
        }
        viewArray = (View[])this.views.toArray(false);
        n2 = this.views.size() - 1;
        while (n2 >= 0) {
            object = viewArray[n2];
            if (((View)object).active && ((View)object).isRunning) {
                int n3;
                this.addToStateThreads(((View)object).renderBin.getUpdateThreadData());
                this.addToStateThreads(((View)object).soundScheduler.getUpdateThreadData());
                canvas3DArray = ((View)object).getCanvasList(false);
                int n4 = ((View)object).getLongestScreenList();
                Object[] objectArray = null;
                int n5 = 0;
                while (n5 < n4) {
                    n3 = 0;
                    while (n3 < canvas3DArray.length) {
                        if (n5 < canvas3DArray[n3].length) {
                            Canvas3D canvas3D = canvas3DArray[n3][n5];
                            if (canvas3D.active && canvas3D.isRunningStatus && !canvas3D.offScreen) {
                                if (canvas3D.screen.renderer == null) {
                                    System.out.println("null renderer");
                                } else {
                                    j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, canvas3D);
                                    this.renderWorkThreads.add(j3dThreadData);
                                    objectArray = (Object[])j3dThreadData.threadArgs;
                                    objectArray[0] = RENDER;
                                    objectArray[1] = canvas3D;
                                    objectArray[2] = object;
                                }
                            }
                        }
                        ++n3;
                    }
                    ++n5;
                }
                n3 = 0;
                while (n3 < canvas3DArray.length) {
                    int n6 = 0;
                    while (n6 < canvas3DArray[n3].length) {
                        Canvas3D canvas3D = canvas3DArray[n3][n6];
                        if (canvas3D.active && canvas3D.isRunningStatus && !canvas3D.offScreen) {
                            j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, null);
                            this.renderWorkThreads.add(j3dThreadData);
                            objectArray = (Object[])j3dThreadData.threadArgs;
                            objectArray[0] = SWAP;
                            objectArray[1] = object;
                            objectArray[2] = canvas3DArray[n3];
                            break;
                        }
                        ++n6;
                    }
                    ++n3;
                }
            }
            --n2;
        }
        j3dThreadData = null;
        object = Screen3D.deviceRendererMap.elements();
        while (object.hasMoreElements()) {
            canvas3DArray = (Canvas3D[][])object.nextElement();
            j3dThreadData = canvas3DArray.getThreadData(null, null);
            this.requestRenderWorkThreads.add(j3dThreadData);
            j3dThreadData.threadOpts = 2;
            ((Object[])j3dThreadData.threadArgs)[0] = REQUESTRENDER;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts |= 1;
        }
        this.threadListsChanged = false;
    }

    private void viewActivate(View view) {
        VirtualUniverse virtualUniverse = view.universe;
        if (!this.views.contains(view) || !this.regUniverseList.contains(virtualUniverse)) {
            this.registerView(view);
        } else if (view.active) {
            return;
        }
        if (this.numActiveViews++ == 0) {
            this.renderingAttributesStructure.updateThread.active = true;
        }
        if (virtualUniverse.activeViewCount++ == 0) {
            virtualUniverse.behaviorScheduler.active = true;
            virtualUniverse.transformStructure.updateThread.active = true;
            virtualUniverse.geometryStructure.updateThread.active = true;
            virtualUniverse.geometryStructure.resetConditionMet();
            virtualUniverse.behaviorStructure.updateThread.active = true;
            virtualUniverse.behaviorStructure.resetConditionMet();
            virtualUniverse.soundStructure.updateThread.active = true;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
            this.activeUniverseList.add(virtualUniverse);
        }
        view.soundScheduler.updateThread.active = true;
        view.renderBin.updateThread.active = true;
        view.active = true;
        if (view.physicalEnvironment.activeViewRef++ == 0) {
            view.physicalEnvironment.inputsched.activate();
        }
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.evaluateAllCanvases();
        view.inRenderThreadData = true;
        this.threadListsChanged = true;
    }

    private void viewDeactivate(View view) {
        if (!this.views.contains(view) || !view.active) {
            view.active = false;
            return;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (view.isRunning) {
            --this.numActiveViews;
            --virtualUniverse.activeViewCount;
        }
        if (this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        if (virtualUniverse.activeViewCount == 0 && virtualUniverse.behaviorScheduler != null) {
            virtualUniverse.behaviorScheduler.deactivate();
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.behaviorStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            this.activeUniverseList.remove(virtualUniverse);
        }
        view.soundScheduler.updateThread.active = false;
        view.renderBin.updateThread.active = false;
        view.active = false;
        if (--view.physicalEnvironment.activeViewRef == 0) {
            view.physicalEnvironment.inputsched.deactivate();
        }
        this.assignNewPrimaryView(virtualUniverse);
        this.evaluateAllCanvases();
        view.inRenderThreadData = false;
        this.threadListsChanged = true;
    }
}

