/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformGroupRetained;

class J3dNodeTable {
    Hashtable nodeTable = new Hashtable();
    String[] nodeArray = new String[200];
    static final int MAX_NUM_NODES = 200;
    static final int NOTHING = 0;
    static final int GROUP = 1;
    static final int TRANSFORM_GROUP = 2;
    static final int SWITCH_GROUP = 3;
    static final int ORDERED_GROUP = 4;
    static final int BRANCH_GROUP = 5;
    static final int ENDGROUP = 9;
    static final int SHAPE3D = 10;
    static final int APPEARANCE = 20;
    static final int MATERIAL = 21;
    static final int TEXTURE = 22;
    static final int TEX_COORD_GENERATION = 23;
    static final int TEXTURE_ATTRIBUTES = 24;
    static final int COLORING_ATTRIBUTES = 25;
    static final int TRANSPARENCY_ATTRIBUTES = 26;
    static final int RENDERING_ATTRIBUTES = 27;
    static final int POLYGON_ATTRIBUTES = 28;
    static final int LINE_ATTRIBUTES = 29;
    static final int POINT_ATTRIBUTES = 30;
    static final int TEXTURE_2D = 31;
    static final int TEXTURE_3D = 32;
    static final int IMAGE_COMPONENT = 33;
    static final int IMAGE_COMPONENT_2D = 34;
    static final int IMAGE_COMPONENT_3D = 35;
    static final int ENDAPPEARANCE = 49;
    static final int GEOMETRY = 100;
    static final int COMPRESSED_GEOMETRY = 101;
    static final int GEOMETRY_ARRAY = 102;
    static final int GEOMETRY_STRIP_ARRAY = 103;
    static final int INDEXED_GEOMETRY_ARRAY = 104;
    static final int INDEXED_GEOMETRY_STRIP_ARRAY = 105;
    static final int INDEXED_LINE_ARRAY = 106;
    static final int INDEXED_LINE_STRIP_ARRAY = 107;
    static final int INDEXED_POINT_ARRAY = 108;
    static final int INDEXED_QUAD_ARRAY = 109;
    static final int INDEXED_TRIANGLE_ARRAY = 110;
    static final int INDEXED_TRIANGLE_FAN_ARRAY = 111;
    static final int INDEXED_TRIANGLE_STRIP_ARRAY = 112;
    static final int LINE_ARRAY = 113;
    static final int LINE_STRIP_ARRAY = 114;
    static final int POINT_ARRAY = 115;
    static final int QUAD_ARRAY = 116;
    static final int TRIANGLE_ARRAY = 117;
    static final int TRIANGLE_FAN_ARRAY = 118;
    static final int TRIANGLE_STRIP_ARRAY = 119;
    static final int BACKGROUND_SOUND = 120;
    static final int POINT_SOUND = 121;
    static final int CONE_SOUND = 122;
    static final int MEDIA_CONTAINER = 123;
    static final int ROTATION_INTERPOLATOR = 150;
    static final int ROTPOSSCALEPATH_INTERPOLATOR = 151;
    static final int ROTATIONPATH_INTERPOLATOR = 152;
    static final int POSITIONPATH_INTERPOLATOR = 153;
    static final int ROTPOSPATH_INTERPOLATOR = 154;
    static final int POSITION_INTERPOLATOR = 155;
    static final int SWITCHVALUE_INTERPOLATOR = 156;
    static final int COLOR_INTERPOLATOR = 157;
    static final int SCALE_INTERPOLATOR = 158;
    static final int SOUND_PLAYER = 159;
    static final int SOUND_FADER = 160;
    static final int BOUNDS = 170;
    static final int BOUNDING_SPHERE = 171;
    static final int BOUNDING_BOX = 172;
    static final int BOUNDING_POLYTOPE = 173;
    static final int TRANSFORM3D = 180;
    static final int BACKGROUND = 181;
    static final int LIGHT = 190;
    static final int POINT_LIGHT = 191;
    static final int SPOT_LIGHT = 192;
    static final int DIRECTIONAL_LIGHT = 193;
    static final int AMBIENT_LIGHT = 194;

    J3dNodeTable() {
        int n = 0;
        while (n < 200) {
            this.nodeArray[n] = null;
            ++n;
        }
        this.nodeArray[1] = "Group";
        this.nodeArray[2] = "TransformGroup";
        this.nodeArray[3] = "Switch";
        this.nodeArray[4] = "OrderedGroup";
        this.nodeArray[5] = "BranchGroup";
        this.nodeArray[10] = "Shape3D";
        this.nodeArray[20] = "Appearance";
        this.nodeArray[21] = "Material";
        this.nodeArray[22] = "Texture";
        this.nodeArray[31] = "Texture2D";
        this.nodeArray[32] = "Texture3D";
        this.nodeArray[33] = "ImageComponent";
        this.nodeArray[34] = "ImageComponent2D";
        this.nodeArray[35] = "ImageComponent3D";
        this.nodeArray[26] = "TransparencyAttributes";
        this.nodeArray[100] = "Geometry";
        this.nodeArray[101] = "CompressedGeometry";
        this.nodeArray[102] = "GeometryArray";
        this.nodeArray[103] = "GeometryStripArray";
        this.nodeArray[104] = "IndexedGeometryArray";
        this.nodeArray[105] = "IndexedGeometryStripArray";
        this.nodeArray[106] = "IndexedLineArray";
        this.nodeArray[107] = "IndexedLineStripArray";
        this.nodeArray[108] = "IndexedPointArray";
        this.nodeArray[109] = "IndexedQuadArray";
        this.nodeArray[110] = "IndexedTriangleArray";
        this.nodeArray[111] = "IndexedTriangleFanArray";
        this.nodeArray[112] = "indexedTriangleStripArray";
        this.nodeArray[113] = "LineArray";
        this.nodeArray[114] = "LineStripArray";
        this.nodeArray[115] = "PointArray";
        this.nodeArray[116] = "QuadArray";
        this.nodeArray[117] = "TriangleArray";
        this.nodeArray[118] = "TriangleFanArray";
        this.nodeArray[119] = "TriangleStripArray";
        this.nodeArray[120] = "BackgroundSound";
        this.nodeArray[121] = "PointSound";
        this.nodeArray[122] = "ConeSound";
        this.nodeArray[123] = "MediaContainer";
        this.nodeArray[150] = "RotationInterpolator";
        this.nodeArray[151] = "RotPosScalePathInterpolator";
        this.nodeArray[152] = "RotationPathInterpolator";
        this.nodeArray[153] = "PositionPathInterpolator";
        this.nodeArray[154] = "RotPosPathInterpolator";
        this.nodeArray[155] = "PositionInterpolator";
        this.nodeArray[156] = "SwitchValueInterpolator";
        this.nodeArray[157] = "ColorInterpolator";
        this.nodeArray[158] = "ScaleInterpolator";
        this.nodeArray[159] = "SoundPlayer";
        this.nodeArray[160] = "SoundFader";
        this.nodeArray[170] = "Bounds";
        this.nodeArray[171] = "BoundingSphere";
        this.nodeArray[172] = "BoundingBox";
        this.nodeArray[173] = "BoundingPolytope";
        this.nodeArray[180] = "Transform3D";
        this.nodeArray[181] = "Background";
        this.nodeArray[190] = "Light";
        this.nodeArray[191] = "PointLight";
        this.nodeArray[192] = "SpotLight";
        this.nodeArray[193] = "DirectionalLight";
        this.nodeArray[194] = "AmbientLight";
        int n2 = 0;
        while (n2 < 200) {
            if (this.nodeArray[n2] != null) {
                this.nodeTable.put(this.nodeArray[n2], new Integer(n2));
            }
            ++n2;
        }
    }

    int getNodeValue(Object object) {
        String string;
        Integer n;
        String string2 = object.getClass().getName();
        int n2 = string2.lastIndexOf(".");
        n2 = n2 == -1 ? 0 : ++n2;
        int n3 = string2.lastIndexOf("Retained");
        if (n3 == -1) {
            n3 = string2.length();
        }
        if ((n = (Integer)this.nodeTable.get(string = string2.substring(n2, n3))) != null) {
            return n;
        }
        if (object instanceof TransformGroup || object instanceof TransformGroupRetained) {
            return 2;
        }
        if (object instanceof BranchGroup || object instanceof BranchGroupRetained) {
            return 5;
        }
        if (object instanceof Switch || object instanceof SwitchRetained) {
            return 3;
        }
        if (object instanceof Group || object instanceof GroupRetained) {
            return 1;
        }
        if (object instanceof Shape3D) {
            return 10;
        }
        System.err.println("Warning: Don't know how to save object of type " + object);
        return 0;
    }

    Object getObject(int n) {
        try {
            if (this.nodeArray[n] != null) {
                String string = "javax.media.j3d." + this.nodeArray[n];
                return Class.forName(string).newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception creating object for nodeValue " + n);
            System.err.println("nodeName = javax.media.j3d." + this.nodeArray[n]);
            System.exit(0);
        }
        return null;
    }
}

