/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public abstract class IndexedGeometryArray
extends GeometryArray {
    public static final int ALLOW_COORDINATE_INDEX_READ = 9;
    public static final int ALLOW_COORDINATE_INDEX_WRITE = 10;
    public static final int ALLOW_COLOR_INDEX_READ = 11;
    public static final int ALLOW_COLOR_INDEX_WRITE = 12;
    public static final int ALLOW_NORMAL_INDEX_READ = 13;
    public static final int ALLOW_NORMAL_INDEX_WRITE = 14;
    public static final int ALLOW_TEXCOORD_INDEX_READ = 15;
    public static final int ALLOW_TEXCOORD_INDEX_WRITE = 16;

    IndexedGeometryArray() {
    }

    public IndexedGeometryArray(int n, int n2, int n3) {
        super(n, n2);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(n3);
    }

    public IndexedGeometryArray(int n, int n2, int n3, int[] nArray, int n4) {
        super(n, n2, n3, nArray);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(n4);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)nodeComponent.retained;
        IndexedGeometryArrayRetained indexedGeometryArrayRetained2 = (IndexedGeometryArrayRetained)this.retained;
        int n = indexedGeometryArrayRetained.getVertexFormat();
        int[] nArray = new int[indexedGeometryArrayRetained.getIndexCount()];
        if ((n & 1) != 0) {
            indexedGeometryArrayRetained.getCoordinateIndices(0, nArray);
            indexedGeometryArrayRetained2.setCoordinateIndices(0, nArray);
        }
        if ((n & 2) != 0) {
            indexedGeometryArrayRetained.getNormalIndices(0, nArray);
            indexedGeometryArrayRetained2.setNormalIndices(0, nArray);
        }
        if ((n & 4) != 0) {
            indexedGeometryArrayRetained.getColorIndices(0, nArray);
            indexedGeometryArrayRetained2.setColorIndices(0, nArray);
        }
        if ((n & 0x20) != 0 || (n & 0x40) != 0) {
            int n2 = 0;
            while (n2 < indexedGeometryArrayRetained.texCoordSetCount) {
                indexedGeometryArrayRetained.getTextureCoordinateIndices(n2, 0, nArray);
                indexedGeometryArrayRetained2.setTextureCoordinateIndices(n2, 0, nArray);
                ++n2;
            }
        }
    }

    public int getColorIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getColorIndex(n);
    }

    public void getColorIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getColorIndices(n, nArray);
    }

    public int getCoordinateIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndex(n);
    }

    public void getCoordinateIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndices(n, nArray);
    }

    public int getIndexCount() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray0"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getIndexCount();
    }

    public int getNormalIndex(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getNormalIndex(n);
    }

    public void getNormalIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getNormalIndices(n, nArray);
    }

    public int getTextureCoordinateIndex(int n) {
        return this.getTextureCoordinateIndex(0, n);
    }

    public int getTextureCoordinateIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndex(n, n2);
    }

    public void getTextureCoordinateIndices(int n, int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndices(n, n2, nArray);
    }

    public void getTextureCoordinateIndices(int n, int[] nArray) {
        this.getTextureCoordinateIndices(0, n, nArray);
    }

    public void setColorIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndex(n, n2);
    }

    public void setColorIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndices(n, nArray);
    }

    public void setCoordinateIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndex(n, n2);
    }

    public void setCoordinateIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndices(n, nArray);
    }

    public void setNormalIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndex(n, n2);
    }

    public void setNormalIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndices(n, nArray);
    }

    public void setTextureCoordinateIndex(int n, int n2) {
        this.setTextureCoordinateIndex(0, n, n2);
    }

    public void setTextureCoordinateIndex(int n, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndex(n, n2, n3);
    }

    public void setTextureCoordinateIndices(int n, int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndices(n, n2, nArray);
    }

    public void setTextureCoordinateIndices(int n, int[] nArray) {
        this.setTextureCoordinateIndices(0, n, nArray);
    }
}

