/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dI18N;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

abstract class GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    static final int majorVersionNumber = 1;
    static final int minorVersionNumber = 0;
    static final int minorMinorVersionNumber = 2;
    private static final int GC_VERTEX = 64;
    private static final int GC_SET_NORM = 192;
    private static final int GC_SET_COLOR = 128;
    private static final int GC_MESH_B_R = 32;
    private static final int GC_SET_STATE = 24;
    private static final int GC_SET_TABLE = 16;
    private static final int GC_PASS_THROUGH = 8;
    private static final int GC_EOS = 0;
    private static final int GC_V_NO_OP = 1;
    private static final int GC_SKIP_8 = 7;
    private HuffmanTableEntry[][] gctables;
    private MeshBufferEntry[] meshBuffer;
    private int meshIndex = 15;
    private int meshState;
    private static final int USE_MESH_NORMAL = 1;
    private static final int USE_MESH_COLOR = 2;
    private short curX;
    private short curY;
    private short curZ;
    private short curR;
    private short curG;
    private short curB;
    private short curA;
    private int curSex;
    private int curOct;
    private int curU;
    private int curV;
    private Point3f curPos = new Point3f();
    private Vector3f curNorm = new Vector3f();
    private Color4f curColor = new Color4f();
    private int repCode;
    private boolean bundlingNorm;
    private boolean bundlingColor;
    private boolean doingAlpha;
    private int currentHeader = 0;
    private int nextHeader = 0;
    private int bitBuffer = 0;
    private int bitBufferCount = 32;
    private long startTime;
    private int vertexCount;
    private static final int[] BMASK;
    private byte[] gcData;
    private int gcIndex;
    private static final double[][][] gcNormals;
    private static final double NORMAL_MAX_Y_ANG = 0.615479709;
    private static final boolean printNormalTable = false;

    static {
        int[] nArray = new int[33];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        nArray[17] = 131071;
        nArray[18] = 262143;
        nArray[19] = 524287;
        nArray[20] = 1048575;
        nArray[21] = 0x1FFFFF;
        nArray[22] = 0x3FFFFF;
        nArray[23] = 0x7FFFFF;
        nArray[24] = 0xFFFFFF;
        nArray[25] = 0x1FFFFFF;
        nArray[26] = 0x3FFFFFF;
        nArray[27] = 0x7FFFFFF;
        nArray[28] = 0xFFFFFFF;
        nArray[29] = 0x1FFFFFFF;
        nArray[30] = 0x3FFFFFFF;
        nArray[31] = Integer.MAX_VALUE;
        nArray[32] = -1;
        BMASK = nArray;
        gcNormals = new double[65][65][3];
        int n = 0;
        while (n < 65) {
            int n2 = 0;
            while (n2 < 65) {
                if (n + n2 <= 64) {
                    double d = 0.615479709 * ((double)n / 64.0);
                    double d2 = Math.asin(Math.tan(0.615479709 * ((double)(64 - n2) / 64.0)));
                    double d3 = Math.cos(d2) * Math.cos(d);
                    double d4 = Math.sin(d);
                    double d5 = Math.sin(d2) * Math.cos(d);
                    int n3 = (int)(d3 *= 16384.0);
                    d3 = n3;
                    int n4 = (int)(d4 *= 16384.0);
                    d4 = n4;
                    int n5 = (int)(d5 *= 16384.0);
                    d5 = n5;
                    GeometryDecompressor.gcNormals[n][n2][0] = d3 /= 16384.0;
                    GeometryDecompressor.gcNormals[n][n2][1] = d4 /= 16384.0;
                    GeometryDecompressor.gcNormals[n][n2][2] = d5 /= 16384.0;
                }
                ++n2;
            }
            ++n;
        }
    }

    GeometryDecompressor() {
        this.gctables = new HuffmanTableEntry[3][64];
        int n = 0;
        while (n < 64) {
            this.gctables[0][n] = new HuffmanTableEntry();
            this.gctables[1][n] = new HuffmanTableEntry();
            this.gctables[2][n] = new HuffmanTableEntry();
            ++n;
        }
        this.meshBuffer = new MeshBufferEntry[16];
        int n2 = 0;
        while (n2 < 16) {
            this.meshBuffer[n2] = new MeshBufferEntry();
            ++n2;
        }
    }

    private void benchmarkPrint(int n) {
        float f = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
        System.out.println("  done in " + f + " sec." + "\n" + "  decompressed " + this.vertexCount + " vertices at " + (float)this.vertexCount / f + " vertices/sec\n");
        System.out.print("  vertex data present: coords");
        int n2 = 12;
        if (this.bundlingNorm) {
            System.out.print(" normals");
            n2 += 12;
        }
        if (this.bundlingColor) {
            System.out.println(" colors");
            n2 += 12;
        }
        if (this.doingAlpha) {
            System.out.println(" alpha");
            n2 += 4;
        }
        System.out.println();
        System.out.println("  bytes of data in generalized strip output: " + this.vertexCount * n2 + "\n" + "  compression ratio: " + (float)n / (float)(this.vertexCount * n2) + "\n");
    }

    private void benchmarkStart(int n) {
        this.vertexCount = 0;
        System.out.println(" GeometryDecompressor: decompressing " + n + " bytes...");
        this.startTime = System.currentTimeMillis();
    }

    boolean checkVersion(int n, int n2) {
        return n < 1 || n == 1 && n2 <= 0;
    }

    void decompress(int n, int n2, byte[] byArray) {
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryDecompressor0"));
        }
        this.gcData = byArray;
        this.gcIndex = n;
        this.bitBufferCount = 0;
        this.meshState = 0;
        this.bundlingNorm = false;
        this.bundlingColor = false;
        this.doingAlpha = false;
        this.repCode = 0;
        this.nextHeader = 1;
        while (this.gcIndex < n + n2) {
            this.processDecompression();
        }
        if (this.bitBufferCount > 0) {
            this.processDecompression();
        }
    }

    private int getBits(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        if (this.bitBufferCount == 0) {
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            this.bitBufferCount = 32;
        }
        if (this.bitBufferCount >= n) {
            n2 = this.bitBuffer >>> 32 - n & BMASK[n];
            this.bitBuffer <<= n;
            this.bitBufferCount -= n;
        } else {
            n2 = this.bitBuffer >>> 32 - n & BMASK[n];
            n2 >>>= n - this.bitBufferCount;
            n2 <<= n - this.bitBufferCount;
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            n2 |= this.bitBuffer >>> 32 - (n - this.bitBufferCount) & BMASK[n - this.bitBufferCount];
            this.bitBuffer <<= n - this.bitBufferCount;
            this.bitBufferCount = 32 - (n - this.bitBufferCount);
        }
        return n2;
    }

    private void indexNormal(int n, int n2, int n3, int n4, Vector3f vector3f) {
        float f;
        float f2;
        float f3;
        if (n > 5) {
            switch (n2 & 1) {
                case 0: {
                    switch ((n & 1) << 1 | (n2 & 4) >> 2) {
                        case 0: {
                            f3 = 1.0f;
                            f2 = 0.0f;
                            f = 0.0f;
                            break;
                        }
                        case 1: {
                            f = 1.0f;
                            f2 = 0.0f;
                            f3 = 0.0f;
                            break;
                        }
                        default: {
                            f2 = 1.0f;
                            f = 0.0f;
                            f3 = 0.0f;
                        }
                    }
                    n = 0;
                    n2 = (n2 & 2) >> 1;
                    n2 = n2 << 2 | n2 << 1 | n2;
                    break;
                }
                default: {
                    n2 = (n & 1) << 2 | n2 >> 1;
                    n = 0;
                    f = f2 = (float)(1.0 / Math.sqrt(3.0));
                    f3 = f2;
                }
            }
            if ((n2 & 1) != 0) {
                f2 = -f2;
            }
            if ((n2 & 2) != 0) {
                f = -f;
            }
            if ((n2 & 4) != 0) {
                f3 = -f3;
            }
        } else {
            float f4;
            f3 = (float)gcNormals[n4][n3][0];
            f = (float)gcNormals[n4][n3][1];
            f2 = (float)gcNormals[n4][n3][2];
            if ((n & 4) != 0) {
                f4 = f3;
                f3 = f2;
                f2 = f4;
            }
            if ((n & 2) != 0) {
                f4 = f;
                f = f2;
                f2 = f4;
            }
            if ((n & 1) != 0) {
                f4 = f3;
                f3 = f;
                f = f4;
            }
            if ((n2 & 1) != 0) {
                f2 = -f2;
            }
            if ((n2 & 2) != 0) {
                f = -f;
            }
            if ((n2 & 4) != 0) {
                f3 = -f3;
            }
        }
        vector3f.set(f3, f, f2);
    }

    abstract void outputColor(Color4f var1);

    abstract void outputNormal(Vector3f var1);

    abstract void outputVertex(Point3f var1, Vector3f var2, Color4f var3, int var4);

    abstract void outputVertexFormat(boolean var1, boolean var2, boolean var3);

    private void processDecompression() {
        this.currentHeader = this.nextHeader;
        if ((this.currentHeader & 0xC0) == 64) {
            if (!this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(8);
                int n = this.processDecompressionOpcode(0);
            } else if (this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(6);
                int n = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(8);
                this.processDecompressionOpcode(n);
            } else if (!this.bundlingNorm && this.bundlingColor) {
                this.nextHeader = this.getBits(6);
                int n = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8);
                this.processDecompressionOpcode(n);
            } else {
                this.nextHeader = this.getBits(6);
                int n = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(6);
                this.processDecompressionOpcode(n);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8);
                this.processDecompressionOpcode(n);
            }
            this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
            this.meshState |= 1;
            this.meshState |= 2;
        } else {
            this.nextHeader = this.getBits(8);
            this.processDecompressionOpcode(0);
        }
    }

    private int processDecompressionOpcode(int n) {
        if ((this.currentHeader & 0xC0) == 192) {
            this.processSetNormal(n);
        } else if ((this.currentHeader & 0xC0) == 128) {
            this.processSetColor(n);
        } else {
            if ((this.currentHeader & 0xC0) == 64) {
                return this.processVertex();
            }
            if ((this.currentHeader & 0xE0) == 32) {
                this.processMeshBR();
                this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
                this.meshState |= 1;
                this.meshState |= 2;
            } else if ((this.currentHeader & 0xF8) == 24) {
                this.processSetState();
            } else if ((this.currentHeader & 0xF8) == 16) {
                this.processSetTable();
            } else if ((this.currentHeader & 0xFF) == 0) {
                this.processEos();
            } else if ((this.currentHeader & 0xFF) == 1) {
                this.processVNoop();
            } else if ((this.currentHeader & 0xFF) == 8) {
                this.processPassThrough();
            } else if ((this.currentHeader & 0xFF) == 7) {
                this.processSkip8();
            }
        }
        return 0;
    }

    private void processEos() {
    }

    private void processMeshBR() {
        int n = this.getBits(1);
        int n2 = this.currentHeader >>> 1 & 0xF;
        this.repCode = (this.currentHeader & 1) << 1 | n;
        n2 = this.meshIndex - n2 & 0xF;
        MeshBufferEntry meshBufferEntry = this.meshBuffer[n2];
        this.curX = meshBufferEntry.x;
        this.curY = meshBufferEntry.y;
        this.curZ = meshBufferEntry.z;
        this.curPos.set((float)this.curX / 32768.0f, (float)this.curY / 32768.0f, (float)this.curZ / 32768.0f);
        if (this.bundlingNorm && (this.meshState & 1) != 0) {
            this.curSex = meshBufferEntry.sextant;
            this.curOct = meshBufferEntry.octant;
            this.curU = meshBufferEntry.u;
            this.curV = meshBufferEntry.v;
            int n3 = this.curSex << 15 | this.curOct << 12 | this.curU << 6 | this.curV;
            this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        }
        if (this.bundlingColor && (this.meshState & 2) != 0) {
            this.curR = meshBufferEntry.r;
            this.curG = meshBufferEntry.g;
            this.curB = meshBufferEntry.b;
            this.curColor.x = this.curR;
            this.curColor.x = (float)((double)this.curColor.x / 32768.0);
            this.curColor.y = this.curG;
            this.curColor.y = (float)((double)this.curColor.y / 32768.0);
            this.curColor.z = this.curB;
            this.curColor.z = (float)((double)this.curColor.z / 32768.0);
            if (this.doingAlpha) {
                this.curA = meshBufferEntry.a;
                this.curColor.w = this.curA;
                this.curColor.w = (float)((double)this.curColor.w / 32768.0);
            }
        }
        this.meshState = 0;
    }

    private void processPassThrough() {
        int n = this.getBits(24);
        n = this.getBits(32);
    }

    private void processSetColor(int n) {
        int n2;
        int n3;
        this.meshState &= 0xFFFFFFFD;
        HuffmanTableEntry huffmanTableEntry = this.gctables[1][this.currentHeader & 0x3F];
        int n4 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        int n5 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
        int n6 = 0;
        if (huffmanTableEntry.tagLength + n4 == 6) {
            n3 = this.getBits(n4);
            n2 = this.getBits(n4);
            if (this.doingAlpha) {
                n6 = this.getBits(n4);
            }
        } else if (huffmanTableEntry.tagLength + n4 < 6) {
            n5 >>= 6 - huffmanTableEntry.tagLength - n4;
            n3 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n4];
            if (huffmanTableEntry.tagLength + 2 * n4 == 6) {
                n2 = this.getBits(n4);
                if (this.doingAlpha) {
                    n6 = this.getBits(n4);
                }
            } else if (huffmanTableEntry.tagLength + 2 * n4 < 6) {
                n3 >>= 6 - huffmanTableEntry.tagLength - 2 * n4;
                n2 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 2 * n4];
                if (huffmanTableEntry.tagLength + 3 * n4 == 6) {
                    if (this.doingAlpha) {
                        n6 = this.getBits(n4);
                    }
                } else if (huffmanTableEntry.tagLength + 3 * n4 < 6) {
                    n2 >>= 6 - huffmanTableEntry.tagLength - 3 * n4;
                    if (this.doingAlpha) {
                        n6 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 4 * n4];
                        if (huffmanTableEntry.tagLength + 4 * n4 < 6) {
                            n6 >>= 6 - huffmanTableEntry.tagLength - 3 * n4;
                        } else if (huffmanTableEntry.tagLength + 4 * n4 > 6) {
                            int n7 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - 3 * n4));
                            n6 = n6 << n4 - (6 - huffmanTableEntry.tagLength - 3 * n4) | n7;
                        }
                    }
                } else {
                    int n8 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - 2 * n4));
                    n2 = n2 << n4 - (6 - huffmanTableEntry.tagLength - 2 * n4) | n8;
                    if (this.doingAlpha) {
                        n6 = this.getBits(n4);
                    }
                }
            } else {
                int n9 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - n4));
                n3 = n3 << n4 - (6 - huffmanTableEntry.tagLength - n4) | n9;
                n2 = this.getBits(n4);
                if (this.doingAlpha) {
                    n6 = this.getBits(n4);
                }
            }
        } else {
            int n10 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength));
            n5 = n5 << n4 - (6 - huffmanTableEntry.tagLength) | n10;
            n3 = this.getBits(n4);
            n2 = this.getBits(n4);
            if (this.doingAlpha) {
                n6 = this.getBits(n4);
            }
        }
        n5 <<= 32 - n4;
        n3 <<= 32 - n4;
        n2 <<= 32 - n4;
        n6 <<= 32 - n4;
        short s = (short)((n5 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s2 = (short)((n3 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s3 = (short)((n2 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s4 = (short)((n6 >>= 32 - n4) << huffmanTableEntry.rightShift);
        if (huffmanTableEntry.absolute != 0) {
            this.curR = s;
            this.curG = s2;
            this.curB = s3;
            if (this.doingAlpha) {
                this.curA = s4;
            }
        } else {
            this.curR = (short)(this.curR + s);
            this.curG = (short)(this.curG + s2);
            this.curB = (short)(this.curB + s3);
            if (this.doingAlpha) {
                this.curA = (short)(this.curA + s4);
            }
        }
        if (n != 0) {
            this.meshBuffer[this.meshIndex].r = this.curR;
            this.meshBuffer[this.meshIndex].g = this.curG;
            this.meshBuffer[this.meshIndex].b = this.curB;
            this.meshBuffer[this.meshIndex].a = this.curA;
        }
        float f = this.curR;
        f = (float)((double)f / 32768.0);
        float f2 = this.curG;
        f2 = (float)((double)f2 / 32768.0);
        float f3 = this.curB;
        f3 = (float)((double)f3 / 32768.0);
        float f4 = this.curA;
        f4 = (float)((double)f4 / 32768.0);
        this.curColor.set(f, f2, f3, f4);
        if (!this.bundlingColor) {
            this.outputColor(this.curColor);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processSetNormal(int var1_1) {
        block36: {
            block38: {
                block37: {
                    block35: {
                        block34: {
                            this.meshState &= -2;
                            var2_2 = this.gctables[2][this.currentHeader & 63];
                            var7_3 = var2_2.dataLength - var2_2.rightShift;
                            if (var2_2.absolute == 0) break block34;
                            var3_4 = this.currentHeader & GeometryDecompressor.BMASK[6 - var2_2.tagLength];
                            if (var2_2.tagLength != 0) {
                                var8_5 = this.getBits(6 - (6 - var2_2.tagLength));
                                var3_4 = var3_4 << 6 - (6 - var2_2.tagLength) | var8_5;
                            }
                            this.curU = this.getBits(var7_3);
                            this.curV = this.getBits(var7_3);
                            this.curU <<= var2_2.rightShift;
                            this.curV <<= var2_2.rightShift;
                            this.curSex = var3_4 >> 3 & 7;
                            this.curOct = var3_4 & 7;
                            ** GOTO lbl106
                        }
                        var4_8 = this.currentHeader & GeometryDecompressor.BMASK[6 - var2_2.tagLength];
                        if (var2_2.tagLength + var7_3 < 6) {
                            var4_8 >>= 6 - var2_2.tagLength - var7_3;
                            var5_9 = this.currentHeader & GeometryDecompressor.BMASK[6 - var2_2.tagLength - var7_3];
                            if (var2_2.tagLength + 2 * var7_3 < 6) {
                                var5_9 >>= 6 - var2_2.tagLength - 2 * var7_3;
                            } else if (var2_2.tagLength + 2 * var7_3 > 6) {
                                var8_6 = this.getBits(var7_3 - (6 - var2_2.tagLength - var7_3));
                                var5_9 = var5_9 << var7_3 - (6 - var2_2.tagLength - var7_3) | var8_6;
                            }
                        } else if (var2_2.tagLength + var7_3 > 6) {
                            var8_7 = this.getBits(var7_3 - (6 - var2_2.tagLength));
                            var4_8 = var4_8 << var7_3 - (6 - var2_2.tagLength) | var8_7;
                            var5_9 = this.getBits(var7_3);
                        } else {
                            var5_9 = this.getBits(var7_3);
                        }
                        var4_8 <<= 32 - var7_3;
                        var4_8 >>= 32 - var7_3;
                        var5_9 <<= 32 - var7_3;
                        var5_9 >>= 32 - var7_3;
                        this.curU += (var4_8 <<= var2_2.rightShift);
                        this.curV += (var5_9 <<= var2_2.rightShift);
                        if (this.curU >= 0 && this.curV >= 0 && this.curU + this.curV <= 64) ** GOTO lbl106
                        if (this.curU >= 0 || this.curV < 0) break block35;
                        this.curU = -this.curU;
                        switch (this.curSex) {
                            case 0: {
                                this.curSex = 4;
                                ** GOTO lbl106
                            }
                            case 1: {
                                this.curSex = 5;
                                ** GOTO lbl106
                            }
                            case 2: {
                                this.curSex = 3;
                                ** GOTO lbl106
                            }
                            case 3: {
                                this.curSex = 2;
                                ** GOTO lbl106
                            }
                            case 4: {
                                this.curSex = 0;
                                ** GOTO lbl106
                            }
                            case 5: {
                                this.curSex = 1;
                                ** GOTO lbl106
                            }
                            default: {
                                if (var1_1 == 0) break block36;
                            }
                        }
                    }
                    if (this.curU < 0 || this.curV >= 0) break block37;
                    this.curV = -this.curV;
                    switch (this.curSex) {
                        case 1: 
                        case 5: {
                            this.curOct ^= 4;
                            ** GOTO lbl106
                        }
                        case 0: 
                        case 4: {
                            this.curOct ^= 2;
                            ** GOTO lbl106
                        }
                        case 2: 
                        case 3: {
                            this.curOct ^= 1;
                            ** GOTO lbl106
                        }
                        default: {
                            if (var1_1 == 0) break block36;
                        }
                    }
                }
                if (this.curU + this.curV <= 64) break block38;
                this.curU = 64 - this.curU;
                this.curV = 64 - this.curV;
                switch (this.curSex) {
                    case 0: {
                        this.curSex = 2;
                        ** GOTO lbl106
                    }
                    case 1: {
                        this.curSex = 3;
                        ** GOTO lbl106
                    }
                    case 2: {
                        this.curSex = 0;
                        ** GOTO lbl106
                    }
                    case 3: {
                        this.curSex = 1;
                        ** GOTO lbl106
                    }
                    case 4: {
                        this.curSex = 5;
                        ** GOTO lbl106
                    }
                    case 5: {
                        this.curSex = 4;
                        ** GOTO lbl106
                    }
                    default: {
                        if (var1_1 == 0) break block36;
                    }
                }
            }
            throw new IllegalArgumentException(J3dI18N.getString("GeometryDecompressor1"));
lbl106:
            // 17 sources

            if (var1_1 == 0) break block36;
            this.meshBuffer[this.meshIndex].sextant = (short)this.curSex;
            this.meshBuffer[this.meshIndex].octant = (short)this.curOct;
            this.meshBuffer[this.meshIndex].u = (short)this.curU;
            this.meshBuffer[this.meshIndex].v = (short)this.curV;
        }
        this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        if (!this.bundlingNorm) {
            this.outputNormal(this.curNorm);
        }
    }

    private void processSetState() {
        int n = this.getBits(3);
        this.bundlingNorm = (this.currentHeader & 1) != 0;
        this.bundlingColor = (n >>> 2 & 1) != 0;
        this.doingAlpha = (n >>> 1 & 1) != 0;
        this.outputVertexFormat(this.bundlingNorm, this.bundlingColor, this.doingAlpha);
    }

    private void processSetTable() {
        HuffmanTableEntry[] huffmanTableEntryArray = this.gctables[(this.currentHeader & 6) >>> 1];
        int n = this.getBits(15);
        int n2 = (this.currentHeader & 1) << 6 | n >>> 9 & 0x3F;
        int n3 = n >>> 5 & 0xF;
        if (n3 == 0) {
            n3 = 16;
        }
        int n4 = n & 0xF;
        int n5 = n >>> 4 & 1;
        int n6 = 6;
        while (n6 > 0) {
            if (n2 >> n6 != 0) break;
            --n6;
        }
        n2 = n2 << 6 - n6 & 0x3F;
        int n7 = 0;
        while (n7 < 1 << 6 - n6) {
            huffmanTableEntryArray[n2 + n7].tagLength = n6;
            huffmanTableEntryArray[n2 + n7].dataLength = n3;
            huffmanTableEntryArray[n2 + n7].rightShift = n4;
            huffmanTableEntryArray[n2 + n7].absolute = n5;
            ++n7;
        }
    }

    private void processSkip8() {
        int n = this.getBits(8);
    }

    private void processVNoop() {
        int n = this.getBits(5);
        int n2 = this.getBits(n);
    }

    private int processVertex() {
        int n;
        int n2;
        int n3;
        this.meshState = 0;
        HuffmanTableEntry huffmanTableEntry = this.gctables[0][this.currentHeader & 0x3F];
        int n4 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        if (6 - 3 * n4 - huffmanTableEntry.tagLength > 0) {
            int n5 = 6 - 3 * n4 - huffmanTableEntry.tagLength;
            int n6 = this.currentHeader & BMASK[n5];
            n3 = this.getBits(3 - n5);
            n3 |= n6 << 3 - n5;
        } else {
            n3 = this.getBits(3);
        }
        this.repCode = n3 >>> 1;
        int n7 = n3 & 1;
        int n8 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
        if (huffmanTableEntry.tagLength + n4 == 6) {
            n2 = this.getBits(n4);
            n = this.getBits(n4);
        } else if (huffmanTableEntry.tagLength + n4 < 6) {
            n8 >>= 6 - huffmanTableEntry.tagLength - n4;
            n2 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n4];
            if (huffmanTableEntry.tagLength + 2 * n4 == 6) {
                n = this.getBits(n4);
            } else if (huffmanTableEntry.tagLength + 2 * n4 < 6) {
                n2 >>= 6 - huffmanTableEntry.tagLength - 2 * n4;
                n = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 2 * n4];
                if (huffmanTableEntry.tagLength + 3 * n4 < 6) {
                    n >>= 6 - huffmanTableEntry.tagLength - 3 * n4;
                } else if (huffmanTableEntry.tagLength + 3 * n4 > 6) {
                    n3 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - 2 * n4));
                    n = n << n4 - (6 - huffmanTableEntry.tagLength - 2 * n4) | n3;
                }
            } else {
                n3 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength - n4));
                n2 = n2 << n4 - (6 - huffmanTableEntry.tagLength - n4) | n3;
                n = this.getBits(n4);
            }
        } else {
            n3 = this.getBits(n4 - (6 - huffmanTableEntry.tagLength));
            n8 = n8 << n4 - (6 - huffmanTableEntry.tagLength) | n3;
            n2 = this.getBits(n4);
            n = this.getBits(n4);
        }
        n8 <<= 32 - n4;
        n2 <<= 32 - n4;
        n <<= 32 - n4;
        short s = (short)((n8 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s2 = (short)((n2 >>= 32 - n4) << huffmanTableEntry.rightShift);
        short s3 = (short)((n >>= 32 - n4) << huffmanTableEntry.rightShift);
        if (huffmanTableEntry.absolute != 0) {
            this.curX = s;
            this.curY = s2;
            this.curZ = s3;
        } else {
            this.curX = (short)(this.curX + s);
            this.curY = (short)(this.curY + s2);
            this.curZ = (short)(this.curZ + s3);
        }
        if (n7 != 0) {
            this.meshIndex = this.meshIndex + 1 & 0xF;
            this.meshBuffer[this.meshIndex].x = this.curX;
            this.meshBuffer[this.meshIndex].y = this.curY;
            this.meshBuffer[this.meshIndex].z = this.curZ;
        }
        float f = this.curX;
        f = (float)((double)f / 32768.0);
        float f2 = this.curY;
        f2 = (float)((double)f2 / 32768.0);
        float f3 = this.curZ;
        f3 = (float)((double)f3 / 32768.0);
        this.curPos.set(f, f2, f3);
        return n7;
    }

    static class HuffmanTableEntry {
        int tagLength;
        int dataLength;
        int rightShift;
        int absolute;

        HuffmanTableEntry() {
        }

        public String toString() {
            return " tag length: " + this.tagLength + " data length: " + this.dataLength + " shift: " + this.rightShift + " abs/rel: " + this.absolute;
        }
    }

    static class MeshBufferEntry {
        short x;
        short y;
        short z;
        short octant;
        short sextant;
        short u;
        short v;
        short r;
        short g;
        short b;
        short a;

        MeshBufferEntry() {
        }
    }
}

