/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

abstract class FogRetained
extends LeafRetained {
    static final int COLOR_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int BOUNDINGLEAF_CHANGED = 8;
    static final int LAST_DEFINED_BIT = 8;
    Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Vector scopes = new Vector();
    int isDirty = 65535;
    boolean inImmCtx = false;
    Bounds region = null;
    FogRetained sgFog = null;
    FogRetained mirrorFog = null;
    static final int targetThreads = 4224;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    ArrayList environmentSets = new ArrayList();

    FogRetained() {
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        setLiveState.notifyThreads |= 0x1080;
        if (this.mirrorFog.boundingLeaf != null) {
            this.mirrorFog.boundingLeaf.removeUser(this.mirrorFog);
        }
        setLiveState.nodeList.add(this.mirrorFog);
    }

    protected Object clone() {
        FogRetained fogRetained = (FogRetained)super.clone();
        fogRetained.color = new Color3f(this.color);
        Bounds bounds = this.getInfluencingBounds();
        if (bounds != null) {
            fogRetained.initInfluencingBounds(bounds);
        }
        fogRetained.scopes = new Vector();
        fogRetained.isDirty = 65535;
        fogRetained.inImmCtx = false;
        fogRetained.region = null;
        fogRetained.sgFog = null;
        fogRetained.mirrorFog = null;
        fogRetained.environmentSets = new ArrayList();
        return fogRetained;
    }

    Enumeration getAllScopes() {
        Enumeration enumeration = this.scopes.elements();
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add(((GroupRetained)enumeration.nextElement()).source);
        }
        return vector.elements();
    }

    void getColor(Color3f color3f) {
        color3f.set((Tuple3f)this.color);
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    Bounds getInfluencingBounds() {
        return this.regionOfInfluence != null ? (Bounds)this.regionOfInfluence.clone() : null;
    }

    Group getScope(int n) {
        return (Group)((GroupRetained)this.scopes.elementAt((int)n)).source;
    }

    void initAddScope(Group group) {
        this.scopes.addElement((GroupRetained)group.retained);
    }

    synchronized void initColor(float f, float f2, float f3) {
        this.color.x = f;
        this.color.y = f2;
        this.color.z = f3;
    }

    synchronized void initColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void initInfluencingBounds(Bounds bounds) {
        this.regionOfInfluence = bounds != null ? (Bounds)bounds.clone() : null;
    }

    void initInsertScope(Node node, int n) {
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
    }

    synchronized void initMirrorObject() {
        Bounds bounds = null;
        this.mirrorFog.inBackgroundGroup = this.inBackgroundGroup;
        this.mirrorFog.geometryBackground = this.geometryBackground;
        this.mirrorFog.color.set((Tuple3f)this.color);
        this.mirrorFog.parent = this.parent;
        int n = 0;
        while (n < this.scopes.size()) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
            this.tempKey.reset();
            groupRetained.markAllNodesForScopedFog(this.mirrorFog, this.tempKey);
            ++n;
        }
        this.mirrorFog.isScoped = this.scopes.size() > 0;
        this.mirrorFog.region = null;
        if (this.boundingLeaf != null) {
            if (this.mirrorFog.boundingLeaf != null) {
                this.mirrorFog.boundingLeaf.removeUser(this.mirrorFog);
            }
            this.mirrorFog.boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
            this.mirrorFog.boundingLeaf.addUser(this.mirrorFog);
            bounds = this.mirrorFog.boundingLeaf.transformedRegion;
        } else {
            this.mirrorFog.boundingLeaf = null;
        }
        if (this.regionOfInfluence != null) {
            this.mirrorFog.regionOfInfluence = (Bounds)this.regionOfInfluence.clone();
            if (this.mirrorFog.region == null) {
                this.mirrorFog.region = (Bounds)this.mirrorFog.regionOfInfluence.clone();
                this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.lastLocalToVworld[0]);
            }
        } else {
            this.mirrorFog.regionOfInfluence = null;
        }
        this.mirrorFog.sgFog = this;
    }

    void initRemoveScope(int n) {
        this.scopes.removeElementAt(n);
    }

    void initScope(Group group, int n) {
        this.scopes.setElementAt((GroupRetained)group.retained, n);
    }

    void insertScope(Node node, int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
        GroupRetained groupRetained = (GroupRetained)node.retained;
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    boolean isScoped() {
        return this.scopes != null;
    }

    int numScopes() {
        return this.scopes.size();
    }

    void removeScope(int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        this.scopes.removeElementAt(n);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 22;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    synchronized void setColor(float f, float f2, float f3) {
        this.initColor(f, f2, f3);
        this.sendMessage(1, new Color3f(f, f2, f3));
    }

    synchronized void setColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
        this.sendMessage(1, new Color3f(color3f));
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorFog);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorFog);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(8, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(4, bounds != null ? bounds.clone() : null);
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("FogRetained0"));
        }
        super.doSetLive(setLiveState);
        if (this.mirrorFog == null) {
            this.mirrorFog = (FogRetained)this.clone();
            this.mirrorFog.boundingLeaf = null;
            this.mirrorFog.sgFog = this;
        }
        this.initMirrorObject();
        setLiveState.nodeList.add(this.mirrorFog);
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.mirrorFog.clearCompositeSwitchMask();
                    this.mirrorFog.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.envNodes.add(this.mirrorFog);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.mirrorFog.clearCompositeSwitchMask();
            this.mirrorFog.isNewSwitchLeaf = true;
            ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.envNodes.add(this.mirrorFog);
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void setScope(Group group, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList2, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.initScope(group, n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    abstract void update(int var1, double var2);

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = (Bounds)this.regionOfInfluence.clone();
            this.region.transform(this.regionOfInfluence, this.currentLocalToVworld[0]);
        } else {
            this.region = null;
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 4) != 0) {
            this.mirrorFog.regionOfInfluence = (Bounds)objectArray[2];
            if (this.mirrorFog.boundingLeaf == null) {
                if (objectArray[2] != null) {
                    this.mirrorFog.region = (Bounds)this.mirrorFog.regionOfInfluence.clone();
                    this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.currentLocalToVworld[0]);
                } else {
                    this.mirrorFog.region = null;
                }
            }
        } else if ((n & 8) != 0) {
            this.mirrorFog.boundingLeaf = (BoundingLeafRetained)objectArray[2];
            if (objectArray[2] != null) {
                this.mirrorFog.region = this.mirrorFog.boundingLeaf.transformedRegion;
            } else if (this.mirrorFog.regionOfInfluence != null) {
                this.mirrorFog.region = (Bounds)this.mirrorFog.regionOfInfluence.clone();
                this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.currentLocalToVworld[0]);
            } else {
                this.mirrorFog.region = null;
            }
        } else if ((n & 2) != 0) {
            Object e;
            int n2;
            Object[] objectArray2 = (Object[])objectArray[2];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                this.mirrorFog.isScoped = bl;
                n2 = 0;
                while (n2 < arrayList.size()) {
                    e = arrayList.get(n2);
                    if (e instanceof GroupRetained) {
                        ((GroupRetained)e).addFog(this.mirrorFog);
                    } else if (e instanceof Shape3DRetained) {
                        ((Shape3DRetained)e).addFog(this.mirrorFog);
                    }
                    ++n2;
                }
            }
            if (arrayList2 != null) {
                this.mirrorFog.isScoped = bl;
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    e = arrayList2.get(n2);
                    if (e instanceof GroupRetained) {
                        ((GroupRetained)e).removeFog(this.mirrorFog);
                    } else if (e instanceof Shape3DRetained) {
                        ((Shape3DRetained)e).removeFog(this.mirrorFog);
                    }
                    ++n2;
                }
            }
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = (Bounds)this.regionOfInfluence.clone();
            this.region.transform(this.regionOfInfluence, this.sgFog.currentLocalToVworld[0]);
        }
    }

    void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 1) != 0) {
            this.mirrorFog.color.set((Tuple3f)((Color3f)objectArray[2]));
        }
    }

    void updateTransformChange() {
    }
}

