/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Transform3D;

class DisplayListRenderMethod
implements RenderMethod {
    final int bufferSize = 128;
    int[] buffer = new int[128];

    DisplayListRenderMethod() {
    }

    void buildDisplayList(RenderMolecule renderMolecule, Canvas3D canvas3D, boolean bl) {
        boolean bl2 = renderMolecule.useAlpha;
        if (bl) {
            canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
        }
        canvas3D.newDisplayList(canvas3D.ctx, renderMolecule.displayListId);
        RenderAtom renderAtom = renderMolecule.primaryRenderAtomList;
        while (renderAtom != null) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtom.geometryAtom.geometry;
            if (geometryArrayRetained instanceof IndexedGeometryArrayRetained) {
                ((GeometryArrayRetained)geometryArrayRetained.mirrorGeometry).buildGA(canvas3D.ctx, renderAtom, false, bl2 && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, renderMolecule.textureBin.attributeBin.ignoreVertexColors);
            } else {
                geometryArrayRetained.buildGA(canvas3D.ctx, renderAtom, false, bl2 && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, renderMolecule.textureBin.attributeBin.ignoreVertexColors);
            }
            renderAtom = renderAtom.next;
        }
        canvas3D.endDisplayList(canvas3D.ctx);
        if (bl) {
            canvas3D.makeCtxCurrent(canvas3D.ctx);
        }
    }

    native void callDisplayLists(int var1, int[] var2);

    public void render(RenderMolecule renderMolecule, Canvas3D canvas3D) {
        Transform3D transform3D = null;
        if (renderMolecule.doInfinite || renderMolecule.vwcBounds.intersect(canvas3D.viewFrustum)) {
            transform3D = renderMolecule.doInfinite ? renderMolecule.infLocalToVworld : renderMolecule.localeLocalToVworld;
            boolean bl = (transform3D.getType() & 0x40) == 0;
            canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vworldToEc.mat, transform3D.mat);
            canvas3D.callDisplayList(canvas3D.ctx, renderMolecule.displayListId, bl);
        }
    }

    public void update(RenderMolecule renderMolecule) {
    }
}

