/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Shape3DRetained;

class CompileState {
    HashMap knownAppearances = new HashMap();
    int numAppearances = 0;
    int numShared = 0;
    Stack destStack = new Stack();
    GroupRetained curDest = null;
    Stack shapeListStack = new Stack();
    HashMap shapeLists = null;
    int numShapes = 0;
    int numMergeSets = 0;
    int numMergeGeos = 0;
    boolean compileVerbose = false;

    CompileState() {
        try {
            this.compileVerbose = Boolean.getBoolean("javax.media.j3d.compileVerbose");
        }
        catch (AccessControlException accessControlException) {
            this.compileVerbose = false;
        }
        this.initShapeMerge();
    }

    void addShape(Shape3DRetained shape3DRetained) {
        if (this.curDest != null) {
            GroupRetained groupRetained;
            Vector<Shape3DRetained> vector = (Vector<Shape3DRetained>)this.shapeLists.get(shape3DRetained.appearance);
            if (vector == null) {
                vector = new Vector<Shape3DRetained>();
                this.shapeLists.put(shape3DRetained.appearance, vector);
            }
            if (shape3DRetained.parent instanceof GroupRetained && (groupRetained = (GroupRetained)shape3DRetained.parent).isStaticChildren()) {
                vector.add(shape3DRetained);
                boolean bl = false;
                int n = groupRetained.numChildren();
                int n2 = 0;
                while (n2 < n && !bl) {
                    if (groupRetained.getChild((int)n2).retained == shape3DRetained) {
                        bl = true;
                        groupRetained.removeChild(n2);
                    }
                    ++n2;
                }
                if (!bl) {
                    System.out.println("ShapeSet.add(): Can't remove shape from parent, can't find shape!");
                }
            }
        }
    }

    void endGroup() {
    }

    AppearanceRetained getAppearance(AppearanceRetained appearanceRetained) {
        if (appearanceRetained.map == this && appearanceRetained.mapAppearance != null) {
            ++this.numShared;
            return appearanceRetained.mapAppearance;
        }
        AppearanceRetained appearanceRetained2 = (AppearanceRetained)this.knownAppearances.get(appearanceRetained);
        if (appearanceRetained2 != null) {
            ++this.numShared;
        } else {
            this.knownAppearances.put(appearanceRetained, appearanceRetained);
            ++this.numAppearances;
            ++this.numShared;
            appearanceRetained2 = appearanceRetained;
        }
        appearanceRetained.map = this;
        appearanceRetained.mapAppearance = appearanceRetained2;
        return appearanceRetained2;
    }

    private void initShapeMerge() {
        this.destStack.push(null);
        this.shapeListStack.push(null);
    }

    void printStats() {
        try {
            if (Boolean.getBoolean("javax.media.j3d.compileStats")) {
                System.out.println("Compile shared " + this.numShared + " appearances" + " as " + this.numAppearances + " unique apprearances ");
                System.out.println("Compile merged " + this.numMergeGeos + " geos into " + this.numMergeSets + " merge sets ");
            }
        }
        catch (AccessControlException accessControlException) {}
    }

    void startGroup(GroupRetained groupRetained) {
        this.curDest = groupRetained;
        this.shapeLists = new HashMap();
        this.destStack.push(this.curDest);
        this.shapeListStack.push(this.shapeLists);
    }
}

