/*
 * Decompiled with CFR 0.152.
 */
package de.mnl.java.io.base64;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private static final char[] charCodes = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private byte[] encBuf = new byte[4];
    private int encoded = 0;
    private int surplus;
    private int col = 0;
    private boolean finishOnFlush;

    public Base64OutputStream(OutputStream out, boolean finishOnFlush) {
        super(out);
        this.finishOnFlush = finishOnFlush;
    }

    public void setFinishOnFlush(boolean value) {
        this.finishOnFlush = value;
    }

    public void write(int b) throws IOException {
        byte[] a = new byte[]{(byte)(b & 0xFF)};
        this.write(a, 0, 1);
    }

    public void write(byte[] data, int off, int len) throws IOException {
        int pos = off;
        while (this.encoded > 0 && pos < off + len) {
            this.encodeByte(data[pos]);
            ++pos;
        }
        while (pos + 2 < off + len) {
            byte b0 = data[pos];
            byte b1 = data[pos + 1];
            byte b2 = data[pos + 2];
            this.encBuf[0] = (byte)charCodes[b0 >> 2 & 0x3F];
            this.encBuf[1] = (byte)charCodes[(b0 & 3) << 4 | b1 >> 4 & 0xF];
            this.encBuf[2] = (byte)charCodes[(b1 & 0xF) << 2 | b2 >> 6 & 3];
            this.encBuf[3] = (byte)charCodes[b2 & 0x3F];
            this.out.write(this.encBuf);
            this.encoded = 0;
            this.col += 4;
            if (this.col >= 76) {
                this.out.write(10);
                this.col = 0;
            }
            pos += 3;
        }
        while (pos < off + len) {
            this.encodeByte(data[pos]);
            ++pos;
        }
    }

    private void encodeByte(byte b) throws IOException {
        switch (this.encoded) {
            case 0: {
                this.encBuf[0] = (byte)charCodes[b >> 2 & 0x3F];
                this.surplus = (b & 3) << 4;
                this.encBuf[1] = (byte)charCodes[this.surplus];
                ++this.encoded;
                break;
            }
            case 1: {
                this.encBuf[1] = (byte)charCodes[this.surplus | b >> 4 & 0xF];
                this.surplus = (b & 0xF) << 2;
                this.encBuf[2] = (byte)charCodes[this.surplus];
                ++this.encoded;
                break;
            }
            case 2: {
                this.encBuf[2] = (byte)charCodes[this.surplus | b >>> 6 & 3];
                this.encBuf[3] = (byte)charCodes[b & 0x3F];
                this.out.write(this.encBuf);
                this.encoded = 0;
                this.col += 4;
                if (this.col < 76) break;
                this.out.write(10);
                this.col = 0;
                break;
            }
        }
    }

    public void flush() throws IOException {
        if (this.finishOnFlush) {
            this.doFlush();
        }
    }

    private void doFlush() throws IOException {
        switch (this.encoded) {
            case 1: {
                this.encBuf[2] = 61;
            }
            case 2: {
                this.encBuf[3] = 61;
                this.out.write(this.encBuf);
                this.col += 4;
                break;
            }
        }
        if (this.col > 0) {
            this.out.write(10);
            this.col = 0;
        }
    }

    public void close() throws IOException {
        this.doFlush();
        this.out.close();
    }
}

