/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewerAvatar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Vector3d;

public class ViewingPlatform
extends BranchGroup {
    protected ViewPlatform viewPlatform;
    protected MultiTransformGroup mtg;
    protected BranchGroup platformGeometryRoot;
    protected BranchGroup avatarRoot;
    protected PlatformGeometry platformGeometry = null;
    protected Hashtable viewerList = new Hashtable();

    public ViewingPlatform() {
        this(1);
    }

    public ViewingPlatform(int n) {
        this.setCapability(13);
        this.setCapability(14);
        if (n < 1) {
            n = 1;
        }
        this.mtg = new MultiTransformGroup(n);
        TransformGroup transformGroup = this.mtg.getTransformGroup(0);
        this.addChild((Node)transformGroup);
        transformGroup = this.mtg.getTransformGroup(n - 1);
        this.viewPlatform = new ViewPlatform();
        this.viewPlatform.setCapability(12);
        this.viewPlatform.setCapability(13);
        transformGroup.addChild((Node)this.viewPlatform);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        this.avatarRoot = new BranchGroup();
        this.avatarRoot.setCapability(12);
        this.avatarRoot.setCapability(13);
        this.avatarRoot.setCapability(14);
        transformGroup.addChild((Node)this.avatarRoot);
        this.platformGeometryRoot = new BranchGroup();
        this.platformGeometryRoot.setCapability(12);
        this.platformGeometryRoot.setCapability(13);
        this.platformGeometryRoot.setCapability(14);
        transformGroup.addChild((Node)this.platformGeometryRoot);
    }

    void addViewer(Viewer viewer) {
        this.viewerList.put(viewer, this.avatarRoot);
    }

    private int findAvatarChild(ViewerAvatar viewerAvatar) {
        int n = 0;
        while (n < this.avatarRoot.numChildren()) {
            if ((ViewerAvatar)this.avatarRoot.getChild(n) == viewerAvatar) {
                return n;
            }
            ++n;
        }
        System.err.println("ViewingPlatform.findAvatarChild:Child not found.");
        return -1;
    }

    public MultiTransformGroup getMultiTransformGroup() {
        return this.mtg;
    }

    public ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    public TransformGroup getViewPlatformTransform() {
        return this.mtg.getTransformGroup(this.mtg.getNumTransforms() - 1);
    }

    void setAvatar(Viewer viewer, ViewerAvatar viewerAvatar) {
        Object v = this.viewerList.get(viewer);
        int n = -1;
        if (v != this.avatarRoot) {
            n = this.findAvatarChild((ViewerAvatar)((Object)v));
        }
        if (viewerAvatar == null) {
            if (n != -1) {
                this.avatarRoot.removeChild(n);
                this.viewerList.put(viewer, this.avatarRoot);
            }
        } else {
            if (n != -1) {
                this.avatarRoot.setChild((Node)viewerAvatar, n);
            } else {
                this.avatarRoot.addChild((Node)viewerAvatar);
            }
            this.viewerList.put(viewer, viewerAvatar);
        }
    }

    public void setNominalViewingTransform() {
        double d;
        if (this.viewerList.size() == 0) {
            d = 0.7853981633974483;
        } else {
            if (this.viewerList.size() > 1) {
                throw new RuntimeException(J3dUtilsI18N.getString("ViewingPlatform0"));
            }
            Viewer viewer = (Viewer)this.viewerList.keys().nextElement();
            d = viewer.getView().getFieldOfView();
        }
        d = 1.0 / Math.tan(d / 2.0);
        Transform3D transform3D = new Transform3D();
        transform3D.set(new Vector3d(0.0, 0.0, d));
        this.getViewPlatformTransform().setTransform(transform3D);
    }

    public void setPlatformGeometry(PlatformGeometry platformGeometry) {
        if (this.platformGeometry == platformGeometry) {
            return;
        }
        if (platformGeometry == null) {
            if (this.platformGeometryRoot.numChildren() != 0) {
                this.platformGeometryRoot.removeChild(0);
            }
        } else if (this.platformGeometryRoot.numChildren() != 0) {
            this.platformGeometryRoot.setChild((Node)platformGeometry, 0);
        } else {
            this.platformGeometryRoot.addChild((Node)platformGeometry);
        }
        this.platformGeometry = platformGeometry;
    }

    public void setViewPlatform(ViewPlatform viewPlatform) {
        this.viewPlatform = viewPlatform;
        Enumeration enumeration = this.viewerList.keys();
        while (enumeration.hasMoreElements()) {
            ((Viewer)enumeration.nextElement()).setViewingPlatform(this);
        }
    }
}

