/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import com.sun.j3d.loaders.objectfile.DefaultMaterials;
import com.sun.j3d.loaders.objectfile.ObjectFileParser;
import com.sun.j3d.loaders.objectfile.RgbFile;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;

class ObjectFileMaterials
implements ImageObserver {
    private static final int DEBUG = 0;
    private String curName = null;
    private ObjectFileMaterial cur = null;
    private Hashtable materials;
    private String basePath;
    private boolean fromUrl;

    ObjectFileMaterials() {
        StringReader stringReader = new StringReader(new DefaultMaterials().materials);
        ObjectFileParser objectFileParser = new ObjectFileParser(stringReader);
        this.materials = new Hashtable(50);
        this.readFile(objectFileParser);
    }

    void assignMaterial(String string, Shape3D shape3D) {
        ObjectFileMaterial objectFileMaterial = null;
        Material material = new Material();
        objectFileMaterial = (ObjectFileMaterial)this.materials.get(string);
        Appearance appearance = new Appearance();
        if (objectFileMaterial != null) {
            if (objectFileMaterial.Ka != null) {
                material.setAmbientColor(objectFileMaterial.Ka);
            }
            if (objectFileMaterial.Kd != null) {
                material.setDiffuseColor(objectFileMaterial.Kd);
            }
            if (objectFileMaterial.Ks != null && objectFileMaterial.illum != 1) {
                material.setSpecularColor(objectFileMaterial.Ks);
            } else if (objectFileMaterial.illum == 1) {
                material.setSpecularColor(0.0f, 0.0f, 0.0f);
            }
            if (objectFileMaterial.illum >= 1) {
                material.setLightingEnable(true);
            } else if (objectFileMaterial.illum == 0) {
                material.setLightingEnable(false);
            }
            if (objectFileMaterial.Ns != -1.0f) {
                material.setShininess(objectFileMaterial.Ns);
            }
            if (objectFileMaterial.t != null) {
                appearance.setTexture((Texture)objectFileMaterial.t);
                if ((((GeometryArray)shape3D.getGeometry()).getVertexFormat() & 0x20) == 0) {
                    TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
                    appearance.setTexCoordGeneration(texCoordGeneration);
                }
            }
            if (objectFileMaterial.transparent) {
                appearance.setTransparencyAttributes(new TransparencyAttributes(1, 0.0f));
            }
        }
        appearance.setMaterial(material);
        shape3D.setAppearance(appearance);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xA0) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAmbient(ObjectFileParser objectFileParser) {
        Color3f color3f = new Color3f();
        if (!objectFileParser.getNumber()) return;
        color3f.x = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) return;
        color3f.y = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) {
            return;
        }
        color3f.z = (float)objectFileParser.nval;
        this.cur.Ka = color3f;
        objectFileParser.skipToNextLine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readDiffuse(ObjectFileParser objectFileParser) {
        Color3f color3f = new Color3f();
        if (!objectFileParser.getNumber()) return;
        color3f.x = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) return;
        color3f.y = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) {
            return;
        }
        color3f.z = (float)objectFileParser.nval;
        this.cur.Kd = color3f;
        objectFileParser.skipToNextLine();
    }

    /*
     * Unable to fully structure code
     */
    private void readFile(ObjectFileParser var1_1) {
        if (var1_1.getToken()) ** GOTO lbl43
        return;
lbl-1000:
        // 1 sources

        {
            if (var1_1.ttype == -3) {
                if (var1_1.sval.equals("newmtl")) {
                    this.readName(var1_1);
                } else if (var1_1.sval.equals("ka")) {
                    this.readAmbient(var1_1);
                } else if (var1_1.sval.equals("kd")) {
                    this.readDiffuse(var1_1);
                } else if (var1_1.sval.equals("ks")) {
                    this.readSpecular(var1_1);
                } else if (var1_1.sval.equals("illum")) {
                    this.readIllum(var1_1);
                } else if (var1_1.sval.equals("d")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else if (var1_1.sval.equals("ns")) {
                    this.readShininess(var1_1);
                } else if (var1_1.sval.equals("tf")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else if (var1_1.sval.equals("sharpness")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else if (var1_1.sval.equals("map_kd")) {
                    this.readMapKd(var1_1);
                } else if (var1_1.sval.equals("map_ka") != false ? var1_1.skipToNextLine() == false : (var1_1.sval.equals("map_ks") != false ? var1_1.skipToNextLine() == false : (var1_1.sval.equals("map_ns") != false ? var1_1.skipToNextLine() == false : var1_1.sval.equals("bump") != false && var1_1.skipToNextLine() == false))) {
                    return;
                }
            }
            if (!var1_1.skipToNextLine()) {
                return;
            }
            if (var1_1.getToken()) continue;
            return;
lbl43:
            // 2 sources

            ** while (var1_1.ttype != -1)
        }
lbl44:
        // 1 sources

        if (this.curName != null) {
            this.materials.put(this.curName, this.cur);
        }
    }

    private void readIllum(ObjectFileParser objectFileParser) {
        if (objectFileParser.getNumber()) {
            this.cur.illum = (int)objectFileParser.nval;
        }
        objectFileParser.skipToNextLine();
    }

    public void readMapKd(ObjectFileParser objectFileParser) {
        objectFileParser.lowerCaseMode(false);
        if (!objectFileParser.getToken()) {
            return;
        }
        objectFileParser.lowerCaseMode(true);
        if (objectFileParser.ttype == -3) {
            String string = objectFileParser.sval.substring(objectFileParser.sval.lastIndexOf(46) + 1).toLowerCase();
            if (string.equals("jpg") || string.equals("gif") || string.equals("jpeg") || string.equals("jpe") || string.equals("xbm")) {
                boolean bl;
                final Image[] imageArray = new Image[1];
                final Toolkit toolkit = Toolkit.getDefaultToolkit();
                final String string2 = new String(String.valueOf(this.basePath) + objectFileParser.sval);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        imageArray[0] = toolkit.getImage(string2);
                        return null;
                    }
                });
                toolkit.prepareImage(imageArray[0], -1, -1, this);
                boolean bl2 = false;
                int n = 0;
                try {
                    do {
                        bl2 = ((n = toolkit.checkImage(imageArray[0], -1, -1, this)) & 0xE0) != 0;
                        Thread.sleep(10L);
                    } while (!bl2);
                }
                catch (InterruptedException interruptedException) {}
                boolean bl3 = bl = (n & 0xC0) != 0;
                if (bl2 && !bl) {
                    int n2 = imageArray[0].getWidth(this);
                    int n3 = imageArray[0].getHeight(this);
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    PixelGrabber pixelGrabber = new PixelGrabber(imageArray[0], 0, 0, n2, n3, nArray, 0, n2);
                    try {
                        pixelGrabber.grabPixels();
                        this.scaleAndLoad(bufferedImage, false, false);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (string.equals("int") || string.equals("inta") || string.equals("rgb") || string.equals("rgba") || string.equals("bw") || string.equals("sgi")) {
                try {
                    RgbFile rgbFile = new RgbFile(String.valueOf(this.basePath) + objectFileParser.sval);
                    BufferedImage bufferedImage = rgbFile.getImage();
                    boolean bl = this.cur.transparent = string.equals("inta") || string.equals("rgba");
                    if (bufferedImage != null) {
                        this.scaleAndLoad(bufferedImage, string.equals("int") || string.equals("inta"), this.cur.transparent);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        objectFileParser.skipToNextLine();
    }

    void readMaterialFile(boolean bl, String string, String string2) {
        Reader reader;
        this.basePath = string;
        this.fromUrl = bl;
        try {
            reader = bl ? new InputStreamReader(new BufferedInputStream(new URL(String.valueOf(string) + string2).openStream())) : new BufferedReader(new FileReader(String.valueOf(string) + string2));
        }
        catch (Exception exception) {
            return;
        }
        ObjectFileParser objectFileParser = new ObjectFileParser(reader);
        this.readFile(objectFileParser);
    }

    private void readName(ObjectFileParser objectFileParser) {
        if (!objectFileParser.getToken()) {
            return;
        }
        if (objectFileParser.ttype == -3) {
            if (this.curName != null) {
                this.materials.put(this.curName, this.cur);
            }
            this.curName = new String(objectFileParser.sval);
            this.cur = new ObjectFileMaterial();
        }
        objectFileParser.skipToNextLine();
    }

    private void readShininess(ObjectFileParser objectFileParser) {
        if (objectFileParser.getNumber()) {
            this.cur.Ns = (float)objectFileParser.nval;
            if (this.cur.Ns < 1.0f) {
                this.cur.Ns = 1.0f;
            } else if (this.cur.Ns > 128.0f) {
                this.cur.Ns = 128.0f;
            }
        }
        objectFileParser.skipToNextLine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSpecular(ObjectFileParser objectFileParser) {
        Color3f color3f = new Color3f();
        if (!objectFileParser.getNumber()) return;
        color3f.x = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) return;
        color3f.y = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) {
            return;
        }
        color3f.z = (float)objectFileParser.nval;
        this.cur.Ks = color3f;
        objectFileParser.skipToNextLine();
    }

    private void scaleAndLoad(BufferedImage bufferedImage, boolean bl, boolean bl2) {
        String string = null;
        string = bl && bl2 ? new String("LUM8_ALPHA8") : (bl ? new String("LUMINANCE") : (bl2 ? new String("RGBA") : new String("RGB")));
        TextureLoader textureLoader = new TextureLoader(bufferedImage, string, 1);
        this.cur.t = (Texture2D)textureLoader.getTexture();
        this.cur.t.setMinFilter(5);
    }

    private class ObjectFileMaterial {
        public Color3f Ka;
        public Color3f Kd;
        public Color3f Ks;
        public int illum;
        public float Ns;
        public Texture2D t;
        public boolean transparent;

        ObjectFileMaterial() {
        }

        public void ObjectFileMaterial() {
            this.Ka = null;
            this.Kd = null;
            this.Ks = null;
            this.illum = -1;
            this.Ns = -1.0f;
            this.t = null;
        }
    }
}

