/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.loaders.objectfile.ObjectFileMaterials;
import com.sun.j3d.loaders.objectfile.ObjectFileParser;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.geometry.Triangulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ObjectFile
implements Loader {
    private static final int DEBUG = 1;
    public static final int RESIZE = 64;
    public static final int TRIANGULATE = 128;
    public static final int REVERSE = 256;
    public static final int STRIPIFY = 512;
    private static final char BACKSLASH = '\\';
    private static final int MAX_PATH_LENGTH = 1024;
    private int flags;
    private String basePath = null;
    private URL baseUrl = null;
    private boolean fromUrl = false;
    private float radians;
    private ArrayList coordList;
    private ArrayList texList;
    private ArrayList normList;
    private ArrayList coordIdxList;
    private ArrayList texIdxList;
    private ArrayList normIdxList;
    private ArrayList stripCounts;
    private Hashtable groups;
    private String curGroup;
    private Hashtable sGroups;
    private String curSgroup;
    private Hashtable groupMaterials;
    private Hashtable triGroups;
    private ArrayList curTriGroup;
    private Hashtable triSgroups;
    private ArrayList curTriSgroup;
    private Point3f[] coordArray = null;
    private Vector3f[] normArray = null;
    private Point2f[] texArray = null;
    private long time;
    private ObjectFileMaterials materials = null;

    public ObjectFile() {
        this(0, -1.0f);
    }

    public ObjectFile(int n) {
        this(n, -1.0f);
    }

    public ObjectFile(int n, float f) {
        this.setFlags(n);
        this.radians = f;
    }

    private void convertToTriangles() {
        Object object;
        boolean bl = (this.flags & 0x80) != 0;
        boolean bl2 = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        boolean bl3 = !this.normList.isEmpty() && !this.normIdxList.isEmpty() && this.normIdxList.size() == this.coordIdxList.size();
        int n = this.stripCounts.size();
        boolean bl4 = this.curSgroup != null;
        this.triGroups = new Hashtable(50);
        if (bl4) {
            this.triSgroups = new Hashtable(50);
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        if (bl) {
            Triangulator triangulator = new Triangulator();
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setStripCounts(this.objectToIntArray(this.stripCounts));
            geometryInfo.setCoordinates(this.coordArray);
            geometryInfo.setCoordinateIndices(this.objectToIntArray(this.coordIdxList));
            if (bl2) {
                geometryInfo.setTextureCoordinates(this.texArray);
                geometryInfo.setTextureCoordinateIndices(this.objectToIntArray(this.texIdxList));
            }
            if (bl3) {
                geometryInfo.setNormals(this.normArray);
                geometryInfo.setNormalIndices(this.objectToIntArray(this.normIdxList));
            }
            triangulator.triangulate(geometryInfo);
            int[] nArray = geometryInfo.getCoordinateIndices();
            object = geometryInfo.getTextureCoordinateIndices();
            int[] nArray2 = geometryInfo.getNormalIndices();
            this.coordIdxList.clear();
            this.texIdxList.clear();
            this.normIdxList.clear();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.coordIdxList.add(new Integer(nArray[n2]));
                if (bl2) {
                    this.texIdxList.add(new Integer((int)object[n2]));
                }
                if (bl3) {
                    this.normIdxList.add(new Integer(nArray2[n2]));
                }
                ++n2;
            }
        } else {
            arrayList = new ArrayList();
            if (bl2) {
                arrayList2 = new ArrayList();
            }
            if (bl3) {
                arrayList3 = new ArrayList();
            }
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = (Integer)this.stripCounts.get(n4);
            object = new Integer(n4);
            this.curGroup = (String)this.groups.get(object);
            this.curTriGroup = (ArrayList)this.triGroups.get(this.curGroup);
            if (this.curTriGroup == null) {
                this.curTriGroup = new ArrayList();
                this.triGroups.put(this.curGroup, this.curTriGroup);
            }
            if (bl4) {
                this.curSgroup = (String)this.sGroups.get(object);
                if (this.curSgroup == null) {
                    this.curSgroup = "0";
                }
                this.curTriSgroup = (ArrayList)this.triSgroups.get(this.curSgroup);
                if (this.curTriSgroup == null) {
                    this.curTriSgroup = new ArrayList();
                    this.triSgroups.put(this.curSgroup, this.curTriSgroup);
                }
            }
            if (bl) {
                n5 = 0;
                while (n5 < n6 - 2) {
                    Integer n7 = new Integer(n3);
                    this.curTriGroup.add(n7);
                    if (bl4) {
                        this.curTriSgroup.add(n7);
                    }
                    n3 += 3;
                    ++n5;
                }
            } else {
                n5 = 0;
                while (n5 < n6 - 2) {
                    Integer n8 = new Integer(arrayList.size());
                    this.curTriGroup.add(n8);
                    if (bl4) {
                        this.curTriSgroup.add(n8);
                    }
                    arrayList.add(this.coordIdxList.get(n3));
                    arrayList.add(this.coordIdxList.get(n3 + n5 + 1));
                    arrayList.add(this.coordIdxList.get(n3 + n5 + 2));
                    if (bl2) {
                        arrayList2.add(this.texIdxList.get(n3));
                        arrayList2.add(this.texIdxList.get(n3 + n5 + 1));
                        arrayList2.add(this.texIdxList.get(n3 + n5 + 2));
                    }
                    if (bl3) {
                        arrayList3.add(this.normIdxList.get(n3));
                        arrayList3.add(this.normIdxList.get(n3 + n5 + 1));
                        arrayList3.add(this.normIdxList.get(n3 + n5 + 2));
                    }
                    ++n5;
                }
                n3 += n6;
            }
            ++n4;
        }
        this.stripCounts = null;
        this.groups = null;
        this.sGroups = null;
        if (!bl) {
            this.coordIdxList = arrayList;
            this.texIdxList = arrayList2;
            this.normIdxList = arrayList3;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public int getFlags() {
        return this.flags;
    }

    private Point3f[] getLimits() {
        Point3f point3f = new Point3f();
        Point3f[] point3fArray = new Point3f[]{new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE), new Point3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)};
        int n = 0;
        while (n < this.coordList.size()) {
            point3f = (Point3f)this.coordList.get(n);
            if (point3f.x < point3fArray[0].x) {
                point3fArray[0].x = point3f.x;
            }
            if (point3f.x > point3fArray[1].x) {
                point3fArray[1].x = point3f.x;
            }
            if (point3f.y < point3fArray[0].y) {
                point3fArray[0].y = point3f.y;
            }
            if (point3f.y > point3fArray[1].y) {
                point3fArray[1].y = point3f.y;
            }
            if (point3f.z < point3fArray[0].z) {
                point3fArray[0].z = point3f.z;
            }
            if (point3f.z > point3fArray[1].z) {
                point3fArray[1].z = point3f.z;
            }
            ++n;
        }
        return point3fArray;
    }

    private int[] groupIndices(ArrayList arrayList, ArrayList arrayList2) {
        int[] nArray = new int[arrayList2.size() * 3];
        int n = 0;
        while (n < arrayList2.size()) {
            int n2 = (Integer)arrayList2.get(n);
            nArray[n * 3] = (Integer)arrayList.get(n2);
            nArray[n * 3 + 1] = (Integer)arrayList.get(n2 + 1);
            nArray[n * 3 + 2] = (Integer)arrayList.get(n2 + 2);
            ++n;
        }
        return nArray;
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        ObjectFileParser objectFileParser = new ObjectFileParser(reader);
        this.coordList = new ArrayList();
        this.texList = new ArrayList();
        this.normList = new ArrayList();
        this.coordIdxList = new ArrayList();
        this.texIdxList = new ArrayList();
        this.normIdxList = new ArrayList();
        this.groups = new Hashtable(50);
        this.curGroup = "default";
        this.sGroups = new Hashtable(50);
        this.curSgroup = null;
        this.stripCounts = new ArrayList();
        this.groupMaterials = new Hashtable(50);
        this.groupMaterials.put(this.curGroup, "default");
        this.materials = new ObjectFileMaterials();
        this.time = 0L;
        this.readFile(objectFileParser);
        if ((this.flags & 0x40) != 0) {
            this.resize();
        }
        return this.makeScene();
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.setBasePathFromFilename(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        return this.load(bufferedReader);
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        BufferedReader bufferedReader;
        this.setBaseUrlFromUrl(uRL);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException();
        }
        this.fromUrl = true;
        return this.load(bufferedReader);
    }

    void loadMaterialFile(ObjectFileParser objectFileParser) {
        String string = null;
        objectFileParser.lowerCaseMode(false);
        do {
            if (!objectFileParser.getToken()) {
                return;
            }
            if (objectFileParser.ttype != -3) continue;
            string = objectFileParser.sval;
        } while (objectFileParser.ttype != 10);
        this.materials.readMaterialFile(this.fromUrl, this.fromUrl ? this.baseUrl.toString() : this.basePath, string);
        objectFileParser.lowerCaseMode(true);
        objectFileParser.skipToNextLine();
    }

    private SceneBase makeScene() {
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        sceneBase.setSceneGroup(branchGroup);
        boolean bl = this.normList.isEmpty() || this.normIdxList.isEmpty() || this.normIdxList.size() != this.coordIdxList.size();
        boolean bl2 = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        this.coordArray = this.objectToPoint3Array(this.coordList);
        if (!bl) {
            this.normArray = this.objectToVectorArray(this.normList);
        }
        if (bl2) {
            this.texArray = this.objectToPoint2Array(this.texList);
        }
        this.convertToTriangles();
        if (bl && this.curSgroup != null) {
            this.smoothingGroupNormals();
            bl = false;
        }
        NormalGenerator normalGenerator = null;
        if (bl) {
            normalGenerator = new NormalGenerator(this.radians);
        }
        Stripifier stripifier = null;
        if ((this.flags & 0x200) != 0) {
            stripifier = new Stripifier();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        Enumeration enumeration = this.triGroups.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)this.triGroups.get(string);
            if (arrayList.size() <= 0) continue;
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinateIndices(this.groupIndices(this.coordIdxList, arrayList));
            geometryInfo.setCoordinates(this.coordArray);
            if (bl2) {
                geometryInfo.setTextureCoordinateIndices(this.groupIndices(this.texIdxList, arrayList));
                geometryInfo.setTextureCoordinates(this.texArray);
            }
            if (bl) {
                if ((this.flags & 0x100) != 0) {
                    geometryInfo.reverse();
                }
                normalGenerator.generateNormals(geometryInfo);
            } else {
                geometryInfo.setNormalIndices(this.groupIndices(this.normIdxList, arrayList));
                geometryInfo.setNormals(this.normArray);
                if ((this.flags & 0x100) != 0) {
                    geometryInfo.reverse();
                }
            }
            if ((this.flags & 0x200) != 0) {
                stripifier.stripify(geometryInfo);
            }
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry((Geometry)geometryInfo.getGeometryArray());
            String string2 = (String)this.groupMaterials.get(string);
            this.materials.assignMaterial(string2, shape3D);
            branchGroup.addChild((Node)shape3D);
            sceneBase.addNamedObject(string, shape3D);
        }
        return sceneBase;
    }

    private int[] objectToIntArray(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private Point2f[] objectToPoint2Array(ArrayList arrayList) {
        Point2f[] point2fArray = new Point2f[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            point2fArray[n] = (Point2f)arrayList.get(n);
            ++n;
        }
        return point2fArray;
    }

    private Point3f[] objectToPoint3Array(ArrayList arrayList) {
        Point3f[] point3fArray = new Point3f[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            point3fArray[n] = (Point3f)arrayList.get(n);
            ++n;
        }
        return point3fArray;
    }

    private Vector3f[] objectToVectorArray(ArrayList arrayList) {
        Vector3f[] vector3fArray = new Vector3f[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            vector3fArray[n] = (Vector3f)arrayList.get(n);
            ++n;
        }
        return vector3fArray;
    }

    void readFace(ObjectFileParser objectFileParser) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        objectFileParser.getToken();
        while (objectFileParser.ttype != 10) {
            objectFileParser.pushBack();
            if (!objectFileParser.getNumber()) break;
            int n4 = (int)objectFileParser.nval - 1;
            if (n4 < 0) {
                n4 += this.coordList.size() + 1;
            }
            this.coordIdxList.add(new Integer(n4));
            objectFileParser.getToken();
            if (objectFileParser.ttype == 47) {
                objectFileParser.getToken();
                if (objectFileParser.ttype == -3) {
                    objectFileParser.pushBack();
                    if (!objectFileParser.getNumber()) break;
                    n = (int)objectFileParser.nval - 1;
                    if (n < 0) {
                        n += this.texList.size() + 1;
                    }
                    this.texIdxList.add(new Integer(n));
                    objectFileParser.getToken();
                }
                if (objectFileParser.ttype == 47) {
                    if (!objectFileParser.getNumber()) break;
                    n2 = (int)objectFileParser.nval - 1;
                    if (n2 < 0) {
                        n2 += this.normList.size() + 1;
                    }
                    this.normIdxList.add(new Integer(n2));
                    objectFileParser.getToken();
                }
            }
            ++n3;
        }
        Integer n5 = new Integer(this.stripCounts.size());
        this.stripCounts.add(new Integer(n3));
        this.groups.put(n5, this.curGroup);
        if (this.curSgroup != null) {
            this.sGroups.put(n5, this.curSgroup);
        }
        objectFileParser.skipToNextLine();
    }

    /*
     * Unable to fully structure code
     */
    void readFile(ObjectFileParser var1_1) {
        if (var1_1.getToken()) ** GOTO lbl55
        return;
lbl-1000:
        // 1 sources

        {
            if (var1_1.ttype == -3) {
                if (var1_1.sval.equals("v")) {
                    this.readVertex(var1_1);
                } else if (var1_1.sval.equals("vn")) {
                    this.readNormal(var1_1);
                } else if (var1_1.sval.equals("vt")) {
                    this.readTexture(var1_1);
                } else if (var1_1.sval.equals("f")) {
                    this.readFace(var1_1);
                } else if (var1_1.sval.equals("fo")) {
                    this.readFace(var1_1);
                } else if (var1_1.sval.equals("g")) {
                    this.readPartName(var1_1);
                } else if (var1_1.sval.equals("s")) {
                    this.readSmoothingGroup(var1_1);
                } else if (var1_1.sval.equals("p")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else if (var1_1.sval.equals("l")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else if (var1_1.sval.equals("mtllib")) {
                    this.loadMaterialFile(var1_1);
                } else if (var1_1.sval.equals("usemtl")) {
                    this.readMaterialName(var1_1);
                } else if (var1_1.sval.equals("maplib")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else if (var1_1.sval.equals("usemap")) {
                    if (!var1_1.skipToNextLine()) {
                        return;
                    }
                } else {
                    System.err.println("Unrecognized token, line " + var1_1.lineno());
                }
            }
            if (!var1_1.skipToNextLine()) {
                return;
            }
            if (var1_1.getToken()) continue;
            return;
lbl55:
            // 2 sources

            ** while (var1_1.ttype != -1)
        }
lbl56:
        // 1 sources

    }

    void readMaterialName(ObjectFileParser objectFileParser) {
        if (!objectFileParser.getToken()) {
            return;
        }
        if (objectFileParser.ttype == -3) {
            this.groupMaterials.put(this.curGroup, new String(objectFileParser.sval));
        }
        objectFileParser.skipToNextLine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean readNormal(ObjectFileParser objectFileParser) {
        Vector3f vector3f = new Vector3f();
        if (!objectFileParser.getNumber()) return false;
        vector3f.x = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) return false;
        vector3f.y = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) {
            return false;
        }
        vector3f.z = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.normList.add(vector3f);
        return true;
    }

    void readPartName(ObjectFileParser objectFileParser) {
        if (!objectFileParser.getToken()) {
            return;
        }
        String string = (String)this.groupMaterials.get(this.curGroup);
        this.curGroup = objectFileParser.ttype != -3 ? "default" : objectFileParser.sval;
        if (this.groupMaterials.get(this.curGroup) == null) {
            this.groupMaterials.put(this.curGroup, string);
        }
        objectFileParser.skipToNextLine();
    }

    void readSmoothingGroup(ObjectFileParser objectFileParser) throws ParsingErrorException {
        if (!objectFileParser.getToken()) {
            return;
        }
        if (objectFileParser.ttype != -3) {
            objectFileParser.skipToNextLine();
            return;
        }
        this.curSgroup = objectFileParser.sval.equals("off") ? "0" : objectFileParser.sval;
        objectFileParser.skipToNextLine();
    }

    boolean readTexture(ObjectFileParser objectFileParser) {
        Point2f point2f = new Point2f();
        if (objectFileParser.getNumber()) {
            point2f.x = (float)objectFileParser.nval;
            if (!objectFileParser.getNumber()) {
                return false;
            }
        } else {
            return false;
        }
        point2f.y = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.texList.add(point2f);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean readVertex(ObjectFileParser objectFileParser) {
        Point3f point3f = new Point3f();
        if (!objectFileParser.getNumber()) return false;
        point3f.x = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) return false;
        point3f.y = (float)objectFileParser.nval;
        if (!objectFileParser.getNumber()) {
            return false;
        }
        point3f.z = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.coordList.add(point3f);
        return true;
    }

    private void resize() {
        Point3f point3f = new Point3f();
        Point3f[] point3fArray = this.getLimits();
        Vector3f vector3f = new Vector3f(-0.5f * (point3fArray[0].x + point3fArray[1].x), -0.5f * (point3fArray[0].y + point3fArray[1].y), -0.5f * (point3fArray[0].z + point3fArray[1].z));
        float f = point3fArray[1].x - point3fArray[0].x;
        if (f < point3fArray[1].y - point3fArray[0].y) {
            f = point3fArray[1].y - point3fArray[0].y;
        }
        if (f < point3fArray[1].z - point3fArray[0].z) {
            f = point3fArray[1].z - point3fArray[0].z;
        }
        f /= 2.0f;
        int n = 0;
        while (n < this.coordList.size()) {
            point3f = (Point3f)this.coordList.get(n);
            point3f.add((Tuple3f)point3f, (Tuple3f)vector3f);
            point3f.x /= f;
            point3f.y /= f;
            point3f.z /= f;
            ++n;
        }
    }

    public void setBasePath(String string) {
        this.basePath = string;
        if (this.basePath == null || this.basePath == "") {
            this.basePath = "." + File.separator;
        }
        this.basePath = this.basePath.replace('/', File.separatorChar);
        this.basePath = this.basePath.replace('\\', File.separatorChar);
        if (!this.basePath.endsWith(File.separator)) {
            this.basePath = String.valueOf(this.basePath) + File.separator;
        }
    }

    private void setBasePathFromFilename(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (string != null && string.startsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        int n = stringTokenizer.countTokens() - 1;
        while (n > 0) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            stringBuffer.append(File.separator);
            --n;
        }
        this.setBasePath(stringBuffer.toString());
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    private void setBaseUrlFromUrl(URL uRL) {
        StringTokenizer stringTokenizer = new StringTokenizer(uRL.toString(), "/\\", true);
        int n = stringTokenizer.countTokens() - 1;
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n2 = 0;
        while (n2 < n) {
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string);
            ++n2;
        }
        try {
            this.baseUrl = new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error setting base URL: " + malformedURLException.getMessage());
        }
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    private void smoothingGroupNormals() {
        NormalGenerator normalGenerator = new NormalGenerator(this.radians == -1.0f ? Math.PI : (double)this.radians);
        NormalGenerator normalGenerator2 = new NormalGenerator(0.0);
        this.normList.clear();
        this.normIdxList = null;
        int[] nArray = new int[this.coordIdxList.size()];
        Enumeration enumeration = this.triSgroups.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)this.triSgroups.get(string);
            if (arrayList.size() <= 0) continue;
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinateIndices(this.groupIndices(this.coordIdxList, arrayList));
            geometryInfo.setCoordinates(this.coordArray);
            if (string.equals("0")) {
                normalGenerator2.generateNormals(geometryInfo);
            } else {
                normalGenerator.generateNormals(geometryInfo);
            }
            Vector3f[] vector3fArray = geometryInfo.getNormals();
            int[] nArray2 = geometryInfo.getNormalIndices();
            int n = 0;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3 = (Integer)arrayList.get(n2);
                int n4 = 0;
                while (n4 < 3) {
                    nArray[n3 + n4] = this.normList.size();
                    this.normList.add(vector3fArray[nArray2[n++]]);
                    ++n4;
                }
                ++n2;
            }
        }
        this.normIdxList = new ArrayList(this.coordIdxList.size());
        int n = 0;
        while (n < this.coordIdxList.size()) {
            this.normIdxList.add(new Integer(nArray[n]));
            ++n;
        }
        this.normArray = this.objectToVectorArray(this.normList);
    }
}

