/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.javasound.JSSample;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class JSPositionalSample
extends JSSample {
    int secondIndex = -1;
    int reverbIndex = -1;
    Point3f xformLeftEar = new Point3f(-0.09f, -0.03f, 0.095f);
    Point3f xformRightEar = new Point3f(0.09f, -0.03f, 0.095f);
    Vector3f xformHeadZAxis = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f sourceToCenterEar = new Vector3f();
    Vector3f sourceToRightEar = new Vector3f();
    Vector3f sourceToLeftEar = new Vector3f();
    boolean averageDistances = false;
    long deltaTime = 0L;
    double sourcePositionChange = -1.0;
    double headPositionChange = -1.0;
    static int MAX_DISTANCES = 4;
    int numDistances = 0;
    long[] times = new long[MAX_DISTANCES];
    Point3f[] positions = new Point3f[MAX_DISTANCES];
    Point3f[] centerEars = new Point3f[MAX_DISTANCES];
    int[] indices = new int[MAX_DISTANCES];
    double lastRequestedDopplerRateRatio = -1.0;
    double lastActualDopplerRateRatio = -1.0;
    static double maxRatio = 256.0;
    static int TOWARDS = 1;
    static int NO_CHANGE = 0;
    static int AWAY = 1;
    boolean filterFlag = false;
    float filterFreq = -1.0f;

    public JSPositionalSample() {
        this.clear();
    }

    void adjustDopplerRate(double d, int n) {
        double d2 = 0.0026f;
        double d3 = 0.0052f;
        if (d > maxRatio) {
            d = maxRatio;
        }
        if (d < 0.0) {
            if (this.lastRequestedDopplerRateRatio < 0.0 || this.lastActualDopplerRateRatio < 0.0) {
                this.lastRequestedDopplerRateRatio = -1.0;
                this.lastActualDopplerRateRatio = -1.0;
            } else if (!(this.lastActualDopplerRateRatio >= maxRatio)) {
                double d4 = this.lastRequestedDopplerRateRatio - this.lastActualDopplerRateRatio;
                if (d4 > 0.0) {
                    d = d4 >= d3 ? this.lastActualDopplerRateRatio + d3 : this.lastActualDopplerRateRatio + d4;
                } else if (d4 < 0.0) {
                    d = -d4 >= d2 ? this.lastActualDopplerRateRatio - d2 : this.lastActualDopplerRateRatio + d4;
                }
                this.lastActualDopplerRateRatio = d;
            }
        } else if (d == 0.0) {
            if (this.lastRequestedDopplerRateRatio < 0.0 || this.lastActualDopplerRateRatio < 0.0) {
                this.lastRequestedDopplerRateRatio = 1.0;
                this.lastActualDopplerRateRatio = 1.0;
            } else if (!(this.lastActualDopplerRateRatio >= maxRatio)) {
                double d5 = this.lastRequestedDopplerRateRatio - this.lastActualDopplerRateRatio;
                if (d5 > 0.0) {
                    d = d5 >= d3 ? this.lastActualDopplerRateRatio + d3 : this.lastActualDopplerRateRatio + d5;
                    this.lastActualDopplerRateRatio = d;
                } else if (d5 < 0.0) {
                    d = -d5 >= d2 ? this.lastActualDopplerRateRatio - d2 : this.lastActualDopplerRateRatio + d5;
                    this.lastActualDopplerRateRatio = d;
                }
            }
        } else if (d > 0.0) {
            if (this.lastRequestedDopplerRateRatio < 0.0 || this.lastActualDopplerRateRatio < 0.0) {
                this.lastRequestedDopplerRateRatio = d;
                this.lastActualDopplerRateRatio = d;
            } else {
                double d6 = d - this.lastActualDopplerRateRatio;
                if (d6 > 0.0) {
                    this.lastRequestedDopplerRateRatio = d;
                    if (d6 >= d3) {
                        d = this.lastActualDopplerRateRatio + d3;
                    }
                    this.lastActualDopplerRateRatio = d;
                } else if (d6 < 0.0) {
                    this.lastRequestedDopplerRateRatio = d;
                    if (-d6 >= d2) {
                        d = this.lastActualDopplerRateRatio - d2;
                    }
                    this.lastActualDopplerRateRatio = d;
                } else {
                    d6 = d - this.lastRequestedDopplerRateRatio;
                    if (d6 > 0.0) {
                        d = d6 >= d3 ? this.lastActualDopplerRateRatio + d3 : this.lastActualDopplerRateRatio + d6;
                        this.lastActualDopplerRateRatio = d;
                    } else if (d6 < 0.0) {
                        d = -d6 >= d2 ? this.lastActualDopplerRateRatio - d2 : this.lastActualDopplerRateRatio + d6;
                        this.lastActualDopplerRateRatio = d;
                    } else {
                        d = 0.0;
                    }
                }
            }
        }
        if (d > maxRatio) {
            d = maxRatio;
        }
    }

    float calculateAngularGain() {
        return 1.0f;
    }

    float calculateDistanceAttenuation(float f) {
        float f2 = 1.0f;
        f2 = this.findFactor(f, this.attenuationDistance, this.attenuationGain);
        if ((double)f2 >= 0.0) {
            return f2;
        }
        return 1.0f;
    }

    float calculateDoppler(AuralParameters auralParameters) {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        float f = 0.344f;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = 0;
        int n2 = this.indices[MAX_DISTANCES - 1];
        int n3 = this.indices[MAX_DISTANCES - 2];
        int n4 = this.indices[0];
        Point3f point3f = this.positions[n3];
        Point3f point3f2 = this.centerEars[n3];
        Point3f point3f3 = this.positions[n2];
        Point3f point3f4 = this.centerEars[n2];
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.averageDistances) {
            this.deltaTime = this.times[n2] - this.times[n4];
            int n5 = 0;
            while (n5 < MAX_DISTANCES - 1) {
                f2 += this.positions[n5 + 1].distance(this.positions[n5]);
                f3 += this.centerEars[n5 + 1].distance(this.centerEars[n5]);
                ++n5;
            }
            f2 /= (float)(MAX_DISTANCES - 1);
            f3 /= (float)(MAX_DISTANCES - 1);
        }
        if ((d4 = (double)point3f3.distance(point3f4)) == (d5 = (double)point3f.distance(point3f2))) {
            n = NO_CHANGE;
            d = 0.0;
        } else {
            d3 = f2 / (float)this.deltaTime;
            d2 = f3 / (float)this.deltaTime;
            if (auralParameters != null) {
                float f4 = auralParameters.getRolloff();
                float f5 = auralParameters.getVelocityScaleFactor();
                if (f4 != 1.0f) {
                    f *= f4;
                }
                if (f5 != 1.0f) {
                    d3 *= (double)f5;
                    d2 *= (double)f5;
                }
            }
            if (d4 < d5) {
                n = TOWARDS;
                d6 = (double)f + d2;
                d7 = (double)f - d3;
            } else {
                n = AWAY;
                d6 = (double)f - d2;
                d7 = (double)f + d3;
            }
            d = d6 <= 0.0 ? -1.0 : (d7 <= 0.0 ? -1.0 : d6 / d7);
        }
        return (float)d;
    }

    void calculateFilter(float f, AuralParameters auralParameters) {
        float f2 = 44100.0f;
        float f3 = 44100.0f;
        int n = auralParameters.getDistanceFilterLength();
        int n2 = auralParameters.getDistanceFilterType();
        boolean bl = false;
        boolean bl2 = false;
        if (n2 != -1 && n > 0) {
            double[] dArray = new double[n];
            float[] fArray = new float[n];
            auralParameters.getDistanceFilter(dArray, fArray);
            f2 = this.findFactor(f, dArray, fArray);
            bl = !(f2 < 0.0f);
        } else {
            bl = false;
            f2 = -1.0f;
        }
        bl2 = false;
        f3 = -1.0f;
        this.filterFlag = bl || bl2;
        this.filterFreq = f2;
    }

    boolean calculateNewEar(int n, View view, Point3f point3f) {
        PhysicalBody physicalBody;
        Point3d point3d = new Point3d();
        int n2 = this.indices[MAX_DISTANCES - 1];
        int n3 = this.indices[MAX_DISTANCES - 2];
        boolean bl = false;
        if (!bl && view != null && (physicalBody = view.getPhysicalBody()) != null) {
            Point3d point3d2 = new Point3d();
            Point3d point3d3 = new Point3d();
            Point3d point3d4 = new Point3d();
            Point3d point3d5 = new Point3d();
            Transform3D transform3D = new Transform3D();
            Point3d point3d6 = new Point3d();
            Point3d point3d7 = new Point3d();
            Point3d point3d8 = new Point3d();
            Point3d point3d9 = new Point3d();
            Canvas3D canvas3D = view.getCanvas3D(0);
            canvas3D.getImagePlateToVworld(transform3D);
            canvas3D.getLeftEyeInImagePlate(point3d4);
            canvas3D.getRightEyeInImagePlate(point3d5);
            physicalBody.getLeftEarPosition(point3d6);
            physicalBody.getRightEarPosition(point3d7);
            physicalBody.getLeftEyePosition(point3d8);
            physicalBody.getRightEyePosition(point3d9);
            Point3d point3d10 = new Point3d();
            Point3d point3d11 = new Point3d();
            if (point3d4.equals((Tuple3d)point3d5)) {
                Point3d point3d12 = new Point3d();
                point3d12.add((Tuple3d)point3d8, (Tuple3d)point3d9);
                point3d12.scale(0.5);
                point3d10.sub((Tuple3d)point3d12, (Tuple3d)point3d6);
                point3d11.sub((Tuple3d)point3d12, (Tuple3d)point3d7);
            } else {
                point3d10.sub((Tuple3d)point3d8, (Tuple3d)point3d6);
                point3d11.sub((Tuple3d)point3d9, (Tuple3d)point3d7);
            }
            point3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d10);
            point3d3.sub((Tuple3d)point3d5, (Tuple3d)point3d11);
            transform3D.transform(point3d2);
            transform3D.transform(point3d3);
            this.xformLeftEar.set((Tuple3d)point3d2);
            this.xformRightEar.set((Tuple3d)point3d3);
            point3f.x = this.xformLeftEar.x + (this.xformRightEar.x - this.xformLeftEar.x) * 0.5f;
            point3f.y = this.xformLeftEar.y + (this.xformRightEar.y - this.xformLeftEar.y) * 0.5f;
            point3f.z = this.xformLeftEar.z + (this.xformRightEar.z - this.xformLeftEar.z) * 0.5f;
            bl = true;
        }
        return bl;
    }

    public void clear() {
        super.clear();
        this.xformLeftEar.set(-0.09f, -0.03f, 0.095f);
        this.xformRightEar.set(0.09f, -0.03f, 0.095f);
        this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
        this.sourceToCenterEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToRightEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToLeftEar.set(0.0f, 0.0f, 0.0f);
        this.averageDistances = false;
        this.deltaTime = 0L;
        this.sourcePositionChange = -1.0;
        this.headPositionChange = -1.0;
        this.rateRatio = 1.0f;
        this.numDistances = 0;
        int n = 0;
        while (n < MAX_DISTANCES) {
            this.positions[n] = new Point3f();
            this.centerEars[n] = new Point3f(0.09f, -0.03f, 0.095f);
            this.indices[n] = n - (MAX_DISTANCES - 1);
            ++n;
        }
    }

    float findFactor(double d, double[] dArray, float[] fArray) {
        if (dArray == null || fArray == null) {
            return -1.0f;
        }
        int n = dArray.length;
        if (n < 2) {
            return -1.0f;
        }
        int n2 = n - 1;
        if (d >= dArray[n2]) {
            return fArray[n2];
        }
        if (d <= dArray[0]) {
            return fArray[0];
        }
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4 - 1) {
            if (dArray[n3] >= d) {
                double cfr_ignored_0 = dArray[n3];
                return fArray[n3];
            }
            if (dArray[n4] <= d) {
                double cfr_ignored_1 = dArray[n4];
                return fArray[n4];
            }
            if (!(d > dArray[n3]) || !(d < dArray[n4])) continue;
            int n5 = n3 + (n4 - n3) / 2;
            if (d <= dArray[n5]) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        float f = (float)((d - dArray[n3]) / (dArray[n4] - dArray[n3])) * (fArray[n4] - fArray[n3]) + fArray[n3];
        return f;
    }

    public boolean getFilterFlag() {
        return this.filterFlag;
    }

    public float getFilterFreq() {
        return this.filterFreq;
    }

    public int getReverbIndex() {
        return this.reverbIndex;
    }

    public int getSecondIndex() {
        return this.secondIndex;
    }

    void incrementIndexArray(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            nArray[n2] = nArray[n2] % n;
            ++n2;
        }
        if (this.numDistances >= n - 1) {
            this.averageDistances = true;
        } else {
            ++this.numDistances;
        }
    }

    void panSample(AuralParameters auralParameters) {
        int n = 1;
        float f = 1.0f;
        float f2 = 0.125f;
        float f3 = f - f2;
        float f4 = 1.0E-6f;
        float f5 = 0.999999f;
        float f6 = -f5;
        float f7 = 1.5707964f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.18f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.344f;
        float f19 = 2.9069767f;
        float f20 = 44.1f;
        boolean bl = false;
        boolean bl2 = false;
        float f21 = 1.0f;
        float f22 = this.gain;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Transform3D transform3D = new Transform3D();
        int n2 = this.indices[MAX_DISTANCES - 1];
        Vector3f vector3f = new Vector3f();
        point3f.set((Tuple3f)this.positions[n2]);
        point3f2.set((Tuple3f)this.centerEars[n2]);
        this.sourceToCenterEar.x = point3f2.x - point3f.x;
        this.sourceToCenterEar.y = point3f2.y - point3f.y;
        this.sourceToCenterEar.z = point3f2.z - point3f.z;
        this.sourceToRightEar.x = this.xformRightEar.x - point3f.x;
        this.sourceToRightEar.y = this.xformRightEar.y - point3f.y;
        this.sourceToRightEar.z = this.xformRightEar.z - point3f.z;
        this.sourceToLeftEar.x = this.xformLeftEar.x - point3f.x;
        this.sourceToLeftEar.y = this.xformLeftEar.y - point3f.y;
        this.sourceToLeftEar.z = this.xformLeftEar.z - point3f.z;
        f8 = point3f.distance(point3f2);
        f10 = point3f.distance(this.xformRightEar);
        f11 = point3f.distance(this.xformLeftEar);
        f12 = this.xformRightEar.distance(this.xformLeftEar);
        f13 = f12 * 0.5f;
        f14 = f13 / f8;
        double d = this.sourceToCenterEar.dot(this.xformHeadZAxis) / (this.sourceToCenterEar.length() * this.xformHeadZAxis.length());
        f15 = (float)Math.acos(d);
        if (f15 > f7) {
            bl2 = true;
            f15 = (float)Math.PI - f15;
        } else {
            bl2 = false;
        }
        f17 = (float)Math.acos(f14);
        bl = !(f10 > f11);
        f16 = (float)Math.sin(f15);
        if ((double)f16 < 0.0) {
            f16 = -f16;
        }
        float f23 = (float)Math.sqrt((double)f8 * (double)f8 + (double)(f13 * f13));
        if (bl) {
            f11 = f23 + f13 * (f7 + f15 - f17);
        } else {
            f10 = f23 + f13 * (f7 + f15 - f17);
        }
        if (f16 < f14) {
            if (bl) {
                f10 = f23 + f13 * (f7 - f15 - f17);
            } else {
                f11 = f23 + f13 * (f7 - f15 - f17);
            }
        }
        if (bl) {
            this.rightDelay = 0;
            this.leftDelay = (int)((f11 - f10) * f19 * f20);
        } else {
            this.leftDelay = 0;
            this.rightDelay = (int)((f10 - f11) * f19 * f20);
        }
        point3f.sub((Tuple3f)point3f2);
        point3f.scale(1.0f / f8);
        f21 = this.calculateDistanceAttenuation(f8);
        f22 *= f21;
        f22 *= this.calculateAngularGain();
        float f24 = point3f.x / 2.0f;
        float f25 = f24 >= 0.0f ? f3 * (0.5f - f24) : f3 * (0.5f + f24);
        if ((double)point3f.x >= 0.0) {
            boolean bl3 = false;
            n = point3f.z >= 0.0f ? 1 : 4;
        } else {
            boolean bl4 = false;
            n = point3f.z >= 0.0f ? 2 : 3;
        }
        switch (n) {
            case 1: 
            case 4: {
                this.rightGain = f22 * (f - f25);
                this.leftGain = f22 * (f2 + f25);
                break;
            }
            case 2: 
            case 3: {
                this.leftGain = f22 * (f - f25);
                this.rightGain = f22 * (f2 + f25);
                break;
            }
        }
        this.calculateFilter(f8, auralParameters);
    }

    public void render(int n, View view, AuralParameters auralParameters) {
        this.updateEar(n, view);
        float f = 1.0f;
        if (auralParameters != null) {
            float f2 = auralParameters.getRolloff();
            float f3 = auralParameters.getFrequencyScaleFactor();
            float f4 = auralParameters.getVelocityScaleFactor();
            if (!(f2 <= 0.0f) && !(f3 <= 0.0f)) {
                if (f4 > 0.0f) {
                    if (this.deltaTime > 0L && (f = this.calculateDoppler(auralParameters)) > 0.0f) {
                        this.rateRatio = f * f3;
                    }
                } else {
                    this.rateRatio = f3;
                }
            }
        } else {
            this.rateRatio = 1.0f;
        }
        this.panSample(auralParameters);
    }

    public void setReverbIndex(int n) {
        this.reverbIndex = n;
    }

    public void setSecondIndex(int n) {
        this.secondIndex = n;
    }

    void setXformedPosition() {
        int n = this.indices[MAX_DISTANCES - 1];
        int n2 = this.indices[MAX_DISTANCES - 2];
        this.times[n] = System.currentTimeMillis();
        if (this.getVWrldXfrmFlag()) {
            this.vworldXfrm.transform(this.position, this.positions[n]);
        } else {
            this.positions[n].set((Tuple3f)this.position);
        }
        if (this.numDistances > 0) {
            this.centerEars[n].set((Tuple3f)this.centerEars[n2]);
        }
        this.incrementIndexArray(this.indices, MAX_DISTANCES);
    }

    public void stop() {
        super.stop();
        this.averageDistances = false;
    }

    void updateEar(int n, View view) {
        int n2 = this.indices[MAX_DISTANCES - 1];
        int n3 = this.indices[MAX_DISTANCES - 2];
        Point3f point3f = new Point3f();
        if (!this.calculateNewEar(n, view, point3f)) {
            return;
        }
        this.times[n2] = System.currentTimeMillis();
        this.centerEars[n2].set((Tuple3f)point3f);
        if (this.numDistances > 0) {
            this.positions[n2].set((Tuple3f)this.positions[n3]);
        }
        this.incrementIndexArray(this.indices, MAX_DISTANCES);
    }
}

