/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.PNMImageDecoder;
import com.sun.media.jai.codecimpl.PNMImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNMCodec
extends ImageCodec {
    static /* synthetic */ Class class$com$sun$media$jai$codec$PNMEncodeParam;
    static /* synthetic */ Class class$java$lang$Object;

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 4 || n == 5) {
            return false;
        }
        int n2 = sampleModel.getNumBands();
        return n2 == 1 || n2 == 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new PNMImageDecoder(seekableStream, null);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(inputStream), null);
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNMEncodeParam pNMEncodeParam = null;
        if (imageEncodeParam != null) {
            pNMEncodeParam = (PNMEncodeParam)imageEncodeParam;
        }
        return new PNMImageEncoder(outputStream, pNMEncodeParam);
    }

    public Class getDecodeParamClass() {
        return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = PNMCodec.class$("java.lang.Object"));
    }

    public Class getEncodeParamClass() {
        return class$com$sun$media$jai$codec$PNMEncodeParam != null ? class$com$sun$media$jai$codec$PNMEncodeParam : (class$com$sun$media$jai$codec$PNMEncodeParam = PNMCodec.class$("com.sun.media.jai.codec.PNMEncodeParam"));
    }

    public String getFormatName() {
        return "pnm";
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] >= 49 && byArray[1] <= 54;
    }
}

