/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.serializer;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.remote.protocol.serializer.Util;
import org.tigr.remote.protocol.serializer.XMLIndent;
import org.tigr.util.FloatMatrix;

class MAGESerializer {
    private static final int BREAK_AFTER = 10240;
    private PrintStream m_out;
    private XMLIndent m_ind = new XMLIndent();

    public MAGESerializer(PrintStream printStream) {
        this.m_out = printStream;
    }

    public void serialize(AlgorithmData algorithmData) {
        this.m_out.println("<MAGE-ML identifier = \"TIGR:Clustering Request\">");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        if (algorithmData.getMatrixes().size() > 0 || algorithmData.getProperties().size() > 0) {
            this.m_out.println("<BioAssayData_package>");
            this.m_ind.inc();
            this.m_ind.print(this.m_out);
            this.m_out.println("<BioAssayData_assnlist>");
            this.m_ind.inc();
            this.m_ind.print(this.m_out);
            Iterator iterator = algorithmData.getMatrixes().entrySet().iterator();
            while (iterator.hasNext()) {
                this.serializeMatrix(iterator.next());
            }
            this.serializeParams(algorithmData.getParams());
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</BioAssayData_assnlist>");
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</BioAssayData_package>");
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</MAGE-ML>");
        }
    }

    private void serializeMatrix(Map.Entry entry) {
        FloatMatrix floatMatrix = (FloatMatrix)entry.getValue();
        String string = Util.escape((String)entry.getKey());
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<DerivedBioAssayData identifier =\"" + string + "\" >");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<BioDataValues_assn>");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<BioDataCube>");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<PropertySets_assnlist>");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<NameValueType name=\"cols\" value=\"" + floatMatrix.getColumnDimension() + "\" />");
        this.m_ind.print(this.m_out);
        this.m_out.println("<NameValueType name=\"rows\" value=\"" + floatMatrix.getRowDimension() + "\" />");
        this.m_ind.print(this.m_out);
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</PropertySets_assnlist>");
        this.m_out.println("         <BioAssayDimension_assnref> \n              <BioAssayDimension_ref identifier=\"UNDEFINED\"/> \n          </BioAssayDimension_assnref> \n          <DesignElementDimension_assnref> \n            <DesignElementDimension_ref identifier=\"UNDEFINED\"/> \n          </DesignElementDimension_assnref> \n          <QuantitationTypeDimension_assnref> \n             <QuantitationTypeDimension_ref identifier=\"UNDEFINED\"/> \n          </QuantitationTypeDimension_assnref> \n          <DataInternal_assn> \n             <DataInternal>");
        float[][] fArray = floatMatrix.getArray();
        int n = floatMatrix.getColumnDimension();
        int n2 = floatMatrix.getRowDimension();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f = fArray[i][j];
                if (Float.isNaN(f)) {
                    this.m_out.print("NaN ");
                } else {
                    this.m_out.print(f);
                    this.m_out.print(' ');
                }
                if (++n3 != 10240) continue;
                n3 = 0;
                this.m_out.print("\r\n<?break?>\r\n");
            }
        }
        this.m_out.println("             </DataInternal> \n          </DataInternal_assn>");
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</BioDataCube>");
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</BioDataValues_assn>");
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</DerivedBioAssayData>");
    }

    private void serializeParams(AlgorithmParameters algorithmParameters) {
        this.m_ind.print(this.m_out);
        this.m_out.println("<DerivedBioAssayData identifier=\"parameters\">");
        this.m_ind.print(this.m_out);
        this.m_out.println("   <PropertySets_assnlist>");
        this.m_ind.print(this.m_out);
        Iterator iterator = algorithmParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = Util.escape((String)entry.getKey());
            String string2 = Util.escape((String)entry.getValue());
            this.m_ind.print(this.m_out);
            this.m_out.println("        <NameValueType name=\"" + string + "\" value=\"" + string2 + "\" />");
        }
        this.m_ind.print(this.m_out);
        this.m_out.println("   </PropertySets_assnlist>");
        this.m_ind.print(this.m_out);
        this.m_out.println("</DerivedBioAssayData>");
    }

    private void serializeCluster(Cluster cluster) {
    }
}

