/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import de.mnl.java.io.base64.Base64InputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.remote.protocol.ExecutedJob;
import org.tigr.remote.protocol.Fail;
import org.tigr.remote.protocol.FailedJob;
import org.tigr.remote.protocol.FinishedJob;
import org.tigr.remote.protocol.JobData;
import org.tigr.remote.protocol.Response;
import org.tigr.remote.protocol.SuccessfulJob;
import org.tigr.remote.protocol.parser.ResponseHandlerBase;
import org.tigr.remote.protocol.parser.XMLMAGEParser;
import org.tigr.remote.protocol.util.TempFile;
import org.tigr.util.ConfMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SAXResponseHandler
extends ResponseHandlerBase {
    private FinishedJob m_job = null;
    private Response m_result = new Response(null);
    private boolean m_inJobData = false;
    private Writer m_mageStorage = null;
    private String m_mageFileName;
    private Fail m_fail;
    private AlgorithmEvent m_event;
    private StringBuffer m_chars = new StringBuffer();

    public SAXResponseHandler(ConfMap confMap) {
        super(confMap);
    }

    public void endDocument() {
        this.m_job = null;
        this.m_mageStorage = null;
        this.m_mageFileName = null;
        this.m_fail = null;
        this.m_event = null;
        this.m_chars = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block13: {
            super.startElement(string, string2, string3, attributes);
            try {
                this.m_chars = new StringBuffer();
                if (string3.equals("response")) break block13;
                if (string3.equals("successful-job")) {
                    String[] stringArray = new String[]{"response", "successful-job"};
                    this.m_path.checkFromTopThrow(stringArray);
                    String string4 = attributes.getValue("id");
                    this.m_job = new SuccessfulJob(string4, new JobData(null));
                    this.m_result = new Response(this.m_job);
                    break block13;
                }
                if (string3.equals("failed-job")) {
                    String[] stringArray = new String[]{"response", "failed-job"};
                    this.m_path.checkFromTopThrow(stringArray);
                    String string5 = attributes.getValue("id");
                    this.m_job = new FailedJob(string5, null);
                    this.m_result = new Response(this.m_job);
                    break block13;
                }
                if (string3.equals("executed-job")) {
                    String[] stringArray = new String[]{"response", "executed-job"};
                    this.m_path.checkFromTopThrow(stringArray);
                    String string6 = attributes.getValue("id");
                    this.m_job = new ExecutedJob(string6, null);
                    this.m_result = new Response(this.m_job);
                    break block13;
                }
                if (string3.equals("job-data")) {
                    String[] stringArray = new String[]{"response", "successful-job", "job-data"};
                    this.m_path.checkFromTopThrow(stringArray);
                    TempFile tempFile = new TempFile(this.m_config);
                    this.m_mageFileName = tempFile.getName("MAGE.base64");
                    this.m_mageStorage = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.m_mageFileName)));
                    break block13;
                }
                if (string3.equals("fail")) {
                    String[] stringArray = new String[]{"response", "failed-job", "fail"};
                    this.m_path.checkFromTopThrow(stringArray);
                    String string7 = attributes.getValue("id");
                    this.m_fail = new Fail(string7, null);
                    ((FailedJob)this.m_job).setFail(this.m_fail);
                    break block13;
                }
                if (string3.equals("event")) {
                    String[] stringArray = new String[]{"response", "executed-job", "event"};
                    this.m_path.checkFromTopThrow(stringArray);
                    String string8 = attributes.getValue("id");
                    int n = 0;
                    try {
                        n = Integer.parseInt(string8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.m_event = new AlgorithmEvent((Object)this, n);
                    ((ExecutedJob)this.m_job).setEvent(this.m_event);
                    break block13;
                }
                if (string3.equals("progress")) {
                    String[] stringArray = new String[]{"response", "executed-job", "event", "progress"};
                    this.m_path.checkFromTopThrow(stringArray);
                    break block13;
                }
                if (string3.equals("float-value")) {
                    String[] stringArray = new String[]{"response", "executed-job", "event", "float-value"};
                    this.m_path.checkFromTopThrow(stringArray);
                    break block13;
                }
                if (string3.equals("description")) {
                    String[] stringArray = new String[]{"response", "executed-job", "event", "description"};
                    this.m_path.checkFromTopThrow(stringArray);
                    break block13;
                }
                throw new Exception("Unexpected element: " + string3);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.processError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        block17: {
            try {
                if (string3.equals("fail")) {
                    this.m_fail.setDescription(this.m_chars.toString());
                    break block17;
                }
                if (string3.equals("job-data")) {
                    int n;
                    boolean bl = this.m_config.getBoolean("remote.debug.keep-response-files", false);
                    this.m_mageStorage.close();
                    this.m_mageStorage = null;
                    TempFile tempFile = new TempFile(this.m_config);
                    String string4 = tempFile.getName("MAGE");
                    Base64InputStream base64InputStream = new Base64InputStream((InputStream)new BufferedInputStream(new FileInputStream(this.m_mageFileName)));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string4));
                    byte[] byArray = new byte[102400];
                    while ((n = base64InputStream.read(byArray)) >= 0) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                    base64InputStream.close();
                    ((OutputStream)bufferedOutputStream).close();
                    base64InputStream = null;
                    bufferedOutputStream = null;
                    if (!bl) {
                        new File(this.m_mageFileName).delete();
                    }
                    XMLMAGEParser xMLMAGEParser = new XMLMAGEParser(this.m_config);
                    xMLMAGEParser.parse(string4);
                    ((SuccessfulJob)this.m_job).getData().setData(xMLMAGEParser.getResult());
                    if (!bl) {
                        new File(string4).delete();
                    }
                    break block17;
                }
                if (string3.equals("progress")) {
                    String string5 = this.m_chars.toString();
                    try {
                        int n = Integer.parseInt(string5);
                        this.m_event.setIntValue(n);
                        break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("invalid progress integer value: " + string5);
                    }
                }
                if (string3.equals("float-value")) {
                    String string6 = this.m_chars.toString();
                    try {
                        float f = Float.parseFloat(string6);
                        this.m_event.setFloatValue(f);
                        break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("invalid float value: " + string6);
                    }
                }
                if (string3.equals("description")) {
                    this.m_event.setDescription(this.m_chars.toString());
                }
            }
            catch (Exception exception) {
                this.processError(exception);
            }
            finally {
                super.endElement(string, string2, string3);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.getCurrentElement().equals("job-data")) {
                this.m_mageStorage.write(cArray, n, n2);
            } else {
                this.m_chars.append(cArray, n, n2);
            }
        }
        catch (Exception exception) {
            this.processError(exception);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public Response getResponse() {
        return this.m_result;
    }
}

