/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication.http;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpURLConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.tigr.remote.protocol.util.TempFile;
import org.tigr.util.ConfMap;

public class HttpCommunicator2 {
    private URL sendURL;
    private URL receiveURL;
    private HttpURLConnection connection;
    private BufferedOutputStream bufferedOutputStream;
    private InputStream inputStream;
    private int contentLength = 0;
    private String context;
    private String fileName;
    private boolean fileCreated;
    private boolean keepTempFile;
    private static long countInstances = 0L;

    public static synchronized String getUniqueContext() {
        return "context" + ++countInstances;
    }

    private HttpCommunicator2(String string) throws MalformedURLException {
        this.sendURL = new URL(string + "?post-request");
        this.receiveURL = new URL(string + "?get-response");
        this.context = HttpCommunicator2.getUniqueContext();
    }

    public HttpCommunicator2(ConfMap confMap) throws MalformedURLException, IOException {
        this(confMap.getString("remote.server"));
        this.fileName = new TempFile(confMap).getName();
        this.keepTempFile = confMap.getBoolean("remote.debug.keep-request-file", false);
    }

    public OutputStream send(Properties properties) throws IOException {
        this.createSendConnection();
        this.setRequestProperties(properties);
        this.bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.fileName));
        this.fileCreated = true;
        return this.bufferedOutputStream;
    }

    public InputStream receive() throws IOException {
        this.createReceiveConnection();
        this.inputStream = new BufferedInputStream(this.connection.getInputStream());
        this.checkResponseCode();
        return this.inputStream;
    }

    public void cleanupAfterReceive() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
        this.checkResponseCode();
        this.connection.disconnect();
        this.connection = null;
    }

    public void cleanupAfterSend() throws IOException {
        File file = null;
        InputStream inputStream = null;
        try {
            int n;
            this.bufferedOutputStream.flush();
            this.bufferedOutputStream.close();
            this.bufferedOutputStream = null;
            file = new File(this.fileName);
            this.setContentLength((int)file.length());
            if (this.contentLength < 1) {
                throw new IOException("HttpCommunicator: wrong content length");
            }
            this.connection.setRequestProperty("Content-Length", new Integer(this.contentLength).toString());
            inputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.connection.getOutputStream());
            byte[] byArray = new byte[102400];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            inputStream = null;
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
            this.deleteTempFile(file);
            this.fileCreated = false;
            this.checkResponseCode();
            this.connection.disconnect();
            this.connection = null;
        }
        catch (IOException iOException) {
            if (this.fileCreated) {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
                if (file == null) {
                    file = new File(this.fileName);
                }
                this.deleteTempFile(file);
            }
            throw iOException;
        }
    }

    private void createSendConnection() throws IOException {
        try {
            this.connection = new HttpURLConnection(this.sendURL);
            this.connection.setContext((Object)this.context);
            HTTPConnection.addDefaultModule(Class.forName("HTTPClient.CookieModule"), (int)0);
            CookieModule.setCookiePolicyHandler(null);
            this.connection.setRequestMethod("POST");
            this.connection.setAllowUserInteraction(true);
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Content-Type", "text/plain");
            this.connection.setRequestProperty("Connection", "close");
        }
        catch (Exception exception) {
            throw new IOException("HttpCommunicator: cannot create send connection");
        }
    }

    private void createReceiveConnection() throws IOException {
        this.connection = new HttpURLConnection(this.receiveURL);
        this.connection.setContext((Object)this.context);
        this.connection.setRequestMethod("GET");
        this.connection.setAllowUserInteraction(true);
        this.connection.setRequestProperty("Connection", "close");
    }

    private void setRequestProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            this.connection.setRequestProperty(string, string2);
        }
    }

    private Properties getResponseProperties() {
        Properties properties = new Properties();
        int n = 1;
        while (true) {
            String string = this.connection.getHeaderFieldKey(n);
            String string2 = this.connection.getHeaderField(n);
            if (string == null) break;
            properties.setProperty(string, string2);
            ++n;
        }
        return properties;
    }

    private void setContentLength(int n) {
        this.contentLength = n;
    }

    public void checkResponseCode() throws IOException {
        int n = this.connection.getResponseCode();
        if (n != 200) {
            throw new IOException("Response code is other than 200 OK. Url: \n" + this.connection.toString() + "\n Code: " + n);
        }
    }

    private void deleteTempFile(File file) throws IOException {
        if (!this.keepTempFile && !file.delete()) {
            throw new IOException("HttpCommunicator: deleting temp file error");
        }
    }
}

