/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.gateway;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.tigr.util.ConfMap;

class MEVRequestAcceptStrategy {
    private static final int MAX_PACKET_SIZE = 0x100000;
    private String m_pvmProxyName;
    private String m_pvmSlaveName;
    private String m_pvmURL;
    private String m_pvmRoot;

    public MEVRequestAcceptStrategy(ConfMap confMap) {
        this.m_pvmProxyName = confMap.getString("gateway.pvm.proxy-name");
        this.m_pvmSlaveName = confMap.getString("gateway.pvm.slave-name");
        this.m_pvmURL = confMap.getProperty("gateway.pvm.slave.http", "").trim();
        this.m_pvmRoot = confMap.getProperty("gateway.pvm.root-path", "").trim();
    }

    private static void checkError(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string != null) {
            if (!string.startsWith("OK")) {
                string = bufferedReader.readLine();
                throw new IOException("Cannot send to PVM: " + string);
            }
        } else {
            throw new IOException("Bad pvmproxy response.");
        }
    }

    private void constructURL(HttpServletRequest httpServletRequest) throws IOException {
        if (this.m_pvmURL == null || this.m_pvmURL.trim().equals("")) {
            StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
            stringBuffer.append("?post-response");
            this.m_pvmURL = stringBuffer.toString();
        }
    }

    public void acceptMEVRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, InterruptedException {
        int n;
        Process process;
        String[] stringArray;
        if (httpServletRequest.getContentLength() < 1) {
            throw new IOException("Bad content length: " + httpServletRequest.getContentLength());
        }
        this.constructURL(httpServletRequest);
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray2 = new String[]{this.m_pvmProxyName, this.m_pvmSlaveName, this.m_pvmURL, this.getSessionIdString(httpServletRequest)};
        if (!this.m_pvmRoot.equals("")) {
            stringArray = new String[]{"PVM_ROOT=" + this.m_pvmRoot};
            process = runtime.exec(stringArray2, stringArray);
        } else {
            process = runtime.exec(stringArray2);
        }
        stringArray = new BufferedOutputStream(process.getOutputStream(), 0x100000);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream((InputStream)httpServletRequest.getInputStream());
        MEVRequestAcceptStrategy.checkError(bufferedInputStream);
        int n2 = 0;
        byte[] byArray = new byte[102400];
        while ((n = ((InputStream)bufferedInputStream2).read(byArray)) >= 0) {
            stringArray.write(byArray, 0, n);
            n2 += n;
        }
        if (n2 < 10) {
            throw new IOException("read only : " + n2);
        }
        stringArray.flush();
        stringArray.close();
        MEVRequestAcceptStrategy.checkError(bufferedInputStream);
        process.waitFor();
        int n3 = process.exitValue();
        if (n3 != 0) {
            throw new IOException("pvmproxy exit code != 0");
        }
    }

    private final String getSessionIdString(HttpServletRequest httpServletRequest) throws IOException {
        return "JSESSIONID=" + httpServletRequest.getSession().getId();
    }
}

