/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.gateway;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tigr.remote.gateway.MEVPollAcceptStrategy;
import org.tigr.remote.gateway.MEVRequestAcceptStrategy;
import org.tigr.remote.gateway.MEVRequestAcceptStrategy2;
import org.tigr.remote.gateway.PVMResponseAcceptStrategy;
import org.tigr.remote.gateway.SessionState;
import org.tigr.remote.gateway.util.ServletUtil;
import org.tigr.util.ConfMap;

public class GatewayServlet
extends HttpServlet {
    ServletConfig m_config;
    ServletContext m_ctx;
    ConfMap m_properties;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.m_config = servletConfig;
        this.m_ctx = servletConfig.getServletContext();
        this.configure();
    }

    private void configure() throws ServletException {
        this.m_properties = new ConfMap();
        String[] stringArray = new String[]{"gateway.pvm.proxy-name", "gateway.pvm.slave-name", "gateway.pvm.root-path"};
        String[] stringArray2 = new String[]{"", "tigr-slave", "/usr/local/pvm3"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.m_ctx.getInitParameter(stringArray[i]);
            if (string == null || "".equals(string)) {
                if (!"".equals(stringArray2[i])) {
                    this.m_properties.setProperty(stringArray[i], stringArray2[i]);
                    continue;
                }
                throw new ServletException("Undefined required parameter: " + stringArray[i]);
            }
            this.m_properties.setProperty(stringArray[i], string);
        }
        this.m_properties.list(System.out);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.logTrace(httpServletRequest, "GET log");
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            return;
        }
        if ("get-response".equals(string)) {
            try {
                this.onMEVPollsForResponse(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                this.logError(httpServletRequest, httpServletResponse, exception, "MEV polling error");
                this.sendError(httpServletResponse, "MEV polling error: " + exception.toString());
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.logTrace(httpServletRequest, "POST log");
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            try {
                ServletUtil.bufferedRead((InputStream)httpServletRequest.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logError(httpServletRequest, httpServletResponse, new Exception("Unrecognized POST"), "");
            this.sendError(httpServletResponse, "Unrecognized POST");
        } else if ("post-request".equals(string)) {
            try {
                this.onMEVPostsRequest(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                try {
                    ServletUtil.bufferedRead((InputStream)httpServletRequest.getInputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.logError(httpServletRequest, httpServletResponse, exception, "MEV POST error");
                this.sendError(httpServletResponse, "MEV POST error: " + exception.toString());
            }
        } else if ("post-response".equals(string)) {
            try {
                this.onPVMPostsResponse(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                try {
                    ServletUtil.bufferedRead((InputStream)httpServletRequest.getInputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.logError(httpServletRequest, httpServletResponse, exception, "PVM POST error");
                this.sendError(httpServletResponse, "PVM POST error: " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMEVPostsRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            HttpSession httpSession2 = httpSession = httpServletRequest.getSession();
            synchronized (httpSession2) {
                httpSession.setAttribute("MEV_SESSION", (Object)new SessionState());
                MEVRequestAcceptStrategy mEVRequestAcceptStrategy = new MEVRequestAcceptStrategy(this.m_properties);
                mEVRequestAcceptStrategy.acceptMEVRequest(httpServletRequest, httpServletResponse);
            }
        } else {
            SessionState sessionState = (SessionState)httpSession.getAttribute("MEV_SESSION");
            MEVRequestAcceptStrategy2 mEVRequestAcceptStrategy2 = new MEVRequestAcceptStrategy2(sessionState);
            mEVRequestAcceptStrategy2.acceptMEVRequest(httpServletRequest, httpServletResponse);
        }
    }

    protected void onMEVPollsForResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new NullPointerException("Illegal call. Session has not been created ");
        }
        SessionState sessionState = (SessionState)httpSession.getAttribute("MEV_SESSION");
        if (sessionState == null) {
            throw new NullPointerException("Illegal call. Session info has not been created for the  current session");
        }
        MEVPollAcceptStrategy mEVPollAcceptStrategy = new MEVPollAcceptStrategy(sessionState, this.m_properties);
        mEVPollAcceptStrategy.acceptPollRequest(httpServletRequest, httpServletResponse);
    }

    protected void onPVMPostsResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new NullPointerException("Illegal call. Session has has not been created ");
        }
        SessionState sessionState = (SessionState)httpSession.getAttribute("MEV_SESSION");
        if (sessionState == null) {
            throw new NullPointerException("Illegal call. Session info has not been created for the  current session");
        }
        PVMResponseAcceptStrategy pVMResponseAcceptStrategy = new PVMResponseAcceptStrategy(sessionState, this.m_properties);
        pVMResponseAcceptStrategy.acceptPVMResponse(httpServletRequest, httpServletResponse);
    }

    protected void sendError(HttpServletResponse httpServletResponse, String string) {
        try {
            this.m_ctx.log("Sending HTTP 404");
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.sendError(404);
        }
        catch (IOException iOException) {
            System.err.println("Error sending error code");
            throw new RuntimeException(iOException.toString());
        }
    }

    private final boolean isDebugMode() {
        String string = this.m_ctx.getInitParameter("gateway.debug");
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("true");
    }

    protected void logTrace(HttpServletRequest httpServletRequest, String string) {
        if (!this.isDebugMode()) {
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n---------- Gateway trace message:\n");
            stringBuffer.append("Trace message:  " + string + "\n");
            stringBuffer.append("Request method: " + httpServletRequest.getMethod() + "\n");
            stringBuffer.append("Query string:   " + httpServletRequest.getQueryString() + "\n");
            stringBuffer.append("Content length: " + httpServletRequest.getContentLength() + "\n");
            stringBuffer.append("Cookies: ( session info )\n");
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray == null || cookieArray.length == 0) {
                stringBuffer.append("No cookies in the HTTP request\n");
            } else {
                for (int i = 0; i < cookieArray.length; ++i) {
                    stringBuffer.append("\tName: " + cookieArray[i].getName() + "\t" + "Value: " + cookieArray[i].getValue() + "\n");
                }
            }
            stringBuffer.append("\n");
            this.m_ctx.log(stringBuffer.toString());
        }
        catch (Exception exception) {
            System.err.println("Error logging a message");
        }
    }

    protected void logError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n---------- Gateway error:\n");
            stringBuffer.append("Error message:  " + string + "\n");
            stringBuffer.append("Request method: " + httpServletRequest.getMethod() + "\n");
            stringBuffer.append("Query string:   " + httpServletRequest.getQueryString() + "\n");
            stringBuffer.append("Content length: " + httpServletRequest.getContentLength() + "\n");
            stringBuffer.append("Cookies: ( session info )\n");
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray == null || cookieArray.length == 0) {
                stringBuffer.append("No cookies in the HTTP request\n");
            } else {
                for (int i = 0; i < cookieArray.length; ++i) {
                    stringBuffer.append("\tName: " + cookieArray[i].getName() + "\t" + "Value: " + cookieArray[i].getValue() + "\n");
                }
            }
            stringBuffer.append("\n");
            this.m_ctx.log(stringBuffer.toString(), (Throwable)exception);
        }
        catch (Exception exception2) {
            System.err.println("Error logging a message");
        }
    }
}

